/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.converters.PathConverter;
import org.wso2.ballerinalang.compiler.packaging.converters.SortablePath;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public class ZipConverter
extends PathConverter {
    public ZipConverter(Path archivePath) {
        super(ZipConverter.resolveIntoArchive(archivePath));
    }

    @Override
    public Path combine(Path path, String pathPart) {
        return ZipConverter.resolveIntoArchive(path.resolve(pathPart));
    }

    private static Path resolveIntoArchive(Path newPath) {
        String pathPart = newPath.toString();
        if ((pathPart.endsWith(".zip") || pathPart.endsWith(".jar") || pathPart.endsWith(".bala")) && Files.isRegularFile(newPath, new LinkOption[0])) {
            return ZipConverter.pathWithinZip(newPath.toUri());
        }
        return newPath;
    }

    private static Path pathWithinZip(URI pathToZip) {
        try {
            URI pathInZip = new URI("jar:" + pathToZip.getScheme(), pathToZip.getUserInfo(), pathToZip.getHost(), pathToZip.getPort(), pathToZip.getPath() + "!/", pathToZip.getQuery(), pathToZip.getFragment());
            ZipConverter.initFS(pathInZip);
            return Path.of(pathInZip);
        }
        catch (URISyntaxException uRISyntaxException) {
            return Path.of(pathToZip);
        }
    }

    private static void initFS(URI uri) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try {
            FileSystems.newFileSystem(uri, env);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
        }
        catch (IOException | ZipError e) {
            throw new BLangCompilerException("Error loading bala " + uri.getPath(), e);
        }
    }

    @Override
    public Stream<Path> getLatestVersion(Path path, PackageID packageID) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Stream.of(new Path[0]);
        }
        try {
            List<Object> pathList = new ArrayList();
            if (packageID != null) {
                try (Stream<Path> stream = Files.list(path);){
                    pathList = stream.map(SortablePath::new).filter(SortablePath::valid).sorted(Comparator.reverseOrder()).limit(1L).map(SortablePath::getPath).toList();
                }
                if (packageID.version.value.isEmpty() && !packageID.orgName.equals(Names.BUILTIN_ORG) && !packageID.orgName.equals(Names.ANON_ORG) && !pathList.isEmpty()) {
                    Path modulePath = (Path)pathList.get(0);
                    packageID.version = new Name(modulePath.toFile().getName());
                    if (RepoUtils.isANightlyBuild() && this.checkForCacheInvalidity(modulePath)) {
                        packageID.version = Names.EMPTY;
                        return Stream.of(new Path[0]);
                    }
                }
            }
            return pathList.stream();
        }
        catch (IOException iOException) {
            return Stream.of(new Path[0]);
        }
    }

    private boolean checkForCacheInvalidity(Path balaPath) {
        Path nightlyFilePath = balaPath.resolve("nightly.build");
        if (!Files.exists(nightlyFilePath, new LinkOption[0])) {
            return false;
        }
        Date modifiedDate = new Date(nightlyFilePath.toFile().lastModified());
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date midnightDate = cal.getTime();
        if (!modifiedDate.before(midnightDate)) {
            return false;
        }
        try {
            ZipConverter.deleteFiles(balaPath);
            ZipConverter.deleteEmptyParentDirs(balaPath, this.getRoot());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static void deleteFiles(Path dirPath) throws IOException {
        if (dirPath == null) {
            return;
        }
        try (Stream<Path> paths = Files.walk(dirPath, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    private static void deleteEmptyParentDirs(Path modulePath, Path repoPath) throws IOException {
        Path pathsInBetween = repoPath.relativize(modulePath);
        for (int i = pathsInBetween.getNameCount(); i > 0; --i) {
            boolean isPresent;
            Path toRemove = repoPath.resolve(pathsInBetween.subpath(0, i));
            try (Stream<Path> stream = Files.list(toRemove);){
                isPresent = stream.findAny().isPresent();
            }
            if (isPresent) continue;
            Files.delete(toRemove);
        }
    }
}

