/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.net.URI;
import java.nio.file.Path;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;

public class JarRepo
implements Repo<Path> {
    private final ZipConverter converter;

    public JarRepo(URI jarLocation) {
        this.converter = new ZipConverter(Path.of(jarLocation));
    }

    @Override
    public Patten calculate(PackageID pkg) {
        return new Patten(Patten.path("META-INF"), Patten.path(pkg.orgName.value, pkg.name.value), Patten.WILDCARD_SOURCE);
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.converter;
    }

    public String toString() {
        return "{t:'JarRepo', c:'" + String.valueOf(this.converter) + "'}";
    }
}

