/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;
import org.wso2.ballerinalang.util.RepoUtils;

public abstract class NonSysRepo<I>
implements Repo<I> {
    private final Converter<I> converter;

    public NonSysRepo(Converter<I> converter) {
        this.converter = converter;
    }

    @Override
    public Patten calculate(PackageID pkgId) {
        String orgName = pkgId.getOrgName().getValue();
        if (!RepoUtils.COMPILE_BALLERINA_ORG && "ballerina".equals(orgName)) {
            return Patten.NULL;
        }
        return this.calculateNonSysPkg(pkgId);
    }

    @Override
    public Converter<I> getConverterInstance() {
        return this.converter;
    }

    public abstract Patten calculateNonSysPkg(PackageID var1);

    public String toString() {
        return "{t:'" + this.getClass().getSimpleName() + "', c:'" + String.valueOf(this.converter) + "'}";
    }
}

