/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayDeque;
import java.util.Deque;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class ConstantAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ConstantAnalyzer> CONSTANT_ANALYZER_KEY = new CompilerContext.Key();
    private final BLangMissingNodesHelper missingNodesHelper;
    private final Names names;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLog dlog;
    private final Deque<BLangExpression> expressions = new ArrayDeque<BLangExpression>();

    private ConstantAnalyzer(CompilerContext context) {
        context.put(CONSTANT_ANALYZER_KEY, this);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public static ConstantAnalyzer getInstance(CompilerContext context) {
        ConstantAnalyzer constantAnalyzer = context.get(CONSTANT_ANALYZER_KEY);
        if (constantAnalyzer == null) {
            constantAnalyzer = new ConstantAnalyzer(context);
        }
        return constantAnalyzer;
    }

    @Override
    public void visit(BLangConstant constant) {
        this.analyzeExpr(constant.expr);
    }

    @Override
    public void visit(BLangLiteral literal) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
    }

    @Override
    public void visit(BLangNumericLiteral literal) {
    }

    @Override
    public void visit(BLangSimpleVarRef varRef) {
        BSymbol symbol = varRef.symbol;
        if (varRef.pkgSymbol != this.symTable.notFoundSymbol && symbol == this.symTable.notFoundSymbol) {
            SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(varRef.pkgSymbol);
            BSymbol bSymbol = symbol = pkgEnv == null ? symbol : this.symResolver.lookupMainSpaceSymbolInPackage(varRef.pos, pkgEnv, this.names.fromIdNode(varRef.pkgAlias), this.names.fromIdNode(varRef.variableName));
        }
        if (symbol == this.symTable.notFoundSymbol) {
            this.logUndefinedSymbolError(varRef.pos, varRef.variableName.value);
        }
        if (symbol != null && (symbol.tag & 0x100001CL) != 0x100001CL) {
            this.dlog.error(varRef.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
        }
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                this.analyzeExpr(keyValuePair.key.expr);
                this.analyzeExpr(keyValuePair.valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeExpr((BLangRecordLiteral.BLangRecordVarNameField)field);
                continue;
            }
            this.analyzeExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
        }
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.analyzeExpr(binaryExpr.lhsExpr);
        this.analyzeExpr(binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr expr) {
        this.analyzeExpr(expr.expression);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        switch (unaryExpr.operator) {
            case ADD: 
            case SUB: 
            case BITWISE_COMPLEMENT: 
            case NOT: {
                this.analyzeExpr(unaryExpr.expr);
                return;
            }
        }
        this.dlog.error(unaryExpr.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            this.analyzeExpr(expr);
        }
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadOpExpr) {
        this.analyzeExpr(spreadOpExpr.expr);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::analyzeExpr);
    }

    void analyzeExpr(BLangExpression expr) {
        switch (expr.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case STRING_TEMPLATE_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case LIST_CONSTRUCTOR_EXPR: 
            case LIST_CONSTRUCTOR_SPREAD_OP: 
            case SIMPLE_VARIABLE_REF: 
            case BINARY_EXPR: 
            case GROUP_EXPR: 
            case UNARY_EXPR: {
                this.expressions.push(expr);
                expr.accept(this);
                this.expressions.pop();
                return;
            }
        }
        this.dlog.error(expr.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
    }

    private void logUndefinedSymbolError(Location pos, String name) {
        if (!this.missingNodesHelper.isMissingNode(name)) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, name);
        }
    }
}

