/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.Value;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.util.Flags;

public class ConstantTypeChecker
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<ConstantTypeChecker> CONSTANT_TYPE_CHECKER_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Names names;
    private final NodeCloner nodeCloner;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private final TypeChecker typeChecker;
    private final TypeResolver typeResolver;
    private final FillMembers fillMembers;
    private final BLangAnonymousModelHelper anonymousModelHelper;

    public ConstantTypeChecker(CompilerContext context) {
        context.put(CONSTANT_TYPE_CHECKER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.typeResolver = TypeResolver.getInstance(context);
        this.fillMembers = FillMembers.getInstance(context);
    }

    public static ConstantTypeChecker getInstance(CompilerContext context) {
        ConstantTypeChecker constTypeChecker = context.get(CONSTANT_TYPE_CHECKER_KEY);
        if (constTypeChecker == null) {
            constTypeChecker = new ConstantTypeChecker(context);
        }
        return constTypeChecker;
    }

    public BType checkConstExpr(BLangExpression expr, AnalyzerData data) {
        return this.checkConstExpr(expr, data.env, this.symTable.noType, data);
    }

    public BType checkConstExpr(BLangExpression expr, SymbolEnv env, BType expType, AnalyzerData data) {
        return this.checkConstExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    public BType checkConstExpr(BLangExpression expr, BType expType, AnalyzerData data) {
        return this.checkConstExpr(expr, data.env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    public BType checkConstExpr(BLangExpression expr, SymbolEnv env, BType expType, DiagnosticCode diagCode, AnalyzerData data) {
        if (expr.typeChecked) {
            return expr.getBType();
        }
        SymbolEnv prevEnv = data.env;
        BType preExpType = data.expType;
        DiagnosticCode preDiagCode = data.diagCode;
        Location prevPos = data.pos;
        data.env = env;
        data.diagCode = diagCode;
        data.expType = expType;
        data.isTypeChecked = true;
        data.pos = expr.pos;
        expr.expectedType = expType;
        switch (expr.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case STRING_TEMPLATE_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case LIST_CONSTRUCTOR_EXPR: 
            case SIMPLE_VARIABLE_REF: 
            case BINARY_EXPR: 
            case GROUP_EXPR: 
            case UNARY_EXPR: {
                expr.accept(this, data);
                break;
            }
            default: {
                data.resultType = this.symTable.semanticError;
            }
        }
        expr.setTypeCheckedType(data.resultType);
        expr.typeChecked = data.isTypeChecked;
        data.env = prevEnv;
        data.expType = preExpType;
        data.diagCode = preDiagCode;
        data.pos = prevPos;
        this.validateAndSetExprExpectedType(expr, data);
        return data.resultType;
    }

    public void validateAndSetExprExpectedType(BLangExpression expr, AnalyzerData data) {
        if (data.resultType.tag == 28) {
            return;
        }
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR && expr.expectedType != null && Types.getImpliedType((BType)expr.expectedType).tag == 16 && Types.getImpliedType((BType)expr.getBType()).tag == 12) {
            return;
        }
        expr.expectedType = data.resultType;
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
        this.dlog.error(node.pos, DiagnosticErrorCode.CONSTANT_DECLARATION_NOT_YET_SUPPORTED, node);
        data.resultType = this.symTable.semanticError;
    }

    @Override
    public void visit(BLangPackage node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangLiteral literalExpr, AnalyzerData data) {
        BType literalType = this.setLiteralValueAndGetType(literalExpr, data.expType, data);
        if (literalType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (literalType.tag == 35) {
            literalType = this.rewriteByteArrayLiteral(literalExpr, data);
        }
        if (literalExpr.isFiniteContext) {
            return;
        }
        BType finiteType = this.getFiniteType(literalExpr.value, data.constantSymbol, literalType);
        if (data.compoundExprCount == 0 && this.types.typeIncompatible(literalExpr.pos, finiteType, data.expType)) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = finiteType;
    }

    private BType rewriteByteArrayLiteral(BLangLiteral literalExpr, AnalyzerData data) {
        byte[] values = this.types.convertToByteArray((String)literalExpr.value);
        ArrayList<BType> memberTypes = new ArrayList<BType>();
        for (byte b : values) {
            memberTypes.add(this.getFiniteType(Byte.toUnsignedLong(b), data.constantSymbol, this.symTable.intType));
        }
        BType expType = Types.getImpliedType(data.expType);
        if (expType.tag == 20 && ((BArrayType)expType).state == BArrayState.INFERRED) {
            BArrayType expArrayType = (BArrayType)expType;
            expArrayType.setSize(memberTypes.size());
            expArrayType.state = BArrayState.CLOSED;
        }
        return this.createNewTupleType(literalExpr.pos, memberTypes, data);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr, AnalyzerData data) {
        BType actualType = this.symTable.semanticError;
        Name varName = this.names.fromIdNode(varRefExpr.variableName);
        if (varName == Names.IGNORE) {
            varRefExpr.setBType(this.symTable.anyType);
            varRefExpr.symbol = new BVarSymbol(0L, true, varName, this.names.originalNameFromIdNode(varRefExpr.variableName), data.env.enclPkg.symbol.pkgID, varRefExpr.getBType(), data.env.scope.owner, varRefExpr.pos, SymbolOrigin.VIRTUAL);
            data.resultType = varRefExpr.getBType();
            return;
        }
        Name compUnitName = this.typeChecker.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (varRefExpr.pkgSymbol == this.symTable.notFoundSymbol) {
            varRefExpr.symbol = this.symTable.notFoundSymbol;
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        } else {
            BSymbol symbol = this.typeResolver.getSymbolOfVarRef(varRefExpr.pos, data.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            if (symbol == this.symTable.notFoundSymbol) {
                data.resultType = this.symTable.semanticError;
                varRefExpr.symbol = symbol;
                return;
            }
            varRefExpr.symbol = symbol;
            if ((symbol.tag & 0x100001CL) == 0x100001CL) {
                actualType = symbol.type;
            }
        }
        if (data.compoundExprCount == 0 && this.types.typeIncompatible(varRefExpr.pos, actualType, data.expType)) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = actualType;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor, AnalyzerData data) {
        BType expType = data.expType;
        if (expType.tag == 24 || expType.tag == 38) {
            data.resultType = this.defineInferredTupleType(listConstructor, data);
            return;
        }
        data.resultType = this.checkListConstructorCompatibility(data.expType, listConstructor, data);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordVarNameField varRefExpr, AnalyzerData data) {
        BType actualType = this.symTable.semanticError;
        Name varName = this.names.fromIdNode(varRefExpr.variableName);
        if (varName == Names.IGNORE) {
            varRefExpr.setBType(this.symTable.anyType);
            varRefExpr.symbol = new BVarSymbol(0L, true, varName, this.names.originalNameFromIdNode(varRefExpr.variableName), data.env.enclPkg.symbol.pkgID, varRefExpr.getBType(), data.env.scope.owner, varRefExpr.pos, SymbolOrigin.VIRTUAL);
            data.resultType = varRefExpr.getBType();
            return;
        }
        Name compUnitName = this.typeChecker.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (varRefExpr.pkgSymbol == this.symTable.notFoundSymbol) {
            varRefExpr.symbol = this.symTable.notFoundSymbol;
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        }
        if (varRefExpr.pkgSymbol != this.symTable.notFoundSymbol) {
            BSymbol symbol = this.typeResolver.getSymbolOfVarRef(varRefExpr.pos, data.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            if (symbol == this.symTable.notFoundSymbol) {
                data.resultType = this.symTable.semanticError;
                return;
            }
            if ((symbol.tag & 0x100001CL) == 0x100001CL) {
                varRefExpr.symbol = symbol;
                actualType = symbol.type;
            } else {
                varRefExpr.symbol = symbol;
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
            }
        }
        data.resultType = this.types.checkType(varRefExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral, AnalyzerData data) {
        BType expType = data.expType;
        int expTypeTag = Types.getImpliedType((BType)expType).tag;
        if (expTypeTag == 24 || expTypeTag == 38) {
            data.resultType = this.validateMapTypeAndInferredType(recordLiteral, expType, expType, data);
            return;
        }
        data.resultType = this.checkMappingConstructorCompatibility(data.expType, recordLiteral, data);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr, AnalyzerData data) {
        BType expType = data.expType;
        ++data.compoundExprCount;
        BType lhsType = this.checkConstExpr(binaryExpr.lhsExpr, expType, data);
        BType rhsType = this.checkConstExpr(binaryExpr.rhsExpr, expType, data);
        --data.compoundExprCount;
        Location pos = binaryExpr.pos;
        if (lhsType == this.symTable.semanticError || rhsType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BSymbol opSymbol = lhsType.tag == 21 && rhsType.tag == 21 ? this.getOpSymbolBothUnion((BUnionType)lhsType, (BUnionType)rhsType, binaryExpr, data) : (lhsType.tag == 21 ? this.getOpSymbolLhsUnion((BUnionType)lhsType, rhsType, binaryExpr, data, false) : (rhsType.tag == 21 ? this.getOpSymbolLhsUnion((BUnionType)rhsType, lhsType, binaryExpr, data, true) : this.getOpSymbolBothNonUnion(lhsType, rhsType, binaryExpr, data)));
        if (opSymbol == this.symTable.notFoundSymbol) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
        BType resultType = data.resultType;
        BConstantSymbol constantSymbol = data.constantSymbol;
        Object resolvedValue = this.calculateSingletonValue((BFiniteType)lhsType, (BFiniteType)rhsType, binaryExpr.opKind, resultType, data);
        if (resolvedValue == null) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType finiteType = this.getFiniteType(resolvedValue, constantSymbol, resultType);
        if (data.compoundExprCount == 0 && this.types.typeIncompatible(pos, finiteType, expType)) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = finiteType;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr, AnalyzerData data) {
        this.checkConstExpr(groupExpr.expression, data.expType, data);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr, AnalyzerData data) {
        ++data.compoundExprCount;
        BType actualType = this.checkConstExpr(unaryExpr.expr, data.expType, data);
        --data.compoundExprCount;
        if (actualType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BSymbol opSymbol = this.getUnaryOpSymbol(unaryExpr, actualType, data);
        BType resultType = this.getBroadType(data.resultType);
        if (opSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(unaryExpr.pos, DiagnosticErrorCode.UNARY_OP_INCOMPATIBLE_TYPES, new Object[]{unaryExpr.operator, actualType});
            data.resultType = this.symTable.semanticError;
            return;
        }
        BConstantSymbol constantSymbol = data.constantSymbol;
        Object resolvedValue = this.evaluateUnaryOperator((BFiniteType)actualType, resultType, unaryExpr.operator, data);
        if (resolvedValue == null) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType finiteType = this.getFiniteType(resolvedValue, constantSymbol, resultType);
        if (data.compoundExprCount == 0 && this.types.typeIncompatible(unaryExpr.pos, finiteType, data.expType)) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = finiteType;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral, AnalyzerData data) {
        StringBuilder resultString = new StringBuilder();
        for (BLangExpression expr : stringTemplateLiteral.exprs) {
            BType exprType = this.checkConstExpr(expr, data);
            if (exprType == this.symTable.semanticError) {
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (!this.types.isNonNilSimpleBasicTypeOrString(exprType)) {
                this.dlog.error(expr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.interpolationAllowedType, exprType);
                data.resultType = this.symTable.semanticError;
                return;
            }
            resultString.append(SemTypeHelper.getStringValue(exprType).orElseThrow());
        }
        Location pos = stringTemplateLiteral.pos;
        BType finiteType = this.getFiniteType(resultString.toString(), data.constantSymbol, this.symTable.stringType);
        if (data.compoundExprCount == 0 && this.types.typeIncompatible(pos, finiteType, data.expType)) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = finiteType;
    }

    private BRecordType createNewRecordType(BRecordTypeSymbol symbol, LinkedHashMap<String, BField> inferredFields, AnalyzerData data) {
        BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)symbol);
        recordType.restFieldType = this.symTable.noType;
        recordType.fields = inferredFields;
        symbol.type = recordType;
        recordType.tsymbol = symbol;
        recordType.sealed = true;
        TypeDefBuilderHelper.createTypeDefinition(recordType, data.constantSymbol.pos, this.names, this.types, this.symTable, data.env);
        return recordType;
    }

    private BType checkMappingConstructorCompatibility(BType expType, BLangRecordLiteral mappingConstructor, AnalyzerData data) {
        int tag = expType.tag;
        if (tag == 21) {
            return this.checkMappingConstructorCompatibilityForUnionType(expType, mappingConstructor, data);
        }
        if (tag == 14) {
            BType refType = Types.getImpliedType(expType);
            return this.checkMappingConstructorCompatibility(refType, mappingConstructor, data);
        }
        if (tag == 22) {
            return this.checkMappingConstructorCompatibility(((BIntersectionType)expType).effectiveType, mappingConstructor, data);
        }
        BType possibleType = this.getMappingConstructorCompatibleNonUnionType(expType, data);
        return switch (possibleType.tag) {
            case 16 -> this.validateSpecifiedFieldsAndGetType(mappingConstructor, possibleType, data);
            case 12 -> {
                boolean hasAllRequiredFields = this.validateRequiredFields((BRecordType)possibleType, mappingConstructor.fields, mappingConstructor.pos, data);
                if (hasAllRequiredFields) {
                    yield this.validateSpecifiedFieldsAndGetType(mappingConstructor, possibleType, data);
                }
                yield this.symTable.semanticError;
            }
            case 38 -> this.checkConstExpr(mappingConstructor, possibleType, data);
            default -> {
                this.reportIncompatibleMappingConstructorError(mappingConstructor, expType);
                yield this.symTable.semanticError;
            }
        };
    }

    private void reportIncompatibleMappingConstructorError(BLangRecordLiteral mappingConstructorExpr, BType expType) {
        BType[] memberTypes;
        if (expType == this.symTable.semanticError) {
            return;
        }
        if (expType.tag != 21) {
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, expType);
            return;
        }
        BUnionType unionType = (BUnionType)expType;
        for (BType bType : memberTypes = this.types.getAllTypes(unionType, true).toArray(new BType[0])) {
            if (!this.types.isMappingConstructorCompatibleType(bType)) continue;
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_MAPPING_CONSTRUCTOR, unionType);
            return;
        }
        this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, unionType);
    }

    private BType checkMappingConstructorCompatibilityForUnionType(BType expType, BLangRecordLiteral mappingConstructor, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        int errorCount = this.dlog.errorCount();
        this.dlog.mute();
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType memberType : ((BUnionType)expType).getMemberTypes()) {
            BType listCompatibleMemType;
            if (memberType == this.symTable.semanticError || (listCompatibleMemType = this.getMappingConstructorCompatibleNonUnionType(memberType, data)) == this.symTable.semanticError) continue;
            this.dlog.resetErrorCount();
            BType memCompatibiltyType = this.checkMappingConstructorCompatibility(listCompatibleMemType, mappingConstructor, data);
            if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.types.isUniqueType(compatibleTypes, listCompatibleMemType)) continue;
            compatibleTypes.add(listCompatibleMemType);
        }
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        this.dlog.setErrorCount(errorCount);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        if (compatibleTypes.isEmpty()) {
            this.reportIncompatibleMappingConstructorError(mappingConstructor, expType);
            return this.symTable.semanticError;
        }
        if (compatibleTypes.size() != 1) {
            this.dlog.error(mappingConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, expType);
            return this.symTable.semanticError;
        }
        return this.checkMappingConstructorCompatibility((BType)compatibleTypes.get(0), mappingConstructor, data);
    }

    private BType getMappingConstructorCompatibleNonUnionType(BType type, AnalyzerData data) {
        switch (type.tag) {
            case 12: 
            case 16: 
            case 38: {
                return type;
            }
            case 7: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapJsonType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapJsonType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapAnydataType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapAnydataType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 18: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapAllType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapAllType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 22: {
                return ((BIntersectionType)type).effectiveType;
            }
            case 14: {
                BType refType = Types.getImpliedType(type);
                BType compatibleType = this.getMappingConstructorCompatibleNonUnionType(refType, data);
                return compatibleType == refType ? type : compatibleType;
            }
        }
        return this.symTable.semanticError;
    }

    private BType validateSpecifiedFieldsAndGetType(BLangRecordLiteral mappingConstructor, BType possibleType, AnalyzerData data) {
        return switch (possibleType.tag) {
            case 16 -> this.validateMapTypeAndInferredType(mappingConstructor, ((BMapType)possibleType).constraint, possibleType, data);
            case 12 -> this.validateRecordType(mappingConstructor, (BRecordType)possibleType, data);
            default -> this.symTable.semanticError;
        };
    }

    private BType validateMapTypeAndInferredType(BLangRecordLiteral mappingConstructor, BType expType, BType possibleType, AnalyzerData data) {
        BLangExpression exprToCheck;
        BLangRecordLiteral.BLangRecordKey key;
        BLangRecordLiteral.BLangRecordKeyValueField keyValue;
        boolean containErrors = false;
        SymbolEnv env = data.env;
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, mappingConstructor.pos, SymbolOrigin.VIRTUAL, data);
        LinkedHashMap<String, BField> inferredFields = new LinkedHashMap<String, BField>();
        ArrayList<RecordLiteralNode.RecordField> computedFields = new ArrayList<RecordLiteralNode.RecordField>();
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            if (field.isKeyValueField()) {
                keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                key = keyValue.key;
                if (key.computedKey) {
                    computedFields.add(field);
                    continue;
                }
                exprToCheck = keyValue.valueExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(keyValue.valueExpr);
                }
                data.anonTypeNameSuffixes.push(key.toString());
                BType keyValueType = this.checkConstExpr(exprToCheck, expType, data);
                data.anonTypeNameSuffixes.pop();
                if (keyValueType == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                BLangExpression keyExpr = key.expr;
                if (this.addFields(inferredFields, keyValueType, this.getKeyName(keyExpr), keyExpr.pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BType varRefType;
                BLangRecordLiteral.BLangRecordVarNameField varNameField;
                exprToCheck = varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(varNameField);
                }
                if ((varRefType = this.checkConstExpr(exprToCheck, expType, data)) == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                if (this.addFields(inferredFields, varRefType, this.getKeyName(varNameField), varNameField.pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            BLangExpression fieldExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
            BType spreadOpType = this.checkConstExpr(fieldExpr, data);
            BType type = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOpType));
            if (type.tag != 12) {
                containErrors = true;
                continue;
            }
            if (this.types.checkType(fieldExpr, type, possibleType) == this.symTable.semanticError) {
                containErrors = true;
                continue;
            }
            BRecordType recordType = (BRecordType)type;
            for (BField recField : recordType.fields.values()) {
                if (this.addFields(inferredFields, Types.getImpliedType(recField.type), recField.name.value, fieldExpr.pos, recordSymbol)) continue;
                containErrors = true;
            }
        }
        for (RecordLiteralNode.RecordField field : computedFields) {
            Optional str;
            SemType semtype;
            keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            key = keyValue.key;
            BType fieldName = this.checkConstExpr(key.expr, data);
            if (fieldName.tag == 33 && SemTypes.isSubtypeSimple((SemType)(semtype = fieldName.semType()), (BasicTypeBitSet)PredefinedType.STRING) && (str = StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.stringSubtype((SemType)semtype))).isPresent()) {
                BType keyValueType;
                exprToCheck = keyValue.valueExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(keyValue.valueExpr);
                }
                if (this.addFields(inferredFields, Types.getImpliedType(keyValueType = this.checkConstExpr(exprToCheck, expType, data)), (String)str.get(), key.pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            this.dlog.error(key.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.stringType, fieldName);
            containErrors = true;
        }
        if (containErrors) {
            return this.symTable.semanticError;
        }
        return this.createNewRecordType(recordSymbol, inferredFields, data);
    }

    private BType validateRecordType(BLangRecordLiteral mappingConstructor, BRecordType expRecordType, AnalyzerData data) {
        BLangExpression exprToCheck;
        BType expType;
        Object key;
        BLangRecordLiteral.BLangRecordKeyValueField keyValue;
        boolean containErrors = false;
        SymbolEnv env = data.env;
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, mappingConstructor.pos, SymbolOrigin.VIRTUAL, data);
        LinkedHashMap<String, BField> inferredFields = new LinkedHashMap<String, BField>();
        ArrayList<RecordLiteralNode.RecordField> computedFields = new ArrayList<RecordLiteralNode.RecordField>();
        LinkedHashMap targetFields = expRecordType.fields;
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            if (field.isKeyValueField()) {
                keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                key = keyValue.key;
                if (((BLangRecordLiteral.BLangRecordKey)key).computedKey) {
                    computedFields.add(field);
                    continue;
                }
                if (!targetFields.containsKey(((BLangRecordLiteral.BLangRecordKey)key).toString())) {
                    if (expRecordType.sealed) {
                        this.dlog.error(keyValue.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, expRecordType.tsymbol.type.getKind().typeName(), expRecordType);
                        containErrors = true;
                        continue;
                    }
                    expType = expRecordType.restFieldType;
                } else {
                    expType = ((BField)targetFields.get((Object)((BLangRecordLiteral.BLangRecordKey)key).toString())).type;
                }
                exprToCheck = keyValue.valueExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(keyValue.valueExpr);
                }
                data.anonTypeNameSuffixes.push(((BLangRecordLiteral.BLangRecordKey)key).toString());
                BType keyValueType = this.checkConstExpr(exprToCheck, expType, data);
                data.anonTypeNameSuffixes.pop();
                if (keyValueType == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                BLangExpression keyExpr = ((BLangRecordLiteral.BLangRecordKey)key).expr;
                if (this.addFields(inferredFields, keyValueType, this.getKeyName(keyExpr), keyExpr.pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BType varRefType;
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                key = field.toString();
                if (!targetFields.containsKey(key)) {
                    if (expRecordType.sealed) {
                        containErrors = true;
                        this.dlog.error(varNameField.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, expRecordType.tsymbol.type.getKind().typeName(), expRecordType);
                        continue;
                    }
                    expType = expRecordType.restFieldType;
                } else {
                    expType = ((BField)targetFields.get((Object)key)).type;
                }
                exprToCheck = varNameField;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(varNameField);
                }
                if ((varRefType = this.checkConstExpr(exprToCheck, expType, data)) == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                if (this.addFields(inferredFields, Types.getImpliedType(varRefType), this.getKeyName(varNameField), varNameField.pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            BLangExpression fieldExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
            BType spreadOpType = this.checkConstExpr(fieldExpr, data);
            BType type = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOpType));
            if (type.tag != 12) {
                containErrors = true;
                continue;
            }
            BRecordType recordType = (BRecordType)type;
            for (BField recField : recordType.fields.values()) {
                if (this.types.checkType(fieldExpr, recField.type, expRecordType.restFieldType) == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                if (this.addFields(inferredFields, Types.getImpliedType(recField.type), recField.name.value, fieldExpr.pos, recordSymbol)) continue;
                containErrors = true;
            }
        }
        for (RecordLiteralNode.RecordField field : computedFields) {
            Optional str;
            SemType semtype;
            keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            key = keyValue.key;
            BType fieldName = this.checkConstExpr(((BLangRecordLiteral.BLangRecordKey)key).expr, data);
            if (fieldName.tag == 33 && SemTypes.isSubtypeSimple((SemType)(semtype = fieldName.semType()), (BasicTypeBitSet)PredefinedType.STRING) && (str = StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.stringSubtype((SemType)semtype))).isPresent()) {
                BType keyValueType;
                String keyName = (String)str.get();
                if (!targetFields.containsKey(keyName)) {
                    if (expRecordType.sealed) {
                        containErrors = true;
                        this.dlog.error(keyValue.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, expRecordType.tsymbol.type.getKind().typeName(), expRecordType);
                        continue;
                    }
                    expType = expRecordType.restFieldType;
                } else {
                    expType = ((BField)targetFields.get((Object)keyName)).type;
                }
                exprToCheck = keyValue.valueExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    exprToCheck = this.nodeCloner.cloneNode(keyValue.valueExpr);
                }
                if (this.addFields(inferredFields, Types.getImpliedType(keyValueType = this.checkConstExpr(exprToCheck, expType, data)), keyName, ((BLangRecordLiteral.BLangRecordKey)key).pos, recordSymbol)) continue;
                containErrors = true;
                continue;
            }
            this.dlog.error(((BLangRecordLiteral.BLangRecordKey)key).pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, fieldName, this.symTable.stringType);
            containErrors = true;
        }
        if (containErrors) {
            return this.symTable.semanticError;
        }
        return this.createNewRecordType(recordSymbol, inferredFields, data);
    }

    private boolean validateRequiredFields(BRecordType type, List<RecordLiteralNode.RecordField> specifiedFields, Location pos, AnalyzerData data) {
        HashSet<String> specFieldNames = this.getFieldNames(specifiedFields, data);
        boolean hasAllRequiredFields = true;
        for (BField field : type.fields.values()) {
            String fieldName = field.name.value;
            if (specFieldNames.contains(fieldName) || !Symbols.isFlagOn(field.symbol.flags, 256L) || this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(field.type)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            if (!hasAllRequiredFields) continue;
            hasAllRequiredFields = false;
        }
        return hasAllRequiredFields;
    }

    private HashSet<String> getFieldNames(List<RecordLiteralNode.RecordField> specifiedFields, AnalyzerData data) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (RecordLiteralNode.RecordField specifiedField : specifiedFields) {
            if (specifiedField.isKeyValueField()) {
                String name = this.typeChecker.getKeyValueFieldName((BLangRecordLiteral.BLangRecordKeyValueField)specifiedField);
                if (name == null) continue;
                fieldNames.add(name);
                continue;
            }
            if (specifiedField.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                fieldNames.add(((BLangRecordLiteral.BLangRecordVarNameField)specifiedField).variableName.value);
                continue;
            }
            fieldNames.addAll(this.getSpreadOpFieldRequiredFieldNames((BLangRecordLiteral.BLangRecordSpreadOperatorField)specifiedField, data));
        }
        return fieldNames;
    }

    private List<String> getSpreadOpFieldRequiredFieldNames(BLangRecordLiteral.BLangRecordSpreadOperatorField field, AnalyzerData data) {
        BType spreadType = Types.getImpliedType(this.checkConstExpr(field.expr, data));
        if (spreadType.tag != 12) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (BField bField : ((BRecordType)spreadType).getFields().values()) {
            if (Symbols.isOptional(bField.symbol)) continue;
            fieldNames.add(bField.name.value);
        }
        return fieldNames;
    }

    private BType defineInferredTupleType(BLangListConstructorExpr listConstructor, AnalyzerData data) {
        boolean containErrors = false;
        ArrayList<BType> memberTypes = new ArrayList<BType>();
        for (BLangExpression expr : listConstructor.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                BType spreadOpExprType = this.checkConstExpr(spreadOpExpr, data);
                BType type = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOpExprType));
                if (type.tag != 31) {
                    containErrors = true;
                    continue;
                }
                memberTypes.addAll(((BTupleType)type).getTupleTypes());
                continue;
            }
            BType tupleMemberType = this.checkConstExpr(expr, data);
            if (tupleMemberType == this.symTable.semanticError) {
                containErrors = true;
                continue;
            }
            memberTypes.add(tupleMemberType);
        }
        if (containErrors) {
            return this.symTable.semanticError;
        }
        return this.createNewTupleType(listConstructor.pos, memberTypes, data);
    }

    private BType checkListConstructorCompatibility(BType expType, BLangListConstructorExpr listConstructor, AnalyzerData data) {
        int tag = expType.tag;
        if (tag == 21) {
            boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
            int errorCount = this.dlog.errorCount();
            data.commonAnalyzerData.nonErrorLoggingCheck = true;
            this.dlog.mute();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            for (BType memberType : ((BUnionType)expType).getMemberTypes()) {
                BType listCompatibleMemType;
                if (memberType == this.symTable.semanticError || (listCompatibleMemType = this.getListConstructorCompatibleNonUnionType(memberType, data)) == this.symTable.semanticError) continue;
                this.dlog.resetErrorCount();
                BType memCompatibiltyType = this.checkListConstructorCompatibility(listCompatibleMemType, listConstructor, data);
                if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.types.isUniqueType(compatibleTypes, memCompatibiltyType)) continue;
                compatibleTypes.add(memCompatibiltyType);
            }
            data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.dlog.setErrorCount(errorCount);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (compatibleTypes.isEmpty()) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, listConstructor);
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, data.expType);
                return this.symTable.semanticError;
            }
            return this.checkListConstructorCompatibility((BType)compatibleTypes.get(0), listConstructor, data);
        }
        if (tag == 14) {
            return this.checkListConstructorCompatibility(Types.getImpliedType(expType), listConstructor, data);
        }
        if (tag == 22) {
            return this.checkListConstructorCompatibility(((BIntersectionType)expType).effectiveType, listConstructor, data);
        }
        BType possibleType = this.getListConstructorCompatibleNonUnionType(expType, data);
        return switch (possibleType.tag) {
            case 20, 35 -> this.checkArrayType((BArrayType)possibleType, listConstructor, data);
            case 31 -> this.checkTupleType((BTupleType)possibleType, listConstructor, data);
            case 38 -> this.checkConstExpr(listConstructor, possibleType, data);
            default -> {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, listConstructor);
                yield this.symTable.semanticError;
            }
        };
    }

    private BType checkArrayType(BArrayType arrayType, BLangListConstructorExpr listConstructor, AnalyzerData data) {
        int listExprSize = 0;
        if (arrayType.state != BArrayState.OPEN) {
            block4: for (BLangExpression expr : listConstructor.exprs) {
                if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    ++listExprSize;
                    continue;
                }
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                Object spreadOpType = this.checkConstExpr(spreadOpExpr, data);
                spreadOpType = Types.getImpliedType((BType)spreadOpType);
                switch (((BType)spreadOpType).tag) {
                    case 20: {
                        int arraySize = ((BArrayType)spreadOpType).getSize();
                        if (arraySize >= 0) {
                            listExprSize += arraySize;
                            continue block4;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                    case 31: {
                        BTupleType tType = (BTupleType)spreadOpType;
                        if (this.types.isFixedLengthTuple(tType)) {
                            listExprSize += tType.getMembers().size();
                            continue block4;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                }
            }
        }
        BType eType = arrayType.eType;
        if (arrayType.state == BArrayState.INFERRED) {
            arrayType.setSize(listExprSize);
            arrayType.state = BArrayState.CLOSED;
        } else if (arrayType.state != BArrayState.OPEN && arrayType.getSize() != listExprSize) {
            if (arrayType.getSize() < listExprSize) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.MISMATCHING_ARRAY_LITERAL_VALUES, arrayType.getSize(), listExprSize);
                return this.symTable.semanticError;
            }
            if (!this.types.hasFillerValue(eType)) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, data.expType);
                return this.symTable.semanticError;
            }
        }
        boolean containErrors = false;
        ArrayList<BType> memberTypes = new ArrayList<BType>();
        for (BLangExpression expr : listConstructor.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                BType spreadOpExprType = this.checkConstExpr(spreadOpExpr, data);
                BType type = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOpExprType));
                if (type.tag != 31) {
                    containErrors = true;
                    continue;
                }
                for (BType memberType : ((BTupleType)type).getTupleTypes()) {
                    if (this.types.checkType(expr.pos, memberType, eType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES) == this.symTable.semanticError) {
                        containErrors = true;
                        continue;
                    }
                    memberTypes.add(memberType);
                }
                continue;
            }
            BType tupleMemberType = this.checkExprIncompatible(eType, expr, data);
            if (tupleMemberType == this.symTable.semanticError) {
                containErrors = true;
                continue;
            }
            memberTypes.add(tupleMemberType);
        }
        if (containErrors) {
            return this.symTable.semanticError;
        }
        BTupleType resultTupleType = this.createNewTupleType(listConstructor.pos, memberTypes, data);
        if (arrayType.state == BArrayState.CLOSED && arrayType.getSize() > listExprSize && !this.fillMembers.addFillMembers(resultTupleType, arrayType, data)) {
            return this.symTable.semanticError;
        }
        return resultTupleType;
    }

    private BType checkTupleType(BTupleType tupleType, BLangListConstructorExpr listConstructor, AnalyzerData data) {
        List<BLangExpression> exprs = listConstructor.exprs;
        List<BTupleMember> members = tupleType.getMembers();
        int memberTypeSize = members.size();
        BType restType = tupleType.restType;
        if (this.types.isFixedLengthTuple(tupleType)) {
            int listExprSize = 0;
            block4: for (BLangExpression expr : exprs) {
                if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    ++listExprSize;
                    continue;
                }
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                BType spreadOpType = this.checkConstExpr(spreadOpExpr, data);
                spreadOpType = Types.getImpliedType(spreadOpType);
                switch (spreadOpType.tag) {
                    case 20: {
                        int arraySize = ((BArrayType)spreadOpType).getSize();
                        if (arraySize >= 0) {
                            listExprSize += arraySize;
                            continue block4;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                    case 31: {
                        BTupleType tType = (BTupleType)spreadOpType;
                        if (this.types.isFixedLengthTuple(tType)) {
                            listExprSize += tType.getMembers().size();
                            continue block4;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                }
            }
            if (listExprSize < memberTypeSize) {
                for (int i = listExprSize; i < memberTypeSize; ++i) {
                    if (this.types.hasFillerValue(members.get((int)i).type)) continue;
                    this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, members.get(i));
                    return this.symTable.semanticError;
                }
            } else if (listExprSize > memberTypeSize) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.TUPLE_AND_EXPRESSION_SIZE_DOES_NOT_MATCH, new Object[0]);
                return this.symTable.semanticError;
            }
        }
        boolean containErrors = false;
        int nonRestTypeIndex = 0;
        ArrayList<BType> memberTypes = new ArrayList<BType>();
        for (BLangExpression expr : exprs) {
            BType tupleMemberType;
            int i;
            int remainNonRestCount = memberTypeSize - nonRestTypeIndex;
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BType memberType;
                if (remainNonRestCount > 0) {
                    memberType = this.checkExprIncompatible(members.get((int)nonRestTypeIndex).type, expr, data);
                    ++nonRestTypeIndex;
                } else {
                    memberType = this.checkExprIncompatible(restType, expr, data);
                }
                if (memberType == this.symTable.semanticError) {
                    containErrors = true;
                    continue;
                }
                memberTypes.add(memberType);
                continue;
            }
            BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            BType spreadOpType = this.checkConstExpr(spreadOpExpr, data);
            BType spreadOpReferredType = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOpType));
            if (spreadOpReferredType.tag != 31) {
                containErrors = true;
                continue;
            }
            BTupleType spreadOpTuple = (BTupleType)spreadOpReferredType;
            List<BType> tupleMemberTypes = spreadOpTuple.getTupleTypes();
            int spreadOpMemberTypeSize = tupleMemberTypes.size();
            for (i = 0; i < spreadOpMemberTypeSize && nonRestTypeIndex < memberTypeSize; ++i, ++nonRestTypeIndex) {
                tupleMemberType = tupleMemberTypes.get(i);
                if (this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberType, members.get((int)nonRestTypeIndex).type)) {
                    return this.symTable.semanticError;
                }
                memberTypes.add(tupleMemberType);
            }
            for (i = remainNonRestCount; i < spreadOpMemberTypeSize; ++i) {
                tupleMemberType = tupleMemberTypes.get(i);
                if (this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberType, restType)) {
                    return this.symTable.semanticError;
                }
                memberTypes.add(tupleMemberType);
            }
        }
        if (containErrors) {
            return this.symTable.semanticError;
        }
        BTupleType resultTupleType = this.createNewTupleType(listConstructor.pos, memberTypes, data);
        if (memberTypeSize - nonRestTypeIndex > 0 && !this.fillMembers.addFillMembers(resultTupleType, tupleType, data)) {
            return this.symTable.semanticError;
        }
        return resultTupleType;
    }

    private BTupleType createNewTupleType(Location pos, List<BType> memberTypes, AnalyzerData data) {
        SymbolEnv symbolEnv = data.env;
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, 1L, Names.EMPTY, symbolEnv.enclPkg.symbol.pkgID, null, symbolEnv.scope.owner, pos, SymbolOrigin.SOURCE);
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
        memberTypes.forEach(m -> members.add(new BTupleMember((BType)m, Symbols.createVarSymbolForTupleMember(m))));
        BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, members);
        tupleType.tsymbol.type = tupleType;
        return tupleType;
    }

    private BType checkExprIncompatible(BType eType, BLangExpression expr, AnalyzerData data) {
        if (expr.typeChecked) {
            return expr.getBType();
        }
        BLangExpression exprToCheck = expr;
        if (data.commonAnalyzerData.nonErrorLoggingCheck) {
            ++expr.cloneAttempt;
            exprToCheck = this.nodeCloner.cloneNode(expr);
        }
        return this.checkConstExpr(exprToCheck, eType, data);
    }

    private BType getListConstructorCompatibleNonUnionType(BType type, AnalyzerData data) {
        return switch (type.tag) {
            case 13, 20, 31, 35, 38 -> type;
            case 7 -> {
                if (!Symbols.isFlagOn(type.getFlags(), 32L)) {
                    yield this.symTable.arrayJsonType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayJsonType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11 -> {
                if (!Symbols.isFlagOn(type.getFlags(), 32L)) {
                    yield this.symTable.arrayAnydataType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayAnydataType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 18 -> {
                if (!Symbols.isFlagOn(type.getFlags(), 32L)) {
                    yield this.symTable.arrayAllType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayAllType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 22 -> ((BIntersectionType)type).effectiveType;
            default -> this.symTable.semanticError;
        };
    }

    private BType getBroadType(BType type) {
        if (type.tag != 33) {
            return type;
        }
        return SemTypeHelper.singleShapeBroadType(type.semType(), this.symTable).get();
    }

    private BSymbol getUnaryOpSymbol(BLangUnaryExpr unaryExpr, BType type, AnalyzerData data) {
        if (type == this.symTable.semanticError) {
            return this.symTable.notFoundSymbol;
        }
        BType exprType = type;
        BSymbol symbol = this.symResolver.resolveUnaryOperator(unaryExpr.operator, exprType);
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.symResolver.getUnaryOpsForTypeSets(unaryExpr.operator, exprType);
        }
        if (symbol != this.symTable.notFoundSymbol) {
            unaryExpr.opSymbol = (BOperatorSymbol)symbol;
            data.resultType = symbol.type.getReturnType();
        }
        if (symbol == this.symTable.notFoundSymbol) {
            exprType = SemTypeHelper.singleShapeBroadType(type.semType(), this.symTable).get();
            symbol = this.symResolver.resolveUnaryOperator(unaryExpr.operator, exprType);
            if (symbol == this.symTable.notFoundSymbol) {
                symbol = this.symResolver.getUnaryOpsForTypeSets(unaryExpr.operator, exprType);
            }
            if (symbol != this.symTable.notFoundSymbol) {
                unaryExpr.opSymbol = (BOperatorSymbol)symbol;
                data.resultType = symbol.type.getReturnType();
            }
        }
        return symbol;
    }

    private Object calculateSingletonValue(BFiniteType lhs, BFiniteType rhs, OperatorKind kind, BType type, AnalyzerData data) {
        if (lhs == null || rhs == null) {
            return null;
        }
        Object lhsValue = ((Value)Core.singleShape((SemType)lhs.semType()).get()).value;
        Object rhsValue = ((Value)Core.singleShape((SemType)rhs.semType()).get()).value;
        try {
            switch (kind) {
                case ADD: {
                    return this.calculateAddition(lhsValue, rhsValue, type, data);
                }
                case SUB: {
                    return this.calculateSubtract(lhsValue, rhsValue, type, data);
                }
                case MUL: {
                    return this.calculateMultiplication(lhsValue, rhsValue, type, data);
                }
                case DIV: {
                    return this.calculateDivision(lhsValue, rhsValue, type, data);
                }
                case MOD: {
                    return this.calculateMod(lhsValue, rhsValue, type);
                }
                case BITWISE_AND: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a & b, type, data);
                }
                case BITWISE_OR: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a | b, type, data);
                }
                case BITWISE_LEFT_SHIFT: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a << (int)b.longValue(), type, data);
                }
                case BITWISE_RIGHT_SHIFT: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a >> (int)b.longValue(), type, data);
                }
                case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a >>> (int)b.longValue(), type, data);
                }
                case BITWISE_XOR: {
                    return this.calculateBitWiseOp(lhsValue, rhsValue, (a, b) -> a ^ b, type, data);
                }
            }
            this.dlog.error(data.pos, DiagnosticErrorCode.CONSTANT_EXPRESSION_NOT_SUPPORTED, new Object[0]);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArithmeticException ae) {
            this.dlog.error(data.pos, DiagnosticErrorCode.INVALID_CONST_EXPRESSION, ae.getMessage());
        }
        return null;
    }

    private Object getValue(BLangLiteral lhsLiteral) {
        Object value = lhsLiteral.value;
        if (value instanceof BLangConstantValue) {
            BLangConstantValue bLangConstantValue = (BLangConstantValue)value;
            return bLangConstantValue.value;
        }
        return value;
    }

    private Object evaluateUnaryOperator(BFiniteType finiteType, BType type, OperatorKind kind, AnalyzerData data) {
        Optional optionalValue = Core.singleShape((SemType)finiteType.semType());
        if (optionalValue.isEmpty()) {
            return null;
        }
        Object value = ((Value)optionalValue.get()).value;
        try {
            switch (kind) {
                case ADD: {
                    return value;
                }
                case SUB: {
                    return this.calculateNegation(value, type, data);
                }
                case BITWISE_COMPLEMENT: {
                    return this.calculateBitWiseComplement(value, type);
                }
                case NOT: {
                    return this.calculateBooleanComplement(value, type);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private Object calculateBitWiseOp(Object lhs, Object rhs, BiFunction<Long, Long, Long> func, BType type, AnalyzerData data) {
        if (Types.getImpliedType((BType)type).tag == 1) {
            return func.apply((Long)lhs, (Long)rhs);
        }
        this.dlog.error(data.pos, DiagnosticErrorCode.CONSTANT_EXPRESSION_NOT_SUPPORTED, new Object[0]);
        return null;
    }

    private Object calculateAddition(Object lhs, Object rhs, BType type, AnalyzerData data) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 2: {
                try {
                    return Math.addExact((Long)lhs, (Long)rhs);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(data.pos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                    return null;
                }
            }
            case 3: {
                return String.valueOf(Double.parseDouble(String.valueOf(lhs)) + Double.parseDouble(String.valueOf(rhs)));
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.add(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(data.pos, resultDecimal);
                return resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
            case 5: {
                return String.valueOf(lhs) + String.valueOf(rhs);
            }
        }
        return null;
    }

    private Object calculateSubtract(Object lhs, Object rhs, BType type, AnalyzerData data) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 2: {
                try {
                    return Math.subtractExact((Long)lhs, (Long)rhs);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(data.pos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                    return null;
                }
            }
            case 3: {
                return String.valueOf(Double.parseDouble(String.valueOf(lhs)) - Double.parseDouble(String.valueOf(rhs)));
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.compareTo(rhsDecimal) == 0 ? BigDecimal.ZERO : lhsDecimal.subtract(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(data.pos, resultDecimal);
                return resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return null;
    }

    private Object calculateMultiplication(Object lhs, Object rhs, BType type, AnalyzerData data) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 2: {
                try {
                    return Math.multiplyExact((long)((Long)lhs), (Long)rhs);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(data.pos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                    return null;
                }
            }
            case 3: {
                return String.valueOf(Double.parseDouble(String.valueOf(lhs)) * Double.parseDouble(String.valueOf(rhs)));
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.multiply(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(data.pos, resultDecimal);
                return resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return null;
    }

    private Object calculateDivision(Object lhs, Object rhs, BType type, AnalyzerData data) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 2: {
                if ((Long)lhs == Long.MIN_VALUE && (Long)rhs == -1L) {
                    this.dlog.error(data.pos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                    return null;
                }
                return (Long)lhs / (Long)rhs;
            }
            case 3: {
                return String.valueOf(Double.parseDouble(String.valueOf(lhs)) / Double.parseDouble(String.valueOf(rhs)));
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.divide(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(data.pos, resultDecimal);
                return resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return null;
    }

    private Object calculateMod(Object lhs, Object rhs, BType type) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 2: {
                return (Long)lhs % (Long)rhs;
            }
            case 3: {
                return String.valueOf(Double.parseDouble(String.valueOf(lhs)) % Double.parseDouble(String.valueOf(rhs)));
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.remainder(rhsDecimal, MathContext.DECIMAL128);
                return resultDecimal.toPlainString();
            }
        }
        return null;
    }

    private Object calculateNegationForInt(Object value, AnalyzerData data) {
        if ((Long)value == Long.MIN_VALUE) {
            this.dlog.error(data.pos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
            return null;
        }
        return -1L * (Long)value;
    }

    private Object calculateNegationForFloat(Object value) {
        return String.valueOf(-1.0 * Double.parseDouble(String.valueOf(value)));
    }

    private Object calculateNegationForDecimal(Object value) {
        BigDecimal valDecimal = new BigDecimal(String.valueOf(value), MathContext.DECIMAL128);
        BigDecimal negDecimal = new BigDecimal(String.valueOf(-1), MathContext.DECIMAL128);
        BigDecimal resultDecimal = valDecimal.multiply(negDecimal, MathContext.DECIMAL128);
        return resultDecimal.toPlainString();
    }

    private Object calculateNegation(Object value, BType type, AnalyzerData data) {
        return switch (type.tag) {
            case 1 -> this.calculateNegationForInt(value, data);
            case 3 -> this.calculateNegationForFloat(value);
            case 4 -> this.calculateNegationForDecimal(value);
            default -> null;
        };
    }

    private Object calculateBitWiseComplement(Object value, BType type) {
        Long result = null;
        if (Types.getImpliedType((BType)type).tag == 1) {
            result = (Long)value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    private Object calculateBooleanComplement(Object value, BType type) {
        Boolean result = null;
        if (Types.getImpliedType((BType)type).tag == 6) {
            result = (Boolean)value == false;
        }
        return result;
    }

    private BType setLiteralValueAndGetType(BLangLiteral literalExpr, BType expType, AnalyzerData data) {
        Object literalValue = literalExpr.value;
        BType expectedType = Types.getImpliedType(expType);
        if (literalExpr.getKind() == NodeKind.NUMERIC_LITERAL) {
            NodeKind kind = ((BLangNumericLiteral)literalExpr).kind;
            if (kind == NodeKind.INTEGER_LITERAL) {
                return this.getIntegerLiteralType(literalExpr, literalValue, expectedType);
            }
            if (kind == NodeKind.DECIMAL_FLOATING_POINT_LITERAL) {
                if (NumericLiteralSupport.isFloatDiscriminated(literalExpr.originalValue)) {
                    return this.getTypeOfLiteralWithFloatDiscriminator(literalExpr, literalValue);
                }
                if (NumericLiteralSupport.isDecimalDiscriminated(literalExpr.originalValue)) {
                    return this.getTypeOfLiteralWithDecimalDiscriminator(literalExpr, literalValue);
                }
                return this.getTypeOfDecimalFloatingPointLiteral(literalExpr, literalValue, expectedType);
            }
            return this.getTypeOfHexFloatingPointLiteral(literalExpr, literalValue, data);
        }
        BType literalType = this.symTable.getTypeFromTag(literalExpr.getBType().tag);
        return literalType;
    }

    private BType getTypeOfLiteralWithFloatDiscriminator(BLangLiteral literalExpr, Object literalValue) {
        String numericLiteral = NumericLiteralSupport.stripDiscriminator(String.valueOf(literalValue));
        if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
            return this.symTable.semanticError;
        }
        literalExpr.value = Double.parseDouble(numericLiteral);
        return this.symTable.floatType;
    }

    public BType getIntegerLiteralType(BLangLiteral literalExpr, Object literalValue, BType expType) {
        return this.getIntegerLiteralTypeUsingExpType(literalExpr, literalValue, expType);
    }

    private BType getIntegerLiteralTypeUsingExpType(BLangLiteral literalExpr, Object literalValue, BType expType) {
        BType expectedType = Types.getImpliedType(expType);
        int expectedTypeTag = expectedType.tag;
        switch (expectedTypeTag) {
            case 1: 
            case 2: 
            case 7: 
            case 11: 
            case 18: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (!(literalValue instanceof Long)) {
                    this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, expType);
                    return this.symTable.semanticError;
                }
                if (literalExpr.getBType().tag == 2) {
                    return this.symTable.byteType;
                }
                return this.symTable.intType;
            }
            case 3: {
                if (literalValue instanceof String) {
                    this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, expectedType);
                    return this.symTable.semanticError;
                }
                literalExpr.value = literalValue instanceof Double ? literalValue : Double.valueOf(((Long)literalValue).doubleValue());
                return this.symTable.floatType;
            }
            case 4: {
                literalExpr.value = String.valueOf(literalValue);
                return this.symTable.decimalType;
            }
            case 33: {
                Set<BType> broadTypes = SemTypeHelper.broadTypes((BFiniteType)expectedType, this.symTable);
                if (broadTypes.size() == 1) {
                    return this.getIntegerLiteralTypeUsingExpType(literalExpr, literalValue, broadTypes.iterator().next());
                }
                BUnionType unionType = new BUnionType(this.types.typeEnv(), null, new LinkedHashSet<BType>(broadTypes), false);
                return this.getIntegerLiteralTypeUsingExpType(literalExpr, literalValue, unionType);
            }
            case 21: {
                BUnionType expectedUnionType = (BUnionType)expectedType;
                ArrayList<BType> validTypes = new ArrayList<BType>();
                this.dlog.mute();
                for (BType memType : expectedUnionType.getMemberTypes()) {
                    BType validType = this.getIntegerLiteralTypeUsingExpType(literalExpr, literalValue, memType);
                    if (validType.tag == 28) continue;
                    validTypes.add(validType);
                }
                this.dlog.unmute();
                validTypes.sort(Comparator.comparingInt(t -> t.tag));
                for (BType validType : validTypes) {
                    if (validType.tag == 1) {
                        literalExpr.value = literalValue;
                        return this.symTable.intType;
                    }
                    if (validType.tag == 3) {
                        literalExpr.value = literalValue instanceof Double ? literalValue : Double.valueOf(((Long)literalValue).doubleValue());
                        return this.symTable.floatType;
                    }
                    if (validType.tag != 4) continue;
                    literalExpr.value = String.valueOf(literalValue);
                    return this.symTable.decimalType;
                }
                break;
            }
        }
        if (!(literalValue instanceof Long)) {
            this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, literalExpr.getBType());
            return this.symTable.semanticError;
        }
        if (literalExpr.getBType().tag == 2) {
            return this.symTable.byteType;
        }
        return this.symTable.intType;
    }

    private BType getTypeOfLiteralWithDecimalDiscriminator(BLangLiteral literalExpr, Object literalValue) {
        literalExpr.value = NumericLiteralSupport.stripDiscriminator(String.valueOf(literalValue));
        if (!this.types.isValidDecimalNumber(literalExpr.pos, literalExpr.value.toString())) {
            return this.symTable.semanticError;
        }
        return this.symTable.decimalType;
    }

    private BType getTypeOfDecimalFloatingPointLiteral(BLangLiteral literalExpr, Object literalValue, BType expType) {
        String numericLiteral = String.valueOf(literalValue);
        BType literalType = this.getTypeOfDecimalFloatingPointLiteralUsingExpType(literalExpr, literalValue, expType);
        if (literalType != this.symTable.semanticError) {
            return literalType;
        }
        return this.types.validateFloatLiteral(literalExpr.pos, numericLiteral) ? this.symTable.floatType : this.symTable.semanticError;
    }

    private BType getTypeOfDecimalFloatingPointLiteralUsingExpType(BLangLiteral literalExpr, Object literalValue, BType expType) {
        BType expectedType = Types.getImpliedType(expType);
        String numericLiteral = String.valueOf(literalValue);
        switch (expectedType.tag) {
            case 3: 
            case 7: 
            case 11: 
            case 18: {
                if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
                    return this.symTable.semanticError;
                }
                return this.symTable.floatType;
            }
            case 4: {
                if (this.types.isValidDecimalNumber(literalExpr.pos, literalExpr.value.toString())) {
                    return this.symTable.decimalType;
                }
                return this.symTable.semanticError;
            }
            case 33: {
                BType expBroadType = SemTypeHelper.singleShapeBroadType(expectedType.semType(), this.symTable).get();
                return this.getTypeOfDecimalFloatingPointLiteralUsingExpType(literalExpr, literalValue, expBroadType);
            }
            case 21: {
                BUnionType expectedUnionType = (BUnionType)expectedType;
                ArrayList<BType> validTypes = new ArrayList<BType>();
                this.dlog.mute();
                for (BType memType : expectedUnionType.getMemberTypes()) {
                    BType validType = this.getTypeOfDecimalFloatingPointLiteralUsingExpType(literalExpr, literalValue, memType);
                    if (validType.tag == 28) continue;
                    validTypes.add(validType);
                }
                this.dlog.unmute();
                validTypes.sort(Comparator.comparingInt(t -> t.tag));
                for (BType validType : validTypes) {
                    if (validType.tag == 3) {
                        return this.symTable.floatType;
                    }
                    if (validType.tag != 4) continue;
                    return this.symTable.decimalType;
                }
                break;
            }
        }
        return this.symTable.semanticError;
    }

    public BType getTypeOfHexFloatingPointLiteral(BLangLiteral literalExpr, Object literalValue, AnalyzerData data) {
        String numericLiteral = String.valueOf(literalValue);
        if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
            data.resultType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        literalExpr.value = Double.parseDouble(numericLiteral);
        return this.symTable.floatType;
    }

    private BType getFiniteType(Object value, BConstantSymbol constantSymbol, BType type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, constantSymbol.flags, Names.EMPTY, constantSymbol.pkgID, null, constantSymbol.owner, constantSymbol.pos, SymbolOrigin.VIRTUAL);
                return BFiniteType.newSingletonBFiniteType(finiteTypeSymbol, SemTypeHelper.resolveSingletonType(value, type.getKind()));
            }
        }
        return type;
    }

    private BLangLiteral getLiteral(Object value, Location pos, BType type) {
        return switch (type.tag) {
            case 1, 3, 4 -> this.updateLiteral((BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression(), value, type, pos);
            case 2 -> this.updateLiteral((BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression(), value, this.symTable.byteType, pos);
            default -> this.updateLiteral((BLangLiteral)TreeBuilder.createLiteralExpression(), value, type, pos);
        };
    }

    private BLangLiteral updateLiteral(BLangLiteral literal, Object value, BType type, Location pos) {
        literal.value = value;
        literal.isConstant = true;
        literal.setBType(type);
        literal.pos = pos;
        return literal;
    }

    private boolean addFields(LinkedHashMap<String, BField> fields, BType keyValueType, String key, Location pos, BRecordTypeSymbol recordSymbol) {
        Name fieldName = Names.fromString(key);
        if (fields.containsKey(key)) {
            this.dlog.error(pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_MAPPING_CONSTRUCTOR, TypeKind.RECORD.typeName(), key);
            return false;
        }
        long flags = recordSymbol.flags | 0x100L;
        BVarSymbol fieldSymbol = new BVarSymbol(flags, fieldName, recordSymbol.pkgID, keyValueType, recordSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        fields.put(fieldName.value, new BField(fieldName, null, fieldSymbol));
        return true;
    }

    private String getKeyName(BLangExpression key) {
        return key.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)key).variableName.value : (String)((BLangLiteral)key).value;
    }

    private BRecordTypeSymbol createRecordTypeSymbol(PackageID pkgID, Location location, SymbolOrigin origin, AnalyzerData data) {
        SymbolEnv env = data.env;
        Name genName = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(pkgID, data.anonTypeNameSuffixes));
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(data.constantSymbol.flags, genName, pkgID, null, env.scope.owner, location, origin);
        recordSymbol.scope = new Scope(recordSymbol);
        return recordSymbol;
    }

    private BSymbol getOpSymbolBothUnion(BUnionType lhsType, BUnionType rhsType, BLangBinaryExpr binaryExpr, AnalyzerData data) {
        BSymbol firstValidOpSymbol = this.symTable.notFoundSymbol;
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        LinkedHashSet<BType> removableLhsMemberTypes = new LinkedHashSet<BType>();
        LinkedHashSet removableRhsMemberTypes = new LinkedHashSet(rhsType.getMemberTypes());
        for (BType memberTypeLhs : lhsType.getMemberTypes()) {
            boolean isValidLhsMemberType = false;
            for (BType memberTypeRhs : rhsType.getMemberTypes()) {
                BSymbol resultantOpSymbol = this.getOpSymbol(memberTypeLhs, memberTypeRhs, binaryExpr, data);
                if (data.resultType != this.symTable.semanticError) {
                    memberTypes.add(data.resultType);
                    isValidLhsMemberType = true;
                    removableRhsMemberTypes.remove(memberTypeRhs);
                }
                if (firstValidOpSymbol != this.symTable.notFoundSymbol || resultantOpSymbol == this.symTable.notFoundSymbol) continue;
                firstValidOpSymbol = resultantOpSymbol;
            }
            if (isValidLhsMemberType) continue;
            removableLhsMemberTypes.add(memberTypeLhs);
        }
        for (BType memberTypeRhs : removableRhsMemberTypes) {
            rhsType.remove(memberTypeRhs);
        }
        for (BType memberTypeLhs : removableLhsMemberTypes) {
            lhsType.remove(memberTypeLhs);
        }
        data.resultType = memberTypes.size() != 1 ? BUnionType.create(this.symTable.typeEnv(), null, memberTypes) : (BType)memberTypes.iterator().next();
        return firstValidOpSymbol;
    }

    private BSymbol getOpSymbolLhsUnion(BUnionType lhsType, BType rhsType, BLangBinaryExpr binaryExpr, AnalyzerData data, boolean swap) {
        BSymbol firstValidOpSymbol = this.symTable.notFoundSymbol;
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        LinkedHashSet<BType> removableLhsMemberTypes = new LinkedHashSet<BType>();
        for (BType memberTypeLhs : lhsType.getMemberTypes()) {
            boolean isValidLhsMemberType = false;
            BSymbol resultantOpSymbol = swap ? this.getOpSymbol(rhsType, memberTypeLhs, binaryExpr, data) : this.getOpSymbol(memberTypeLhs, rhsType, binaryExpr, data);
            if (data.resultType != this.symTable.semanticError) {
                memberTypes.add(data.resultType);
                isValidLhsMemberType = true;
            }
            if (firstValidOpSymbol == this.symTable.notFoundSymbol && resultantOpSymbol != this.symTable.notFoundSymbol) {
                firstValidOpSymbol = resultantOpSymbol;
            }
            if (isValidLhsMemberType) continue;
            removableLhsMemberTypes.add(memberTypeLhs);
        }
        for (BType memberTypeLhs : removableLhsMemberTypes) {
            lhsType.remove(memberTypeLhs);
        }
        data.resultType = memberTypes.size() != 1 ? BUnionType.create(this.symTable.typeEnv(), null, memberTypes) : (BType)memberTypes.iterator().next();
        return firstValidOpSymbol;
    }

    private BSymbol getOpSymbolBothNonUnion(BType lhsType, BType rhsType, BLangBinaryExpr binaryExpr, AnalyzerData data) {
        return this.getOpSymbol(lhsType, rhsType, binaryExpr, data);
    }

    private BSymbol getOpSymbol(BType lhsType, BType rhsType, BLangBinaryExpr binaryExpr, AnalyzerData data) {
        BSymbol opSymbol = this.symResolver.resolveBinaryOperator(binaryExpr.opKind, lhsType, rhsType);
        if (lhsType != this.symTable.semanticError && rhsType != this.symTable.semanticError) {
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBitwiseShiftOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryBitwiseOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getArithmeticOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryEqualityForTypeSets(binaryExpr.opKind, lhsType, rhsType, binaryExpr, data.env);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryComparisonOpForTypeSets(binaryExpr.opKind, lhsType, rhsType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getRangeOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                DiagnosticErrorCode errorCode = DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES;
                if (!(binaryExpr.opKind != OperatorKind.DIV && binaryExpr.opKind != OperatorKind.MOD || lhsType.tag != 1 || rhsType.tag != 4 && rhsType.tag != 3)) {
                    errorCode = DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES_INT_FLOAT_DIVISION;
                }
                this.dlog.error(binaryExpr.pos, errorCode, new Object[]{binaryExpr.opKind, lhsType, rhsType});
                data.resultType = this.symTable.semanticError;
            } else {
                data.resultType = opSymbol.type.getReturnType();
            }
        }
        return opSymbol;
    }

    public BLangConstantValue getConstantValue(BType type) {
        BType refType = Types.getImpliedType(type);
        switch (refType.tag) {
            case 33: {
                BType t = SemTypeHelper.singleShapeBroadType(refType.semType(), this.symTable).get();
                Value v = (Value)Core.singleShape((SemType)refType.semType()).get();
                return new BLangConstantValue(v.value, t);
            }
            case 12: {
                HashMap<String, BLangConstantValue> fields = new HashMap<String, BLangConstantValue>();
                LinkedHashMap recordFields = ((BRecordType)refType).fields;
                for (String key : recordFields.keySet()) {
                    BLangConstantValue constantValue = this.getConstantValue(((BField)recordFields.get((Object)key)).type);
                    fields.put(key, constantValue);
                }
                return new BLangConstantValue(fields, type);
            }
            case 31: {
                ArrayList<BLangConstantValue> members = new ArrayList<BLangConstantValue>();
                List<BType> tupleTypes = ((BTupleType)refType).getTupleTypes();
                for (BType memberType : tupleTypes) {
                    BLangConstantValue constantValue = this.getConstantValue(memberType);
                    members.add(constantValue);
                }
                return new BLangConstantValue(members, type);
            }
            case 10: {
                return new BLangConstantValue(refType.tsymbol.getType().toString(), type.tsymbol.getType());
            }
        }
        return null;
    }

    public static class FillMembers
    extends TypeVisitor {
        private static final CompilerContext.Key<FillMembers> FILL_MEMBERS_KEY = new CompilerContext.Key();
        private final SymbolTable symTable;
        private final Types types;
        private final ConstantTypeChecker constantTypeChecker;
        private final Names names;
        private final BLangDiagnosticLog dlog;
        private AnalyzerData data;

        public FillMembers(CompilerContext context) {
            context.put(FILL_MEMBERS_KEY, this);
            this.symTable = SymbolTable.getInstance(context);
            this.types = Types.getInstance(context);
            this.constantTypeChecker = ConstantTypeChecker.getInstance(context);
            this.names = Names.getInstance(context);
            this.dlog = BLangDiagnosticLog.getInstance(context);
        }

        public static FillMembers getInstance(CompilerContext context) {
            FillMembers fillMembers = context.get(FILL_MEMBERS_KEY);
            if (fillMembers == null) {
                fillMembers = new FillMembers(context);
            }
            return fillMembers;
        }

        public boolean addFillMembers(BTupleType type, BType expType, AnalyzerData data) {
            block5: {
                BType refType;
                block4: {
                    refType = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(expType));
                    List<BType> tupleTypes = type.getTupleTypes();
                    int tupleMemberCount = tupleTypes.size();
                    if (refType.tag != 20) break block4;
                    BArrayType arrayType = (BArrayType)expType;
                    int noOfFillMembers = arrayType.getSize() - tupleMemberCount;
                    BType fillMemberType = this.getFillMembers(arrayType.eType, data);
                    if (fillMemberType == this.symTable.semanticError) {
                        return false;
                    }
                    for (int i = 0; i < noOfFillMembers; ++i) {
                        type.addMembers(new BTupleMember(fillMemberType, Symbols.createVarSymbolForTupleMember(fillMemberType)));
                    }
                    break block5;
                }
                if (refType.tag != 31) break block5;
                List<BType> bTypeList = ((BTupleType)expType).getTupleTypes();
                for (int i = tupleMemberCount; i < bTypeList.size(); ++i) {
                    BType fillMemberType = this.getFillMembers(bTypeList.get(i), data);
                    if (fillMemberType == this.symTable.semanticError) {
                        return false;
                    }
                    type.addMembers(new BTupleMember(fillMemberType, Symbols.createVarSymbolForTupleMember(fillMemberType)));
                }
            }
            return true;
        }

        public BType getFillMembers(BType type, AnalyzerData data) {
            this.data = data;
            data.resultType = this.symTable.semanticError;
            type.accept(this);
            if (data.resultType == this.symTable.semanticError) {
                this.dlog.error(data.constantSymbol.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, data.expType);
            }
            return data.resultType;
        }

        @Override
        public void visit(BAnnotationType bAnnotationType) {
        }

        @Override
        public void visit(BArrayType arrayType) {
            BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.data.env.enclPkg.symbol.pkgID, null, this.data.env.scope.owner, null, SymbolOrigin.SOURCE);
            if (arrayType.state == BArrayState.OPEN) {
                BTupleType resultTupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, new ArrayList<BTupleMember>());
                tupleTypeSymbol.type = resultTupleType;
                this.data.resultType = resultTupleType;
                return;
            }
            if (arrayType.state == BArrayState.INFERRED) {
                this.data.resultType = this.symTable.semanticError;
                return;
            }
            BType fillMemberType = this.getFillMembers(arrayType.eType, this.data);
            if (fillMemberType == this.symTable.semanticError) {
                this.data.resultType = this.symTable.semanticError;
                return;
            }
            ArrayList<BType> tupleTypes = new ArrayList<BType>(arrayType.getSize());
            for (int i = 0; i < arrayType.getSize(); ++i) {
                tupleTypes.add(fillMemberType);
            }
            ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
            tupleTypes.forEach(m -> members.add(new BTupleMember((BType)m, Symbols.createVarSymbolForTupleMember(m))));
            BTupleType resultTupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, members);
            tupleTypeSymbol.type = resultTupleType;
            this.data.resultType = resultTupleType;
        }

        @Override
        public void visit(BAnyType bAnyType) {
            this.data.resultType = this.symTable.nilType;
        }

        @Override
        public void visit(BAnydataType bAnydataType) {
            this.data.resultType = this.symTable.nilType;
        }

        @Override
        public void visit(BErrorType bErrorType) {
        }

        @Override
        public void visit(BFiniteType finiteType) {
            if (Core.singleShape((SemType)finiteType.semType()).isEmpty()) {
                if (finiteType.isNullable()) {
                    this.data.resultType = this.symTable.nilType;
                    return;
                }
                this.data.resultType = this.symTable.semanticError;
                return;
            }
            if (finiteType.isNullable()) {
                this.data.resultType = this.symTable.nilType;
                return;
            }
            this.data.resultType = finiteType;
        }

        @Override
        public void visit(BInvokableType bInvokableType) {
        }

        @Override
        public void visit(BJSONType bjsonType) {
            this.data.resultType = this.symTable.nilType;
        }

        @Override
        public void visit(BMapType bMapType) {
            BRecordTypeSymbol recordSymbol = this.constantTypeChecker.createRecordTypeSymbol(this.data.constantSymbol.pkgID, this.data.constantSymbol.pos, SymbolOrigin.VIRTUAL, this.data);
            recordSymbol.type = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
            BRecordType resultRecordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
            recordSymbol.type = resultRecordType;
            resultRecordType.tsymbol = recordSymbol;
            resultRecordType.sealed = true;
            resultRecordType.restFieldType = this.symTable.neverType;
            TypeDefBuilderHelper.createTypeDefinition(resultRecordType, this.data.constantSymbol.pos, this.names, this.types, this.symTable, this.data.env);
            this.data.resultType = resultRecordType;
        }

        @Override
        public void visit(BStreamType bStreamType) {
        }

        @Override
        public void visit(BTypedescType bTypedescType) {
        }

        @Override
        public void visit(BTypeReferenceType bTypeReferenceType) {
            this.getFillMembers(bTypeReferenceType.referredType, this.data);
        }

        @Override
        public void visit(BParameterizedType bTypedescType) {
        }

        @Override
        public void visit(BNeverType bNeverType) {
        }

        @Override
        public void visitNilType(BType bType) {
            this.data.resultType = this.symTable.nilType;
        }

        @Override
        public void visit(BNoType bNoType) {
        }

        @Override
        public void visit(BPackageType bPackageType) {
        }

        @Override
        public void visit(BStructureType bStructureType) {
        }

        @Override
        public void visit(BTupleType tupleType) {
            List<BType> bTypeList = tupleType.getTupleTypes();
            BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.data.env.enclPkg.symbol.pkgID, null, this.data.env.scope.owner, null, SymbolOrigin.SOURCE);
            ArrayList<BType> tupleTypes = new ArrayList<BType>(bTypeList.size());
            for (BType bType : bTypeList) {
                BType fillMemberType = this.getFillMembers(bType, this.data);
                if (fillMemberType == this.symTable.semanticError) {
                    this.data.resultType = this.symTable.semanticError;
                    return;
                }
                tupleTypes.add(fillMemberType);
            }
            ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
            tupleTypes.forEach(m -> members.add(new BTupleMember((BType)m, Symbols.createVarSymbolForTupleMember(m))));
            BTupleType resultTupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, members);
            tupleTypeSymbol.type = resultTupleType;
            this.data.resultType = resultTupleType;
        }

        @Override
        public void visit(BUnionType unionType) {
            Set memberTypes = unionType.getMemberTypes();
            if (((HashSet)memberTypes).size() == 1) {
                this.getFillMembers((BType)((HashSet)memberTypes).iterator().next(), this.data);
                return;
            }
            if (((HashSet)memberTypes).size() > 2 || !unionType.isNullable()) {
                this.data.resultType = this.symTable.semanticError;
                return;
            }
            this.data.resultType = this.symTable.nilType;
        }

        @Override
        public void visit(BIntersectionType intersectionType) {
            this.data.resultType = this.getFillMembers(intersectionType.effectiveType, this.data);
        }

        @Override
        public void visit(BXMLType bxmlType) {
        }

        @Override
        public void visit(BTableType bTableType) {
            this.data.resultType = this.symTable.tableType;
        }

        @Override
        public void visit(BRecordType recordType) {
            LinkedHashMap fields = recordType.fields;
            BRecordTypeSymbol recordSymbol = this.constantTypeChecker.createRecordTypeSymbol(this.data.constantSymbol.pkgID, this.data.constantSymbol.pos, SymbolOrigin.VIRTUAL, this.data);
            for (BField field : fields.values()) {
                if (!Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
                this.data.resultType = this.symTable.semanticError;
                return;
            }
            BRecordType resultRecordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
            recordSymbol.type = resultRecordType;
            resultRecordType.tsymbol = recordSymbol;
            resultRecordType.sealed = true;
            resultRecordType.restFieldType = this.symTable.neverType;
            TypeDefBuilderHelper.createTypeDefinition(resultRecordType, this.data.constantSymbol.pos, this.names, this.types, this.symTable, this.data.env);
            this.data.resultType = resultRecordType;
        }

        @Override
        public void visit(BObjectType bObjectType) {
        }

        @Override
        public void visit(BType type) {
            switch (type.tag) {
                case 10: {
                    this.visitNilType(type);
                    return;
                }
            }
            BConstantSymbol constantSymbol = this.data.constantSymbol;
            BTypeSymbol finiteTypeSym = Symbols.createTypeSymbol(557084L, constantSymbol.flags, Names.EMPTY, constantSymbol.pkgID, null, constantSymbol.owner, constantSymbol.pos, SymbolOrigin.VIRTUAL);
            BType refType = Types.getImpliedType(type);
            switch (refType.tag) {
                case 6: {
                    this.data.resultType = this.symTable.falseType;
                    break;
                }
                case 1: 
                case 2: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    this.data.resultType = BFiniteType.newSingletonBFiniteType(finiteTypeSym, SemTypes.intConst((long)0L));
                    break;
                }
                case 3: {
                    this.data.resultType = BFiniteType.newSingletonBFiniteType(finiteTypeSym, SemTypes.floatConst((double)0.0));
                    break;
                }
                case 4: {
                    this.data.resultType = BFiniteType.newSingletonBFiniteType(finiteTypeSym, SemTypes.decimalConst((String)"0"));
                    break;
                }
                case 5: 
                case 45: {
                    this.data.resultType = BFiniteType.newSingletonBFiniteType(finiteTypeSym, SemTypes.stringConst((String)""));
                    break;
                }
                default: {
                    this.data.resultType = this.symTable.semanticError;
                }
            }
        }

        @Override
        public void visit(BFutureType bFutureType) {
        }

        @Override
        public void visit(BHandleType bHandleType) {
        }
    }

    public static class AnalyzerData {
        public SymbolEnv env;
        boolean isTypeChecked;
        Types.CommonAnalyzerData commonAnalyzerData = new Types.CommonAnalyzerData();
        DiagnosticCode diagCode;
        BType expType;
        BType resultType;
        Map<String, BLangNode> modTable;
        BConstantSymbol constantSymbol;
        int compoundExprCount = 0;
        Deque<String> anonTypeNameSuffixes = new ArrayDeque<String>();
        Location pos;
    }

    public static class ResolveConstantExpressionType
    extends SimpleBLangNodeAnalyzer<AnalyzerData> {
        private static final CompilerContext.Key<ResolveConstantExpressionType> RESOLVE_CONSTANT_EXPRESSION_TYPE = new CompilerContext.Key();
        private final Types types;
        private final ConstantTypeChecker constantTypeChecker;
        private final SymbolTable symTable;

        public ResolveConstantExpressionType(CompilerContext context) {
            context.put(RESOLVE_CONSTANT_EXPRESSION_TYPE, this);
            this.types = Types.getInstance(context);
            this.constantTypeChecker = ConstantTypeChecker.getInstance(context);
            this.symTable = SymbolTable.getInstance(context);
        }

        public static ResolveConstantExpressionType getInstance(CompilerContext context) {
            ResolveConstantExpressionType resolveConstantExpressionType = context.get(RESOLVE_CONSTANT_EXPRESSION_TYPE);
            if (resolveConstantExpressionType == null) {
                resolveConstantExpressionType = new ResolveConstantExpressionType(context);
            }
            return resolveConstantExpressionType;
        }

        public BType resolveConstExpr(BLangExpression expr, BType expType, AnalyzerData data) {
            return this.resolveConstExpr(expr, data.env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
        }

        public BType resolveConstExpr(BLangExpression expr, SymbolEnv env, BType expType, DiagnosticCode diagCode, AnalyzerData data) {
            SymbolEnv prevEnv = data.env;
            BType preExpType = data.expType;
            DiagnosticCode preDiagCode = data.diagCode;
            data.env = env;
            data.diagCode = diagCode;
            data.expType = expType;
            expr.expectedType = expType;
            expr.accept(this, data);
            data.env = prevEnv;
            data.expType = preExpType;
            data.diagCode = preDiagCode;
            return data.resultType;
        }

        @Override
        public void analyzeNode(BLangNode node, AnalyzerData data) {
        }

        @Override
        public void visit(BLangPackage node, AnalyzerData data) {
        }

        @Override
        public void visit(BLangLiteral literalExpr, AnalyzerData data) {
            this.updateBlangExprType(literalExpr, data);
        }

        private void updateBlangExprType(BLangExpression expression, AnalyzerData data) {
            BType expressionType = expression.getBType();
            if (expressionType.tag == 33) {
                expressionType = SemTypeHelper.singleShapeBroadType(expressionType.semType(), this.symTable).get();
                expression.setBType(expressionType);
                this.types.setImplicitCastExpr(expression, data.expType, expressionType);
                return;
            }
            if (expressionType.tag != 21) {
                return;
            }
            BType expType = data.expType;
            BType targetType = expType.tag == 33 ? SemTypeHelper.singleShapeBroadType(expType.semType(), this.symTable).get() : expType;
            for (BType memberType : ((BUnionType)expressionType).getMemberTypes()) {
                BType type = SemTypeHelper.singleShapeBroadType(memberType.semType(), this.symTable).get();
                if (type.tag != targetType.tag && !this.types.isAssignable(memberType, targetType)) continue;
                expression.setBType(type);
                this.types.setImplicitCastExpr(expression, type, memberType);
                return;
            }
        }

        @Override
        public void visit(BLangSimpleVarRef varRefExpr, AnalyzerData data) {
        }

        @Override
        public void visit(BLangListConstructorExpr listConstructor, AnalyzerData data) {
            BType resolvedType = data.expType;
            BTupleType tupleType = (BTupleType)(resolvedType.tag == 22 ? ((BIntersectionType)resolvedType).effectiveType : resolvedType);
            List<BType> resolvedMemberType = tupleType.getTupleTypes();
            listConstructor.setBType(data.expType);
            int currentListIndex = 0;
            for (BLangExpression memberExpr : listConstructor.exprs) {
                if (memberExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadOp = (BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)memberExpr;
                    BTupleType type = (BTupleType)Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(spreadOp.expr.getBType()));
                    spreadOp.setBType(spreadOp.expr.getBType());
                    currentListIndex += type.getTupleTypes().size();
                    continue;
                }
                this.resolveConstExpr(memberExpr, resolvedMemberType.get(currentListIndex), data);
                ++currentListIndex;
            }
        }

        @Override
        public void visit(BLangRecordLiteral recordLiteral, AnalyzerData data) {
            BType resolvedType = data.expType;
            recordLiteral.setBType(data.expType);
            for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
                BType expFieldType;
                if (field.isKeyValueField()) {
                    BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    BLangRecordLiteral.BLangRecordKey key = keyValue.key;
                    BLangExpression keyValueExpr = keyValue.valueExpr;
                    if (key.computedKey) {
                        BLangRecordLiteral.BLangRecordKeyValueField computedKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        BLangRecordLiteral.BLangRecordKey computedKey = computedKeyValue.key;
                        BType fieldName = this.constantTypeChecker.checkConstExpr(computedKey.expr, data);
                        expFieldType = this.getResolvedFieldType(((Value)Core.singleShape((SemType)fieldName.semType()).get()).value, resolvedType);
                        this.resolveConstExpr(computedKey.expr, expFieldType, data);
                        this.resolveConstExpr(keyValueExpr, expFieldType, data);
                        continue;
                    }
                    expFieldType = this.getResolvedFieldType(this.constantTypeChecker.getKeyName(key.expr), resolvedType);
                    this.resolveConstExpr(keyValueExpr, expFieldType, data);
                    continue;
                }
                if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                    BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                    expFieldType = this.getResolvedFieldType(this.constantTypeChecker.getKeyName(varNameField), resolvedType);
                    this.resolveConstExpr(varNameField, expFieldType, data);
                    continue;
                }
                BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
                spreadField.setBType(spreadField.expr.getBType());
            }
        }

        private BType getResolvedFieldType(Object targetKey, BType resolvedType) {
            BRecordType recordType = (BRecordType)(resolvedType.tag == 22 ? ((BIntersectionType)resolvedType).effectiveType : resolvedType);
            for (String key : recordType.getFields().keySet()) {
                if (!key.equals(targetKey)) continue;
                return recordType.getFields().get((Object)key).type;
            }
            return null;
        }

        @Override
        public void visit(BLangBinaryExpr binaryExpr, AnalyzerData data) {
            switch (binaryExpr.opKind) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case OR: 
                case AND: {
                    this.resolveConstExpr(binaryExpr.lhsExpr, data.expType, data);
                    this.resolveConstExpr(binaryExpr.rhsExpr, data.expType, data);
                    this.updateBlangExprType(binaryExpr, data);
                    BInvokableType invokableType = (BInvokableType)binaryExpr.opSymbol.type;
                    ArrayList<BType> paramTypes = new ArrayList<BType>(2);
                    paramTypes.add(binaryExpr.lhsExpr.getBType());
                    paramTypes.add(binaryExpr.rhsExpr.getBType());
                    invokableType.paramTypes = paramTypes;
                    invokableType.retType = binaryExpr.getBType();
                    break;
                }
            }
        }

        @Override
        public void visit(BLangUnaryExpr unaryExpr, AnalyzerData data) {
            this.updateBlangExprType(unaryExpr.expr, data);
            this.updateBlangExprType(unaryExpr, data);
            BInvokableType invokableType = (BInvokableType)unaryExpr.opSymbol.type;
            ArrayList<BType> paramTypes = new ArrayList<BType>(1);
            paramTypes.add(unaryExpr.expr.getBType());
            invokableType.paramTypes = paramTypes;
            invokableType.retType = unaryExpr.getBType();
        }

        @Override
        public void visit(BLangGroupExpr groupExpr, AnalyzerData data) {
            this.updateBlangExprType(groupExpr.expression, data);
            this.updateBlangExprType(groupExpr, data);
        }
    }
}

