/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.util.Flags;

public class ConstantValueResolver
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ConstantValueResolver> CONSTANT_VALUE_RESOLVER_KEY = new CompilerContext.Key();
    private BConstantSymbol currentConstSymbol;
    private BLangConstantValue result;
    private final BLangDiagnosticLog dlog;
    private Location currentPos;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private SymbolEnv symEnv;
    private final Names names;
    private final SymbolTable symTable;
    private final Types types;
    private PackageID pkgID;
    private final Map<BConstantSymbol, BLangConstant> unresolvedConstants = new HashMap<BConstantSymbol, BLangConstant>();
    private final Map<String, BLangConstantValue> constantMap = new HashMap<String, BLangConstantValue>();
    private final ArrayList<BConstantSymbol> resolvingConstants = new ArrayList();
    private final HashSet<BConstantSymbol> unresolvableConstants = new HashSet();
    private final HashMap<BSymbol, BLangTypeDefinition> createdTypeDefinitions = new HashMap();
    private Deque<String> anonTypeNameSuffixes = new ArrayDeque<String>();

    private ConstantValueResolver(CompilerContext context) {
        context.put(CONSTANT_VALUE_RESOLVER_KEY, this);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.types = Types.getInstance(context);
    }

    public static ConstantValueResolver getInstance(CompilerContext context) {
        ConstantValueResolver constantValueResolver = context.get(CONSTANT_VALUE_RESOLVER_KEY);
        if (constantValueResolver == null) {
            constantValueResolver = new ConstantValueResolver(context);
        }
        return constantValueResolver;
    }

    public void resolve(List<BLangConstant> constants, PackageID packageID, SymbolEnv symEnv) {
        this.dlog.setCurrentPackageId(packageID);
        this.pkgID = packageID;
        this.symEnv = symEnv;
        constants.forEach(constant -> this.unresolvedConstants.put(constant.symbol, (BLangConstant)constant));
        constants.forEach(constant -> constant.accept(this));
        this.constantMap.clear();
        this.createdTypeDefinitions.clear();
    }

    private void reset() {
        this.unresolvedConstants.clear();
        this.constantMap.clear();
        this.resolvingConstants.clear();
        this.unresolvableConstants.clear();
        this.createdTypeDefinitions.clear();
    }

    @Override
    public void visit(BLangConstant constant) {
        if (!this.unresolvedConstants.containsKey(constant.symbol)) {
            return;
        }
        BConstantSymbol tempCurrentConstSymbol = this.currentConstSymbol;
        this.currentConstSymbol = constant.symbol;
        this.resolvingConstants.add(this.currentConstSymbol);
        this.currentConstSymbol.value = this.constructBLangConstantValue(constant.expr);
        this.resolvingConstants.remove(this.currentConstSymbol);
        this.anonTypeNameSuffixes.push(constant.name.value);
        this.updateConstantType(constant);
        this.anonTypeNameSuffixes.pop();
        this.checkUniqueness(constant);
        this.unresolvedConstants.remove(this.currentConstSymbol);
        this.currentConstSymbol = tempCurrentConstSymbol;
    }

    @Override
    public void visit(BLangLiteral literal) {
        this.result = new BLangConstantValue(literal.value, literal.getBType());
    }

    @Override
    public void visit(BLangNumericLiteral literal) {
        this.result = new BLangConstantValue(literal.value, literal.getBType());
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = ((BConstantSymbol)constRef.symbol).value;
    }

    @Override
    public void visit(BLangSimpleVarRef varRef) {
        if (varRef.symbol == null || (varRef.symbol.tag & 0x100001CL) != 0x100001CL) {
            this.result = null;
            return;
        }
        BConstantSymbol constSymbol = (BConstantSymbol)varRef.symbol;
        BLangConstantValue constVal = constSymbol.value;
        if (constVal != null) {
            this.result = constVal;
            return;
        }
        if (this.currentConstSymbol == constSymbol) {
            this.dlog.error(varRef.pos, DiagnosticErrorCode.SELF_REFERENCE_CONSTANT, constSymbol.name);
            return;
        }
        if (!this.unresolvedConstants.containsKey(constSymbol)) {
            if (this.unresolvableConstants.contains(constSymbol)) {
                this.result = null;
                return;
            }
            this.unresolvableConstants.add(constSymbol);
            this.dlog.error(varRef.pos, DiagnosticErrorCode.CANNOT_RESOLVE_CONST, constSymbol.name.value);
            this.result = null;
            return;
        }
        if (this.resolvingConstants.contains(constSymbol)) {
            for (BConstantSymbol symbol : this.resolvingConstants) {
                this.unresolvableConstants.add(symbol);
            }
            this.dlog.error(varRef.pos, DiagnosticErrorCode.CONSTANT_CYCLIC_REFERENCE, this.resolvingConstants);
            this.result = null;
            return;
        }
        this.unresolvedConstants.get(constSymbol).accept(this);
        this.result = constSymbol.value;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        LinkedHashMap<String, BLangConstantValue> mapConstVal = new LinkedHashMap<String, BLangConstantValue>();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            BLangConstantValue value;
            String key;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                NodeKind nodeKind = keyValuePair.key.expr.getKind();
                if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
                    key = (String)((BLangLiteral)keyValuePair.key.expr).value;
                } else {
                    if (nodeKind != NodeKind.SIMPLE_VARIABLE_REF) continue;
                    key = ((BLangSimpleVarRef)keyValuePair.key.expr).variableName.value;
                }
                value = this.constructBLangConstantValue(keyValuePair.valueExpr);
            } else if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                key = varNameField.variableName.value;
                value = this.constructBLangConstantValue(varNameField);
            } else {
                BLangConstantValue spreadOpConstValue = this.constructBLangConstantValue(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
                if (spreadOpConstValue == null) continue;
                mapConstVal.putAll((Map)spreadOpConstValue.value);
                continue;
            }
            mapConstVal.put(key, value);
        }
        this.result = new BLangConstantValue(mapConstVal, recordLiteral.getBType());
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        List<BLangExpression> memberExprs = listConstructorExpr.exprs;
        ArrayList<BLangConstantValue> listConstValue = new ArrayList<BLangConstantValue>(memberExprs.size());
        for (BLangExpression memberExpr : memberExprs) {
            listConstValue.add(this.constructBLangConstantValue(memberExpr));
        }
        this.result = new BLangConstantValue(listConstValue, listConstructorExpr.getBType());
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral listConstructorExpr) {
        this.visit((BLangListConstructorExpr)listConstructorExpr);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral listConstructorExpr) {
        this.visit((BLangListConstructorExpr)listConstructorExpr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        BLangConstantValue lhs = this.constructBLangConstantValue(binaryExpr.lhsExpr);
        BLangConstantValue rhs = this.constructBLangConstantValue(binaryExpr.rhsExpr);
        this.result = this.calculateConstValue(lhs, rhs, binaryExpr.opKind);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        StringBuilder resultString = new StringBuilder();
        stringTemplateLiteral.exprs.forEach(expr -> {
            expr.accept(this);
            resultString.append(this.result);
        });
        this.result = new BLangConstantValue(resultString.toString(), this.symTable.stringType);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.result = this.constructBLangConstantValue(groupExpr.expression);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        BLangConstantValue value = this.constructBLangConstantValue(unaryExpr.expr);
        this.result = this.evaluateUnaryOperator(value, unaryExpr.operator);
    }

    private BLangConstantValue calculateConstValue(BLangConstantValue lhs, BLangConstantValue rhs, OperatorKind kind) {
        if (lhs == null || rhs == null || lhs.value == null || rhs.value == null) {
            return new BLangConstantValue(null, this.currentConstSymbol.type);
        }
        try {
            switch (kind) {
                case ADD: {
                    return this.calculateAddition(lhs, rhs);
                }
                case SUB: {
                    return this.calculateSubtract(lhs, rhs);
                }
                case MUL: {
                    return this.calculateMultiplication(lhs, rhs);
                }
                case DIV: {
                    return this.calculateDivision(lhs, rhs);
                }
                case MOD: {
                    return this.calculateMod(lhs, rhs);
                }
                case BITWISE_AND: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a & b);
                }
                case BITWISE_OR: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a | b);
                }
                case BITWISE_LEFT_SHIFT: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a << (int)b.longValue());
                }
                case BITWISE_RIGHT_SHIFT: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a >> (int)b.longValue());
                }
                case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a >>> (int)b.longValue());
                }
                case BITWISE_XOR: {
                    return this.calculateBitWiseOp(lhs, rhs, (a, b) -> a ^ b);
                }
            }
            this.dlog.error(this.currentPos, DiagnosticErrorCode.CONSTANT_EXPRESSION_NOT_SUPPORTED, new Object[0]);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArithmeticException ae) {
            this.dlog.error(this.currentPos, DiagnosticErrorCode.INVALID_CONST_EXPRESSION, ae.getMessage());
        }
        return new BLangConstantValue(null, this.currentConstSymbol.type);
    }

    private BLangConstantValue evaluateUnaryOperator(BLangConstantValue value, OperatorKind kind) {
        if (value == null || value.value == null) {
            return new BLangConstantValue(null, this.currentConstSymbol.type);
        }
        try {
            switch (kind) {
                case ADD: {
                    return new BLangConstantValue(value.value, value.type);
                }
                case SUB: {
                    return this.calculateNegation(value);
                }
                case BITWISE_COMPLEMENT: {
                    return this.calculateBitWiseComplement(value);
                }
                case NOT: {
                    return this.calculateBooleanComplement(value);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new BLangConstantValue(null, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateBitWiseOp(BLangConstantValue lhs, BLangConstantValue rhs, BiFunction<Long, Long, Long> func) {
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: {
                Long val = func.apply((Long)lhs.value, (Long)rhs.value);
                return new BLangConstantValue(val, this.currentConstSymbol.type);
            }
        }
        this.dlog.error(this.currentPos, DiagnosticErrorCode.CONSTANT_EXPRESSION_NOT_SUPPORTED, new Object[0]);
        return new BLangConstantValue(null, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateAddition(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: 
            case 2: {
                try {
                    result = Math.addExact((Long)lhs.value, (Long)rhs.value);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(this.currentPos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                }
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) + Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.add(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(this.currentPos, resultDecimal);
                result = resultDecimal != null ? resultDecimal.toPlainString() : null;
                break;
            }
            case 5: {
                result = String.valueOf(lhs.value) + String.valueOf(rhs.value);
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateSubtract(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: 
            case 2: {
                try {
                    result = Math.subtractExact((Long)lhs.value, (Long)rhs.value);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(this.currentPos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                }
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) - Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.subtract(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(this.currentPos, resultDecimal);
                result = resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateMultiplication(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: 
            case 2: {
                try {
                    result = Math.multiplyExact((long)((Long)lhs.value), (Long)rhs.value);
                }
                catch (ArithmeticException ae) {
                    this.dlog.error(this.currentPos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                }
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) * Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.multiply(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(this.currentPos, resultDecimal);
                result = resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateDivision(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: 
            case 2: {
                if ((Long)lhs.value == Long.MIN_VALUE && (Long)rhs.value == -1L) {
                    this.dlog.error(this.currentPos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
                    return new BLangConstantValue(null, this.currentConstSymbol.type);
                }
                result = (Long)lhs.value / (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) / Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.divide(rhsDecimal, MathContext.DECIMAL128);
                resultDecimal = this.types.getValidDecimalNumber(this.currentPos, resultDecimal);
                result = resultDecimal != null ? resultDecimal.toPlainString() : null;
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateMod(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (Types.getImpliedType((BType)this.currentConstSymbol.type).tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value % (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) % Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.remainder(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private Object calculateNegationForInt(BLangConstantValue value) {
        if ((Long)value.value == Long.MIN_VALUE) {
            this.dlog.error(this.currentPos, DiagnosticErrorCode.INT_RANGE_OVERFLOW_ERROR, new Object[0]);
            return new BLangConstantValue(null, this.currentConstSymbol.type);
        }
        return -1L * (Long)value.value;
    }

    private Object calculateNegationForFloat(BLangConstantValue value) {
        return String.valueOf(-1.0 * Double.parseDouble(String.valueOf(value.value)));
    }

    private Object calculateNegationForDecimal(BLangConstantValue value) {
        BigDecimal valDecimal = new BigDecimal(String.valueOf(value.value), MathContext.DECIMAL128);
        BigDecimal negDecimal = new BigDecimal(String.valueOf(-1), MathContext.DECIMAL128);
        BigDecimal resultDecimal = valDecimal.multiply(negDecimal, MathContext.DECIMAL128);
        return resultDecimal.toPlainString();
    }

    private BLangConstantValue calculateNegation(BLangConstantValue value) {
        Object result = null;
        BType constSymbolValType = value.type;
        int constSymbolValTypeTag = Types.getImpliedType((BType)constSymbolValType).tag;
        result = switch (constSymbolValTypeTag) {
            case 1 -> this.calculateNegationForInt(value);
            case 3 -> this.calculateNegationForFloat(value);
            case 4 -> this.calculateNegationForDecimal(value);
            default -> result;
        };
        return new BLangConstantValue(result, constSymbolValType);
    }

    private BLangConstantValue calculateBitWiseComplement(BLangConstantValue value) {
        Long result = null;
        if (Types.getImpliedType((BType)this.currentConstSymbol.type).tag == 1) {
            result = (Long)value.value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateBooleanComplement(BLangConstantValue value) {
        Boolean result = null;
        if (Types.getImpliedType((BType)this.currentConstSymbol.type).tag == 6) {
            result = (Boolean)value.value == false;
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    BLangConstantValue constructBLangConstantValueWithExactType(BLangExpression expression, BConstantSymbol constantSymbol, SymbolEnv env) {
        return this.constructBLangConstantValueWithExactType(expression, constantSymbol, env, new ArrayDeque<String>(), false);
    }

    BLangConstantValue constructBLangConstantValueWithExactType(BLangExpression expression, BConstantSymbol constantSymbol, SymbolEnv env, Deque<String> anonTypeNameSuffixes, boolean isSourceOnlyAnon) {
        BLangConstantValue value;
        this.currentConstSymbol = constantSymbol;
        constantSymbol.value = value = this.constructBLangConstantValue(expression);
        if (value == null) {
            return null;
        }
        this.anonTypeNameSuffixes = anonTypeNameSuffixes;
        this.updateConstantType(constantSymbol, expression, env);
        Optional.ofNullable(isSourceOnlyAnon ? this.createdTypeDefinitions.get(constantSymbol.type.tsymbol) : null).ifPresent(typeDefinition -> typeDefinition.symbol.flags |= 0x100000000000L);
        this.reset();
        return value;
    }

    private BLangConstantValue constructBLangConstantValue(BLangExpression node) {
        if (!node.typeChecked) {
            return null;
        }
        switch (node.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case LIST_CONSTRUCTOR_EXPR: 
            case ARRAY_LITERAL_EXPR: 
            case TUPLE_LITERAL_EXPR: 
            case SIMPLE_VARIABLE_REF: 
            case BINARY_EXPR: 
            case GROUP_EXPR: 
            case UNARY_EXPR: 
            case STRING_TEMPLATE_LITERAL: {
                BLangConstantValue prevResult = this.result;
                Location prevPos = this.currentPos;
                this.currentPos = node.pos;
                this.result = null;
                node.accept(this);
                BLangConstantValue newResult = this.result;
                this.result = prevResult;
                this.currentPos = prevPos;
                return newResult;
            }
        }
        return null;
    }

    private void checkUniqueness(BLangConstant constant) {
        if (constant.symbol.kind == SymbolKind.CONSTANT) {
            String nameString = constant.name.value;
            BLangConstantValue value = constant.symbol.value;
            if (this.constantMap.containsKey(nameString)) {
                if (value == null) {
                    this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL, nameString);
                } else {
                    BLangConstantValue lastValue = this.constantMap.get(nameString);
                    if (!value.equals(lastValue)) {
                        if (lastValue == null) {
                            this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL, nameString);
                        } else {
                            this.dlog.error(constant.name.pos, DiagnosticErrorCode.ALREADY_INITIALIZED_SYMBOL_WITH_ANOTHER, nameString, lastValue);
                        }
                    }
                }
            } else {
                this.constantMap.put(nameString, value);
            }
        }
    }

    private void updateConstantType(BLangConstant constant) {
        BConstantSymbol symbol = constant.symbol;
        this.updateConstantType(symbol, constant.expr, this.symEnv);
        BType resolvedType = Types.getReferredType(symbol.type);
        if (resolvedType.tag == 22) {
            BIntersectionType intersectionType = (BIntersectionType)resolvedType;
            if (Types.getImpliedType((BType)intersectionType.effectiveType).tag == 12) {
                this.addAssociatedTypeDefinition(constant, intersectionType);
            }
        }
    }

    private void updateConstantType(BConstantSymbol symbol, BLangExpression expr, SymbolEnv env) {
        BType type = Types.getImpliedType(symbol.type);
        if (type.getKind() == TypeKind.FINITE) {
            return;
        }
        if (symbol.value == null) {
            return;
        }
        BType resolvedType = this.checkType(expr, symbol, symbol.value.value, type, symbol.pos, env);
        if (resolvedType == null) {
            return;
        }
        if (resolvedType.getKind() == TypeKind.RECORD && this.isListOrMapping(type.tag)) {
            expr.setBType(resolvedType);
            symbol.type = resolvedType;
            symbol.literalType = resolvedType;
            symbol.value.type = resolvedType;
            return;
        }
        expr.setBType(resolvedType);
        symbol.type = resolvedType;
    }

    private boolean isListOrMapping(int tag) {
        return switch (tag) {
            case 12, 16, 20, 31 -> true;
            default -> false;
        };
    }

    private BFiniteType createFiniteType(BConstantSymbol constantSymbol, BLangLiteral literal) {
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, constantSymbol.flags, Names.EMPTY, constantSymbol.pkgID, null, constantSymbol.owner, constantSymbol.pos, SymbolOrigin.VIRTUAL);
        return BFiniteType.newSingletonBFiniteType(finiteTypeSymbol, SemTypeHelper.resolveSingletonType(literal));
    }

    private BType checkType(BLangExpression expr, BConstantSymbol constantSymbol, Object value, BType type, Location pos, SymbolEnv env) {
        if (expr != null && expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (((BLangSimpleVarRef)expr).symbol.type.getKind() == TypeKind.FINITE || ((BLangSimpleVarRef)expr).symbol.type.getKind() == TypeKind.INTERSECTION)) {
            return ((BLangSimpleVarRef)expr).symbol.type;
        }
        type = Types.getImpliedType(type);
        return switch (type.tag) {
            case 1, 3, 4 -> {
                BLangNumericLiteral numericLiteral = (BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression();
                yield this.createFiniteType(constantSymbol, this.updateLiteral(numericLiteral, value, type, pos));
            }
            case 2 -> {
                BLangNumericLiteral byteLiteral = (BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression();
                yield this.createFiniteType(constantSymbol, this.updateLiteral(byteLiteral, value, this.symTable.intType, pos));
            }
            case 5, 6, 10 -> {
                BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
                yield this.createFiniteType(constantSymbol, this.updateLiteral(literal, value, type, pos));
            }
            case 12, 16 -> {
                if (value != null) {
                    yield this.createRecordType(expr, constantSymbol, value, pos, env);
                }
                yield null;
            }
            case 20, 31 -> {
                if (value != null) {
                    yield this.createTupleType(expr, constantSymbol, pos, value, env);
                }
                yield null;
            }
            default -> null;
        };
    }

    private BLangLiteral updateLiteral(BLangLiteral literal, Object value, BType type, Location pos) {
        literal.value = value;
        literal.isConstant = true;
        literal.setBType(type);
        literal.pos = pos;
        return literal;
    }

    private BField createField(BVarSymbol symbol, BType symbolType, String fieldName, Location pos) {
        symbol.type = symbolType;
        if (symbolType.getKind() == TypeKind.INTERSECTION) {
            for (BType memberType : ((BIntersectionType)symbolType).getConstituentTypes()) {
                if (memberType.getKind() != TypeKind.RECORD) continue;
                symbol.type = memberType;
            }
        }
        BField field = new BField(Names.fromString(fieldName), pos, symbol);
        field.symbol.flags |= 0x100L;
        return field;
    }

    private void createTypeDefinition(BRecordType type, Location pos, SymbolEnv env) {
        BRecordTypeSymbol recordSymbol = (BRecordTypeSymbol)type.tsymbol;
        BTypeDefinitionSymbol typeDefinitionSymbol = Symbols.createTypeDefinitionSymbol(type.tsymbol.flags, type.tsymbol.name, this.pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        typeDefinitionSymbol.scope = new Scope(typeDefinitionSymbol);
        typeDefinitionSymbol.scope.define(Names.fromString(typeDefinitionSymbol.name.value), typeDefinitionSymbol);
        type.tsymbol.scope = new Scope(type.tsymbol);
        for (BField field : ((HashMap)type.fields).values()) {
            type.tsymbol.scope.define(field.name, field.symbol);
            field.symbol.owner = recordSymbol;
        }
        typeDefinitionSymbol.type = type;
        recordSymbol.type = type;
        recordSymbol.typeDefinitionSymbol = typeDefinitionSymbol;
        recordSymbol.markdownDocumentation = new MarkdownDocAttachment(0);
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(new ArrayList<BLangSimpleVariable>(), type, pos);
        TypeDefBuilderHelper.populateStructureFieldsAndTypeInclusions(this.types, this.symTable, null, this.names, recordTypeNode, type, type, pos, env, this.pkgID, null, 0L, false);
        recordTypeNode.sealed = true;
        type.restFieldType = new BNoType(24);
        BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.createTypeDefinitionForTSymbol(null, typeDefinitionSymbol, recordTypeNode, env);
        typeDefinition.symbol.scope = new Scope(typeDefinition.symbol);
        typeDefinition.symbol.type = type;
        typeDefinition.flagSet = new HashSet<Flag>();
        typeDefinition.flagSet.add(Flag.PUBLIC);
        typeDefinition.flagSet.add(Flag.ANONYMOUS);
        this.createdTypeDefinitions.put(type.tsymbol, typeDefinition);
    }

    private BLangTypeDefinition findTypeDefinition(List<BLangTypeDefinition> typeDefinitionArrayList, String name) {
        for (int i = typeDefinitionArrayList.size() - 1; i >= 0; --i) {
            BLangTypeDefinition typeDefinition = typeDefinitionArrayList.get(i);
            if (!typeDefinition.name.value.equals(name)) continue;
            return typeDefinition;
        }
        return null;
    }

    private void addAssociatedTypeDefinition(BLangConstant constant, BIntersectionType immutableType) {
        BLangTypeDefinition typeDefinition;
        constant.associatedTypeDefinition = typeDefinition = this.findTypeDefinition(this.symEnv.enclPkg.typeDefinitions, immutableType.effectiveType.tsymbol.name.value);
    }

    private BType createRecordType(BLangExpression expr, BConstantSymbol constantSymbol, Object value, Location pos, SymbolEnv env) {
        if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return expr.getBType();
        }
        HashMap constValueMap = (HashMap)value;
        for (BLangConstantValue memberValue : constValueMap.values()) {
            if (memberValue != null) continue;
            return null;
        }
        Name genName = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(env.enclPkg.packageID, this.anonTypeNameSuffixes));
        BRecordTypeSymbol recordTypeSymbol = new BRecordTypeSymbol(163932L, constantSymbol.flags | 0x800L, genName, constantSymbol.pkgID, null, constantSymbol.owner, pos, SymbolOrigin.VIRTUAL);
        recordTypeSymbol.scope = constantSymbol.scope;
        BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordTypeSymbol);
        recordType.tsymbol.name = genName;
        recordType.sealed = true;
        recordType.restFieldType = new BNoType(24);
        recordTypeSymbol.type = recordType;
        if (!constValueMap.isEmpty() && !this.populateRecordFields(expr, constantSymbol, pos, constValueMap, recordType, env)) {
            return null;
        }
        this.createTypeDefinition(recordType, pos, env);
        this.updateRecordFields(recordType, pos, env);
        recordType.tsymbol.flags |= 0x20L;
        recordType.addFlags(32L);
        return recordType;
    }

    private void updateRecordFields(BRecordType recordType, Location pos, SymbolEnv env) {
        BTypeSymbol structureSymbol = recordType.tsymbol;
        for (BField field : recordType.fields.values()) {
            field.type = ImmutableTypeCloner.getImmutableType(pos, this.types, field.type, env, env.enclPkg.packageID, env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
            Name fieldName = field.symbol.name;
            field.symbol = new BVarSymbol(field.symbol.flags | 0x20L, fieldName, env.enclPkg.packageID, field.type, structureSymbol, pos, SymbolOrigin.SOURCE);
            structureSymbol.scope.define(fieldName, field.symbol);
        }
    }

    private boolean populateRecordFields(BLangExpression expr, BConstantSymbol constantSymbol, Location pos, HashMap<String, BLangConstantValue> constValueMap, BRecordType recordType, SymbolEnv env) {
        for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)expr).fields) {
            BVarSymbol newSymbol;
            String key;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangExpression exprValueField = keyValuePair.valueExpr;
                if (exprValueField.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                    key = keyValuePair.key.toString();
                    newSymbol = new BVarSymbol(constantSymbol.flags, Names.fromString(key), constantSymbol.pkgID, null, constantSymbol.owner, pos, SymbolOrigin.VIRTUAL);
                    BLangSimpleVarRef simpleVarRefExpr = (BLangSimpleVarRef)exprValueField;
                    if (simpleVarRefExpr.symbol.type.getKind() == TypeKind.FINITE || simpleVarRefExpr.symbol.type.getKind() == TypeKind.INTERSECTION) {
                        BType resolvedType = simpleVarRefExpr.symbol.type;
                        recordType.fields.put(key, this.createField(newSymbol, resolvedType, key, pos));
                        keyValuePair.setBType(resolvedType);
                        if (resolvedType.getKind() == TypeKind.FINITE) continue;
                        constValueMap.get((Object)key).type = resolvedType;
                        if (resolvedType.getKind() != TypeKind.INTERSECTION) continue;
                        simpleVarRefExpr.setBType(((BIntersectionType)resolvedType).effectiveType);
                        continue;
                    }
                }
                key = keyValuePair.key.toString();
                newSymbol = new BVarSymbol(constantSymbol.flags, Names.fromString(key), constantSymbol.pkgID, null, constantSymbol.owner, pos, SymbolOrigin.VIRTUAL);
                this.anonTypeNameSuffixes.push(key);
                BType newType = this.checkType(exprValueField, constantSymbol, constValueMap.get((Object)key).value, constValueMap.get((Object)key).type, pos, env);
                this.anonTypeNameSuffixes.pop();
                if (newType == null) {
                    return false;
                }
                keyValuePair.setBType(newType);
                TypeKind kind = newType.getKind();
                if (kind != TypeKind.FINITE) {
                    constValueMap.get((Object)key).type = newType;
                    BType type = kind == TypeKind.INTERSECTION ? ((BIntersectionType)newType).effectiveType : newType;
                    exprValueField.setBType(type);
                }
                recordType.fields.put(key, this.createField(newSymbol, newType, key, pos));
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                key = varNameField.variableName.value;
                newSymbol = new BVarSymbol(constantSymbol.flags, Names.fromString(key), constantSymbol.pkgID, null, constantSymbol.owner, pos, SymbolOrigin.VIRTUAL);
                BType resolvedType = varNameField.symbol.type;
                varNameField.setBType(resolvedType);
                recordType.fields.put(key, this.createField(newSymbol, resolvedType, key, pos));
                continue;
            }
            BLangExpression exprSpreadField = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
            if (exprSpreadField.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
            BLangSimpleVarRef simpleVarRefExpr = (BLangSimpleVarRef)exprSpreadField;
            if (simpleVarRefExpr.symbol.type.getKind() != TypeKind.FINITE && simpleVarRefExpr.symbol.type.getKind() != TypeKind.INTERSECTION) continue;
            BRecordType resolvedType = (BRecordType)((BIntersectionType)simpleVarRefExpr.symbol.type).effectiveType;
            exprSpreadField.setBType(resolvedType);
            for (String spreadFieldKeys : ((HashMap)resolvedType.fields).keySet()) {
                newSymbol = new BVarSymbol(constantSymbol.flags, Names.fromString(spreadFieldKeys), constantSymbol.pkgID, null, constantSymbol.owner, pos, SymbolOrigin.VIRTUAL);
                BType spreadFieldType = ((BField)resolvedType.fields.get((Object)spreadFieldKeys)).type;
                recordType.fields.put(spreadFieldKeys, this.createField(newSymbol, spreadFieldType, spreadFieldKeys, pos));
            }
        }
        return true;
    }

    private BType createTupleType(BLangExpression expr, BConstantSymbol constantSymbol, Location pos, Object constValue, SymbolEnv env) {
        if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return expr.getBType();
        }
        List constValueList = (List)constValue;
        for (BLangConstantValue memberValue : constValueList) {
            if (memberValue != null) continue;
            return null;
        }
        List<BLangExpression> memberExprs = ((BLangListConstructorExpr)expr).exprs;
        ArrayList<BTupleMember> tupleTypes = new ArrayList<BTupleMember>(constValueList.size());
        for (int i = 0; i < memberExprs.size(); ++i) {
            BType newType;
            BLangExpression memberExpr = memberExprs.get(i);
            BLangConstantValue memberConstValue = (BLangConstantValue)constValueList.get(i);
            if (memberExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BVarSymbol varSymbol;
                BType type = ((BLangSimpleVarRef)memberExpr).symbol.type;
                int tag = Types.getReferredType((BType)type).tag;
                if (tag == 33) {
                    varSymbol = Symbols.createVarSymbolForTupleMember(type);
                    tupleTypes.add(new BTupleMember(type, varSymbol));
                    continue;
                }
                if (tag == 22) {
                    memberConstValue.type = type;
                    varSymbol = Symbols.createVarSymbolForTupleMember(type);
                    tupleTypes.add(new BTupleMember(type, varSymbol));
                    continue;
                }
            }
            if ((newType = this.checkType(memberExpr, constantSymbol, memberConstValue.value, memberConstValue.type, pos, env)) == null) {
                return null;
            }
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(newType);
            tupleTypes.add(new BTupleMember(newType, varSymbol));
            if (Types.getImpliedType((BType)newType).tag == 33) continue;
            memberConstValue.type = newType;
            memberExpr.setBType(newType);
        }
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, env.enclPkg.symbol.pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, tupleTypes), env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
    }
}

