/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;

public class EffectiveTypePopulator
extends TypeVisitor {
    private static final CompilerContext.Key<EffectiveTypePopulator> UPDATE_IMMUTABLE_TYPE_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Names names;
    private final Types types;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private Location loc;
    private PackageID pkgID;
    private BLangNode typeNode;
    private SymbolEnv env;
    public HashSet<BType> visitedImmutableTypes = new HashSet();

    public EffectiveTypePopulator(CompilerContext context) {
        context.put(UPDATE_IMMUTABLE_TYPE_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    public static EffectiveTypePopulator getInstance(CompilerContext context) {
        EffectiveTypePopulator effectiveTypePopulator = context.get(UPDATE_IMMUTABLE_TYPE_KEY);
        if (effectiveTypePopulator == null) {
            effectiveTypePopulator = new EffectiveTypePopulator(context);
        }
        return effectiveTypePopulator;
    }

    public void updateType(BType immutableType, Location loc, PackageID pkgID, BLangNode typeNode, SymbolEnv env) {
        if (!this.visitedImmutableTypes.add(immutableType)) {
            return;
        }
        Location prevLoc = loc;
        PackageID prevPkgID = pkgID;
        BLangNode prevTypeNode = typeNode;
        SymbolEnv prevEnv = env;
        this.loc = loc;
        this.pkgID = pkgID;
        this.typeNode = typeNode;
        this.env = env;
        immutableType.accept(this);
        this.loc = prevLoc;
        this.pkgID = prevPkgID;
        this.typeNode = prevTypeNode;
        this.env = prevEnv;
    }

    @Override
    public void visit(BAnnotationType bAnnotationType) {
    }

    @Override
    public void visit(BArrayType bArrayType) {
        BArrayType origArrayType = bArrayType.mutableType;
        if (origArrayType != null) {
            if (bArrayType.eType.tag == 50 || bArrayType.eType == this.symTable.semanticError) {
                bArrayType.eType = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origArrayType.eType, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
            }
            this.updateType(bArrayType.eType, this.loc, this.pkgID, this.typeNode, this.env);
            bArrayType.mutableType = null;
        }
    }

    @Override
    public void visit(BAnyType bAnyType) {
    }

    @Override
    public void visit(BAnydataType bAnydataType) {
    }

    @Override
    public void visit(BErrorType bErrorType) {
    }

    @Override
    public void visit(BFiniteType bFiniteType) {
    }

    @Override
    public void visit(BInvokableType bInvokableType) {
    }

    @Override
    public void visit(BJSONType bjsonType) {
    }

    @Override
    public void visit(BMapType bMapType) {
        BMapType origMapType = bMapType.mutableType;
        if (origMapType != null) {
            if (bMapType.constraint.tag == 50 || bMapType.constraint == this.symTable.semanticError) {
                bMapType.constraint = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origMapType.constraint, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
            }
            this.updateType(bMapType.constraint, this.loc, this.pkgID, this.typeNode, this.env);
            bMapType.mutableType = null;
        }
    }

    @Override
    public void visit(BStreamType bStreamType) {
    }

    @Override
    public void visit(BTypedescType bTypedescType) {
    }

    @Override
    public void visit(BTypeReferenceType bTypeReferenceType) {
        this.updateType(Types.getImpliedType(bTypeReferenceType), this.loc, this.pkgID, this.typeNode, this.env);
    }

    @Override
    public void visit(BParameterizedType bTypedescType) {
    }

    @Override
    public void visit(BNeverType bNeverType) {
    }

    @Override
    public void visitNilType(BType bNilType) {
    }

    @Override
    public void visit(BNoType bNoType) {
    }

    @Override
    public void visit(BPackageType bPackageType) {
    }

    @Override
    public void visit(BStructureType bStructureType) {
    }

    @Override
    public void visit(BTupleType bTupleType) {
        BTupleType origTupleType = bTupleType.mutableType;
        if (origTupleType != null) {
            BTypeSymbol tsymbol;
            if (origTupleType.getMembers().size() != bTupleType.getMembers().size()) {
                ArrayList members = new ArrayList(origTupleType.getMembers().size());
                bTupleType.setMembers(members);
                for (BTupleMember origTupleMemType : origTupleType.getMembers()) {
                    if (this.types.isInherentlyImmutableType(origTupleMemType.type)) {
                        bTupleType.addMembers(origTupleMemType);
                        continue;
                    }
                    BType newType = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origTupleMemType.type, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                    BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(newType);
                    BTupleMember member = new BTupleMember(newType, varSymbol);
                    bTupleType.addMembers(member);
                }
            } else {
                for (BType memberType : bTupleType.getTupleTypes()) {
                    this.updateType(memberType, this.loc, this.pkgID, this.typeNode, this.env);
                }
            }
            if ((tsymbol = bTupleType.tsymbol) != null && tsymbol.name != null && !tsymbol.name.value.isEmpty() && !Symbols.isFlagOn(bTupleType.getFlags(), 0x80000000000L)) {
                BLangTupleTypeNode tupleTypeNode = (BLangTupleTypeNode)TreeBuilder.createTupleTypeNode();
                tupleTypeNode.setBType(bTupleType);
                BLangTypeDefinition typeDefinition = TypeDefBuilderHelper.addTypeDefinition(bTupleType, bTupleType.tsymbol, tupleTypeNode, this.env);
                typeDefinition.pos = this.loc;
            }
            bTupleType.mutableType = null;
        }
    }

    @Override
    public void visit(BUnionType bUnionType) {
        for (BType immutableMemberType : bUnionType.getMemberTypes()) {
            this.updateType(immutableMemberType, this.loc, this.pkgID, this.typeNode, this.env);
        }
    }

    @Override
    public void visit(BIntersectionType bIntersectionType) {
        this.updateType(bIntersectionType.effectiveType, this.loc, this.pkgID, this.typeNode, this.env);
    }

    @Override
    public void visit(BXMLType bXMLType) {
        BXMLType origXMLType = bXMLType.mutableType;
        if (origXMLType != null) {
            if (bXMLType.constraint == this.symTable.semanticError) {
                bXMLType.constraint = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origXMLType.constraint, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
            }
            this.updateType(bXMLType.constraint, this.loc, this.pkgID, this.typeNode, this.env);
            bXMLType.mutableType = null;
        }
    }

    @Override
    public void visit(BTableType bTableType) {
        BTableType origTableType = bTableType.mutableType;
        if (origTableType != null) {
            if (bTableType.constraint.tag == 50 || bTableType.constraint == this.symTable.semanticError) {
                bTableType.constraint = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origTableType.constraint, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
            }
            this.updateType(bTableType.constraint, this.loc, this.pkgID, this.typeNode, this.env);
            if (origTableType.keyTypeConstraint != null) {
                bTableType.keyTypeConstraint = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origTableType.keyTypeConstraint, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                this.updateType(bTableType.keyTypeConstraint, this.loc, this.pkgID, this.typeNode, this.env);
            }
            bTableType.mutableType = null;
        }
    }

    @Override
    public void visit(BRecordType bRecordType) {
        BRecordType origRecordType = bRecordType.mutableType;
        BTypeSymbol structureSymbol = bRecordType.tsymbol;
        if (origRecordType != null) {
            if (origRecordType.fields.size() != bRecordType.fields.size()) {
                LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
                for (BField origField : origRecordType.fields.values()) {
                    BVarSymbol fieldSymbol;
                    BType fieldType = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origField.type, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                    Name origFieldName = origField.name;
                    BType referredType = Types.getImpliedType(fieldType);
                    if (referredType.tag == 17 && referredType.tsymbol != null) {
                        fieldSymbol = new BInvokableSymbol(origField.symbol.tag, origField.symbol.flags | 0x20L, origFieldName, this.pkgID, fieldType, (BSymbol)structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)referredType.tsymbol;
                        BInvokableSymbol invokableSymbol = (BInvokableSymbol)fieldSymbol;
                        invokableSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
                        invokableSymbol.restParam = tsymbol.restParam;
                        invokableSymbol.retType = tsymbol.returnType;
                        invokableSymbol.flags = tsymbol.flags;
                    } else {
                        fieldSymbol = fieldType == this.symTable.semanticError ? new BVarSymbol(origField.symbol.flags | 0x20L | 0x1000L, origFieldName, this.pkgID, this.symTable.neverType, structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE) : new BVarSymbol(origField.symbol.flags | 0x20L, origFieldName, this.pkgID, fieldType, structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                    }
                    String nameString = origFieldName.value;
                    fields.put(nameString, new BField(origFieldName, null, fieldSymbol));
                    structureSymbol.scope.define(origFieldName, fieldSymbol);
                }
                bRecordType.fields = fields;
                bRecordType.restFieldType = origRecordType.restFieldType;
            } else {
                for (BField immutableField : bRecordType.fields.values()) {
                    BField origField = (BField)origRecordType.fields.get(immutableField.name.value);
                    if (immutableField.type.tag == 50) {
                        immutableField.type = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origField.type, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                    }
                    Name origFieldName = origField.name;
                    this.updateType(immutableField.type, this.loc, this.pkgID, this.typeNode, this.env);
                    immutableField.symbol = new BVarSymbol(origField.symbol.flags | 0x20L, origFieldName, this.pkgID, immutableField.type, structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                    structureSymbol.scope.define(origFieldName, immutableField.symbol);
                }
            }
            bRecordType.mutableType = null;
        }
    }

    @Override
    public void visit(BObjectType bObjectType) {
        BObjectType origObjectType = bObjectType.mutableType;
        BTypeSymbol structureSymbol = bObjectType.tsymbol;
        if (origObjectType != null) {
            if (origObjectType.fields.size() != bObjectType.fields.size()) {
                LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
                for (BField origField : origObjectType.fields.values()) {
                    BVarSymbol fieldSymbol;
                    BType fieldType = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origField.type, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                    Name origFieldName = origField.name;
                    BType referredType = Types.getImpliedType(fieldType);
                    if (referredType.tag == 17 && referredType.tsymbol != null) {
                        fieldSymbol = new BInvokableSymbol(origField.symbol.tag, origField.symbol.flags | 0x20L, origFieldName, this.pkgID, fieldType, (BSymbol)structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)referredType.tsymbol;
                        BInvokableSymbol invokableSymbol = (BInvokableSymbol)fieldSymbol;
                        invokableSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
                        invokableSymbol.restParam = tsymbol.restParam;
                        invokableSymbol.retType = tsymbol.returnType;
                        invokableSymbol.flags = tsymbol.flags;
                    } else {
                        fieldSymbol = new BVarSymbol(origField.symbol.flags | 0x20L, origFieldName, this.pkgID, fieldType, structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                    }
                    String nameString = origFieldName.value;
                    fields.put(nameString, new BField(origFieldName, null, fieldSymbol));
                    structureSymbol.scope.define(origFieldName, fieldSymbol);
                }
                bObjectType.fields = fields;
            } else {
                for (BField immutableField : bObjectType.fields.values()) {
                    BField origField = (BField)origObjectType.fields.get(immutableField.name.value);
                    if (immutableField.type.tag == 50) {
                        immutableField.type = ImmutableTypeCloner.getImmutableType(this.loc, this.types, origField.type, this.env, this.pkgID, this.env.scope.owner, this.symTable, this.anonymousModelHelper, this.names, new HashSet<BType>());
                    }
                    Name origFieldName = origField.name;
                    this.updateType(immutableField.type, this.loc, this.pkgID, this.typeNode, this.env);
                    immutableField.symbol = new BVarSymbol(origField.symbol.flags | 0x20L, origFieldName, this.pkgID, immutableField.type, structureSymbol, origField.symbol.pos, SymbolOrigin.SOURCE);
                    structureSymbol.scope.define(origFieldName, immutableField.symbol);
                }
            }
            bObjectType.mutableType = null;
        }
    }

    @Override
    public void visit(BFutureType bFutureType) {
    }

    @Override
    public void visit(BHandleType bHandleType) {
    }
}

