/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.List;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.MainParameterVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public class MainFunctionValidator
extends BLangNodeVisitor {
    private final Types types;
    private final BLangDiagnosticLog dLog;
    private BType foundArrayType;

    public MainFunctionValidator(Types types, BLangDiagnosticLog dLog) {
        this.types = types;
        this.dLog = dLog;
    }

    void validateMainFunction(BLangFunction funcNode) {
        BLangSimpleVariable lastVar;
        this.validatePublicFunction(funcNode);
        List requiredParams = funcNode.requiredParams;
        this.validateOperandParams(funcNode, requiredParams);
        if (!requiredParams.isEmpty() && this.isIncludedRecord(lastVar = (BLangSimpleVariable)requiredParams.get(requiredParams.size() - 1))) {
            this.validateOptionParams(lastVar);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.MAIN_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private void validateOperandParams(BLangFunction funcNode, List<BLangSimpleVariable> requiredParams) {
        MainParameterVisitor mainParameterVisitor = new MainParameterVisitor(false);
        BLangSimpleVariable foundOperand = null;
        boolean foundInvalid = false;
        for (int i = 0; i < requiredParams.size(); ++i) {
            BLangSimpleVariable param = requiredParams.get(i);
            if (mainParameterVisitor.visit(param.getBType())) {
                foundOperand = this.handleSuccessfulVisit(mainParameterVisitor, foundOperand, param);
                continue;
            }
            if (i == requiredParams.size() - 1 && this.isIncludedRecord(param)) break;
            this.dLog.error(param.pos, DiagnosticErrorCode.INVALID_MAIN_PARAMS_TYPE, param.name, param.getBType());
            foundInvalid = true;
        }
        this.validateRestParams(funcNode, mainParameterVisitor);
        if (foundInvalid) {
            return;
        }
        this.detectArrayRelatedErrors(requiredParams);
    }

    private void detectArrayRelatedErrors(List<BLangSimpleVariable> requiredParams) {
        boolean firstArrayFound = false;
        for (BLangSimpleVariable param : requiredParams) {
            if (Types.getImpliedType((BType)param.getBType()).tag == 20 && !firstArrayFound) {
                firstArrayFound = true;
                continue;
            }
            this.validateWithFoundArrayType(param);
        }
    }

    private BLangSimpleVariable handleSuccessfulVisit(MainParameterVisitor mainParameterVisitor, BLangSimpleVariable foundOperand, BLangSimpleVariable param) {
        BType paramType = param.getBType();
        BType referredParamType = Types.getImpliedType(paramType);
        if (mainParameterVisitor.isOperandType(paramType) && param.expr == null && foundOperand != null) {
            this.dLog.error(param.pos, DiagnosticErrorCode.OPTIONAL_OPERAND_PRECEDES_OPERAND, foundOperand.name, foundOperand.getBType(), param.name, paramType);
        } else if (this.foundUnion(param)) {
            foundOperand = param;
        } else if (referredParamType.tag == 20 && this.foundArrayType == null) {
            this.foundArrayType = ((BArrayType)referredParamType).eType;
        }
        return foundOperand;
    }

    private void validateRestParams(BLangFunction funcNode, MainParameterVisitor mainParameterVisitor) {
        if (funcNode.restParam == null) {
            return;
        }
        BLangSimpleVariable param = funcNode.restParam;
        if (!mainParameterVisitor.visit(param.getBType())) {
            this.dLog.error(param.pos, DiagnosticErrorCode.INVALID_MAIN_PARAMS_TYPE, param.name, param.getBType());
        } else {
            if (this.foundArrayType != null) {
                this.dLog.error(param.pos, DiagnosticErrorCode.SAME_ARRAY_TYPE_AS_MAIN_PARAMETER, new Object[0]);
                return;
            }
            this.foundArrayType = ((BArrayType)param.getBType()).eType;
        }
    }

    private void validatePublicFunction(BLangFunction funcNode) {
        if (!Symbols.isPublic(funcNode.symbol)) {
            this.dLog.error(funcNode.pos, DiagnosticErrorCode.MAIN_SHOULD_BE_PUBLIC, new Object[0]);
        }
    }

    private void validateWithFoundArrayType(BLangSimpleVariable param) {
        if (this.foundArrayType == null) {
            return;
        }
        if (Types.getImpliedType((BType)param.getBType()).tag == 20) {
            this.dLog.error(param.pos, DiagnosticErrorCode.SAME_ARRAY_TYPE_AS_MAIN_PARAMETER, new Object[0]);
        } else if (param.expr != null) {
            this.dLog.error(param.pos, DiagnosticErrorCode.VARIABLE_AND_ARRAY_TYPE_AS_MAIN_PARAM, param.name, "defaultable " + String.valueOf(param.getBType()), this.foundArrayType);
        } else if (this.foundUnion(param)) {
            this.dLog.error(param.pos, DiagnosticErrorCode.VARIABLE_AND_ARRAY_TYPE_AS_MAIN_PARAM, param.name, param.getBType(), this.foundArrayType);
        }
    }

    private boolean foundUnion(BLangSimpleVariable param) {
        return Types.getImpliedType((BType)param.getBType()).tag == 21;
    }

    private boolean isIncludedRecord(BLangSimpleVariable param) {
        return Types.getImpliedType((BType)param.getBType()).tag == 12 && param.getFlags().contains((Object)Flag.INCLUDED);
    }

    private void validateOptionParams(BLangSimpleVariable lastVar) {
        MainParameterVisitor mainParameterVisitor = new MainParameterVisitor(true);
        BRecordType recordType = (BRecordType)Types.getImpliedType(lastVar.getBType());
        recordType.getFields().forEach((name, field) -> {
            if (!mainParameterVisitor.visit(field.type)) {
                this.dLog.error(field.pos, DiagnosticErrorCode.INVALID_MAIN_OPTION_PARAMS_TYPE, field.name, lastVar.name, field.type);
            }
        });
    }
}

