/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class MainParameterVisitor {
    private final boolean option;

    public MainParameterVisitor(boolean option) {
        this.option = option;
    }

    public boolean visit(BType type) {
        type = Types.getImpliedType(type);
        if (type.tag == 20) {
            return this.isOperandType(((BArrayType)type).eType);
        }
        return this.isOperandTypeOrUnion(type);
    }

    private boolean isOperandTypeOrUnion(BType type) {
        return this.isOperandType(type) || this.isUnionWithNil(type);
    }

    private boolean isUnionWithNil(BType type) {
        BUnionType bUnionType;
        Set memberTypes;
        if (type.tag == 21 && ((HashSet)(memberTypes = (bUnionType = (BUnionType)type).getMemberTypes())).size() == 2) {
            boolean result = this.hasNil((LinkedHashSet<BType>)memberTypes);
            if (result) {
                for (BType memberType : memberTypes) {
                    result &= this.isOperandType(memberType) || memberType.tag == 10;
                }
            }
            return result;
        }
        return false;
    }

    private boolean hasNil(LinkedHashSet<BType> memberTypes) {
        boolean result = false;
        for (BType memberType : memberTypes) {
            if (Types.getImpliedType((BType)memberType).tag != 10) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isOperandType(BType type) {
        return switch (Types.getImpliedType((BType)type).tag) {
            case 2, 3, 4 -> true;
            case 6 -> this.option;
            default -> TypeTags.isIntegerTypeTag(type.tag) || TypeTags.isStringTypeTag(type.tag);
        };
    }
}

