/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConditionResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ReachabilityAnalyzer
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<ReachabilityAnalyzer> REACHABILITY_ANALYZER_KEY = new CompilerContext.Key();
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private final TypeNarrower typeNarrower;
    private final Types types;
    private final BLangDiagnosticLog dlog;
    private final Names names;

    private ReachabilityAnalyzer(CompilerContext context) {
        context.put(REACHABILITY_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
    }

    public static ReachabilityAnalyzer getInstance(CompilerContext context) {
        ReachabilityAnalyzer reachabilityAnalyzer = context.get(REACHABILITY_ANALYZER_KEY);
        if (reachabilityAnalyzer == null) {
            reachabilityAnalyzer = new ReachabilityAnalyzer(context);
        }
        return reachabilityAnalyzer;
    }

    void analyzeReachability(BLangNode node, SymbolEnv env) {
        AnalyzerData data = new AnalyzerData();
        data.env = env;
        this.analyzeReachability(node, data);
    }

    private void analyzeReachability(BLangNode node, AnalyzerData data) {
        SymbolEnv prevEnv = data.env;
        this.visitNode(node, data);
        data.env = prevEnv;
    }

    private void analyzeReachabilityInExpressionIfApplicable(BLangExpression expr, AnalyzerData data) {
        if (expr == null) {
            return;
        }
        NodeKind exprKind = expr.getKind();
        switch (exprKind) {
            case DO_ACTION: {
                this.analyzeReachability((BLangNode)expr, data);
                return;
            }
            case CHECK_EXPR: {
                this.analyzeReachabilityInExpressionIfApplicable(((BLangCheckedExpr)expr).expr, data);
                return;
            }
            case CHECK_PANIC_EXPR: {
                this.analyzeReachabilityInExpressionIfApplicable(((BLangCheckPanickedExpr)expr).expr, data);
                return;
            }
            case TRAP_EXPR: {
                this.analyzeReachabilityInExpressionIfApplicable(((BLangTrapExpr)expr).expr, data);
                return;
            }
            case TYPE_CONVERSION_EXPR: {
                this.analyzeReachabilityInExpressionIfApplicable(((BLangTypeConversionExpr)expr).expr, data);
                return;
            }
            case GROUP_EXPR: {
                this.analyzeReachabilityInExpressionIfApplicable(((BLangGroupExpr)expr).expression, data);
            }
        }
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangPackage pkgNode, AnalyzerData data) {
    }

    @Override
    public void visit(BLangBlockStmt blockNode, AnalyzerData data) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, data.env);
        BType prevBoolConst = data.booleanConstCondition;
        data.isBlockUnreachable = false;
        for (BLangStatement stmt : blockNode.stmts) {
            data.env = blockEnv;
            this.analyzeReachability((BLangNode)stmt, data);
        }
        data.booleanConstCondition = prevBoolConst;
        this.resetUnreachableBlock(data);
        this.resetSkipFurtherAnalysisInUnreachableBlock(data);
    }

    @Override
    public void visit(BLangLock lockNode, AnalyzerData data) {
        boolean failureHandled = data.failureHandled;
        this.checkStatementExecutionValidity(lockNode, data);
        if (!data.failureHandled) {
            data.failureHandled = lockNode.onFailClause != null;
        }
        for (BLangStatement stmt : lockNode.body.stmts) {
            this.analyzeReachability((BLangNode)stmt, data);
        }
        data.failureHandled = failureHandled;
        this.analyzeOnFailClause(lockNode.onFailClause, data);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(varDefNode, data);
        BLangExpression expr = varDefNode.var.expr;
        this.analyzeReachabilityInExpressionIfApplicable(expr, data);
    }

    @Override
    public void visit(BLangAssignment assignNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(assignNode, data);
        this.analyzeReachabilityInExpressionIfApplicable(assignNode.expr, data);
        this.validateAssignmentToNarrowedVariable(assignNode.varRef, assignNode.pos, data);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment, AnalyzerData data) {
        this.checkStatementExecutionValidity(compoundAssignment, data);
        this.validateAssignmentToNarrowedVariable(compoundAssignment.varRef, compoundAssignment.pos, data);
    }

    @Override
    public void visit(BLangContinue continueNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(continueNode, data);
        data.continueAsLastStatement = data.loopCount > 0;
    }

    @Override
    public void visit(BLangBreak breakNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(breakNode, data);
        data.breakAsLastStatement = data.loopCount > 0;
        data.breakStmtFound = true;
    }

    @Override
    public void visit(BLangReturn returnStmt, AnalyzerData data) {
        this.checkStatementExecutionValidity(returnStmt, data);
        this.analyzeReachabilityInExpressionIfApplicable(returnStmt.expr, data);
        data.statementReturnsPanicsOrFails = true;
        data.returnedWithinQuery = true;
    }

    @Override
    public void visit(BLangPanic panicNode, AnalyzerData data) {
        data.statementReturnsPanicsOrFails = true;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(xmlnsStmtNode, data);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(exprStmtNode, data);
        BLangExpression expr = exprStmtNode.expr;
        this.analyzeReachabilityInExpressionIfApplicable(expr, data);
        if (expr.getKind() == NodeKind.INVOCATION && this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(expr.getBType())) {
            data.statementReturnsPanicsOrFails = true;
        }
    }

    @Override
    public void visit(BLangIf ifStmt, AnalyzerData data) {
        this.checkStatementExecutionValidity(ifStmt, data);
        data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
        data.unreachableBlock = data.unreachableBlock || data.booleanConstCondition == this.symTable.falseType;
        this.analyzeReachability((BLangNode)ifStmt.body, data);
        boolean allBranchesTerminate = data.breakAsLastStatement || data.statementReturnsPanicsOrFails;
        this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(allBranchesTerminate, data.continueAsLastStatement, data.potentiallyInvalidAssignmentInLoopsInfo);
        boolean ifStmtReturnsPanicsOrFails = data.statementReturnsPanicsOrFails;
        boolean currentErrorThrown = data.errorThrown;
        boolean ifStmtBreakAsLastStatement = data.breakAsLastStatement;
        boolean ifStmtContinueAsLastStatement = data.continueAsLastStatement;
        BLangStatement elseStmt = ifStmt.elseStmt;
        if (data.booleanConstCondition != this.symTable.trueType || elseStmt != null && elseStmt.getKind() == NodeKind.IF) {
            this.resetStatementReturnsPanicsOrFails(data);
            this.resetErrorThrown(data);
            this.resetLastStatement(data);
        }
        if (elseStmt != null) {
            data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
            data.unreachableBlock = data.unreachableBlock || data.booleanConstCondition == this.symTable.trueType && elseStmt.getKind() != NodeKind.IF;
            this.analyzeReachability((BLangNode)elseStmt, data);
            this.resetUnreachableBlock(data);
            this.resetSkipFurtherAnalysisInUnreachableBlock(data);
            this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(data.breakAsLastStatement || data.statementReturnsPanicsOrFails, data.continueAsLastStatement, data.potentiallyInvalidAssignmentInLoopsInfo);
            if (data.booleanConstCondition == this.symTable.trueType) {
                if (elseStmt.getKind() != NodeKind.IF) {
                    data.statementReturnsPanicsOrFails = this.checkAllBranchesTerminate(ifStmtReturnsPanicsOrFails, ifStmtBreakAsLastStatement, ifStmtContinueAsLastStatement, data);
                }
                this.resetErrorThrown(data);
            }
            if (data.booleanConstCondition == this.symTable.semanticError) {
                data.statementReturnsPanicsOrFails = this.checkAllBranchesTerminate(ifStmtReturnsPanicsOrFails, ifStmtBreakAsLastStatement, ifStmtContinueAsLastStatement, data);
                data.errorThrown = currentErrorThrown && data.errorThrown;
                data.breakAsLastStatement = ifStmtBreakAsLastStatement && data.breakAsLastStatement;
                data.continueAsLastStatement = ifStmtContinueAsLastStatement && data.continueAsLastStatement;
            }
        }
    }

    private boolean checkAllBranchesTerminate(boolean ifStmtReturnsPanicsOrFails, boolean ifStmtBreakAsLastStatement, boolean ifStmtContinueAsLastStatement, AnalyzerData data) {
        return !(!ifStmtReturnsPanicsOrFails && !ifStmtBreakAsLastStatement && !ifStmtContinueAsLastStatement || !data.statementReturnsPanicsOrFails && !data.breakAsLastStatement && !data.continueAsLastStatement);
    }

    @Override
    public void visit(BLangDo doNode, AnalyzerData data) {
        boolean failureHandled = data.failureHandled;
        this.checkStatementExecutionValidity(doNode, data);
        if (!data.failureHandled) {
            data.failureHandled = doNode.onFailClause != null;
        }
        this.analyzeReachability((BLangNode)doNode.body, data);
        data.failureHandled = failureHandled;
        this.analyzeOnFailClause(doNode.onFailClause, data);
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructureStmt, AnalyzerData data) {
        this.checkStatementExecutionValidity(errorDestructureStmt, data);
        this.analyzeReachabilityInExpressionIfApplicable(errorDestructureStmt.expr, data);
        this.validateAssignmentToNarrowedVariables(this.getVarRefs(errorDestructureStmt.varRef), errorDestructureStmt.pos, data);
    }

    @Override
    public void visit(BLangErrorVariableDef errorVariableDef, AnalyzerData data) {
        this.checkStatementExecutionValidity(errorVariableDef, data);
        BLangExpression expr = errorVariableDef.errorVariable.expr;
        this.analyzeReachabilityInExpressionIfApplicable(expr, data);
    }

    @Override
    public void visit(BLangFail failNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(failNode, data);
        boolean bl = data.errorThrown = data.booleanConstCondition == this.symTable.semanticError;
        if (!data.failureHandled) {
            data.statementReturnsPanicsOrFails = true;
        }
        data.returnedWithinQuery = true;
    }

    @Override
    public void visit(BLangForeach foreach, AnalyzerData data) {
        SymbolEnv foreachEnv = SymbolEnv.createLoopEnv(foreach, data.env);
        data.loopAndDoClauseEnvs.push(foreachEnv);
        data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
        boolean prevStatementReturnsPanicsOrFails = data.statementReturnsPanicsOrFails;
        boolean prevBreakAsLastStatement = data.breakAsLastStatement;
        boolean prevContinueAsLastStatement = data.continueAsLastStatement;
        boolean prevBreakStmtFound = data.breakStmtFound;
        boolean failureHandled = data.failureHandled;
        this.checkStatementExecutionValidity(foreach, data);
        if (!data.failureHandled) {
            data.failureHandled = foreach.onFailClause != null;
        }
        data.breakStmtFound = false;
        this.incrementLoopCount(data);
        data.env = foreachEnv;
        this.analyzeReachability((BLangNode)foreach.body, data);
        this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(data.breakAsLastStatement || data.statementReturnsPanicsOrFails, true, data.potentiallyInvalidAssignmentInLoopsInfo);
        this.decrementLoopCount(data);
        data.failureHandled = failureHandled;
        data.continueAsLastStatement = prevContinueAsLastStatement;
        data.breakAsLastStatement = prevBreakAsLastStatement;
        data.statementReturnsPanicsOrFails = prevStatementReturnsPanicsOrFails;
        data.breakStmtFound = prevBreakStmtFound;
        this.analyzeOnFailClause(foreach.onFailClause, data);
        data.loopAndDoClauseEnvs.pop();
    }

    @Override
    public void visit(BLangForkJoin forkJoin, AnalyzerData data) {
    }

    @Override
    public void visit(BLangMatchStatement matchStatement, AnalyzerData data) {
        this.checkStatementExecutionValidity(matchStatement, data);
        this.analyzeReachabilityInExpressionIfApplicable(matchStatement.expr, data);
        if (!data.failureHandled) {
            data.failureHandled = matchStatement.onFailClause != null;
        }
        boolean currentErrorThrown = data.errorThrown;
        boolean hasLastPatternInStatement = data.hasLastPatternInStatement;
        data.hasLastPatternInStatement = false;
        boolean allClausesReturns = true;
        boolean allClausesBreak = true;
        boolean allClausesContinue = true;
        List<BLangMatchClause> matchClauses = matchStatement.matchClauses;
        for (BLangMatchClause matchClause : matchClauses) {
            this.resetErrorThrown(data);
            data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
            this.analyzeReachability((BLangNode)matchClause, data);
            this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(data.breakAsLastStatement || data.statementReturnsPanicsOrFails, data.continueAsLastStatement, data.potentiallyInvalidAssignmentInLoopsInfo);
            allClausesReturns &= data.statementReturnsPanicsOrFails;
            allClausesBreak &= data.breakAsLastStatement;
            allClausesContinue &= data.continueAsLastStatement;
            this.resetStatementReturnsPanicsOrFails(data);
            this.resetLastStatement(data);
        }
        data.statementReturnsPanicsOrFails = allClausesReturns && data.hasLastPatternInStatement;
        data.breakAsLastStatement = allClausesBreak && data.hasLastPatternInStatement;
        data.continueAsLastStatement = allClausesContinue && data.hasLastPatternInStatement;
        data.errorThrown = currentErrorThrown;
        this.analyzeOnFailClause(matchStatement.onFailClause, data);
        data.hasLastPatternInStatement = hasLastPatternInStatement;
    }

    @Override
    public void visit(BLangMatchClause matchClause, AnalyzerData data) {
        boolean hasLastPatternInClause = false;
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        for (BLangMatchPattern matchPattern : matchPatterns) {
            if (data.hasLastPatternInStatement || hasLastPatternInClause && matchClause.matchGuard == null) {
                this.dlog.warning(matchPattern.pos, DiagnosticWarningCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
            hasLastPatternInClause = hasLastPatternInClause || matchPattern.isLastPattern;
        }
        this.analyzeReachability((BLangNode)matchClause.blockStmt, data);
        data.hasLastPatternInStatement = data.hasLastPatternInStatement || matchClause.matchGuard == null && hasLastPatternInClause;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructureStmt, AnalyzerData data) {
        this.checkStatementExecutionValidity(recordDestructureStmt, data);
        this.validateAssignmentToNarrowedVariables(this.getVarRefs(recordDestructureStmt.varRef), recordDestructureStmt.pos, data);
    }

    @Override
    public void visit(BLangRecordVariableDef recordVariableDef, AnalyzerData data) {
        this.checkStatementExecutionValidity(recordVariableDef, data);
    }

    @Override
    public void visit(BLangRollback rollbackNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(rollbackNode, data);
    }

    @Override
    public void visit(BLangTransaction transactionNode, AnalyzerData data) {
        this.checkStatementExecutionValidity(transactionNode, data);
        boolean failureHandled = data.failureHandled;
        if (!data.failureHandled) {
            data.failureHandled = transactionNode.onFailClause != null;
        }
        this.analyzeReachability((BLangNode)transactionNode.transactionBody, data);
        data.failureHandled = failureHandled;
        this.analyzeOnFailClause(transactionNode.onFailClause, data);
    }

    private void analyzeOnFailClause(BLangOnFailClause onFailClause, AnalyzerData data) {
        if (onFailClause == null) {
            return;
        }
        boolean currentStatementReturns = data.statementReturnsPanicsOrFails;
        data.booleanConstCondition = this.symTable.semanticError;
        this.resetStatementReturnsPanicsOrFails(data);
        this.resetLastStatement(data);
        this.resetUnreachableBlock(data);
        this.analyzeReachability((BLangNode)onFailClause, data);
        data.statementReturnsPanicsOrFails = currentStatementReturns && data.statementReturnsPanicsOrFails;
    }

    @Override
    public void visit(BLangCollectClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangRetry retryNode, AnalyzerData data) {
        boolean failureHandled = data.failureHandled;
        this.checkStatementExecutionValidity(retryNode, data);
        if (!data.failureHandled) {
            data.failureHandled = retryNode.onFailClause != null;
        }
        this.analyzeReachability((BLangNode)retryNode.retryBody, data);
        data.failureHandled = failureHandled;
        this.resetLastStatement(data);
        this.resetErrorThrown(data);
        this.analyzeOnFailClause(retryNode.onFailClause, data);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction, AnalyzerData data) {
        this.analyzeReachability((BLangNode)retryTransaction.transaction, data);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause, AnalyzerData data) {
        this.resetLastStatement(data);
        this.resetErrorThrown(data);
        this.analyzeReachability((BLangNode)onFailClause.body, data);
        this.resetErrorThrown(data);
    }

    @Override
    public void visit(BLangGroupByClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangGroupingKey node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangFunction funcNode, AnalyzerData data) {
        this.resetFunction(data);
        if (funcNode.flagSet.contains((Object)Flag.NATIVE)) {
            return;
        }
        if (funcNode.body != null) {
            this.analyzeReachability((BLangNode)funcNode.body, data);
            boolean isNeverReturn = this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(funcNode.symbol.type.getReturnType());
            if (!(funcNode.symbol.type.getReturnType().isNullable() || isNeverReturn || data.hasFunctionTerminated)) {
                Location closeBracePos = this.getEndCharPos(funcNode.pos);
                this.dlog.error(closeBracePos, DiagnosticErrorCode.INVOKABLE_MUST_RETURN, funcNode.getKind().toString().toLowerCase());
            } else if (isNeverReturn && !data.hasFunctionTerminated) {
                this.dlog.error(funcNode.pos, DiagnosticErrorCode.THIS_FUNCTION_SHOULD_PANIC, new Object[0]);
            }
        }
        BType returnType = Types.getImpliedType(funcNode.returnTypeNode.getBType());
        if (!funcNode.interfaceFunction && returnType.tag == 21 && this.types.getAllTypes(returnType, true).contains(this.symTable.nilType) && !this.types.isSubTypeOfErrorOrNilContainingNil((BUnionType)returnType) && !data.statementReturnsPanicsOrFails) {
            this.dlog.warning(funcNode.returnTypeNode.pos, DiagnosticWarningCode.FUNCTION_SHOULD_EXPLICITLY_RETURN_A_VALUE, new Object[0]);
        }
    }

    private Location getEndCharPos(Location pos) {
        LineRange lineRange = pos.lineRange();
        LinePosition endLinePos = lineRange.endLine();
        return new BLangDiagnosticLocation(lineRange.fileName(), endLinePos.line(), endLinePos.line(), endLinePos.offset() - 1, endLinePos.offset(), pos.textRange().startOffset() + pos.textRange().length() - 1, 1);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction, AnalyzerData data) {
        boolean prevStatementReturnsPanicsOrFails = data.statementReturnsPanicsOrFails;
        boolean prevBreakAsLastStatement = data.breakAsLastStatement;
        boolean prevContinueAsLastStatement = data.continueAsLastStatement;
        if (bLangLambdaFunction.parent.getKind() == NodeKind.VARIABLE && ((BLangSimpleVariable)bLangLambdaFunction.parent).name.value.startsWith("0")) {
            BLangFunction function = bLangLambdaFunction.function;
            data.env = SymbolEnv.createFunctionEnv(function, function.symbol.scope, data.env);
            this.analyzeReachability((BLangNode)function, data);
        }
        data.continueAsLastStatement = prevContinueAsLastStatement;
        data.breakAsLastStatement = prevBreakAsLastStatement;
        data.statementReturnsPanicsOrFails = prevStatementReturnsPanicsOrFails;
    }

    @Override
    public void visit(BLangExternalFunctionBody body, AnalyzerData data) {
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction, AnalyzerData data) {
        this.visit((BLangFunction)resourceFunction, data);
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructureStmt, AnalyzerData data) {
        this.checkStatementExecutionValidity(tupleDestructureStmt, data);
        this.validateAssignmentToNarrowedVariables(this.getVarRefs(tupleDestructureStmt.varRef), tupleDestructureStmt.pos, data);
    }

    @Override
    public void visit(BLangTupleVariableDef tupleVariableDef, AnalyzerData data) {
        this.checkStatementExecutionValidity(tupleVariableDef, data);
    }

    @Override
    public void visit(BLangWhile whileNode, AnalyzerData data) {
        SymbolEnv whileEnv = SymbolEnv.createLoopEnv(whileNode, data.env);
        data.loopAndDoClauseEnvs.push(whileEnv);
        data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
        boolean prevStatementReturnsPanicsOrFails = data.statementReturnsPanicsOrFails;
        boolean prevBreakAsLastStatement = data.breakAsLastStatement;
        boolean prevContinueAsLastStatement = data.continueAsLastStatement;
        boolean prevBreakStmtFound = data.breakStmtFound;
        boolean failureHandled = data.failureHandled;
        this.checkStatementExecutionValidity(whileNode, data);
        if (!data.failureHandled) {
            data.failureHandled = whileNode.onFailClause != null;
        }
        this.incrementLoopCount(data);
        data.breakStmtFound = false;
        data.unreachableBlock = data.unreachableBlock || data.booleanConstCondition == this.symTable.falseType;
        data.env = whileEnv;
        this.analyzeReachability((BLangNode)whileNode.body, data);
        this.resetUnreachableBlock(data);
        this.resetSkipFurtherAnalysisInUnreachableBlock(data);
        this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(data.breakAsLastStatement || data.statementReturnsPanicsOrFails, true, data.potentiallyInvalidAssignmentInLoopsInfo);
        this.decrementLoopCount(data);
        data.failureHandled = failureHandled;
        if (data.booleanConstCondition != this.symTable.trueType || data.breakStmtFound) {
            data.statementReturnsPanicsOrFails = prevStatementReturnsPanicsOrFails;
            data.continueAsLastStatement = prevContinueAsLastStatement;
            data.breakAsLastStatement = prevBreakAsLastStatement;
        } else {
            data.statementReturnsPanicsOrFails = true;
        }
        data.breakStmtFound = prevBreakStmtFound;
        this.analyzeOnFailClause(whileNode.onFailClause, data);
        data.loopAndDoClauseEnvs.pop();
    }

    @Override
    public void visit(BLangBlockFunctionBody body, AnalyzerData data) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, data.env);
        boolean hasFunctionTerminated = false;
        for (BLangStatement stmt : body.stmts) {
            data.env = blockEnv;
            this.analyzeReachability((BLangNode)stmt, data);
            hasFunctionTerminated |= data.statementReturnsPanicsOrFails || data.isBlockUnreachable && stmt.getKind() == NodeKind.BLOCK;
        }
        data.hasFunctionTerminated = hasFunctionTerminated;
    }

    @Override
    public void visit(BLangExprFunctionBody body, AnalyzerData data) {
        data.statementReturnsPanicsOrFails = true;
        data.hasFunctionTerminated = true;
        this.resetLastStatement(data);
    }

    @Override
    public void visit(BLangQueryAction queryAction, AnalyzerData data) {
        boolean prevReturnedWithinQuery = data.returnedWithinQuery;
        data.returnedWithinQuery = false;
        for (BLangNode queryClause : queryAction.queryClauseList) {
            if (queryClause.getKind() != NodeKind.WHERE) continue;
            BLangWhereClause whereClause = (BLangWhereClause)queryClause;
            boolean bl = data.unreachableBlock = ConditionResolver.checkConstCondition(this.types, this.symTable, whereClause.expression) == this.symTable.falseType;
            if (!data.unreachableBlock) continue;
            break;
        }
        this.analyzeReachability((BLangNode)queryAction.getDoClause(), data);
        queryAction.returnsWithinDoClause = data.returnedWithinQuery;
        data.returnedWithinQuery = prevReturnedWithinQuery;
    }

    @Override
    public void visit(BLangDoClause doClause, AnalyzerData data) {
        SymbolEnv doEnv = doClause.env;
        data.loopAndDoClauseEnvs.push(doEnv);
        ++data.loopAndDoClauseCount;
        data.potentiallyInvalidAssignmentInLoopsInfo.push(new PotentiallyInvalidAssignmentInfo(new ArrayList<Location>(), data.env.enclInvokable));
        BLangBlockStmt body = doClause.body;
        data.env = doEnv;
        this.analyzeReachability((BLangNode)body, data);
        this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(data.statementReturnsPanicsOrFails, true, DiagnosticErrorCode.INVALID_ASSIGNMENT_TO_NARROWED_VAR_IN_QUERY_ACTION, data.potentiallyInvalidAssignmentInLoopsInfo);
        --data.loopAndDoClauseCount;
        data.loopAndDoClauseEnvs.pop();
        this.resetStatementReturnsPanicsOrFails(data);
        this.resetLastStatement(data);
    }

    @Override
    public void visit(BLangLetExpression letExpression, AnalyzerData data) {
        boolean returnStateBefore = data.statementReturnsPanicsOrFails;
        data.statementReturnsPanicsOrFails = false;
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.analyzeReachability((BLangNode)((Object)letVariable.definitionNode), data);
        }
        data.statementReturnsPanicsOrFails = returnStateBefore;
    }

    private void checkStatementExecutionValidity(BLangStatement statement, AnalyzerData data) {
        if (data.skipFurtherAnalysisInUnreachableBlock) {
            return;
        }
        this.checkUnreachableCode(statement.pos, data);
        this.checkConditionInWhileOrIf(statement, data);
    }

    private void checkConditionInWhileOrIf(BLangStatement statement, AnalyzerData data) {
        switch (statement.getKind()) {
            case WHILE: {
                data.booleanConstCondition = ConditionResolver.checkConstCondition(this.types, this.symTable, ((BLangWhile)statement).expr);
                break;
            }
            case IF: {
                data.unreachableBlock = statement.parent != null && statement.parent.getKind() == NodeKind.IF && data.booleanConstCondition == this.symTable.trueType;
                data.booleanConstCondition = ConditionResolver.checkConstCondition(this.types, this.symTable, ((BLangIf)statement).expr);
            }
        }
    }

    private void checkUnreachableCode(Location pos, AnalyzerData data) {
        if (data.statementReturnsPanicsOrFails) {
            this.logUnreachableError(pos, data);
            this.resetStatementReturnsPanicsOrFails(data);
        } else if (data.errorThrown) {
            this.logUnreachableError(pos, data);
            this.resetErrorThrown(data);
        } else if (data.breakAsLastStatement || data.continueAsLastStatement) {
            this.logUnreachableError(pos, data);
            this.resetLastStatement(data);
        } else if (data.unreachableBlock) {
            data.skipFurtherAnalysisInUnreachableBlock = true;
            this.logUnreachableError(pos, data);
            this.resetUnreachableBlock(data);
        }
    }

    private void logUnreachableError(Location pos, AnalyzerData data) {
        this.dlog.error(pos, DiagnosticErrorCode.UNREACHABLE_CODE, new Object[0]);
        data.isBlockUnreachable = true;
    }

    private void resetStatementReturnsPanicsOrFails(AnalyzerData data) {
        data.statementReturnsPanicsOrFails = false;
    }

    private void resetLastStatement(AnalyzerData data) {
        data.breakAsLastStatement = false;
        data.continueAsLastStatement = false;
    }

    private void resetErrorThrown(AnalyzerData data) {
        data.errorThrown = false;
    }

    private void resetUnreachableBlock(AnalyzerData data) {
        data.unreachableBlock = false;
    }

    private void resetFunction(AnalyzerData data) {
        this.resetStatementReturnsPanicsOrFails(data);
        this.resetErrorThrown(data);
        this.resetLastStatement(data);
        data.booleanConstCondition = this.symTable.semanticError;
    }

    private void resetSkipFurtherAnalysisInUnreachableBlock(AnalyzerData data) {
        data.skipFurtherAnalysisInUnreachableBlock = false;
    }

    private void validateAssignmentToNarrowedVariables(List<BLangExpression> exprs, Location location, AnalyzerData data) {
        for (BLangExpression expr : exprs) {
            if (expr == null) continue;
            switch (expr.getKind()) {
                case SIMPLE_VARIABLE_REF: {
                    this.validateAssignmentToNarrowedVariable(expr, location, data);
                    break;
                }
                case RECORD_VARIABLE_REF: {
                    this.validateAssignmentToNarrowedVariables(this.getVarRefs((BLangRecordVarRef)expr), location, data);
                    break;
                }
                case TUPLE_VARIABLE_REF: {
                    this.validateAssignmentToNarrowedVariables(this.getVarRefs((BLangTupleVarRef)expr), location, data);
                    break;
                }
                case ERROR_VARIABLE_REF: {
                    this.validateAssignmentToNarrowedVariables(this.getVarRefs((BLangErrorVarRef)expr), location, data);
                }
            }
        }
    }

    private void validateAssignmentToNarrowedVariable(BLangExpression expr, Location location, AnalyzerData data) {
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return;
        }
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
        BSymbol symbol = varRef.symbol;
        if (symbol == null || ((BVarSymbol)symbol).originalSymbol == null) {
            return;
        }
        if (data.loopAndDoClauseCount == 0) {
            return;
        }
        this.validateAssignmentToNarrowedVariable(varRef, location, data);
    }

    private void validateAssignmentToNarrowedVariable(BLangSimpleVarRef varRef, Location location, AnalyzerData data) {
        if (Symbols.isFlagOn(varRef.symbol.flags, 4L)) {
            return;
        }
        Name name = this.names.fromIdNode(varRef.variableName);
        SymbolEnv loopEnv = data.loopAndDoClauseEnvs.peek();
        SymbolEnv currentEnv = data.env;
        while (currentEnv != null) {
            BSymbol foundSym = this.symResolver.lookupSymbolInMainSpace(currentEnv, name);
            if (foundSym != this.symTable.notFoundSymbol && foundSym.tag == 52L && ((BVarSymbol)foundSym).originalSymbol == null) {
                return;
            }
            if (currentEnv == loopEnv) {
                BLangNode loopNode = loopEnv.node;
                if (loopNode.getKind() != NodeKind.WHILE || !((BLangWhile)loopNode).expr.narrowedTypeInfo.containsKey(this.typeNarrower.getOriginalVarSymbol((BVarSymbol)varRef.symbol))) break;
                return;
            }
            currentEnv = currentEnv.enclEnv;
        }
        data.potentiallyInvalidAssignmentInLoopsInfo.peek().locations.add(location);
    }

    private void handleInvalidAssignmentToTypeNarrowedVariableInLoop(List<Location> locations, DiagnosticErrorCode errorCode) {
        for (Location location : locations) {
            this.dlog.error(location, errorCode, new Object[0]);
        }
    }

    private void handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(boolean branchTerminates, boolean isLoopBodyOrBranchWithContinueAsLastStmt, Deque<PotentiallyInvalidAssignmentInfo> potentiallyInvalidAssignmentInLoopsInfo) {
        this.handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(branchTerminates, isLoopBodyOrBranchWithContinueAsLastStmt, DiagnosticErrorCode.INVALID_ASSIGNMENT_TO_NARROWED_VAR_IN_LOOP, potentiallyInvalidAssignmentInLoopsInfo);
    }

    private void handlePotentiallyInvalidAssignmentsToTypeNarrowedVariablesInLoop(boolean branchTerminates, boolean isLoopBodyOrBranchWithContinueAsLastStmt, DiagnosticErrorCode errorCode, Deque<PotentiallyInvalidAssignmentInfo> potentiallyInvalidAssignmentInLoopsInfo) {
        PotentiallyInvalidAssignmentInfo currentBranchInfo = potentiallyInvalidAssignmentInLoopsInfo.pop();
        if (branchTerminates) {
            return;
        }
        List<Location> currentBranchLocations = currentBranchInfo.locations;
        if (isLoopBodyOrBranchWithContinueAsLastStmt) {
            this.handleInvalidAssignmentToTypeNarrowedVariableInLoop(currentBranchLocations, errorCode);
            return;
        }
        if (currentBranchLocations.isEmpty() || potentiallyInvalidAssignmentInLoopsInfo.isEmpty()) {
            return;
        }
        PotentiallyInvalidAssignmentInfo prevInfo = potentiallyInvalidAssignmentInLoopsInfo.peek();
        if (prevInfo.enclInvokable != currentBranchInfo.enclInvokable) {
            return;
        }
        prevInfo.locations.addAll(currentBranchLocations);
    }

    private List<BLangExpression> getVarRefs(BLangRecordVarRef varRef) {
        return Stream.concat(varRef.recordRefFields.stream().map(e -> e.variableReference), Stream.of(varRef.restParam)).toList();
    }

    private List<BLangExpression> getVarRefs(BLangErrorVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>();
        if (varRef.message != null) {
            varRefs.add(varRef.message);
        }
        if (varRef.cause != null) {
            varRefs.add(varRef.cause);
        }
        varRefs.addAll(varRef.detail.stream().map(e -> e.expr).toList());
        varRefs.add(varRef.restVar);
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangTupleVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>(varRef.expressions);
        varRefs.add(varRef.restParam);
        return varRefs;
    }

    private void incrementLoopCount(AnalyzerData data) {
        ++data.loopCount;
        ++data.loopAndDoClauseCount;
    }

    private void decrementLoopCount(AnalyzerData data) {
        --data.loopCount;
        --data.loopAndDoClauseCount;
    }

    public static class AnalyzerData {
        SymbolEnv env;
        boolean statementReturnsPanicsOrFails;
        boolean breakAsLastStatement;
        boolean continueAsLastStatement;
        boolean errorThrown;
        boolean unreachableBlock;
        boolean breakStmtFound;
        boolean hasLastPatternInStatement;
        boolean failureHandled;
        boolean returnedWithinQuery;
        boolean skipFurtherAnalysisInUnreachableBlock;
        boolean hasFunctionTerminated;
        boolean isBlockUnreachable;
        int loopCount;
        int loopAndDoClauseCount;
        BType booleanConstCondition;
        Deque<SymbolEnv> loopAndDoClauseEnvs = new ArrayDeque<SymbolEnv>();
        Deque<PotentiallyInvalidAssignmentInfo> potentiallyInvalidAssignmentInLoopsInfo = new ArrayDeque<PotentiallyInvalidAssignmentInfo>();
    }

    private static class PotentiallyInvalidAssignmentInfo {
        List<Location> locations;
        BLangInvokableNode enclInvokable;

        private PotentiallyInvalidAssignmentInfo(List<Location> locations, BLangInvokableNode enclInvokable) {
            this.locations = locations;
            this.enclInvokable = enclInvokable;
        }
    }
}

