/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConditionResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantValueResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.QueryTypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangResourcePathSegment;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorCauseBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorFieldBindingPatterns;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorMessageBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangFieldBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangNamedArgBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangRestBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangSimpleBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangWildCardBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReDisjunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagsOnOff;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangValueExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorCauseMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorFieldMatchPatterns;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMessageMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangNamedArgMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangSimpleMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.Unifier;
import org.wso2.ballerinalang.util.AttachPoints;
import org.wso2.ballerinalang.util.Flags;

public class SemanticAnalyzer
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<SemanticAnalyzer> SYMBOL_ANALYZER_KEY = new CompilerContext.Key();
    private static final String LISTENER_NAME = "listener";
    private final BLangAnonymousModelHelper anonModelHelper;
    private final ConstantAnalyzer constantAnalyzer;
    private final ConstantValueResolver constantValueResolver;
    private final BLangDiagnosticLog dlog;
    private final Names names;
    private final SymbolEnter symbolEnter;
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private final TypeChecker typeChecker;
    private final TypeNarrower typeNarrower;
    private final Types types;
    private final Unifier unifier;
    private final Deque<String> anonTypeNameSuffixes;
    private final CompilerContext compilerContext;
    private final Env typeEnv;

    public static SemanticAnalyzer getInstance(CompilerContext context) {
        SemanticAnalyzer semAnalyzer = context.get(SYMBOL_ANALYZER_KEY);
        if (semAnalyzer == null) {
            semAnalyzer = new SemanticAnalyzer(context);
        }
        return semAnalyzer;
    }

    private SemanticAnalyzer(CompilerContext context) {
        context.put(SYMBOL_ANALYZER_KEY, this);
        this.compilerContext = context;
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.constantAnalyzer = ConstantAnalyzer.getInstance(context);
        this.constantValueResolver = ConstantValueResolver.getInstance(context);
        this.anonModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.unifier = new Unifier();
        this.anonTypeNameSuffixes = new ArrayDeque<String>();
        this.typeEnv = this.types.typeEnv();
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        AnalyzerData data = new AnalyzerData(pkgEnv);
        this.visitNode(pkgNode, data);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode, AnalyzerData data) {
        SymbolEnv pkgEnv;
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.TYPE_CHECK)) {
            return;
        }
        data.env = pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        ArrayList<TopLevelNode> copyOfOriginalTopLevelNodes = new ArrayList<TopLevelNode>(pkgNode.topLevelNodes);
        List<TopLevelNode> topLevelNodes = pkgNode.topLevelNodes;
        for (int i = 0; i < topLevelNodes.size(); ++i) {
            TopLevelNode constant = topLevelNodes.get(i);
            if (constant.getKind() != NodeKind.CONSTANT) continue;
            this.analyzeNode((BLangNode)((Object)constant), data);
        }
        this.validateEnumMemberMetadata(pkgNode.constants);
        for (TopLevelNode copyOfOriginalTopLevelNode : copyOfOriginalTopLevelNodes) {
            if (copyOfOriginalTopLevelNode.getKind() != NodeKind.TYPE_DEFINITION) continue;
            this.analyzeNode((BLangNode)((Object)copyOfOriginalTopLevelNode), data);
        }
        for (int i = 0; i < pkgNode.topLevelNodes.size(); ++i) {
            TopLevelNode pkgLevelNode = pkgNode.topLevelNodes.get(i);
            NodeKind kind = pkgLevelNode.getKind();
            if (kind == NodeKind.CONSTANT) continue;
            if (kind == NodeKind.FUNCTION) {
                BLangFunction blangFunction = (BLangFunction)pkgLevelNode;
                if (blangFunction.flagSet.contains((Object)Flag.LAMBDA) || blangFunction.flagSet.contains((Object)Flag.ATTACHED)) continue;
            }
            if (kind == NodeKind.CLASS_DEFN && ((BLangClassDefinition)pkgLevelNode).isObjectContructorDecl || kind == NodeKind.TYPE_DEFINITION && copyOfOriginalTopLevelNodes.contains(pkgLevelNode)) continue;
            this.analyzeNode((BLangNode)((Object)pkgLevelNode), data);
        }
        this.analyzeModuleConfigurableAmbiguity(pkgNode);
        while (pkgNode.lambdaFunctions.peek() != null) {
            BLangLambdaFunction lambdaFunction = pkgNode.lambdaFunctions.poll();
            BLangFunction function = lambdaFunction.function;
            lambdaFunction.setBType(function.symbol.type);
            data.env = lambdaFunction.capturedClosureEnv;
            this.analyzeNode((BLangNode)lambdaFunction.function, data);
        }
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage, data));
        pkgNode.completedPhases.add(CompilerPhase.TYPE_CHECK);
    }

    private void validateEnumMemberMetadata(List<BLangConstant> constants) {
        HashMap<String, 1> duplicateEnumMembersWithMetadata = new HashMap<String, 1>();
        for (final BLangConstant bLangConstant : constants) {
            if (!bLangConstant.flagSet.contains((Object)Flag.ENUM_MEMBER) || bLangConstant.markdownDocumentationAttachment == null && bLangConstant.annAttachments.isEmpty()) continue;
            String name = bLangConstant.name.value;
            if (duplicateEnumMembersWithMetadata.containsKey(name)) {
                ((List)duplicateEnumMembersWithMetadata.get(name)).add(bLangConstant);
                continue;
            }
            duplicateEnumMembersWithMetadata.put(name, new ArrayList<BLangConstant>(){
                {
                    this.add(bLangConstant);
                }
            });
        }
        for (Map.Entry entry : duplicateEnumMembersWithMetadata.entrySet()) {
            List duplicateMembers = (List)entry.getValue();
            if (duplicateMembers.size() == 1) continue;
            for (BLangConstant duplicateMember : duplicateMembers) {
                this.dlog.warning(duplicateMember.pos, DiagnosticWarningCode.INVALID_METADATA_ON_DUPLICATE_ENUM_MEMBER, new Object[0]);
            }
        }
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        xmlnsNode.setBType(this.symTable.stringType);
        this.typeChecker.checkExpr(xmlnsNode.namespaceURI, currentEnv, this.symTable.stringType, data.prevEnvs, data.commonAnalyzerData);
        if (currentEnv.node.getKind() != NodeKind.PACKAGE) {
            this.symbolEnter.defineNode(xmlnsNode, currentEnv);
        }
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)xmlnsStmtNode.xmlnsDecl, data);
    }

    @Override
    public void visit(BLangResourceFunction funcNode, AnalyzerData data) {
        this.visit((BLangFunction)funcNode, data);
        BType returnType = funcNode.returnTypeNode.getBType();
        if (this.containsClientObjectTypeOrFunctionType(returnType)) {
            this.dlog.error(funcNode.returnTypeNode.getPosition(), DiagnosticErrorCode.INVALID_RESOURCE_METHOD_RETURN_TYPE, new Object[0]);
        }
        List<BLangResourcePathSegment> resourcePathSegments = funcNode.resourcePathSegments;
        int pathSegmentCount = resourcePathSegments.size();
        BLangResourcePathSegment lastPathSegment = resourcePathSegments.get(resourcePathSegments.size() - 1);
        if (lastPathSegment.kind == NodeKind.RESOURCE_ROOT_PATH_SEGMENT) {
            return;
        }
        if (lastPathSegment.kind == NodeKind.RESOURCE_PATH_REST_PARAM_SEGMENT) {
            if (!this.types.isAssignable(lastPathSegment.getBType(), this.symTable.pathParamAllowedType)) {
                this.dlog.error(lastPathSegment.typeNode.getPosition(), DiagnosticErrorCode.UNSUPPORTED_REST_PATH_PARAM_TYPE, lastPathSegment.getBType());
            }
            --pathSegmentCount;
        }
        if (pathSegmentCount > 0) {
            resourcePathSegments.subList(0, pathSegmentCount).stream().filter(pathSeg -> !this.types.isAssignable(pathSeg.typeNode.getBType(), this.symTable.pathParamAllowedType)).forEach(pathSeg -> this.dlog.error(pathSeg.typeNode.getPosition(), DiagnosticErrorCode.UNSUPPORTED_PATH_PARAM_TYPE, pathSeg.getBType()));
        }
    }

    private boolean containsClientObjectTypeOrFunctionType(BType type) {
        BType referredType = Types.getImpliedType(type);
        if (referredType != this.symTable.semanticError && Symbols.isFlagOn(referredType.tsymbol.flags, 65536L)) {
            return true;
        }
        switch (referredType.tag) {
            case 17: {
                return true;
            }
            case 21: {
                for (BType memberType : ((BUnionType)referredType).getMemberTypes()) {
                    if (!this.containsClientObjectTypeOrFunctionType(memberType)) continue;
                    return true;
                }
                break;
            }
            case 22: {
                for (BType memberType : ((BIntersectionType)referredType).getConstituentTypes()) {
                    if (!this.containsClientObjectTypeOrFunctionType(memberType)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void visit(BLangFunction funcNode, AnalyzerData data) {
        boolean hasReturnType;
        SymbolEnv currentEnv = data.env;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, currentEnv);
        funcNode.symbol.params.forEach(param -> param.flags |= 0x40L);
        BVarSymbol restParamSym = funcNode.symbol.restParam;
        if (restParamSym != null) {
            restParamSym.flags |= 0x40L;
        }
        if (!funcNode.flagSet.contains((Object)Flag.WORKER)) {
            funcNode.annAttachments.forEach(annotationAttachment -> {
                if (Symbols.isFlagOn(funcNode.symbol.flags, 32768L) && funcNode.receiver != null && Symbols.isService(funcNode.receiver.getBType().tsymbol)) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.SERVICE_REMOTE);
                    annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT_METHOD);
                } else if (funcNode.attachedFunction) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT_METHOD);
                }
                annotationAttachment.attachPoints.add(AttachPoint.Point.FUNCTION);
                data.env = funcEnv;
                this.analyzeNode((BLangNode)annotationAttachment, data);
            });
            this.validateAnnotationAttachmentCount(funcNode.annAttachments);
        }
        funcNode.symbol.getAnnotations().addAll(this.getAnnotationAttachmentSymbols(funcNode.annAttachments));
        BLangType returnTypeNode = funcNode.returnTypeNode;
        boolean bl = hasReturnType = returnTypeNode != null;
        if (hasReturnType) {
            funcNode.returnTypeAnnAttachments.forEach(annotationAttachment -> {
                annotationAttachment.attachPoints.add(AttachPoint.Point.RETURN);
                data.env = funcEnv;
                this.analyzeNode((BLangNode)annotationAttachment, data);
            });
            this.validateAnnotationAttachmentCount(funcNode.returnTypeAnnAttachments);
            ((BInvokableTypeSymbol)funcNode.symbol.type.tsymbol).returnTypeAnnots.addAll(this.getAnnotationAttachmentSymbols(funcNode.returnTypeAnnAttachments));
            this.analyzeNode((BLangNode)returnTypeNode, data);
        }
        boolean inIsolatedFunction = funcNode.flagSet.contains((Object)Flag.ISOLATED);
        SymbolEnv clonedEnv = funcNode.clonedEnv;
        for (BLangSimpleVariable param2 : funcNode.requiredParams) {
            this.symbolEnter.defineExistingVarSymbolInEnv(param2.symbol, clonedEnv);
            data.env = clonedEnv;
            this.analyzeNode((BLangNode)param2, data);
            BLangExpression expr = param2.expr;
            if (expr != null) {
                funcNode.symbol.paramDefaultValTypes.put(param2.symbol.name.value, expr.getBType());
            }
            this.validateIsolatedParamUsage(inIsolatedFunction, param2, false, data);
        }
        BLangSimpleVariable restParam = funcNode.restParam;
        if (restParam != null) {
            this.symbolEnter.defineExistingVarSymbolInEnv(restParam.symbol, clonedEnv);
            data.env = clonedEnv;
            this.analyzeNode((BLangNode)restParam, data);
            this.validateIsolatedParamUsage(inIsolatedFunction, restParam, true, data);
        }
        if (hasReturnType && Symbols.isFlagOn(returnTypeNode.getBType().getFlags(), 0x4000000L)) {
            this.unifier.validate(this.typeEnv, returnTypeNode.getBType(), funcNode, this.symTable, currentEnv, this.types, this.dlog);
        }
        this.validateObjectAttachedFunction(funcNode, data);
        if (funcNode.hasBody()) {
            data.env = funcEnv;
            this.anonTypeNameSuffixes.push(funcNode.name.value);
            BLangFunctionBody body = funcNode.body;
            this.analyzeNode((BLangNode)body, returnTypeNode.getBType(), data);
            if (body instanceof BLangExternalFunctionBody) {
                BLangExternalFunctionBody externalFunctionBody = (BLangExternalFunctionBody)body;
                funcNode.symbol.setAnnotationAttachmentsOnExternal(this.getAnnotationAttachmentSymbols(externalFunctionBody.annAttachments));
            }
            this.anonTypeNameSuffixes.pop();
        }
        if (funcNode.anonForkName != null) {
            funcNode.symbol.enclForkName = funcNode.anonForkName;
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody body, AnalyzerData data) {
        SymbolEnv funcBodyEnv = SymbolEnv.createFuncBodyEnv(body, data.env);
        int stmtCount = -1;
        for (BLangStatement stmt : body.stmts) {
            boolean analyzedStmt = this.analyzeBlockStmtFollowingIfWithoutElse(stmt, ++stmtCount > 0 ? body.stmts.get(stmtCount - 1) : null, funcBodyEnv, data);
            if (analyzedStmt) continue;
            data.env = funcBodyEnv;
            this.analyzeStmt(stmt, data);
        }
        data.prevEnvs.remove(funcBodyEnv);
        this.resetNotCompletedNormally(data);
    }

    private boolean analyzeBlockStmtFollowingIfWithoutElse(BLangStatement currentStmt, BLangStatement prevStatement, SymbolEnv currentEnv, AnalyzerData data) {
        if (currentStmt.getKind() == NodeKind.BLOCK && prevStatement != null && prevStatement.getKind() == NodeKind.IF && ((BLangIf)prevStatement).elseStmt == null && data.notCompletedNormally) {
            BLangIf ifStmt = (BLangIf)prevStatement;
            data.notCompletedNormally = ConditionResolver.checkConstCondition(this.types, this.symTable, ifStmt.expr) == this.symTable.trueType;
            data.prevEnvs.push(currentEnv);
            data.env = this.typeNarrower.evaluateFalsity(ifStmt.expr, currentStmt, currentEnv, false);
            this.analyzeStmt(currentStmt, data);
            data.prevEnvs.pop();
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangExprFunctionBody body, AnalyzerData data) {
        SymbolEnv env = SymbolEnv.createFuncBodyEnv(body, data.env);
        data.typeChecker.checkExpr(body.expr, env, data.expType, data.prevEnvs, data.commonAnalyzerData);
    }

    @Override
    public void visit(BLangExternalFunctionBody body, AnalyzerData data) {
        for (BLangAnnotationAttachment annotationAttachment : body.annAttachments) {
            annotationAttachment.attachPoints.add(AttachPoint.Point.EXTERNAL);
            this.anonTypeNameSuffixes.push(annotationAttachment.annotationName.value);
            this.analyzeNode((BLangNode)annotationAttachment, data);
            this.anonTypeNameSuffixes.pop();
        }
        this.validateAnnotationAttachmentCount(body.annAttachments);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition, AnalyzerData data) {
        this.analyzeNode((BLangNode)typeDefinition.typeNode, data);
        ArrayList<BAnnotationAttachmentSymbol> annotSymbols = new ArrayList<BAnnotationAttachmentSymbol>();
        typeDefinition.annAttachments.forEach(annotationAttachment -> {
            if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
                annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT);
            }
            annotationAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            annotationAttachment.accept(this, data);
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol != null) {
                annotSymbols.add(annotationAttachmentSymbol);
            }
        });
        BSymbol typeDefSym = typeDefinition.symbol;
        if (typeDefSym != null && typeDefSym.kind == SymbolKind.TYPE_DEF) {
            ((BTypeDefinitionSymbol)typeDefSym).getAnnotations().addAll(annotSymbols);
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            ((BEnumSymbol)typeDefSym).addAnnotations(annotSymbols);
            HashSet<String> enumElements = new HashSet<String>();
            BLangUnionTypeNode bLangUnionTypeNode = (BLangUnionTypeNode)typeDefinition.typeNode;
            for (int j = bLangUnionTypeNode.memberTypeNodes.size() - 1; j >= 0; --j) {
                BLangUserDefinedType nextType = (BLangUserDefinedType)bLangUnionTypeNode.memberTypeNodes.get(j);
                String nextTypeName = nextType.typeName.value;
                if (enumElements.contains(nextTypeName)) {
                    this.dlog.error(nextType.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, nextTypeName);
                    continue;
                }
                enumElements.add(nextTypeName);
            }
        }
        this.validateAnnotationAttachmentCount(typeDefinition.annAttachments);
        this.validateBuiltinTypeAnnotationAttachment(typeDefinition.annAttachments, data);
    }

    @Override
    public void visit(BLangClassDefinition classDefinition, AnalyzerData data) {
        Set<Flag> flagSet = classDefinition.flagSet;
        AttachPoint.Point attachedPoint = flagSet.contains((Object)Flag.OBJECT_CTOR) && flagSet.contains((Object)Flag.SERVICE) ? AttachPoint.Point.SERVICE : AttachPoint.Point.CLASS;
        BClassSymbol symbol = (BClassSymbol)classDefinition.symbol;
        classDefinition.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(attachedPoint);
            annotationAttachment.accept(this, data);
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol != null) {
                symbol.addAnnotation(annotationAttachmentSymbol);
            }
        });
        this.validateAnnotationAttachmentCount(classDefinition.annAttachments);
        this.analyzeClassDefinition(classDefinition, data);
        BType type = classDefinition.getBType();
        List<BLangType> inclusions = classDefinition.typeRefs;
        this.validateInclusions(flagSet, inclusions, false, Symbols.isFlagOn(type.tsymbol.flags, 2048L));
        this.validateTypesOfOverriddenFields(type, classDefinition.fields, inclusions);
    }

    private void analyzeClassDefinition(BLangClassDefinition classDefinition, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        SymbolEnv classEnv = SymbolEnv.createClassEnv(classDefinition, this.createClassScopeWithoutFields(classDefinition.symbol.scope), currentEnv);
        for (BLangSimpleVariable field : classDefinition.fields) {
            data.env = classEnv;
            this.analyzeNode((BLangNode)field, data);
        }
        data.env = currentEnv;
        for (BLangFunction function : classDefinition.functions) {
            this.analyzeNode((BLangNode)function, data);
            if (classDefinition.flagSet.contains((Object)Flag.CLIENT) || !function.flagSet.contains((Object)Flag.RESOURCE) || !function.flagSet.contains((Object)Flag.NATIVE)) continue;
            this.dlog.error(function.pos, DiagnosticErrorCode.SERVICE_RESOURCE_METHOD_CANNOT_BE_EXTERN, function.name);
        }
        DiagnosticErrorCode code = classDefinition.isServiceDecl ? DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_SERVICE_DECL : ((classDefinition.symbol.flags & 0x100000000L) == 0x100000000L ? DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_OBJECT_CTOR : DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_CLASS);
        for (BAttachedFunction func : ((BObjectTypeSymbol)classDefinition.symbol).referencedFunctions) {
            this.validateReferencedFunction(classDefinition.pos, func, currentEnv, code);
        }
        this.analyzerClassInitMethod(classDefinition, data);
    }

    private Scope createClassScopeWithoutFields(Scope classScope) {
        Scope scope = new Scope(classScope.owner);
        Map<Name, Scope.ScopeEntry> classScopeEntries = classScope.entries;
        Map<Name, Scope.ScopeEntry> scopeEntries = scope.entries;
        for (Name key : classScopeEntries.keySet()) {
            Scope.ScopeEntry entry = classScopeEntries.get(key);
            if (Symbols.isFlagOn(entry.symbol.flags, 0x4000000000L)) continue;
            scopeEntries.put(key, entry);
        }
        return scope;
    }

    private void analyzerClassInitMethod(BLangClassDefinition classDefinition, AnalyzerData data) {
        if (classDefinition.initFunction == null) {
            return;
        }
        if (classDefinition.initFunction.flagSet.contains((Object)Flag.PRIVATE)) {
            this.dlog.error(classDefinition.initFunction.pos, DiagnosticErrorCode.PRIVATE_OBJECT_CONSTRUCTOR, classDefinition.symbol.name);
            return;
        }
        if (classDefinition.initFunction.flagSet.contains((Object)Flag.NATIVE)) {
            this.dlog.error(classDefinition.initFunction.pos, DiagnosticErrorCode.OBJECT_INIT_FUNCTION_CANNOT_BE_EXTERN, classDefinition.symbol.name);
            return;
        }
        this.analyzeNode((BLangNode)classDefinition.initFunction, data);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr, AnalyzerData data) {
        conversionExpr.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            if (conversionExpr.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
                annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT);
            }
            annotationAttachment.accept(this, data);
        });
        this.validateAnnotationAttachmentCount(conversionExpr.annAttachments);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode, AnalyzerData data) {
        for (int i = 0; i < finiteTypeNode.valueSpace.size(); ++i) {
            BLangExpression value = finiteTypeNode.valueSpace.get(i);
            NodeKind valueKind = value.getKind();
            if (valueKind == NodeKind.UNARY_EXPR) {
                BLangNumericLiteral newNumericLiteral = Types.constructNumericLiteralFromUnaryExpr((BLangUnaryExpr)value);
                finiteTypeNode.valueSpace.set(i, newNumericLiteral);
                continue;
            }
            if ((valueKind == NodeKind.LITERAL || valueKind == NodeKind.NUMERIC_LITERAL) && ((BLangLiteral)value).originalValue == null) continue;
            this.analyzeNode((BLangNode)value, data);
        }
    }

    @Override
    public void visit(BLangLiteral literalExpr, AnalyzerData data) {
        NodeKind kind;
        if (literalExpr.getKind() == NodeKind.NUMERIC_LITERAL && ((kind = ((BLangNumericLiteral)literalExpr).kind) == NodeKind.HEX_FLOATING_POINT_LITERAL || NumericLiteralSupport.isFloatDiscriminated(literalExpr.originalValue))) {
            this.types.validateFloatLiteral(literalExpr.pos, String.valueOf(literalExpr.value));
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode, AnalyzerData data) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, data.env);
        objectTypeNode.fields.forEach(field -> {
            data.env = objectEnv;
            this.analyzeNode((BLangNode)field, data);
            if (field.flagSet.contains((Object)Flag.PRIVATE)) {
                this.dlog.error(field.pos, DiagnosticErrorCode.PRIVATE_FIELD_ABSTRACT_OBJECT, field.symbol.name);
            }
        });
        objectTypeNode.functions.forEach(func -> {
            this.analyzeNode((BLangNode)func, data);
            if (func.flagSet.contains((Object)Flag.PRIVATE)) {
                this.dlog.error(func.pos, DiagnosticErrorCode.PRIVATE_FUNC_ABSTRACT_OBJECT, func.name, objectTypeNode.symbol.name);
            }
            if (func.flagSet.contains((Object)Flag.NATIVE)) {
                this.dlog.error(func.pos, DiagnosticErrorCode.EXTERN_FUNC_ABSTRACT_OBJECT, func.name, objectTypeNode.symbol.name);
            }
            if (!objectTypeNode.flagSet.contains((Object)Flag.CLIENT) && func.flagSet.contains((Object)Flag.RESOURCE) && func.flagSet.contains((Object)Flag.NATIVE)) {
                this.dlog.error(func.pos, DiagnosticErrorCode.SERVICE_RESOURCE_METHOD_CANNOT_BE_EXTERN, func.name);
            }
        });
        this.validateInclusions(objectTypeNode.flagSet, objectTypeNode.typeRefs, true, false);
        this.validateTypesOfOverriddenFields(objectTypeNode);
        if (objectTypeNode.initFunction == null) {
            return;
        }
        this.dlog.error(objectTypeNode.initFunction.pos, DiagnosticErrorCode.INIT_METHOD_IN_OBJECT_TYPE_DESCRIPTOR, objectTypeNode.symbol.name);
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint keyTypeConstraint, AnalyzerData data) {
        this.analyzeNode((BLangNode)keyTypeConstraint.keyType, data);
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode, AnalyzerData data) {
        BType constraint;
        BType referredConstraint;
        this.analyzeNode((BLangNode)tableTypeNode.constraint, data);
        if (tableTypeNode.tableKeyTypeConstraint != null) {
            this.analyzeNode((BLangNode)tableTypeNode.tableKeyTypeConstraint, data);
        }
        if (!(this.types.isAssignable(referredConstraint = Types.getImpliedType(constraint = tableTypeNode.constraint.getBType()), this.symTable.mapAllType) || referredConstraint.getKind() == TypeKind.PARAMETERIZED && ((BParameterizedType)referredConstraint).paramValueType.getKind() == TypeKind.ANYDATA)) {
            this.dlog.error(tableTypeNode.constraint.pos, DiagnosticErrorCode.TABLE_CONSTRAINT_INVALID_SUBTYPE, constraint);
            return;
        }
        if (referredConstraint.tag == 16) {
            this.typeChecker.validateMapConstraintTable(tableTypeNode.tableType);
            return;
        }
        List<String> fieldNameList = tableTypeNode.tableType.fieldNameList;
        if (!fieldNameList.isEmpty()) {
            this.typeChecker.validateKeySpecifier(fieldNameList, referredConstraint, tableTypeNode.tableKeySpecifier.pos);
        }
        this.analyzeNode((BLangNode)tableTypeNode.constraint, data);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode, AnalyzerData data) {
        if (recordTypeNode.analyzed) {
            return;
        }
        SymbolEnv recordEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, data.env);
        BType type = Types.getImpliedType(recordTypeNode.getBType());
        boolean isRecordType = false;
        LinkedHashMap fields = null;
        boolean allReadOnlyFields = false;
        if (type.tag == 12) {
            isRecordType = true;
            BRecordType recordType = (BRecordType)type;
            fields = recordType.fields;
            allReadOnlyFields = recordType.sealed || Types.getImpliedType((BType)recordType.restFieldType).tag == 50;
        }
        ArrayList recordFields = new ArrayList(recordTypeNode.fields);
        recordFields.addAll(recordTypeNode.includedFields);
        for (BLangSimpleVariable field : recordFields) {
            if (field.flagSet.contains((Object)Flag.READONLY)) {
                this.handleReadOnlyField(isRecordType, fields, field, data);
            } else if (!this.types.isAssignable(field.getBType(), this.symTable.neverType)) {
                allReadOnlyFields = false;
            }
            data.env = recordEnv;
            this.analyzeNode((BLangNode)field, data);
        }
        if (isRecordType && allReadOnlyFields) {
            type.tsymbol.flags |= 0x20L;
            type.addFlags(32L);
        }
        this.validateDefaultable(recordTypeNode);
        this.validateTypesOfOverriddenFields(recordTypeNode);
        recordTypeNode.analyzed = true;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        data.env = SymbolEnv.createTypeEnv(functionTypeNode, functionTypeNode.getBType().tsymbol.scope, currentEnv);
        for (BLangVariable bLangVariable : functionTypeNode.params) {
            this.analyzeNode((BLangNode)bLangVariable, data);
        }
        if (functionTypeNode.restParam != null) {
            this.analyzeNode((BLangNode)functionTypeNode.restParam.typeNode, data);
        }
        if (functionTypeNode.returnTypeNode != null) {
            this.analyzeNode((BLangNode)functionTypeNode.returnTypeNode, data);
        }
        functionTypeNode.analyzed = true;
    }

    @Override
    public void visit(BLangErrorType errorType, AnalyzerData data) {
        if (errorType.detailType == null) {
            return;
        }
        BType detailType = errorType.detailType.getBType();
        if (detailType != null && !this.types.isValidErrorDetailType(detailType)) {
            this.dlog.error(errorType.detailType.pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_TYPE, errorType.detailType, this.symTable.detailType);
        }
        this.analyzeNode((BLangNode)errorType.detailType, data);
    }

    @Override
    public void visit(BLangConstrainedType constrainedType, AnalyzerData data) {
        this.analyzeNode((BLangNode)constrainedType.constraint, data);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode, AnalyzerData data) {
        for (BLangType memberType : unionTypeNode.memberTypeNodes) {
            this.analyzeNode((BLangNode)memberType, data);
        }
    }

    @Override
    public void visit(BLangStreamType streamType, AnalyzerData data) {
        this.analyzeNode((BLangNode)streamType.constraint, data);
        if (streamType.error != null) {
            this.analyzeNode((BLangNode)streamType.error, data);
        }
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode, AnalyzerData data) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeNode((BLangNode)constituentTypeNode, data);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode, AnalyzerData data) {
        List<BLangSimpleVariable> memberNodes = tupleTypeNode.members;
        BType bType = tupleTypeNode.getBType();
        data.env = bType.tag == 24 ? data.env : SymbolEnv.createTypeEnv(tupleTypeNode, new Scope(bType.tsymbol), data.env);
        boolean isTuple = bType.tag == 31;
        List<BTupleMember> members = isTuple ? ((BTupleType)bType).getMembers() : null;
        for (int i = 0; i < memberNodes.size(); ++i) {
            BLangSimpleVariable member = memberNodes.get(i);
            this.analyzeNode((BLangNode)member, data);
            if (!isTuple) continue;
            for (BLangAnnotationAttachment ann : member.annAttachments) {
                members.get((int)i).symbol.addAnnotation(ann.annotationAttachmentSymbol);
            }
        }
        if (tupleTypeNode.restParamType != null) {
            this.analyzeNode((BLangNode)tupleTypeNode.restParamType, data);
        }
    }

    @Override
    public void visit(BLangArrayType arrayType, AnalyzerData data) {
        this.analyzeNode((BLangNode)arrayType.elemtype, data);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType, AnalyzerData data) {
    }

    @Override
    public void visit(BLangValueType valueType, AnalyzerData data) {
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType, AnalyzerData data) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode, AnalyzerData data) {
        BAnnotationSymbol symbol = (BAnnotationSymbol)annotationNode.symbol;
        annotationNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.ANNOTATION);
            annotationAttachment.accept(this, data);
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol != null) {
                symbol.addAnnotation(annotationAttachmentSymbol);
            }
        });
        this.validateAnnotationAttachmentCount(annotationNode.annAttachments);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode, AnalyzerData data) {
        BAnnotationSymbol annotationSymbol;
        BSymbol symbol = this.symResolver.resolveAnnotation(annAttachmentNode.pos, data.env, Names.fromString(annAttachmentNode.pkgAlias.getValue()), Names.fromString(annAttachmentNode.getAnnotationName().getValue()));
        if (symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(annAttachmentNode.pos, DiagnosticErrorCode.UNDEFINED_ANNOTATION, annAttachmentNode.getAnnotationName().getValue());
            return;
        }
        annAttachmentNode.annotationSymbol = annotationSymbol = (BAnnotationSymbol)symbol;
        if (annotationSymbol.maskedPoints > 0 && !Symbols.isAttachPointPresent(annotationSymbol.maskedPoints, AttachPoints.asMask(annAttachmentNode.attachPoints))) {
            String msg = annAttachmentNode.attachPoints.stream().map(point -> point.name().toLowerCase()).collect(Collectors.joining(", "));
            this.dlog.error(annAttachmentNode.pos, DiagnosticErrorCode.ANNOTATION_NOT_ALLOWED, annotationSymbol, msg);
        }
        this.validateAnnotationAttachmentExpr(annAttachmentNode, annotationSymbol, data);
        this.symResolver.populateAnnotationAttachmentSymbol(annAttachmentNode, data.env, this.constantValueResolver, this.anonTypeNameSuffixes);
    }

    @Override
    public void visit(BLangSimpleVariable varNode, AnalyzerData data) {
        BLangExpression rhsExpr;
        boolean configurable = this.isConfigurable(varNode);
        if (varNode.isDeclaredWithVar) {
            if (configurable) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.CONFIGURABLE_VARIABLE_CANNOT_BE_DECLARED_WITH_VAR, new Object[0]);
            }
            this.validateWorkerAnnAttachments(varNode.expr, data);
            this.handleDeclaredWithVar(varNode, data);
            this.transferForkFlag(varNode);
            return;
        }
        SymbolEnv currentEnv = data.env;
        long ownerSymTag = currentEnv.scope.owner.tag;
        boolean isListenerDecl = varNode.flagSet.contains((Object)Flag.LISTENER);
        if ((ownerSymTag & 0x100L) == 256L || (ownerSymTag & 0x8000000L) == 0x8000000L || currentEnv.node.getKind() == NodeKind.LET_CLAUSE) {
            if (varNode.symbol == null) {
                this.analyzeVarNode(varNode, data, AttachPoint.Point.VAR);
            } else {
                this.analyzeVarNode(varNode, data, AttachPoint.Point.PARAMETER);
            }
        } else if ((ownerSymTag & 0x1805CL) == 98396L) {
            this.analyzeVarNode(varNode, data, AttachPoint.Point.OBJECT_FIELD, AttachPoint.Point.FIELD);
        } else if ((ownerSymTag & 0x2805CL) == 163932L) {
            this.analyzeVarNode(varNode, data, AttachPoint.Point.RECORD_FIELD, AttachPoint.Point.FIELD);
        } else if ((ownerSymTag & 0x40801CL) == 4227100L) {
            this.analyzeVarNode(varNode, data, AttachPoint.Point.FIELD);
        } else if ((ownerSymTag & 0x200801CL) == 33587228L) {
            this.analyzeVarNode(varNode, data, AttachPoint.Point.PARAMETER);
        } else {
            varNode.annAttachments.forEach(annotationAttachment -> {
                if (isListenerDecl) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.LISTENER);
                } else if (Symbols.isFlagOn(varNode.symbol.flags, 262144L)) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.SERVICE);
                } else {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                }
                annotationAttachment.accept(this, data);
                BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
                if (annotationAttachmentSymbol != null) {
                    varNode.symbol.addAnnotation(annotationAttachmentSymbol);
                }
            });
        }
        this.validateAnnotationAttachmentCount(varNode.annAttachments);
        this.validateWorkerAnnAttachments(varNode.expr, data);
        if (varNode.typeNode != null) {
            this.analyzeNode((BLangNode)varNode.typeNode, data);
        }
        this.handleWildCardBindingVariable(varNode, currentEnv);
        BType lhsType = varNode.symbol.type;
        varNode.setBType(lhsType);
        if (configurable && varNode.typeNode != null && lhsType.tag != 28) {
            if (!this.types.isAssignable(lhsType, this.symTable.anydataType)) {
                this.dlog.error(varNode.typeNode.pos, DiagnosticErrorCode.CONFIGURABLE_VARIABLE_MUST_BE_ANYDATA, new Object[0]);
            } else {
                if (!this.types.isInherentlyImmutableType(lhsType)) {
                    lhsType = ImmutableTypeCloner.getImmutableIntersectionType(varNode.pos, this.types, lhsType, currentEnv, this.symTable, this.anonModelHelper, this.names, new HashSet<Flag>());
                    varNode.setBType(lhsType);
                    varNode.symbol.type = lhsType;
                }
                this.checkSupportedConfigType(varNode.symbol, varNode.pos, varNode.name.value);
            }
        }
        if ((rhsExpr = varNode.expr) == null) {
            if (varNode.flagSet.contains((Object)Flag.ISOLATED)) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_ISOLATED_QUALIFIER_ON_MODULE_NO_INIT_VAR_DECL, new Object[0]);
            }
            if (ownerSymTag != 4227100L && Types.getImpliedType((BType)lhsType).tag == 20 && this.typeChecker.isArrayOpenSealedType((BArrayType)Types.getImpliedType(lhsType))) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.CLOSED_ARRAY_TYPE_NOT_INITIALIZED, new Object[0]);
            }
            return;
        }
        SymbolEnv varInitEnv = SymbolEnv.createVarInitEnv(varNode, currentEnv, varNode.symbol);
        if (isListenerDecl) {
            BType rhsType = this.typeChecker.checkExpr(rhsExpr, varInitEnv, (BType)BUnionType.create(this.typeEnv, null, lhsType, this.symTable.errorType), data.prevEnvs, data.commonAnalyzerData);
            this.validateListenerCompatibility(varNode, rhsType);
        } else {
            data.typeChecker.checkExpr(rhsExpr, varInitEnv, lhsType, data.prevEnvs, data.commonAnalyzerData);
        }
        this.checkSelfReferencesInVarNode(varNode, rhsExpr, data);
        this.transferForkFlag(varNode);
    }

    private void analyzeModuleConfigurableAmbiguity(BLangPackage pkgNode) {
        if (pkgNode.moduleContextDataHolder == null) {
            return;
        }
        ModuleDescriptor rootModule = pkgNode.moduleContextDataHolder.descriptor();
        Set<BVarSymbol> configVars = this.symResolver.getConfigVarSymbolsIncludingImportedModules(pkgNode.symbol);
        String rootOrgName = rootModule.org().value();
        String rootModuleName = rootModule.packageName().value();
        Map<String, PackageID> configKeys = this.getModuleKeys(configVars, rootOrgName);
        for (BVarSymbol variable : configVars) {
            String moduleName = variable.pkgID.name.value;
            String orgName = variable.pkgID.orgName.value;
            String varName = variable.name.value;
            this.validateMapConfigVariable(orgName + "." + moduleName + "." + varName, variable, configKeys);
            if (!orgName.equals(rootOrgName)) continue;
            this.validateMapConfigVariable(moduleName + "." + varName, variable, configKeys);
            if (!moduleName.equals(rootModuleName) || varName.equals(moduleName)) continue;
            this.validateMapConfigVariable(varName, variable, configKeys);
        }
    }

    private Map<String, PackageID> getModuleKeys(Set<BVarSymbol> configVars, String rootOrg) {
        HashMap<String, PackageID> configKeys = new HashMap<String, PackageID>();
        for (BVarSymbol variable : configVars) {
            PackageID pkgID = variable.pkgID;
            String orgName = pkgID.orgName.value;
            String moduleName = pkgID.name.value;
            configKeys.put(orgName + "." + moduleName, pkgID);
            if (!orgName.equals(rootOrg)) break;
            configKeys.put(moduleName, pkgID);
        }
        return configKeys;
    }

    private void validateMapConfigVariable(String configKey, BVarSymbol variable, Map<String, PackageID> configKeys) {
        if (configKeys.containsKey(configKey) && this.types.isSubTypeOfMapping(variable.type.semType())) {
            this.dlog.error(variable.pos, DiagnosticErrorCode.CONFIGURABLE_VARIABLE_MODULE_AMBIGUITY, variable.name.value, configKeys.get(configKey));
        }
    }

    private void checkSupportedConfigType(BVarSymbol varSymbol, Location location, String varName) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.isSupportedConfigType(varSymbol.type, errors, varName, new HashSet<BType>(), Symbols.isFlagOn(varSymbol.flags, 256L)) || !errors.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            for (String error : errors) {
                errorMsg.append("\n\t").append(error);
            }
            this.dlog.error(location, DiagnosticErrorCode.CONFIGURABLE_VARIABLE_CURRENTLY_NOT_SUPPORTED, varSymbol.type, errorMsg);
        }
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral node, AnalyzerData data) {
        if (node.reDisjunction.sequenceList.isEmpty()) {
            this.dlog.error(node.reDisjunction.pos, DiagnosticErrorCode.EMPTY_REGEXP_STRING_DISALLOWED, node.reDisjunction);
        } else {
            this.analyzeNode((BLangNode)node.reDisjunction, data);
        }
    }

    @Override
    public void visit(BLangReDisjunction node, AnalyzerData data) {
        node.sequenceList.forEach(sequence -> this.analyzeNode((BLangNode)sequence, data));
    }

    @Override
    public void visit(BLangReSequence node, AnalyzerData data) {
        node.termList.forEach(term -> this.analyzeNode((BLangNode)term, data));
    }

    @Override
    public void visit(BLangReAtomQuantifier node, AnalyzerData data) {
        if (node.atom.getKind() == NodeKind.REG_EXP_CHARACTER_CLASS || node.atom.getKind() == NodeKind.REG_EXP_CAPTURING_GROUP) {
            this.analyzeNode((BLangNode)node.atom, data);
        }
    }

    @Override
    public void visit(BLangReCharacterClass node, AnalyzerData data) {
        if (node.charSet == null && node.negation == null) {
            this.dlog.error(node.pos, DiagnosticErrorCode.UNSUPPORTED_EMPTY_CHARACTER_CLASS, node);
        }
    }

    @Override
    public void visit(BLangReAssertion node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangReAtomCharOrEscape node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangReQuantifier node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangReCharSet node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangReCharSetRange node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangReCapturingGroups node, AnalyzerData data) {
        this.analyzeNode((BLangNode)node.disjunction, data);
    }

    @Override
    public void visit(BLangReFlagsOnOff node, AnalyzerData data) {
    }

    private boolean isSupportedConfigType(BType type, List<String> errors, String varName, Set<BType> unresolvedTypes, boolean isRequired) {
        if (!unresolvedTypes.add(type)) {
            return true;
        }
        switch (type.getKind()) {
            case ANYDATA: {
                break;
            }
            case FINITE: {
                return this.types.isAnydata(type.semType());
            }
            case NIL: {
                return !isRequired;
            }
            case ARRAY: {
                BType elementType = ((BArrayType)type).eType;
                if (this.isSupportedConfigType(elementType, errors, varName, unresolvedTypes, isRequired)) break;
                errors.add("array element type '" + String.valueOf(elementType) + "' is not supported");
                break;
            }
            case RECORD: {
                BRecordType recordType = (BRecordType)type;
                HashSet invalidTypeSet = new HashSet();
                recordType.getFields().forEach((fieldName, field) -> {
                    BType fieldType = field.type;
                    String fieldString = varName + "." + fieldName;
                    if (invalidTypeSet.contains(fieldType)) {
                        errors.add("record field type '" + String.valueOf(fieldType) + "' of field '" + fieldString + "' is not supported");
                        return;
                    }
                    if (this.isNilableDefaultField((BField)field, fieldType)) {
                        return;
                    }
                    if (!this.isSupportedConfigType(fieldType, errors, fieldString, unresolvedTypes, isRequired)) {
                        errors.add("record field type '" + String.valueOf(fieldType) + "' of field '" + fieldString + "' is not supported");
                        invalidTypeSet.add(fieldType);
                    }
                });
                break;
            }
            case MAP: {
                BMapType mapType = (BMapType)type;
                if (this.isSupportedConfigType(mapType.constraint, errors, varName, unresolvedTypes, isRequired)) break;
                errors.add("map constraint type '" + String.valueOf(mapType.constraint) + "' is not supported");
                break;
            }
            case TABLE: {
                BTableType tableType = (BTableType)type;
                if (this.isSupportedConfigType(tableType.constraint, errors, varName, unresolvedTypes, isRequired)) break;
                errors.add("table constraint type '" + String.valueOf(tableType.constraint) + "' is not supported");
                break;
            }
            case INTERSECTION: {
                return this.isSupportedConfigType(((BIntersectionType)type).effectiveType, errors, varName, unresolvedTypes, isRequired);
            }
            case UNION: {
                BUnionType unionType = (BUnionType)type;
                for (BType memberType : unionType.getMemberTypes()) {
                    if (this.isSupportedConfigType(memberType, errors, varName, unresolvedTypes, isRequired)) continue;
                    errors.add("union member type '" + String.valueOf(memberType) + "' is not supported");
                }
                break;
            }
            case TUPLE: {
                BTupleType tupleType = (BTupleType)type;
                for (BType memberType : tupleType.getTupleTypes()) {
                    if (this.isSupportedConfigType(memberType, errors, varName, unresolvedTypes, isRequired)) continue;
                    errors.add("tuple element type '" + String.valueOf(memberType) + "' is not supported");
                }
                break;
            }
            case TYPEREFDESC: {
                return this.isSupportedConfigType(Types.getImpliedType(type), errors, varName, unresolvedTypes, isRequired);
            }
            default: {
                return this.types.isAssignable(type, this.symTable.intType) || this.types.isAssignable(type, this.symTable.floatType) || this.types.isAssignable(type, this.symTable.stringType) || this.types.isAssignable(type, this.symTable.booleanType) || this.types.isAssignable(type, this.symTable.decimalType) || this.types.isAssignable(type, this.symTable.xmlType) || this.types.isAssignable(type, this.symTable.jsonType);
            }
        }
        return true;
    }

    private boolean isNilableDefaultField(BField field, BType fieldType) {
        return !Symbols.isFlagOn(field.symbol.flags, 256L) && !Symbols.isFlagOn(field.symbol.flags, 4096L) && fieldType.isNullable();
    }

    private void validateListenerCompatibility(BLangSimpleVariable varNode, BType rhsType) {
        if (Types.getImpliedType((BType)rhsType).tag == 21) {
            for (BType memberType : ((BUnionType)rhsType).getMemberTypes()) {
                memberType = Types.getImpliedType(rhsType);
                if (memberType.tag == 29 || this.types.checkListenerCompatibility(varNode.symbol.type)) continue;
                this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LISTENER_VARIABLE, varNode.name);
            }
        } else if (!this.types.checkListenerCompatibility(varNode.symbol.type)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LISTENER_VARIABLE, varNode.name);
        }
    }

    private void analyzeVarNode(BLangSimpleVariable varNode, AnalyzerData data, AttachPoint.Point ... attachPoints) {
        SymbolEnv currentEnv = data.env;
        if (varNode.symbol == null) {
            this.symbolEnter.defineNode(varNode, currentEnv);
        }
        if (varNode.typeNode != null && varNode.typeNode.getKind() == NodeKind.RECORD_TYPE && !((BLangRecordTypeNode)varNode.typeNode).analyzed) {
            data.env = currentEnv;
            this.analyzeNode((BLangNode)varNode.typeNode, data);
        }
        if (varNode.typeNode != null && varNode.typeNode.getKind() == NodeKind.FUNCTION_TYPE && !((BLangFunctionTypeNode)varNode.typeNode).analyzed) {
            this.analyzeNode((BLangNode)varNode.typeNode, data);
        }
        List<AttachPoint.Point> attachPointsList = Arrays.asList(attachPoints);
        for (BLangAnnotationAttachment annotationAttachment : varNode.annAttachments) {
            annotationAttachment.attachPoints.addAll(attachPointsList);
            annotationAttachment.accept(this, data);
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol == null) continue;
            varNode.symbol.addAnnotation(annotationAttachmentSymbol);
        }
    }

    private void transferForkFlag(BLangSimpleVariable varNode) {
        if (varNode.expr != null && varNode.expr.getKind() == NodeKind.INVOCATION && varNode.flagSet.contains((Object)Flag.WORKER)) {
            BLangInvocation expr = (BLangInvocation)varNode.expr;
            if (expr.name.value.startsWith("0") && (expr.symbol.flags & 0x1000000L) == 0x1000000L) {
                varNode.symbol.flags |= 0x1000000L;
            }
        }
    }

    private void validateWorkerAnnAttachments(BLangExpression expr, AnalyzerData data) {
        if (expr != null && expr instanceof BLangInvocation.BLangActionInvocation && ((BLangInvocation.BLangActionInvocation)expr).async) {
            ((BLangInvocation)expr).annAttachments.forEach(annotationAttachment -> {
                annotationAttachment.attachPoints.add(AttachPoint.Point.WORKER);
                annotationAttachment.accept(this, data);
            });
            this.validateAnnotationAttachmentCount(((BLangInvocation)expr).annAttachments);
        }
    }

    @Override
    public void visit(BLangRecordVariable varNode, AnalyzerData data) {
        if (this.isConfigurable(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_SIMPLE_VARIABLES_ARE_ALLOWED_TO_BE_CONFIGURABLE, new Object[0]);
        }
        if (this.isIsolated(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_A_SIMPLE_VARIABLE_CAN_BE_MARKED_AS_ISOLATED, new Object[0]);
        }
        if (varNode.isDeclaredWithVar) {
            this.handleDeclaredWithVar(varNode, data);
            return;
        }
        SymbolEnv currentEnv = data.env;
        if (varNode.getBType() == null) {
            varNode.setBType(this.symResolver.resolveTypeNode(varNode.typeNode, currentEnv));
        }
        this.analyzeNode((BLangNode)varNode.typeNode, data);
        long ownerSymTag = currentEnv.scope.owner.tag;
        if ((ownerSymTag & 0x1001L) != 4097L && !this.symbolEnter.symbolEnterAndValidateRecordVariable(varNode, currentEnv)) {
            varNode.setBType(this.symTable.semanticError);
            return;
        }
        if (varNode.getBType() == this.symTable.semanticError) {
            return;
        }
        BVarSymbol symbol = varNode.symbol;
        varNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
            annotationAttachment.accept(this, data);
            symbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
        });
        this.validateAnnotationAttachmentCount(varNode.annAttachments);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, currentEnv, varNode.getBType(), data.prevEnvs, data.commonAnalyzerData);
    }

    @Override
    public void visit(BLangTupleVariable varNode, AnalyzerData data) {
        if (this.isConfigurable(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_SIMPLE_VARIABLES_ARE_ALLOWED_TO_BE_CONFIGURABLE, new Object[0]);
        }
        if (this.isIsolated(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_A_SIMPLE_VARIABLE_CAN_BE_MARKED_AS_ISOLATED, new Object[0]);
        }
        if (varNode.isDeclaredWithVar) {
            data.expType = this.resolveTupleType(varNode);
            this.handleDeclaredWithVar(varNode, data);
            return;
        }
        SymbolEnv currentEnv = data.env;
        if (varNode.getBType() == null) {
            varNode.setBType(this.symResolver.resolveTypeNode(varNode.typeNode, currentEnv));
        }
        this.analyzeNode((BLangNode)varNode.typeNode, data);
        long ownerSymTag = currentEnv.scope.owner.tag;
        if ((ownerSymTag & 0x1001L) != 4097L && !this.symbolEnter.checkTypeAndVarCountConsistency(varNode, currentEnv)) {
            varNode.setBType(this.symTable.semanticError);
            return;
        }
        BVarSymbol symbol = varNode.symbol;
        varNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
            annotationAttachment.accept(this, data);
            symbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
        });
        this.validateAnnotationAttachmentCount(varNode.annAttachments);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, currentEnv, varNode.getBType(), data.prevEnvs, data.commonAnalyzerData);
        this.checkSelfReferencesInVarNode(varNode, varNode.expr, data);
    }

    private void checkSelfReferencesInVarNode(BLangVariable variable, BLangExpression rhsExpr, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        switch (variable.getKind()) {
            case VARIABLE: {
                SymbolEnv simpleVarEnv = currentEnv.enclVarSym != null ? currentEnv : SymbolEnv.createVarInitEnv(variable, currentEnv, variable.symbol);
                this.checkSelfReferences(rhsExpr, simpleVarEnv);
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                if (rhsExpr.getKind() != NodeKind.LIST_CONSTRUCTOR_EXPR || ((BLangListConstructorExpr)rhsExpr).exprs.size() > tupleVariable.memberVariables.size()) {
                    return;
                }
                BLangListConstructorExpr listExpr = (BLangListConstructorExpr)rhsExpr;
                for (int i = 0; i < listExpr.exprs.size(); ++i) {
                    for (int j = 0; j < tupleVariable.memberVariables.size(); ++j) {
                        if (listExpr.exprs.get(i).getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                            this.checkSelfReferencesInVarNode(tupleVariable.memberVariables.get(j), listExpr.exprs.get(i), data);
                            continue;
                        }
                        BLangVariable memberVar = tupleVariable.memberVariables.get(j);
                        SymbolEnv varEnv = SymbolEnv.createVarInitEnv(memberVar, currentEnv, memberVar.symbol);
                        this.checkSelfReferences(listExpr.exprs.get(i), varEnv);
                    }
                }
                break;
            }
        }
    }

    private void checkSelfReferences(BLangExpression expr, SymbolEnv varInitEnv) {
        if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
            if (varRef.symbol != null && (varRef.symbol.tag & 0x34L) == 52L) {
                this.typeChecker.checkSelfReferences(varRef.pos, varInitEnv, (BVarSymbol)varRef.symbol);
            }
            return;
        }
        if (expr.getKind() == NodeKind.LET_EXPR) {
            for (BLangLetVariable letVar : ((BLangLetExpression)expr).letVarDeclarations) {
                this.checkSelfReferences(((BLangVariable)letVar.definitionNode.getVariable()).expr, varInitEnv);
            }
            return;
        }
        if (expr.getKind() == NodeKind.INVOCATION) {
            for (BLangExpression argExpr : ((BLangInvocation)expr).argExprs) {
                this.checkSelfReferences(argExpr, varInitEnv);
            }
            return;
        }
        if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
            BLangListConstructorExpr listExpr = (BLangListConstructorExpr)expr;
            for (int i = 0; i < listExpr.exprs.size(); ++i) {
                BLangExpression expression = listExpr.exprs.get(i);
                if (expression.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    expression = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expression).expr;
                }
                this.checkSelfReferences(expression, varInitEnv);
            }
            return;
        }
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            BLangRecordLiteral recordLiteral = (BLangRecordLiteral)expr;
            for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
                if (field.isKeyValueField()) {
                    BLangRecordLiteral.BLangRecordKeyValueField pair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    this.checkSelfReferences(pair.valueExpr, varInitEnv);
                    continue;
                }
                if (field.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
                this.checkSelfReferences((BLangSimpleVarRef)((Object)field), varInitEnv);
            }
        }
    }

    private BType resolveTupleType(BLangTupleVariable varNode) {
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>(varNode.memberVariables.size());
        for (BLangVariable memberVariable : varNode.memberVariables) {
            BType type = this.getTupleMemberType(memberVariable);
            BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
            members.add(new BTupleMember(type, varSymbol));
        }
        BLangVariable restVariable = varNode.restVariable;
        if (restVariable == null) {
            return new BTupleType(this.typeEnv, members);
        }
        return new BTupleType(this.typeEnv, null, members, this.getTupleMemberType(restVariable), 0L);
    }

    private BType getTupleMemberType(BLangVariable memberVariable) {
        if (memberVariable.getKind() == NodeKind.TUPLE_VARIABLE) {
            return this.resolveTupleType((BLangTupleVariable)memberVariable);
        }
        return this.symTable.noType;
    }

    @Override
    public void visit(BLangErrorVariable varNode, AnalyzerData data) {
        long ownerSymTag;
        if (this.isConfigurable(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_SIMPLE_VARIABLES_ARE_ALLOWED_TO_BE_CONFIGURABLE, new Object[0]);
        }
        if (this.isIsolated(varNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.ONLY_A_SIMPLE_VARIABLE_CAN_BE_MARKED_AS_ISOLATED, new Object[0]);
        }
        if (varNode.isDeclaredWithVar) {
            this.handleDeclaredWithVar(varNode, data);
            this.validateErrorDetailBindingPatterns(varNode);
            return;
        }
        SymbolEnv currentEnv = data.env;
        if (varNode.getBType() == null) {
            varNode.setBType(this.symResolver.resolveTypeNode(varNode.typeNode, currentEnv));
        }
        this.analyzeNode((BLangNode)varNode.typeNode, data);
        if (!varNode.reasonVarPrefixAvailable && varNode.getBType() == null) {
            BErrorType errorType = new BErrorType(this.typeEnv, varNode.getBType().tsymbol, null);
            if (Types.getImpliedType((BType)varNode.getBType()).tag == 21) {
                Set<BType> members = this.types.expandAndGetMemberTypesRecursive(varNode.getBType());
                List<BErrorType> errorMembers = members.stream().filter(m -> Types.getImpliedType((BType)m).tag == 29).map(m -> (BErrorType)Types.getImpliedType(m)).toList();
                if (errorMembers.isEmpty()) {
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_ERROR_MATCH_PATTERN, new Object[0]);
                    return;
                }
                errorType.detailType = errorMembers.size() == 1 ? errorMembers.get((int)0).detailType : this.symTable.detailType;
                varNode.setBType(errorType);
            } else if (Types.getImpliedType((BType)varNode.getBType()).tag == 29) {
                errorType.detailType = ((BErrorType)Types.getImpliedType((BType)varNode.getBType())).detailType;
            }
        }
        if (((ownerSymTag = currentEnv.scope.owner.tag) & 0x1001L) != 4097L && !this.symbolEnter.symbolEnterAndValidateErrorVariable(varNode, currentEnv)) {
            varNode.setBType(this.symTable.semanticError);
            return;
        }
        if (varNode.getBType() == this.symTable.semanticError) {
            return;
        }
        BVarSymbol symbol = varNode.symbol;
        varNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
            annotationAttachment.accept(this, data);
            symbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
        });
        this.validateAnnotationAttachmentCount(varNode.annAttachments);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, currentEnv, varNode.getBType(), data.prevEnvs, data.commonAnalyzerData);
        this.validateErrorDetailBindingPatterns(varNode);
    }

    private void validateErrorDetailBindingPatterns(BLangErrorVariable errorVariable) {
        BType rhsType = Types.getImpliedType(errorVariable.expr.getBType());
        if (rhsType.getKind() != TypeKind.ERROR) {
            return;
        }
        BErrorType errorType = (BErrorType)rhsType;
        BType detailType = Types.getImpliedType(errorType.detailType);
        if (detailType.getKind() != TypeKind.RECORD) {
            for (BLangErrorVariable.BLangErrorDetailEntry errorDetailEntry : errorVariable.detail) {
                this.dlog.error(errorDetailEntry.pos, DiagnosticErrorCode.CANNOT_BIND_UNDEFINED_ERROR_DETAIL_FIELD, errorDetailEntry.key.value);
            }
            return;
        }
        BRecordType rhsDetailType = (BRecordType)detailType;
        LinkedHashMap detailFields = rhsDetailType.fields;
        for (BLangErrorVariable.BLangErrorDetailEntry errorDetailEntry : errorVariable.detail) {
            String entryName = errorDetailEntry.key.getValue();
            BField entryField = (BField)detailFields.get(entryName);
            if (entryField == null) {
                this.dlog.error(errorDetailEntry.pos, DiagnosticErrorCode.CANNOT_BIND_UNDEFINED_ERROR_DETAIL_FIELD, errorDetailEntry.key.value);
                continue;
            }
            errorDetailEntry.keySymbol = entryField.symbol;
            if (!Symbols.isFlagOn(entryField.symbol.flags, 4096L)) continue;
            this.dlog.error(errorDetailEntry.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
        }
    }

    private void handleDeclaredWithVar(BLangVariable variable, AnalyzerData data) {
        BType rhsType;
        SymbolEnv currentEnv = data.env;
        BLangExpression varRefExpr = variable.expr;
        if (varRefExpr == null) {
            rhsType = this.symTable.semanticError;
            variable.setBType(this.symTable.semanticError);
            this.dlog.error(variable.pos, DiagnosticErrorCode.VARIABLE_DECL_WITH_VAR_WITHOUT_INITIALIZER, new Object[0]);
        } else {
            rhsType = data.typeChecker.checkExpr(varRefExpr, currentEnv, data.expType, data.prevEnvs, data.commonAnalyzerData);
        }
        switch (variable.getKind()) {
            case VARIABLE: 
            case LET_VARIABLE: {
                if (!this.validateObjectTypeInitInvocation(varRefExpr)) {
                    rhsType = this.symTable.semanticError;
                }
                if (variable.flagSet.contains((Object)Flag.LISTENER)) {
                    BType listenerType = this.getListenerType(rhsType);
                    if (listenerType == null) {
                        this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, LISTENER_NAME, rhsType);
                        return;
                    }
                    rhsType = listenerType;
                }
                BLangSimpleVariable simpleVariable = (BLangSimpleVariable)variable;
                simpleVariable.setBType(rhsType);
                this.handleWildCardBindingVariable(simpleVariable, currentEnv);
                long ownerSymTag = currentEnv.scope.owner.tag;
                if (((ownerSymTag & 0x100L) == 256L || (ownerSymTag & 0x8000000L) == 0x8000000L) && simpleVariable.symbol == null) {
                    this.symbolEnter.defineNode(simpleVariable, currentEnv);
                }
                simpleVariable.symbol.type = rhsType;
                if (simpleVariable.symbol.type == this.symTable.semanticError) {
                    simpleVariable.symbol.state = DiagnosticState.UNKNOWN_TYPE;
                }
                variable.annAttachments.forEach(annotationAttachment -> {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                    annotationAttachment.accept(this, data);
                    BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
                    if (annotationAttachmentSymbol != null) {
                        variable.symbol.addAnnotation(annotationAttachmentSymbol);
                    }
                });
                this.validateAnnotationAttachmentCount(variable.annAttachments);
                break;
            }
            case TUPLE_VARIABLE: {
                if (varRefExpr == null) {
                    return;
                }
                if (variable.isDeclaredWithVar && variable.expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                    List<BLangExpression> members = ((BLangListConstructorExpr)varRefExpr).exprs;
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_INFER_TYPES_FOR_TUPLE_BINDING, members);
                    variable.setBType(this.symTable.semanticError);
                    return;
                }
                if (31 != Types.getImpliedType((BType)rhsType).tag && 20 != Types.getImpliedType((BType)rhsType).tag) {
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN_INFERENCE, rhsType);
                    variable.setBType(this.symTable.semanticError);
                    return;
                }
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                tupleVariable.setBType(rhsType);
                if (!this.symbolEnter.checkTypeAndVarCountConsistency(tupleVariable, currentEnv)) {
                    tupleVariable.setBType(this.symTable.semanticError);
                    return;
                }
                BVarSymbol tupleVarSymbol = tupleVariable.symbol;
                tupleVariable.annAttachments.forEach(annotationAttachment -> {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                    annotationAttachment.accept(this, data);
                    tupleVarSymbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
                });
                this.validateAnnotationAttachmentCount(tupleVariable.annAttachments);
                break;
            }
            case RECORD_VARIABLE: {
                if (varRefExpr == null) {
                    return;
                }
                BType recordRhsType = Types.getImpliedType(rhsType);
                if (12 != recordRhsType.tag && 16 != recordRhsType.tag && 7 != recordRhsType.tag) {
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_TYPE_DEFINITION_FOR_RECORD_VAR, rhsType);
                    variable.setBType(this.symTable.semanticError);
                }
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.setBType(rhsType);
                if (!this.symbolEnter.symbolEnterAndValidateRecordVariable(recordVariable, currentEnv)) {
                    recordVariable.setBType(this.symTable.semanticError);
                }
                BVarSymbol recordVarSymbol = recordVariable.symbol;
                recordVariable.annAttachments.forEach(annotationAttachment -> {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                    annotationAttachment.accept(this, data);
                    recordVarSymbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
                });
                this.validateAnnotationAttachmentCount(recordVariable.annAttachments);
                break;
            }
            case ERROR_VARIABLE: {
                if (varRefExpr == null) {
                    return;
                }
                if (29 != Types.getImpliedType((BType)rhsType).tag) {
                    this.dlog.error(variable.expr.pos, DiagnosticErrorCode.INVALID_TYPE_DEFINITION_FOR_ERROR_VAR, rhsType);
                    variable.setBType(this.symTable.semanticError);
                    return;
                }
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                if (errorVariable.typeNode != null) {
                    this.symResolver.resolveTypeNode(errorVariable.typeNode, currentEnv);
                }
                errorVariable.setBType(rhsType);
                if (!this.symbolEnter.symbolEnterAndValidateErrorVariable(errorVariable, currentEnv)) {
                    errorVariable.setBType(this.symTable.semanticError);
                    return;
                }
                BVarSymbol errorVarSymbol = errorVariable.symbol;
                errorVariable.annAttachments.forEach(annotationAttachment -> {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                    annotationAttachment.accept(this, data);
                    errorVarSymbol.addAnnotation(annotationAttachment.annotationAttachmentSymbol);
                });
                this.validateAnnotationAttachmentCount(errorVariable.annAttachments);
            }
        }
    }

    private BType getListenerType(BType bType) {
        LinkedHashSet<BType> compatibleTypes = new LinkedHashSet<BType>();
        BType type = Types.getImpliedType(bType);
        if (type.tag == 21) {
            for (BType t : ((BUnionType)type).getMemberTypes()) {
                if (Types.getImpliedType((BType)t).tag == 29) continue;
                if (this.types.checkListenerCompatibility(t)) {
                    compatibleTypes.add(t);
                    continue;
                }
                return null;
            }
        } else if (this.types.checkListenerCompatibility(type)) {
            compatibleTypes.add(type);
        }
        if (compatibleTypes.isEmpty()) {
            return null;
        }
        if (compatibleTypes.size() == 1) {
            return (BType)compatibleTypes.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, compatibleTypes);
    }

    private void handleWildCardBindingVariable(BLangSimpleVariable variable, SymbolEnv env) {
        BType bindingValueType;
        if (!variable.name.value.equals(Names.IGNORE.value)) {
            return;
        }
        BLangExpression bindingExp = variable.expr;
        BType bType = bindingValueType = bindingExp != null && bindingExp.getBType() != null ? bindingExp.getBType() : variable.getBType();
        if (!this.types.isAssignable(bindingValueType, this.symTable.anyType)) {
            this.dlog.error(variable.pos, DiagnosticErrorCode.WILD_CARD_BINDING_PATTERN_ONLY_SUPPORTS_TYPE_ANY, new Object[0]);
        }
        variable.symbol = new BVarSymbol(0L, Names.IGNORE, env.enclPkg.packageID, variable.getBType(), env.scope.owner, variable.pos, SymbolOrigin.VIRTUAL);
    }

    void handleDeclaredVarInForeach(BLangVariable variable, BType rhsType, SymbolEnv blockEnv) {
        BType referredRhsType = Types.getImpliedType(rhsType);
        switch (variable.getKind()) {
            case VARIABLE: {
                BLangSimpleVariable simpleVariable = (BLangSimpleVariable)variable;
                simpleVariable.setBType(rhsType);
                this.handleWildCardBindingVariable(simpleVariable, blockEnv);
                long ownerSymTag = blockEnv.scope.owner.tag;
                if (((ownerSymTag & 0x100L) == 256L || (ownerSymTag & 0x1001L) == 4097L || (ownerSymTag & 0x8000000L) == 0x8000000L) && simpleVariable.symbol == null) {
                    variable.flagSet.add(Flag.NEVER_ALLOWED);
                    this.symbolEnter.defineNode(simpleVariable, blockEnv);
                }
                this.recursivelySetFinalFlag(simpleVariable);
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                if (31 != referredRhsType.tag && 20 != referredRhsType.tag && 21 != referredRhsType.tag || variable.isDeclaredWithVar && !this.types.isSubTypeOfBaseType(rhsType, PredefinedType.LIST)) {
                    this.dlog.error(variable.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN_INFERENCE, rhsType);
                    this.recursivelyDefineVariables(tupleVariable, blockEnv);
                    return;
                }
                tupleVariable.setBType(rhsType);
                if (referredRhsType.tag == 31 && !this.symbolEnter.checkTypeAndVarCountConsistency(tupleVariable, (BTupleType)referredRhsType, blockEnv)) {
                    this.recursivelyDefineVariables(tupleVariable, blockEnv);
                    return;
                }
                if (referredRhsType.tag == 21 || referredRhsType.tag == 20) {
                    BTupleType tupleVariableType = null;
                    BLangType type = tupleVariable.typeNode;
                    if (type != null && Types.getImpliedType((BType)type.getBType()).tag == 31) {
                        tupleVariableType = (BTupleType)Types.getImpliedType(type.getBType());
                    }
                    if (!this.symbolEnter.checkTypeAndVarCountConsistency(tupleVariable, tupleVariableType, blockEnv)) {
                        this.recursivelyDefineVariables(tupleVariable, blockEnv);
                        return;
                    }
                }
                this.recursivelySetFinalFlag(tupleVariable);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.setBType(rhsType);
                this.symbolEnter.validateRecordVariable(recordVariable, blockEnv);
                this.recursivelySetFinalFlag(recordVariable);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                errorVariable.setBType(rhsType);
                if (29 != referredRhsType.tag) {
                    if (referredRhsType != this.symTable.semanticError) {
                        this.dlog.error(variable.pos, DiagnosticErrorCode.INVALID_TYPE_DEFINITION_FOR_ERROR_VAR, rhsType);
                    }
                    this.recursivelyDefineVariables(errorVariable, blockEnv);
                    return;
                }
                this.symbolEnter.validateErrorVariable(errorVariable, blockEnv);
                this.recursivelySetFinalFlag(errorVariable);
            }
        }
    }

    private void recursivelyDefineVariables(BLangVariable variable, SymbolEnv blockEnv) {
        switch (variable.getKind()) {
            case VARIABLE: {
                Name name = this.names.fromIdNode(((BLangSimpleVariable)variable).name);
                Name origName = this.names.originalNameFromIdNode(((BLangSimpleVariable)variable).name);
                variable.setBType(this.symTable.semanticError);
                this.symbolEnter.defineVarSymbol(variable.pos, variable.flagSet, variable.getBType(), name, origName, blockEnv, variable.internal);
                break;
            }
            case TUPLE_VARIABLE: {
                ((BLangTupleVariable)variable).memberVariables.forEach(memberVariable -> this.recursivelyDefineVariables((BLangVariable)memberVariable, blockEnv));
                break;
            }
            case RECORD_VARIABLE: {
                ((BLangRecordVariable)variable).variableList.forEach(value -> this.recursivelyDefineVariables(value.valueBindingPattern, blockEnv));
            }
        }
    }

    private void recursivelySetFinalFlag(BLangVariable variable) {
        if (variable == null) {
            return;
        }
        switch (variable.getKind()) {
            case VARIABLE: {
                if (variable.symbol == null) {
                    return;
                }
                variable.symbol.flags |= 4L;
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                tupleVariable.memberVariables.forEach(this::recursivelySetFinalFlag);
                this.recursivelySetFinalFlag(tupleVariable.restVariable);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.variableList.forEach(value -> this.recursivelySetFinalFlag(value.valueBindingPattern));
                this.recursivelySetFinalFlag(recordVariable.restParam);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                this.recursivelySetFinalFlag(errorVariable.message);
                this.recursivelySetFinalFlag(errorVariable.restDetail);
                errorVariable.detail.forEach(bLangErrorDetailEntry -> this.recursivelySetFinalFlag(bLangErrorDetailEntry.valueBindingPattern));
            }
        }
    }

    @Override
    public void visit(BLangBlockStmt blockNode, AnalyzerData data) {
        data.env = SymbolEnv.createBlockEnv(blockNode, data.env);
        int stmtCount = -1;
        for (BLangStatement stmt : blockNode.stmts) {
            boolean analyzedStmt = this.analyzeBlockStmtFollowingIfWithoutElse(stmt, ++stmtCount > 0 ? blockNode.stmts.get(stmtCount - 1) : null, data.env, data);
            if (analyzedStmt) continue;
            this.analyzeStmt(stmt, data);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)varDefNode.var, data);
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)varDefNode.var, data);
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)varDefNode.errorVariable, data);
    }

    @Override
    public void visit(BLangTupleVariableDef tupleVariableDef, AnalyzerData data) {
        this.analyzeNode((BLangNode)tupleVariableDef.var, data);
    }

    private Boolean validateLhsVar(BLangExpression vRef) {
        if (vRef.getKind() == NodeKind.INVOCATION) {
            this.dlog.error(vRef.pos, DiagnosticErrorCode.INVALID_INVOCATION_LVALUE_ASSIGNMENT, vRef);
            return false;
        }
        if (vRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || vRef.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            this.validateLhsVar(((BLangAccessExpression)vRef).expr);
        }
        return true;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment, AnalyzerData data) {
        BType expType;
        BLangValueExpression varRef = compoundAssignment.varRef;
        SymbolEnv currentEnv = data.env;
        boolean isValidVarRef = this.validateLhsVar(varRef);
        if (isValidVarRef) {
            varRef.isCompoundAssignmentLValue = true;
            this.typeChecker.checkExpr((BLangExpression)varRef, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
            expType = varRef.getBType();
        } else {
            expType = this.symTable.semanticError;
        }
        data.typeChecker.checkExpr(compoundAssignment.expr, currentEnv, data.prevEnvs, data.commonAnalyzerData);
        this.checkConstantAssignment(varRef, data);
        if (expType != this.symTable.semanticError && compoundAssignment.expr.getBType() != this.symTable.semanticError) {
            BSymbol opSymbol;
            BType expressionType = compoundAssignment.expr.getBType();
            if (expType.isNullable() || expressionType.isNullable()) {
                this.dlog.error(compoundAssignment.pos, DiagnosticErrorCode.COMPOUND_ASSIGNMENT_NOT_ALLOWED_WITH_NULLABLE_OPERANDS, new Object[0]);
            }
            if ((opSymbol = this.symResolver.resolveBinaryOperator(compoundAssignment.opKind, expType, expressionType)) == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getArithmeticOpsForTypeSets(compoundAssignment.opKind, expType, expressionType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBitwiseShiftOpsForTypeSets(compoundAssignment.opKind, expType, expressionType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryBitwiseOpsForTypeSets(compoundAssignment.opKind, expType, expressionType);
            }
            if (opSymbol == this.symTable.notFoundSymbol) {
                this.dlog.error(compoundAssignment.pos, DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES, new Object[]{compoundAssignment.opKind, expType, expressionType});
            } else {
                BVarSymbol originSymbol;
                compoundAssignment.modifiedExpr = this.getBinaryExpr(varRef, compoundAssignment.expr, compoundAssignment.opKind, opSymbol);
                if (this.isSimpleVarRef(varRef) && (originSymbol = ((BVarSymbol)varRef.symbol).originalSymbol) != null) {
                    BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
                    simpleVarRef.pos = varRef.pos;
                    simpleVarRef.variableName = ((BLangSimpleVarRef)varRef).variableName;
                    simpleVarRef.symbol = varRef.symbol;
                    simpleVarRef.isLValue = true;
                    simpleVarRef.setBType(originSymbol.type);
                    compoundAssignment.varRef = simpleVarRef;
                }
                compoundAssignment.modifiedExpr.parent = compoundAssignment;
                this.types.checkType(compoundAssignment.modifiedExpr, compoundAssignment.modifiedExpr.getBType(), compoundAssignment.varRef.getBType());
            }
        }
        this.resetTypeNarrowing(compoundAssignment.varRef, data);
    }

    @Override
    public void visit(BLangAssignment assignNode, AnalyzerData data) {
        BLangExpression varRef = assignNode.varRef;
        if (varRef.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            ((BLangAccessExpression)varRef).leafNode = true;
        }
        this.setTypeOfVarRefInAssignment(varRef, data);
        data.expType = varRef.getBType();
        this.validateFunctionVarRef(varRef, data);
        this.checkInvalidTypeDef(varRef);
        BType actualExpectedType = null;
        if (data.expType != this.symTable.semanticError && CompilerUtils.isAssignmentToOptionalField(assignNode)) {
            actualExpectedType = data.expType;
            data.expType = this.types.addNilForNillableAccessType(actualExpectedType);
        }
        BLangExpression expr = assignNode.expr;
        data.typeChecker.checkExpr(expr, data.env, data.expType, data.prevEnvs, data.commonAnalyzerData);
        if (actualExpectedType != null && expr.impConversionExpr != null) {
            data.typeChecker.resetImpConversionExpr(expr, expr.getBType(), actualExpectedType);
        }
        this.validateWorkerAnnAttachments(assignNode.expr, data);
        this.resetTypeNarrowing(varRef, data);
    }

    @Override
    public void visit(BLangTupleDestructure tupleDeStmt, AnalyzerData data) {
        for (BLangExpression tupleVar : tupleDeStmt.varRef.expressions) {
            this.setTypeOfVarRefForBindingPattern(tupleVar, data);
            this.checkInvalidTypeDef(tupleVar);
            this.validateFunctionVarRef(tupleVar, data);
        }
        if (tupleDeStmt.varRef.restParam != null) {
            this.setTypeOfVarRefForBindingPattern(tupleDeStmt.varRef.restParam, data);
            this.checkInvalidTypeDef(tupleDeStmt.varRef.restParam);
        }
        this.setTypeOfVarRef(tupleDeStmt.varRef, data);
        BType type = this.typeChecker.checkExpr(tupleDeStmt.expr, data.env, tupleDeStmt.varRef.getBType(), data.prevEnvs, data.commonAnalyzerData);
        if (type.tag != 28) {
            this.checkTupleVarRefEquivalency(tupleDeStmt.pos, tupleDeStmt.varRef, tupleDeStmt.expr.getBType(), tupleDeStmt.expr.pos, data);
        }
    }

    private void validateFunctionVarRef(BLangExpression expr, AnalyzerData data) {
        if (this.types.isFunctionVarRef(expr)) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, Names.FUNCTION);
            data.expType = this.symTable.semanticError;
        }
    }

    @Override
    public void visit(BLangRecordDestructure recordDeStmt, AnalyzerData data) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue keyValue : recordDeStmt.varRef.recordRefFields) {
            this.setTypeOfVarRefForBindingPattern(keyValue.variableReference, data);
            this.checkInvalidTypeDef(keyValue.variableReference);
        }
        if (recordDeStmt.varRef.restParam != null) {
            this.setTypeOfVarRefForBindingPattern(recordDeStmt.varRef.restParam, data);
            this.checkInvalidTypeDef(recordDeStmt.varRef.restParam);
        }
        this.setTypeOfVarRef(recordDeStmt.varRef, data);
        SymbolEnv currentEnv = data.env;
        data.typeChecker.checkExpr((BLangExpression)recordDeStmt.varRef, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        data.typeChecker.checkExpr(recordDeStmt.expr, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        this.checkRecordVarRefEquivalency(recordDeStmt.pos, recordDeStmt.varRef, recordDeStmt.expr.getBType(), recordDeStmt.expr.pos, data);
    }

    @Override
    public void visit(BLangErrorDestructure errorDeStmt, AnalyzerData data) {
        BLangErrorVarRef varRef = errorDeStmt.varRef;
        if (varRef.message != null) {
            if (this.names.fromIdNode(((BLangSimpleVarRef)varRef.message).variableName) != Names.IGNORE) {
                this.setTypeOfVarRefInErrorBindingAssignment(varRef.message, data);
                this.checkInvalidTypeDef(varRef.message);
            } else {
                varRef.message.setBType(this.symTable.noType);
            }
        }
        if (varRef.cause != null) {
            if (varRef.cause.getKind() != NodeKind.SIMPLE_VARIABLE_REF || this.names.fromIdNode(((BLangSimpleVarRef)varRef.cause).variableName) != Names.IGNORE) {
                this.setTypeOfVarRefInErrorBindingAssignment(varRef.cause, data);
                this.checkInvalidTypeDef(varRef.cause);
            } else {
                varRef.cause.setBType(this.symTable.noType);
            }
        }
        this.typeChecker.checkExpr(errorDeStmt.expr, data.env, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        this.checkErrorVarRefEquivalency(varRef, errorDeStmt.expr.getBType(), errorDeStmt.expr.pos, data);
    }

    private void checkRecordVarRefEquivalency(Location pos, BLangRecordVarRef lhsVarRef, BType rhsType, Location rhsPos, AnalyzerData data) {
        rhsType = Types.getImpliedType(rhsType);
        if (rhsType.tag == 16) {
            for (BLangRecordVarRef.BLangRecordVarRefKeyValue field2 : lhsVarRef.recordRefFields) {
                this.dlog.error(field2.variableName.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
            }
            return;
        }
        if (rhsType.tag != 12) {
            this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, "record type", rhsType);
            return;
        }
        BRecordType rhsRecordType = (BRecordType)rhsType;
        ArrayList<String> mappedFields = new ArrayList<String>();
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue lhsField : lhsVarRef.recordRefFields) {
            if (!rhsRecordType.fields.containsKey(lhsField.variableName.value)) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, lhsField.variableName.value, rhsType);
            } else if (Symbols.isOptional(((BField)rhsRecordType.fields.get((Object)lhsField.variableName.value)).symbol)) {
                this.dlog.error(lhsField.variableName.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
            }
            mappedFields.add(lhsField.variableName.value);
        }
        for (BField rhsField : rhsRecordType.fields.values()) {
            List<BLangRecordVarRef.BLangRecordVarRefKeyValue> expField = lhsVarRef.recordRefFields.stream().filter(field -> field.variableName.value.equals(rhsField.name.toString())).toList();
            if (expField.isEmpty()) continue;
            if (expField.size() > 1) {
                this.dlog.error(pos, DiagnosticErrorCode.MULTIPLE_RECORD_REF_PATTERN_FOUND, rhsField.name);
                return;
            }
            BLangExpression variableReference = expField.get((int)0).variableReference;
            if (variableReference.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                this.checkRecordVarRefEquivalency(variableReference.pos, (BLangRecordVarRef)variableReference, rhsField.type, rhsPos, data);
                continue;
            }
            if (variableReference.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                this.checkTupleVarRefEquivalency(pos, (BLangTupleVarRef)variableReference, rhsField.type, rhsPos, data);
                continue;
            }
            if (variableReference.getKind() == NodeKind.ERROR_VARIABLE_REF) {
                this.checkErrorVarRefEquivalency((BLangErrorVarRef)variableReference, rhsField.type, rhsPos, data);
                continue;
            }
            if (variableReference.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                Name varName = this.names.fromIdNode(((BLangSimpleVarRef)variableReference).variableName);
                if (varName == Names.IGNORE) continue;
                this.resetTypeNarrowing(variableReference, data);
                this.types.checkType(variableReference.pos, rhsField.type, variableReference.getBType(), (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                continue;
            }
            this.dlog.error(variableReference.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, variableReference);
        }
        if (lhsVarRef.restParam != null) {
            BLangSimpleVarRef varRefRest = (BLangSimpleVarRef)lhsVarRef.restParam;
            BType lhsRefType = Types.getImpliedType((BType)varRefRest.getBType()).tag == 12 ? varRefRest.getBType() : lhsVarRef.restParam.getBType();
            BType rhsRestConstraint = rhsRecordType.restFieldType == this.symTable.noType ? this.symTable.neverType : rhsRecordType.restFieldType;
            BRecordType rhsResType = this.symbolEnter.createRecordTypeForRestField(pos, data.env, rhsRecordType, mappedFields, rhsRestConstraint);
            this.types.checkType(lhsVarRef.restParam.pos, (BType)rhsResType, lhsRefType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        }
    }

    private void checkArrayVarRefEquivalency(Location pos, BLangTupleVarRef target, BType source, Location rhsPos, AnalyzerData data) {
        BArrayType arraySource = (BArrayType)source;
        if (arraySource.getSize() < target.expressions.size() && arraySource.state != BArrayState.OPEN) {
            this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), arraySource);
        }
        BType souceElementType = arraySource.eType;
        for (BLangExpression expression : target.expressions) {
            if (NodeKind.RECORD_VARIABLE_REF == expression.getKind()) {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expression;
                this.checkRecordVarRefEquivalency(pos, recordVarRef, souceElementType, rhsPos, data);
                continue;
            }
            if (NodeKind.TUPLE_VARIABLE_REF == expression.getKind()) {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expression;
                this.checkTupleVarRefEquivalency(pos, tupleVarRef, souceElementType, rhsPos, data);
                continue;
            }
            if (NodeKind.ERROR_VARIABLE_REF == expression.getKind()) {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expression;
                this.checkErrorVarRefEquivalency(errorVarRef, souceElementType, rhsPos, data);
                continue;
            }
            if (expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)expression;
                Name varName = this.names.fromIdNode(simpleVarRef.variableName);
                if (varName == Names.IGNORE) continue;
                this.resetTypeNarrowing(simpleVarRef, data);
                BType targetType = simpleVarRef.getBType();
                if (this.types.isAssignable(souceElementType, targetType)) continue;
                this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), arraySource);
                break;
            }
            this.dlog.error(expression.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, expression);
        }
    }

    private void checkTupleVarRefEquivalency(Location pos, BLangTupleVarRef target, BType source, Location rhsPos, AnalyzerData data) {
        source = Types.getImpliedType(source);
        if (source.tag == 20) {
            this.checkArrayVarRefEquivalency(pos, target, source, rhsPos, data);
            return;
        }
        if (source.tag != 31) {
            this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), source);
            return;
        }
        if (target.restParam == null) {
            if (((BTupleType)source).restType != null) {
                this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), source);
                return;
            }
            if (((BTupleType)source).getMembers().size() != target.expressions.size()) {
                this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), source);
                return;
            }
        }
        ArrayList<BType> sourceTypes = new ArrayList<BType>(((BTupleType)source).getTupleTypes());
        if (((BTupleType)source).restType != null) {
            BType type = ((BTupleType)source).restType;
            sourceTypes.add(type);
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            BLangExpression varRefExpr = target.expressions.size() > i ? target.expressions.get(i) : target.restParam;
            BType sourceType = (BType)sourceTypes.get(i);
            if (NodeKind.RECORD_VARIABLE_REF == varRefExpr.getKind()) {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)varRefExpr;
                this.checkRecordVarRefEquivalency(pos, recordVarRef, sourceType, rhsPos, data);
                continue;
            }
            if (NodeKind.TUPLE_VARIABLE_REF == varRefExpr.getKind()) {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)varRefExpr;
                this.checkTupleVarRefEquivalency(pos, tupleVarRef, sourceType, rhsPos, data);
                continue;
            }
            if (NodeKind.ERROR_VARIABLE_REF == varRefExpr.getKind()) {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)varRefExpr;
                this.checkErrorVarRefEquivalency(errorVarRef, sourceType, rhsPos, data);
                continue;
            }
            if (varRefExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BType targetType;
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRefExpr;
                Name varName = this.names.fromIdNode(simpleVarRef.variableName);
                if (varName == Names.IGNORE) continue;
                this.resetTypeNarrowing(simpleVarRef, data);
                if (target.expressions.size() > i) {
                    targetType = varRefExpr.getBType();
                } else {
                    BType varRefExprType = Types.getImpliedType(varRefExpr.getBType());
                    targetType = varRefExprType.tag == 20 ? ((BArrayType)varRefExprType).eType : varRefExprType;
                }
                if (this.types.isAssignable(sourceType, targetType)) continue;
                this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, target.getBType(), source);
                break;
            }
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, varRefExpr);
        }
    }

    private void checkErrorVarRefEquivalency(BLangErrorVarRef lhsRef, BType rhsType, Location rhsPos, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        if (Types.getImpliedType((BType)rhsType).tag != 29) {
            this.dlog.error(rhsPos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.errorType, rhsType);
            return;
        }
        this.typeChecker.checkExpr((BLangExpression)lhsRef, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        if (lhsRef.getBType() == this.symTable.semanticError) {
            return;
        }
        BErrorType rhsErrorType = (BErrorType)Types.getImpliedType(rhsType);
        BType refType = Types.getImpliedType(rhsErrorType.detailType);
        if (refType.tag != 12 && refType.tag != 16) {
            return;
        }
        BRecordType rhsDetailType = this.symbolEnter.getDetailAsARecordType(rhsErrorType);
        LinkedHashMap fields = rhsDetailType.fields;
        BType wideType = this.interpolateWideType(rhsDetailType, lhsRef.detail);
        for (BLangNamedArgsExpression detailItem : lhsRef.detail) {
            BField matchedDetailItem = (BField)fields.get(detailItem.name.value);
            if (matchedDetailItem == null) {
                if (rhsDetailType.sealed) {
                    this.dlog.error(detailItem.pos, DiagnosticErrorCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, detailItem.name);
                    return;
                }
                this.dlog.error(detailItem.pos, DiagnosticErrorCode.CANNOT_BIND_UNDEFINED_ERROR_DETAIL_FIELD, detailItem.name.value);
                continue;
            }
            detailItem.varSymbol = matchedDetailItem.symbol;
            if (Symbols.isOptional(matchedDetailItem.symbol)) {
                this.dlog.error(detailItem.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
                continue;
            }
            BType matchedType = matchedDetailItem.type;
            this.checkErrorDetailRefItem(detailItem.pos, rhsPos, detailItem, matchedType, data);
            this.resetTypeNarrowing(detailItem.expr, data);
            if (this.types.isAssignable(matchedType, detailItem.expr.getBType())) continue;
            this.dlog.error(detailItem.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, detailItem.expr.getBType(), matchedType);
        }
        if (lhsRef.restVar != null && !this.isIgnoreVar(lhsRef)) {
            this.setTypeOfVarRefInErrorBindingAssignment(lhsRef.restVar, data);
            this.checkInvalidTypeDef(lhsRef.restVar);
            BMapType expRestType = new BMapType(this.typeEnv, 16, wideType, null);
            BType restVarType = Types.getImpliedType(lhsRef.restVar.getBType());
            if (restVarType.tag != 16 || !this.types.isAssignable(wideType, ((BMapType)restVarType).constraint)) {
                this.dlog.error(lhsRef.restVar.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, lhsRef.restVar.getBType(), expRestType);
                return;
            }
            this.resetTypeNarrowing(lhsRef.restVar, data);
            this.typeChecker.checkExpr((BLangExpression)lhsRef.restVar, currentEnv, data.prevEnvs, data.commonAnalyzerData);
        }
    }

    private BType interpolateWideType(BRecordType rhsDetailType, List<BLangNamedArgsExpression> detailType) {
        Set extractedKeys = detailType.stream().map(detail -> detail.name.value).collect(Collectors.toSet());
        BUnionType wideType = BUnionType.create(this.typeEnv, null, new BType[0]);
        for (BField field : rhsDetailType.fields.values()) {
            if (extractedKeys.contains(field.name.value)) continue;
            wideType.add(field.type);
        }
        if (!rhsDetailType.sealed) {
            wideType.add(rhsDetailType.restFieldType);
        }
        return wideType;
    }

    private boolean isIgnoreVar(BLangErrorVarRef lhsRef) {
        if (lhsRef.restVar != null && lhsRef.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)lhsRef.restVar).variableName.value.equals(Names.IGNORE.value);
        }
        return false;
    }

    private void checkErrorDetailRefItem(Location location, Location rhsLocation, BLangNamedArgsExpression detailItem, BType expectedType, AnalyzerData data) {
        if (detailItem.expr.getKind() == NodeKind.RECORD_VARIABLE_REF) {
            this.typeChecker.checkExpr(detailItem.expr, data.env, data.prevEnvs, data.commonAnalyzerData);
            this.checkRecordVarRefEquivalency(location, (BLangRecordVarRef)detailItem.expr, expectedType, rhsLocation, data);
            return;
        }
        if (detailItem.getKind() == NodeKind.SIMPLE_VARIABLE_REF && detailItem.name.value.equals(Names.IGNORE.value)) {
            return;
        }
        this.setTypeOfVarRefInErrorBindingAssignment(detailItem.expr, data);
        this.checkInvalidTypeDef(detailItem.expr);
    }

    private void checkConstantAssignment(BLangExpression varRef, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        if (varRef.getBType() == this.symTable.semanticError) {
            return;
        }
        if (varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return;
        }
        BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRef;
        if (simpleVarRef.pkgSymbol != null && simpleVarRef.pkgSymbol.tag == 8193L) {
            this.dlog.error(varRef.pos, DiagnosticErrorCode.XML_QNAME_UPDATE_NOT_ALLOWED, new Object[0]);
            return;
        }
        Name varName = this.names.fromIdNode(simpleVarRef.variableName);
        if (!Names.IGNORE.equals(varName) && currentEnv.enclInvokable != currentEnv.enclPkg.initFunction) {
            if ((simpleVarRef.symbol.flags & 4L) == 4L) {
                if ((simpleVarRef.symbol.flags & 0x40000L) == 262144L) {
                    this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, Names.SERVICE);
                } else if ((simpleVarRef.symbol.flags & 0x80000L) == 524288L) {
                    this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, LISTENER_NAME);
                }
            } else if ((simpleVarRef.symbol.flags & 0x4000L) == 16384L) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.CANNOT_ASSIGN_VALUE_TO_CONSTANT, new Object[0]);
            } else if ((simpleVarRef.symbol.flags & 0x40L) == 64L) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.CANNOT_ASSIGN_VALUE_FUNCTION_ARGUMENT, varRef);
            }
        }
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        SymbolEnv stmtEnv = new SymbolEnv(exprStmtNode, currentEnv.scope);
        currentEnv.copyTo(stmtEnv);
        BLangExpression expr = exprStmtNode.expr;
        BType bType = data.typeChecker.checkExpr(expr, stmtEnv, data.prevEnvs, data.commonAnalyzerData);
        if (!this.types.isAssignable(bType, this.symTable.nilType) && bType != this.symTable.semanticError && expr.getKind() != NodeKind.FAIL && !this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(bType)) {
            this.dlog.error(exprStmtNode.pos, DiagnosticErrorCode.ASSIGNMENT_REQUIRED, bType);
        } else if (expr.getKind() == NodeKind.INVOCATION && this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(expr.getBType())) {
            data.notCompletedNormally = true;
        }
        this.validateWorkerAnnAttachments(exprStmtNode.expr, data);
    }

    @Override
    public void visit(BLangIf ifNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        data.typeChecker.checkExpr(ifNode.expr, currentEnv, this.symTable.booleanType, data.prevEnvs, data.commonAnalyzerData);
        BType actualType = ifNode.expr.getBType();
        if (31 == Types.getImpliedType((BType)actualType).tag) {
            this.dlog.error(ifNode.expr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        Map<BVarSymbol, BType.NarrowedTypes> prevNarrowedTypeInfo = data.narrowedTypeInfo;
        HashMap<BVarSymbol, BType.NarrowedTypes> falseTypesOfNarrowedTypes = new HashMap<BVarSymbol, BType.NarrowedTypes>();
        SymbolEnv ifEnv = this.typeNarrower.evaluateTruth(ifNode.expr, ifNode.body, currentEnv);
        data.narrowedTypeInfo = new HashMap<BVarSymbol, BType.NarrowedTypes>();
        data.env = ifEnv;
        this.analyzeStmt(ifNode.body, data);
        if (ifNode.expr.narrowedTypeInfo == null || ifNode.expr.narrowedTypeInfo.isEmpty()) {
            ifNode.expr.narrowedTypeInfo = data.narrowedTypeInfo;
        } else {
            Map<BVarSymbol, BType.NarrowedTypes> existingNarrowedTypeInfo = ifNode.expr.narrowedTypeInfo;
            for (Map.Entry<BVarSymbol, BType.NarrowedTypes> entry : data.narrowedTypeInfo.entrySet()) {
                BVarSymbol key = entry.getKey();
                if (!existingNarrowedTypeInfo.containsKey(key)) continue;
                BType.NarrowedTypes existingNarrowTypes = existingNarrowedTypeInfo.get(key);
                BUnionType unionType = BUnionType.create(this.typeEnv, null, existingNarrowTypes.trueType, existingNarrowTypes.falseType);
                BType.NarrowedTypes newPair = new BType.NarrowedTypes(existingNarrowTypes.trueType, unionType);
                falseTypesOfNarrowedTypes.put(key, newPair);
            }
        }
        if (prevNarrowedTypeInfo != null) {
            prevNarrowedTypeInfo.putAll(data.narrowedTypeInfo);
        }
        if (ifNode.elseStmt != null) {
            boolean ifCompletionStatus = data.notCompletedNormally;
            this.resetNotCompletedNormally(data);
            SymbolEnv elseEnv = this.typeNarrower.evaluateFalsity(ifNode.expr, ifNode.elseStmt, currentEnv, false);
            BLangStatement elseStmt = ifNode.elseStmt;
            data.env = elseEnv;
            this.analyzeStmt(elseStmt, data);
            if (elseStmt.getKind() == NodeKind.IF) {
                data.notCompletedNormally = ifCompletionStatus && data.notCompletedNormally;
            }
        }
        data.narrowedTypeInfo = prevNarrowedTypeInfo;
        if (data.narrowedTypeInfo != null) {
            data.narrowedTypeInfo.putAll(falseTypesOfNarrowedTypes);
        }
    }

    private void resetNotCompletedNormally(AnalyzerData data) {
        data.notCompletedNormally = false;
    }

    @Override
    public void visit(BLangMatchStatement matchStatement, AnalyzerData data) {
        boolean onFailExists;
        this.typeChecker.checkExpr(matchStatement.expr, data.env, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        List<BLangMatchClause> matchClauses = matchStatement.matchClauses;
        if (matchClauses.isEmpty()) {
            return;
        }
        boolean bl = onFailExists = matchStatement.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        this.analyzeNode((BLangNode)matchClauses.get(0), data);
        SymbolEnv matchClauseEnv = data.env;
        for (int i = 1; i < matchClauses.size(); ++i) {
            BLangMatchClause prevMatchClause = matchClauses.get(i - 1);
            BLangMatchClause currentMatchClause = matchClauses.get(i);
            data.env = matchClauseEnv = this.typeNarrower.evaluateTruth(matchStatement.expr, prevMatchClause.patternsType, currentMatchClause, matchClauseEnv);
            this.analyzeNode((BLangNode)currentMatchClause, data);
        }
        if (onFailExists) {
            this.analyzeNode((BLangNode)matchStatement.onFailClause, data);
        }
    }

    @Override
    public void visit(BLangMatchClause matchClause, AnalyzerData data) {
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        if (matchPatterns.isEmpty()) {
            return;
        }
        SymbolEnv currentEnv = data.env;
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(matchClause.blockStmt, currentEnv);
        Map<String, BVarSymbol> clauseVariables = matchClause.declaredVars;
        for (BLangMatchPattern matchPattern : matchPatterns) {
            data.env = SymbolEnv.createPatternEnv(matchPattern, currentEnv);
            this.analyzeNode((BLangNode)matchPattern, data);
            this.resolveMatchClauseVariableTypes(matchPattern, clauseVariables, blockEnv);
            if (matchPattern.getKind() == NodeKind.CONST_MATCH_PATTERN) continue;
            if (matchClause.patternsType == null) {
                matchClause.patternsType = matchPattern.getBType();
                continue;
            }
            matchClause.patternsType = this.types.mergeTypes(matchClause.patternsType, matchPattern.getBType());
        }
        BLangMatchGuard matchGuard = matchClause.matchGuard;
        if (matchGuard != null) {
            data.env = blockEnv;
            this.analyzeNode((BLangNode)matchGuard, data);
            blockEnv = this.typeNarrower.evaluateTruth(matchGuard.expr, matchClause.blockStmt, blockEnv);
            for (Map.Entry<BVarSymbol, BType.NarrowedTypes> entry : matchGuard.expr.narrowedTypeInfo.entrySet()) {
                if (entry.getValue().trueType != this.symTable.semanticError) continue;
                this.dlog.warning(matchClause.pos, DiagnosticWarningCode.MATCH_STMT_UNMATCHED_PATTERN, new Object[0]);
            }
            this.evaluatePatternsTypeAccordingToMatchGuard(matchClause, matchGuard.expr, blockEnv);
        }
        data.env = blockEnv;
        this.analyzeStmt(matchClause.blockStmt, data);
    }

    private void resolveMatchClauseVariableTypes(BLangMatchPattern matchPattern, Map<String, BVarSymbol> clauseVariables, SymbolEnv env) {
        Map<String, BVarSymbol> patternVariables = matchPattern.declaredVars;
        for (String patternVariableName : patternVariables.keySet()) {
            BVarSymbol patternVariableSymbol = patternVariables.get(patternVariableName);
            if (!clauseVariables.containsKey(patternVariableName)) {
                BVarSymbol clauseVarSymbol = this.symbolEnter.defineVarSymbol(patternVariableSymbol.pos, patternVariableSymbol.getFlags(), patternVariableSymbol.type, patternVariableSymbol.name, env, false);
                clauseVariables.put(patternVariableName, clauseVarSymbol);
                continue;
            }
            BVarSymbol clauseVariableSymbol = clauseVariables.get(patternVariableName);
            clauseVariableSymbol.type = this.types.mergeTypes(clauseVariableSymbol.type, patternVariableSymbol.type);
        }
    }

    private void evaluatePatternsTypeAccordingToMatchGuard(BLangMatchClause matchClause, BLangExpression matchGuardExpr, SymbolEnv env) {
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        if (matchGuardExpr.getKind() != NodeKind.TYPE_TEST_EXPR && matchGuardExpr.getKind() != NodeKind.BINARY_EXPR) {
            return;
        }
        this.evaluateMatchPatternsTypeAccordingToMatchGuard(matchPatterns.get(0), env);
        BType clauseType = matchPatterns.get(0).getBType();
        for (int i = 1; i < matchPatterns.size(); ++i) {
            this.evaluateMatchPatternsTypeAccordingToMatchGuard(matchPatterns.get(i), env);
            clauseType = this.types.mergeTypes(matchPatterns.get(i).getBType(), clauseType);
        }
        matchClause.patternsType = clauseType;
    }

    private void evaluateBindingPatternsTypeAccordingToMatchGuard(BLangBindingPattern bindingPattern, SymbolEnv env) {
        NodeKind bindingPatternKind = bindingPattern.getKind();
        switch (bindingPatternKind) {
            case CAPTURE_BINDING_PATTERN: {
                BLangCaptureBindingPattern captureBindingPattern = (BLangCaptureBindingPattern)bindingPattern;
                Name varName = new Name(captureBindingPattern.getIdentifier().getValue());
                if (!env.scope.entries.containsKey(varName)) break;
                captureBindingPattern.setBType(env.scope.entries.get((Object)varName).symbol.type);
                break;
            }
        }
    }

    private void evaluateMatchPatternsTypeAccordingToMatchGuard(BLangMatchPattern matchPattern, SymbolEnv env) {
        NodeKind patternKind = matchPattern.getKind();
        switch (patternKind) {
            case VAR_BINDING_PATTERN_MATCH_PATTERN: {
                BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern = (BLangVarBindingPatternMatchPattern)matchPattern;
                BLangBindingPattern bindingPattern = varBindingPatternMatchPattern.getBindingPattern();
                this.evaluateBindingPatternsTypeAccordingToMatchGuard(bindingPattern, env);
                varBindingPatternMatchPattern.setBType(bindingPattern.getBType());
                break;
            }
            case LIST_MATCH_PATTERN: {
                BLangListMatchPattern listMatchPattern = (BLangListMatchPattern)matchPattern;
                ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                for (BLangMatchPattern memberMatchPattern : listMatchPattern.matchPatterns) {
                    this.evaluateMatchPatternsTypeAccordingToMatchGuard(memberMatchPattern, env);
                    BType type = memberMatchPattern.getBType();
                    BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
                    members.add(new BTupleMember(type, varSymbol));
                }
                BTupleType matchPatternType = new BTupleType(this.typeEnv, members);
                if (listMatchPattern.restMatchPattern != null) {
                    this.evaluateMatchPatternsTypeAccordingToMatchGuard(listMatchPattern.restMatchPattern, env);
                    BType listRestType = Types.getImpliedType(listMatchPattern.restMatchPattern.getBType());
                    if (listRestType.tag == 31) {
                        BTupleType restTupleType = (BTupleType)listRestType;
                        matchPatternType.getMembers().addAll(restTupleType.getMembers());
                        matchPatternType.restType = restTupleType.restType;
                    } else {
                        matchPatternType.restType = ((BArrayType)listRestType).eType;
                    }
                }
                listMatchPattern.setBType(matchPatternType);
                break;
            }
            case REST_MATCH_PATTERN: {
                BLangRestMatchPattern restMatchPattern = (BLangRestMatchPattern)matchPattern;
                Name varName = new Name(restMatchPattern.variableName.value);
                if (!env.scope.entries.containsKey(varName)) break;
                restMatchPattern.setBType(env.scope.entries.get((Object)varName).symbol.type);
                break;
            }
        }
    }

    @Override
    public void visit(BLangMatchGuard matchGuard, AnalyzerData data) {
        this.typeChecker.checkExpr(matchGuard.expr, data.env, this.symTable.booleanType, data.prevEnvs, data.commonAnalyzerData);
    }

    @Override
    public void visit(BLangMappingMatchPattern mappingMatchPattern, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        BRecordTypeSymbol recordSymbol = this.symbolEnter.createAnonRecordSymbol(currentEnv, mappingMatchPattern.pos);
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BLangFieldMatchPattern fieldMatchPattern : mappingMatchPattern.fieldMatchPatterns) {
            this.analyzeNode((BLangNode)fieldMatchPattern, data);
            Name fieldName = this.names.fromIdNode(fieldMatchPattern.fieldName);
            BVarSymbol fieldSymbol = new BVarSymbol(0L, fieldName, this.names.originalNameFromIdNode(fieldMatchPattern.fieldName), currentEnv.enclPkg.symbol.pkgID, fieldMatchPattern.matchPattern.getBType(), (BSymbol)recordSymbol, fieldMatchPattern.pos, SymbolOrigin.COMPILED_SOURCE);
            BField field = new BField(fieldName, fieldMatchPattern.pos, fieldSymbol);
            fields.put(fieldName.getValue(), field);
            mappingMatchPattern.declaredVars.putAll(fieldMatchPattern.declaredVars);
        }
        BRecordType recordVarType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
        recordVarType.fields = fields;
        recordVarType.restFieldType = this.symTable.anyOrErrorType;
        if (mappingMatchPattern.restMatchPattern != null) {
            BRecordTypeSymbol matchPattenRecordSym = this.symbolEnter.createAnonRecordSymbol(currentEnv, mappingMatchPattern.pos);
            BLangRestMatchPattern restMatchPattern = mappingMatchPattern.restMatchPattern;
            BType restType = restMatchPattern.getBType();
            BRecordType matchPatternRecType = new BRecordType(this.typeEnv, (BTypeSymbol)matchPattenRecordSym);
            recordVarType.restFieldType = matchPatternRecType.restFieldType = restType != null ? restType : this.symTable.anyOrErrorType;
            restMatchPattern.setBType(matchPatternRecType);
            this.analyzeNode((BLangNode)restMatchPattern, data);
            mappingMatchPattern.declaredVars.put(restMatchPattern.variableName.value, restMatchPattern.symbol);
            BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(matchPatternRecType, currentEnv.enclPkg.packageID, this.symTable, mappingMatchPattern.pos);
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(matchPatternRecType, matchPattenRecordSym, recordTypeNode, currentEnv);
        }
        mappingMatchPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(mappingMatchPattern, recordVarType, currentEnv));
        this.assignTypesToMemberPatterns(mappingMatchPattern, mappingMatchPattern.getBType(), data);
    }

    private void assignTypesToMemberPatterns(BLangMatchPattern matchPattern, BType bType, AnalyzerData data) {
        BType patternType = Types.getImpliedType(bType);
        NodeKind matchPatternKind = matchPattern.getKind();
        switch (matchPatternKind) {
            case WILDCARD_MATCH_PATTERN: 
            case CONST_MATCH_PATTERN: {
                return;
            }
            case VAR_BINDING_PATTERN_MATCH_PATTERN: {
                BLangBindingPattern bindingPattern = ((BLangVarBindingPatternMatchPattern)matchPattern).getBindingPattern();
                this.assignTypesToMemberPatterns(bindingPattern, patternType, data);
                matchPattern.setBType(bindingPattern.getBType());
                return;
            }
            case LIST_MATCH_PATTERN: {
                BLangListMatchPattern listMatchPattern = (BLangListMatchPattern)matchPattern;
                if (patternType.tag == 21) {
                    for (BType type : ((BUnionType)patternType).getMemberTypes()) {
                        this.assignTypesToMemberPatterns(listMatchPattern, type, data);
                    }
                    listMatchPattern.setBType(patternType);
                    return;
                }
                if (patternType.tag == 20) {
                    BArrayType arrayType = (BArrayType)patternType;
                    for (BLangMatchPattern memberPattern : listMatchPattern.matchPatterns) {
                        this.assignTypesToMemberPatterns(memberPattern, arrayType.eType, data);
                    }
                    if (listMatchPattern.restMatchPattern == null) {
                        return;
                    }
                    if (arrayType.state == BArrayState.CLOSED) {
                        BType type = arrayType.eType;
                        BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(type);
                        BTupleType restTupleType = this.createTupleForClosedArray(arrayType.getSize() - listMatchPattern.matchPatterns.size(), new BTupleMember(type, varSymbol));
                        listMatchPattern.restMatchPattern.setBType(restTupleType);
                        BVarSymbol restMatchPatternSymbol = (BVarSymbol)listMatchPattern.restMatchPattern.declaredVars.get(listMatchPattern.restMatchPattern.getIdentifier().getValue());
                        restMatchPatternSymbol.type = restTupleType;
                        return;
                    }
                    BLangRestMatchPattern restMatchPattern = listMatchPattern.restMatchPattern;
                    BType restType = ((BArrayType)restMatchPattern.getBType()).eType;
                    ((BArrayType)restMatchPattern.getBType()).eType = restType = this.types.mergeTypes(restType, arrayType.eType);
                    return;
                }
                if (patternType.tag != 31) {
                    return;
                }
                BTupleType patternTupleType = (BTupleType)patternType;
                List<BTupleMember> members = patternTupleType.getMembers();
                List<BLangMatchPattern> matchPatterns = listMatchPattern.matchPatterns;
                ArrayList<BTupleMember> newMembers = new ArrayList<BTupleMember>();
                for (int i = 0; i < matchPatterns.size(); ++i) {
                    this.assignTypesToMemberPatterns(matchPatterns.get(i), members.get((int)i).type, data);
                    BType type = matchPatterns.get(i).getBType();
                    BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
                    newMembers.add(new BTupleMember(type, varSymbol));
                }
                BTupleType tupleType = new BTupleType(this.typeEnv, newMembers);
                if (listMatchPattern.restMatchPattern == null) {
                    listMatchPattern.setBType(tupleType);
                    return;
                }
                tupleType.restType = this.createTypeForTupleRestType(matchPatterns.size(), members, patternTupleType.restType);
                listMatchPattern.restMatchPattern.setBType(tupleType.restType);
                matchPattern.setBType(patternType);
                BVarSymbol restMatchPatternSymbol = (BVarSymbol)listMatchPattern.restMatchPattern.declaredVars.get(listMatchPattern.restMatchPattern.getIdentifier().getValue());
                restMatchPatternSymbol.type = tupleType.restType;
                return;
            }
            case MAPPING_MATCH_PATTERN: {
                BLangMappingMatchPattern mappingMatchPattern = (BLangMappingMatchPattern)matchPattern;
                if (patternType.tag == 21) {
                    for (BType type : ((BUnionType)patternType).getMemberTypes()) {
                        this.assignTypesToMemberPatterns(mappingMatchPattern, type, data);
                    }
                    return;
                }
                if (patternType.tag != 12) {
                    return;
                }
                BRecordType recordType = (BRecordType)patternType;
                ArrayList<String> boundedFieldNames = new ArrayList<String>();
                for (BLangFieldMatchPattern fieldMatchPattern : mappingMatchPattern.fieldMatchPatterns) {
                    this.assignTypesToMemberPatterns(fieldMatchPattern.matchPattern, ((BField)recordType.fields.get((Object)fieldMatchPattern.fieldName.value)).type, data);
                    boundedFieldNames.add(fieldMatchPattern.fieldName.value);
                }
                if (mappingMatchPattern.restMatchPattern == null) {
                    return;
                }
                BLangRestMatchPattern restMatchPattern = mappingMatchPattern.restMatchPattern;
                BRecordType restPatternRecType = (BRecordType)restMatchPattern.getBType();
                BVarSymbol restVarSymbol = (BVarSymbol)restMatchPattern.declaredVars.get(restMatchPattern.getIdentifier().getValue());
                BType restVarType = Types.getImpliedType(restVarSymbol.type);
                if (restVarType.tag != 12) {
                    return;
                }
                BRecordType restVarSymbolRecordType = (BRecordType)restVarType;
                this.setRestMatchPatternConstraintType(recordType, boundedFieldNames, restPatternRecType, restVarSymbolRecordType, data);
            }
        }
    }

    private BTupleType createTupleForClosedArray(int noOfElements, BTupleMember elementType) {
        List<BTupleMember> members = Collections.nCopies(noOfElements, elementType);
        return new BTupleType(this.typeEnv, members);
    }

    private BType createTypeForTupleRestType(int startIndex, List<BTupleMember> members, BType patternRestType) {
        ArrayList<BTupleMember> remainingMembers = new ArrayList<BTupleMember>();
        for (int i = startIndex; i < members.size(); ++i) {
            remainingMembers.add(members.get(i));
        }
        if (!remainingMembers.isEmpty()) {
            BTupleType restTupleType = new BTupleType(this.typeEnv, remainingMembers);
            if (patternRestType != null) {
                restTupleType.restType = patternRestType;
            }
            return restTupleType;
        }
        if (patternRestType != null) {
            return new BArrayType(this.typeEnv, patternRestType);
        }
        return new BArrayType(this.typeEnv, this.symTable.anyOrErrorType);
    }

    @Override
    public void visit(BLangFieldMatchPattern fieldMatchPattern, AnalyzerData data) {
        BLangMatchPattern matchPattern = fieldMatchPattern.matchPattern;
        matchPattern.accept(this, data);
        fieldMatchPattern.declaredVars.putAll(matchPattern.declaredVars);
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        BLangBindingPattern bindingPattern = varBindingPattern.getBindingPattern();
        NodeKind patternKind = bindingPattern.getKind();
        BType patternType = null;
        if (varBindingPattern.matchExpr != null) {
            patternType = varBindingPattern.matchExpr.getBType();
        }
        switch (patternKind) {
            case WILDCARD_BINDING_PATTERN: {
                BLangWildCardBindingPattern wildCardBindingPattern = (BLangWildCardBindingPattern)bindingPattern;
                wildCardBindingPattern.setBType(patternType);
                this.analyzeNode((BLangNode)wildCardBindingPattern, data);
                varBindingPattern.isLastPattern = this.types.isAssignable(wildCardBindingPattern.getBType(), this.symTable.anyType);
                break;
            }
            case CAPTURE_BINDING_PATTERN: {
                BLangCaptureBindingPattern captureBindingPattern = (BLangCaptureBindingPattern)bindingPattern;
                captureBindingPattern.setBType(varBindingPattern.getBType() == null ? patternType : varBindingPattern.getBType());
                this.analyzeNode((BLangNode)captureBindingPattern, data);
                break;
            }
            case LIST_BINDING_PATTERN: {
                BLangListBindingPattern listBindingPattern = (BLangListBindingPattern)bindingPattern;
                this.analyzeNode((BLangNode)listBindingPattern, data);
                listBindingPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(listBindingPattern, varBindingPattern, currentEnv));
                this.assignTypesToMemberPatterns(listBindingPattern, listBindingPattern.getBType(), data);
                break;
            }
            case ERROR_BINDING_PATTERN: {
                BLangErrorBindingPattern errorBindingPattern = (BLangErrorBindingPattern)bindingPattern;
                this.analyzeNode((BLangNode)errorBindingPattern, data);
                errorBindingPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(errorBindingPattern, varBindingPattern.matchExpr, currentEnv));
                break;
            }
            case MAPPING_BINDING_PATTERN: {
                BLangMappingBindingPattern mappingBindingPattern = (BLangMappingBindingPattern)bindingPattern;
                this.analyzeNode((BLangNode)mappingBindingPattern, data);
                mappingBindingPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(mappingBindingPattern, varBindingPattern, currentEnv));
                this.assignTypesToMemberPatterns(mappingBindingPattern, mappingBindingPattern.getBType(), data);
                break;
            }
        }
        varBindingPattern.declaredVars.putAll(bindingPattern.declaredVars);
        varBindingPattern.setBType(bindingPattern.getBType());
    }

    @Override
    public void visit(BLangWildCardBindingPattern wildCardBindingPattern, AnalyzerData data) {
        if (wildCardBindingPattern.getBType() == null) {
            wildCardBindingPattern.setBType(this.symTable.anyType);
            return;
        }
        BType bindingPatternType = wildCardBindingPattern.getBType();
        BType intersectionType = this.types.getTypeIntersection(Types.IntersectionContext.compilerInternalIntersectionContext(), bindingPatternType, this.symTable.anyType, data.env);
        if (intersectionType == this.symTable.semanticError) {
            wildCardBindingPattern.setBType(this.symTable.noType);
            return;
        }
        wildCardBindingPattern.setBType(intersectionType);
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern, AnalyzerData data) {
        BLangIdentifier id = (BLangIdentifier)captureBindingPattern.getIdentifier();
        Name name = new Name(id.getValue());
        Name origName = new Name(id.originalValue);
        captureBindingPattern.setBType(captureBindingPattern.getBType() == null ? this.symTable.anyOrErrorType : captureBindingPattern.getBType());
        captureBindingPattern.symbol = this.symbolEnter.defineVarSymbol(captureBindingPattern.getIdentifier().getPosition(), Flags.unMask(0L), captureBindingPattern.getBType(), name, origName, data.env, false);
        captureBindingPattern.declaredVars.put(name.value, captureBindingPattern.symbol);
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern, AnalyzerData data) {
        ArrayList<BTupleMember> listMembers = new ArrayList<BTupleMember>();
        for (BLangBindingPattern bindingPattern : listBindingPattern.bindingPatterns) {
            this.analyzeNode((BLangNode)bindingPattern, data);
            BType type = bindingPattern.getBType();
            BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
            listMembers.add(new BTupleMember(type, varSymbol));
            listBindingPattern.declaredVars.putAll(bindingPattern.declaredVars);
        }
        BTupleType listBindingPatternType = new BTupleType(this.typeEnv, listMembers);
        if (listBindingPattern.restBindingPattern != null) {
            BLangRestBindingPattern restBindingPattern = listBindingPattern.restBindingPattern;
            BType restBindingPatternType = restBindingPattern.getBType();
            BType restType = restBindingPatternType != null ? restBindingPatternType : this.symTable.anyOrErrorType;
            restBindingPattern.setBType(new BArrayType(this.typeEnv, restType));
            restBindingPattern.accept(this, data);
            listBindingPattern.declaredVars.put(restBindingPattern.variableName.value, restBindingPattern.symbol);
            listBindingPatternType.restType = restType;
        }
        listBindingPattern.setBType(listBindingPatternType);
    }

    @Override
    public void visit(BLangRestBindingPattern restBindingPattern, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        Name name = new Name(restBindingPattern.variableName.value);
        Name origName = this.names.originalNameFromIdNode(restBindingPattern.variableName);
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(currentEnv, name);
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = new BVarSymbol(0L, name, origName, currentEnv.enclPkg.packageID, restBindingPattern.getBType(), currentEnv.scope.owner, restBindingPattern.variableName.pos, SymbolOrigin.SOURCE);
            this.symbolEnter.defineSymbol(restBindingPattern.variableName.pos, symbol, currentEnv);
        }
        restBindingPattern.symbol = (BVarSymbol)symbol;
        restBindingPattern.declaredVars.put(name.value, restBindingPattern.symbol);
    }

    @Override
    public void visit(BLangErrorBindingPattern errorBindingPattern, AnalyzerData data) {
        if (errorBindingPattern.errorTypeReference != null) {
            errorBindingPattern.setBType(this.symResolver.resolveTypeNode(errorBindingPattern.errorTypeReference, data.env));
        } else {
            errorBindingPattern.setBType(this.symTable.errorType);
        }
        if (errorBindingPattern.errorMessageBindingPattern != null) {
            this.analyzeNode((BLangNode)errorBindingPattern.errorMessageBindingPattern, data);
            errorBindingPattern.declaredVars.putAll(errorBindingPattern.errorMessageBindingPattern.declaredVars);
        }
        if (errorBindingPattern.errorCauseBindingPattern != null) {
            this.analyzeNode((BLangNode)errorBindingPattern.errorCauseBindingPattern, data);
            errorBindingPattern.declaredVars.putAll(errorBindingPattern.errorCauseBindingPattern.declaredVars);
        }
        if (errorBindingPattern.errorFieldBindingPatterns != null) {
            this.analyzeNode((BLangNode)errorBindingPattern.errorFieldBindingPatterns, data);
            errorBindingPattern.declaredVars.putAll(errorBindingPattern.errorFieldBindingPatterns.declaredVars);
        }
    }

    @Override
    public void visit(BLangSimpleBindingPattern simpleBindingPattern, AnalyzerData data) {
        if (simpleBindingPattern.wildCardBindingPattern != null) {
            this.analyzeNode((BLangNode)simpleBindingPattern.wildCardBindingPattern, data);
            return;
        }
        if (simpleBindingPattern.captureBindingPattern != null) {
            this.analyzeNode((BLangNode)simpleBindingPattern.captureBindingPattern, data);
            simpleBindingPattern.declaredVars.putAll(simpleBindingPattern.captureBindingPattern.declaredVars);
        }
    }

    @Override
    public void visit(BLangErrorMessageBindingPattern errorMessageBindingPattern, AnalyzerData data) {
        BLangSimpleBindingPattern simpleBindingPattern = errorMessageBindingPattern.simpleBindingPattern;
        if (simpleBindingPattern.wildCardBindingPattern != null) {
            simpleBindingPattern.wildCardBindingPattern.setBType(this.symTable.stringType);
        }
        if (simpleBindingPattern.captureBindingPattern != null) {
            simpleBindingPattern.captureBindingPattern.setBType(this.symTable.stringType);
        }
        this.analyzeNode((BLangNode)simpleBindingPattern, data);
        errorMessageBindingPattern.declaredVars.putAll(simpleBindingPattern.declaredVars);
    }

    @Override
    public void visit(BLangErrorCauseBindingPattern errorCauseBindingPattern, AnalyzerData data) {
        if (errorCauseBindingPattern.simpleBindingPattern != null) {
            BLangSimpleBindingPattern simpleBindingPattern = errorCauseBindingPattern.simpleBindingPattern;
            if (simpleBindingPattern.captureBindingPattern != null) {
                simpleBindingPattern.captureBindingPattern.setBType(this.symTable.errorOrNilType);
            }
            this.analyzeNode((BLangNode)simpleBindingPattern, data);
            errorCauseBindingPattern.declaredVars.putAll(simpleBindingPattern.declaredVars);
            return;
        }
        if (errorCauseBindingPattern.errorBindingPattern != null) {
            this.analyzeNode((BLangNode)errorCauseBindingPattern.errorBindingPattern, data);
            errorCauseBindingPattern.declaredVars.putAll(errorCauseBindingPattern.errorBindingPattern.declaredVars);
        }
    }

    @Override
    public void visit(BLangErrorFieldBindingPatterns errorFieldBindingPatterns, AnalyzerData data) {
        for (BLangNamedArgBindingPattern namedArgBindingPattern : errorFieldBindingPatterns.namedArgBindingPatterns) {
            this.analyzeNode((BLangNode)namedArgBindingPattern, data);
            errorFieldBindingPatterns.declaredVars.putAll(namedArgBindingPattern.declaredVars);
        }
        if (errorFieldBindingPatterns.restBindingPattern != null) {
            errorFieldBindingPatterns.restBindingPattern.setBType(new BMapType(this.typeEnv, 16, this.symTable.anydataType, null));
            this.analyzeNode((BLangNode)errorFieldBindingPatterns.restBindingPattern, data);
            errorFieldBindingPatterns.declaredVars.putAll(errorFieldBindingPatterns.restBindingPattern.declaredVars);
        }
    }

    @Override
    public void visit(BLangNamedArgBindingPattern namedArgBindingPattern, AnalyzerData data) {
        this.setNamedArgBindingPatternType(namedArgBindingPattern.bindingPattern);
        this.analyzeNode((BLangNode)namedArgBindingPattern.bindingPattern, data);
        namedArgBindingPattern.declaredVars.putAll(namedArgBindingPattern.bindingPattern.declaredVars);
    }

    private void setNamedArgBindingPatternType(BLangBindingPattern bindingPattern) {
        switch (bindingPattern.getKind()) {
            case LIST_BINDING_PATTERN: {
                BLangListBindingPattern listBindingPattern = (BLangListBindingPattern)bindingPattern;
                listBindingPattern.bindingPatterns.forEach(pattern -> pattern.setBType(this.symTable.cloneableType));
                if (listBindingPattern.restBindingPattern == null) break;
                listBindingPattern.restBindingPattern.setBType(this.symTable.cloneableType);
                break;
            }
            case MAPPING_BINDING_PATTERN: {
                BLangMappingBindingPattern mappingBindingPattern = (BLangMappingBindingPattern)bindingPattern;
                mappingBindingPattern.fieldBindingPatterns.forEach(pattern -> pattern.bindingPattern.setBType(this.symTable.cloneableType));
                if (mappingBindingPattern.restBindingPattern == null) break;
                mappingBindingPattern.restBindingPattern.setBType(this.symTable.cloneableType);
                break;
            }
            case CAPTURE_BINDING_PATTERN: {
                BLangCaptureBindingPattern captureBindingPattern = (BLangCaptureBindingPattern)bindingPattern;
                captureBindingPattern.setBType(this.symTable.cloneableType);
            }
        }
    }

    @Override
    public void visit(BLangErrorMatchPattern errorMatchPattern, AnalyzerData data) {
        if (errorMatchPattern.errorTypeReference != null) {
            errorMatchPattern.setBType(this.symResolver.resolveTypeNode(errorMatchPattern.errorTypeReference, data.env));
        } else {
            errorMatchPattern.setBType(this.symTable.errorType);
        }
        errorMatchPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(errorMatchPattern, errorMatchPattern.matchExpr));
        if (errorMatchPattern.errorMessageMatchPattern != null) {
            this.analyzeNode((BLangNode)errorMatchPattern.errorMessageMatchPattern, data);
            errorMatchPattern.declaredVars.putAll(errorMatchPattern.errorMessageMatchPattern.declaredVars);
        }
        if (errorMatchPattern.errorCauseMatchPattern != null) {
            this.analyzeNode((BLangNode)errorMatchPattern.errorCauseMatchPattern, data);
            errorMatchPattern.declaredVars.putAll(errorMatchPattern.errorCauseMatchPattern.declaredVars);
        }
        if (errorMatchPattern.errorFieldMatchPatterns != null) {
            this.analyzeNode((BLangNode)errorMatchPattern.errorFieldMatchPatterns, data);
            errorMatchPattern.declaredVars.putAll(errorMatchPattern.errorFieldMatchPatterns.declaredVars);
        }
    }

    @Override
    public void visit(BLangSimpleMatchPattern simpleMatchPattern, AnalyzerData data) {
        if (simpleMatchPattern.wildCardMatchPattern != null) {
            this.analyzeNode((BLangNode)simpleMatchPattern.wildCardMatchPattern, data);
            simpleMatchPattern.wildCardMatchPattern.isLastPattern = true;
            return;
        }
        if (simpleMatchPattern.constPattern != null) {
            this.analyzeNode((BLangNode)simpleMatchPattern.constPattern, data);
            return;
        }
        if (simpleMatchPattern.varVariableName != null) {
            this.analyzeNode((BLangNode)simpleMatchPattern.varVariableName, data);
            simpleMatchPattern.declaredVars.putAll(simpleMatchPattern.varVariableName.declaredVars);
        }
    }

    @Override
    public void visit(BLangErrorMessageMatchPattern errorMessageMatchPattern, AnalyzerData data) {
        BLangSimpleMatchPattern simpleMatchPattern = errorMessageMatchPattern.simpleMatchPattern;
        if (simpleMatchPattern.varVariableName != null) {
            simpleMatchPattern.varVariableName.setBType(this.symTable.stringType);
        }
        this.analyzeNode((BLangNode)simpleMatchPattern, data);
        errorMessageMatchPattern.declaredVars.putAll(simpleMatchPattern.declaredVars);
    }

    @Override
    public void visit(BLangErrorCauseMatchPattern errorCauseMatchPattern, AnalyzerData data) {
        if (errorCauseMatchPattern.simpleMatchPattern != null) {
            BLangSimpleMatchPattern simpleMatchPattern = errorCauseMatchPattern.simpleMatchPattern;
            if (simpleMatchPattern.varVariableName != null) {
                simpleMatchPattern.varVariableName.setBType(this.symTable.errorOrNilType);
            }
            this.analyzeNode((BLangNode)simpleMatchPattern, data);
            errorCauseMatchPattern.declaredVars.putAll(simpleMatchPattern.declaredVars);
            return;
        }
        if (errorCauseMatchPattern.errorMatchPattern != null) {
            this.analyzeNode((BLangNode)errorCauseMatchPattern.errorMatchPattern, data);
            errorCauseMatchPattern.declaredVars.putAll(errorCauseMatchPattern.errorMatchPattern.declaredVars);
        }
    }

    @Override
    public void visit(BLangErrorFieldMatchPatterns errorFieldMatchPatterns, AnalyzerData data) {
        for (BLangNamedArgMatchPattern namedArgMatchPattern : errorFieldMatchPatterns.namedArgMatchPatterns) {
            this.analyzeNode((BLangNode)namedArgMatchPattern, data);
            errorFieldMatchPatterns.declaredVars.putAll(namedArgMatchPattern.declaredVars);
        }
        if (errorFieldMatchPatterns.restMatchPattern != null) {
            errorFieldMatchPatterns.restMatchPattern.setBType(new BMapType(this.typeEnv, 16, this.symTable.anydataType, null));
            this.analyzeNode((BLangNode)errorFieldMatchPatterns.restMatchPattern, data);
            errorFieldMatchPatterns.declaredVars.putAll(errorFieldMatchPatterns.restMatchPattern.declaredVars);
        }
    }

    @Override
    public void visit(BLangNamedArgMatchPattern namedArgMatchPattern, AnalyzerData data) {
        this.setNamedArgMatchPatternType(namedArgMatchPattern.matchPattern);
        this.analyzeNode((BLangNode)namedArgMatchPattern.matchPattern, data);
        namedArgMatchPattern.declaredVars.putAll(namedArgMatchPattern.matchPattern.declaredVars);
    }

    private void setNamedArgMatchPatternType(BLangMatchPattern matchPattern) {
        switch (matchPattern.getKind()) {
            case VAR_BINDING_PATTERN_MATCH_PATTERN: 
            case CONST_MATCH_PATTERN: {
                matchPattern.setBType(this.symTable.cloneableType);
                break;
            }
            case LIST_MATCH_PATTERN: {
                BLangListMatchPattern listMatchPattern = (BLangListMatchPattern)matchPattern;
                listMatchPattern.matchPatterns.forEach(pattern -> pattern.setBType(this.symTable.cloneableType));
                if (listMatchPattern.restMatchPattern == null) break;
                listMatchPattern.restMatchPattern.setBType(this.symTable.cloneableType);
                break;
            }
            case MAPPING_MATCH_PATTERN: {
                BLangMappingMatchPattern mappingMatchPattern = (BLangMappingMatchPattern)matchPattern;
                mappingMatchPattern.fieldMatchPatterns.forEach(pattern -> pattern.matchPattern.setBType(this.symTable.cloneableType));
                if (mappingMatchPattern.restMatchPattern == null) break;
                mappingMatchPattern.restMatchPattern.setBType(this.symTable.cloneableType);
            }
        }
    }

    @Override
    public void visit(BLangMappingBindingPattern mappingBindingPattern, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        BRecordTypeSymbol recordSymbol = this.symbolEnter.createAnonRecordSymbol(currentEnv, mappingBindingPattern.pos);
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BLangFieldBindingPattern fieldBindingPattern : mappingBindingPattern.fieldBindingPatterns) {
            fieldBindingPattern.accept(this, data);
            Name fieldName = this.names.fromIdNode(fieldBindingPattern.fieldName);
            BVarSymbol fieldSymbol = new BVarSymbol(0L, fieldName, this.names.originalNameFromIdNode(fieldBindingPattern.fieldName), currentEnv.enclPkg.symbol.pkgID, fieldBindingPattern.bindingPattern.getBType(), (BSymbol)recordSymbol, fieldBindingPattern.pos, SymbolOrigin.COMPILED_SOURCE);
            BField field = new BField(fieldName, fieldBindingPattern.pos, fieldSymbol);
            fields.put(fieldName.getValue(), field);
            mappingBindingPattern.declaredVars.putAll(fieldBindingPattern.declaredVars);
        }
        BRecordType recordVarType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
        recordVarType.fields = fields;
        recordVarType.restFieldType = this.symTable.anyOrErrorType;
        if (mappingBindingPattern.restBindingPattern != null) {
            BLangRestBindingPattern restBindingPattern = mappingBindingPattern.restBindingPattern;
            BType restType = restBindingPattern.getBType();
            BRecordTypeSymbol matchPattenRecordSym = this.symbolEnter.createAnonRecordSymbol(currentEnv, restBindingPattern.pos);
            BRecordType matchPatternRecType = new BRecordType(this.typeEnv, (BTypeSymbol)matchPattenRecordSym);
            recordVarType.restFieldType = matchPatternRecType.restFieldType = restType != null ? restType : this.symTable.anyOrErrorType;
            restBindingPattern.setBType(matchPatternRecType);
            restBindingPattern.accept(this, data);
            mappingBindingPattern.declaredVars.put(restBindingPattern.variableName.value, restBindingPattern.symbol);
            BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(matchPatternRecType, currentEnv.enclPkg.packageID, this.symTable, restBindingPattern.pos);
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(matchPatternRecType, matchPattenRecordSym, recordTypeNode, currentEnv);
        }
        mappingBindingPattern.setBType(recordVarType);
    }

    @Override
    public void visit(BLangFieldBindingPattern fieldBindingPattern, AnalyzerData data) {
        BLangBindingPattern bindingPattern = fieldBindingPattern.bindingPattern;
        bindingPattern.accept(this, data);
        fieldBindingPattern.declaredVars.putAll(bindingPattern.declaredVars);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern, AnalyzerData data) {
        BLangExpression constPatternExpr = constMatchPattern.expr;
        this.typeChecker.checkExpr(constPatternExpr, data.env, data.prevEnvs, data.commonAnalyzerData);
        if (constPatternExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef constRef = (BLangSimpleVarRef)constPatternExpr;
            if (constRef.symbol.kind != SymbolKind.CONSTANT) {
                this.dlog.error(constMatchPattern.pos, DiagnosticErrorCode.VARIABLE_SHOULD_BE_DECLARED_AS_CONSTANT, constRef.variableName);
                constMatchPattern.setBType(this.symTable.noType);
                return;
            }
        }
        constMatchPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(constMatchPattern, constPatternExpr));
    }

    @Override
    public void visit(BLangRestMatchPattern restMatchPattern, AnalyzerData data) {
        Name name = new Name(restMatchPattern.variableName.value);
        Name origName = new Name(restMatchPattern.variableName.originalValue);
        restMatchPattern.symbol = this.symbolEnter.defineVarSymbol(restMatchPattern.variableName.pos, Flags.unMask(0L), restMatchPattern.getBType(), name, origName, data.env, false);
        restMatchPattern.declaredVars.put(name.value, restMatchPattern.symbol);
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern, AnalyzerData data) {
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
        for (BLangMatchPattern memberMatchPattern : listMatchPattern.matchPatterns) {
            memberMatchPattern.accept(this, data);
            BType type = memberMatchPattern.getBType();
            BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
            members.add(new BTupleMember(type, varSymbol));
            this.checkForSimilarVars(listMatchPattern.declaredVars, memberMatchPattern.declaredVars, memberMatchPattern.pos);
            listMatchPattern.declaredVars.putAll(memberMatchPattern.declaredVars);
        }
        BTupleType matchPatternType = new BTupleType(this.typeEnv, members);
        if (listMatchPattern.getRestMatchPattern() != null) {
            BLangRestMatchPattern restMatchPattern = (BLangRestMatchPattern)listMatchPattern.getRestMatchPattern();
            BType restBindingPatternType = restMatchPattern.getBType();
            BType restType = restBindingPatternType != null ? restBindingPatternType : this.symTable.anyOrErrorType;
            restMatchPattern.setBType(new BArrayType(this.typeEnv, restType));
            restMatchPattern.accept(this, data);
            this.checkForSimilarVars(listMatchPattern.declaredVars, restMatchPattern.declaredVars, restMatchPattern.pos);
            listMatchPattern.declaredVars.put(restMatchPattern.variableName.value, restMatchPattern.symbol);
            matchPatternType.restType = restType;
        }
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(data.env.enclPkg.symbol);
        listMatchPattern.setBType(this.types.resolvePatternTypeFromMatchExpr(listMatchPattern, matchPatternType, pkgEnv));
        this.assignTypesToMemberPatterns(listMatchPattern, listMatchPattern.getBType(), data);
    }

    private void checkForSimilarVars(Map<String, BVarSymbol> declaredVars, Map<String, BVarSymbol> var, Location pos) {
        for (String variableName : var.keySet()) {
            if (!declaredVars.containsKey(variableName)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.MATCH_PATTERN_CANNOT_REPEAT_SAME_VARIABLE, new Object[0]);
        }
    }

    private void assignTypesToMemberPatterns(BLangBindingPattern bindingPattern, BType patternType, AnalyzerData data) {
        NodeKind patternKind = bindingPattern.getKind();
        BType bindingPatternType = Types.getImpliedType(patternType);
        switch (patternKind) {
            case WILDCARD_BINDING_PATTERN: {
                return;
            }
            case CAPTURE_BINDING_PATTERN: {
                BLangCaptureBindingPattern captureBindingPattern = (BLangCaptureBindingPattern)bindingPattern;
                BVarSymbol captureBindingPatternSymbol = (BVarSymbol)captureBindingPattern.declaredVars.get(captureBindingPattern.getIdentifier().getValue());
                captureBindingPatternSymbol.type = bindingPatternType.tag == 29 ? bindingPatternType : this.types.mergeTypes(captureBindingPatternSymbol.type, bindingPatternType);
                captureBindingPattern.setBType(captureBindingPatternSymbol.type);
                return;
            }
            case LIST_BINDING_PATTERN: {
                BLangListBindingPattern listBindingPattern = (BLangListBindingPattern)bindingPattern;
                if (bindingPatternType.tag == 21) {
                    for (BType type : ((BUnionType)bindingPatternType).getMemberTypes()) {
                        this.assignTypesToMemberPatterns(bindingPattern, type, data);
                    }
                    listBindingPattern.setBType(bindingPatternType);
                    return;
                }
                if (bindingPatternType.tag == 20) {
                    BArrayType arrayType = (BArrayType)bindingPatternType;
                    for (BLangBindingPattern memberBindingPattern : listBindingPattern.bindingPatterns) {
                        this.assignTypesToMemberPatterns(memberBindingPattern, arrayType.eType, data);
                    }
                    if (listBindingPattern.restBindingPattern == null) {
                        return;
                    }
                    if (arrayType.state == BArrayState.CLOSED) {
                        BType type = arrayType.eType;
                        BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(type);
                        BTupleType restTupleType = this.createTupleForClosedArray(arrayType.getSize() - listBindingPattern.bindingPatterns.size(), new BTupleMember(type, varSymbol));
                        listBindingPattern.restBindingPattern.setBType(restTupleType);
                        BVarSymbol restBindingPatternSymbol = (BVarSymbol)listBindingPattern.restBindingPattern.declaredVars.get(listBindingPattern.restBindingPattern.getIdentifier().getValue());
                        restBindingPatternSymbol.type = restTupleType;
                        return;
                    }
                    BLangRestBindingPattern restBindingPattern = listBindingPattern.restBindingPattern;
                    BType restType = ((BArrayType)restBindingPattern.getBType()).eType;
                    ((BArrayType)restBindingPattern.getBType()).eType = restType = this.types.mergeTypes(restType, arrayType.eType);
                    return;
                }
                if (bindingPatternType.tag != 31) {
                    return;
                }
                BTupleType bindingPatternTupleType = (BTupleType)bindingPatternType;
                List<BTupleMember> tupleMemebers = bindingPatternTupleType.getMembers();
                List<BLangBindingPattern> bindingPatterns = listBindingPattern.bindingPatterns;
                ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                for (int i = 0; i < bindingPatterns.size(); ++i) {
                    this.assignTypesToMemberPatterns(bindingPatterns.get(i), tupleMemebers.get((int)i).type, data);
                    BType type = bindingPatterns.get(i).getBType();
                    BVarSymbol varSymbol = new BVarSymbol(type.getFlags(), null, null, type, null, null, null);
                    members.add(new BTupleMember(type, varSymbol));
                }
                BTupleType tupleType = new BTupleType(this.typeEnv, members);
                if (listBindingPattern.restBindingPattern == null) {
                    bindingPattern.setBType(tupleType);
                    return;
                }
                tupleType.restType = this.createTypeForTupleRestType(bindingPatterns.size(), tupleMemebers, bindingPatternTupleType.restType);
                listBindingPattern.restBindingPattern.setBType(tupleType.restType);
                bindingPattern.setBType(bindingPatternType);
                BVarSymbol restBindingPatternSymbol = (BVarSymbol)listBindingPattern.restBindingPattern.declaredVars.get(listBindingPattern.restBindingPattern.getIdentifier().getValue());
                restBindingPatternSymbol.type = tupleType.restType;
                return;
            }
            case MAPPING_BINDING_PATTERN: {
                BLangMappingBindingPattern mappingBindingPattern = (BLangMappingBindingPattern)bindingPattern;
                if (bindingPatternType.tag == 21) {
                    for (BType type : ((BUnionType)bindingPatternType).getMemberTypes()) {
                        this.assignTypesToMemberPatterns(mappingBindingPattern, type, data);
                    }
                    return;
                }
                if (bindingPatternType.tag != 12) {
                    return;
                }
                BRecordType recordType = (BRecordType)bindingPatternType;
                ArrayList<String> boundedFields = new ArrayList<String>();
                for (BLangFieldBindingPattern fieldBindingPattern : mappingBindingPattern.fieldBindingPatterns) {
                    this.assignTypesToMemberPatterns(fieldBindingPattern.bindingPattern, ((BField)recordType.fields.get((Object)fieldBindingPattern.fieldName.value)).type, data);
                    boundedFields.add(fieldBindingPattern.fieldName.value);
                }
                if (mappingBindingPattern.restBindingPattern == null) {
                    return;
                }
                BLangRestBindingPattern restBindingPattern = mappingBindingPattern.restBindingPattern;
                BRecordType restPatternRecordType = (BRecordType)restBindingPattern.getBType();
                BVarSymbol restVarSymbol = (BVarSymbol)restBindingPattern.declaredVars.get(restBindingPattern.getIdentifier().getValue());
                BRecordType restVarSymbolRecordType = (BRecordType)restVarSymbol.type;
                this.setRestMatchPatternConstraintType(recordType, boundedFields, restPatternRecordType, restVarSymbolRecordType, data);
                return;
            }
        }
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern, AnalyzerData data) {
        if (wildCardMatchPattern.matchExpr == null) {
            wildCardMatchPattern.setBType(this.symTable.anyType);
            return;
        }
        BType matchExprType = wildCardMatchPattern.matchExpr.getBType();
        if (this.types.isAssignable(matchExprType, this.symTable.anyType)) {
            wildCardMatchPattern.setBType(this.symTable.anyType);
            return;
        }
        BType intersectionType = this.types.getTypeIntersection(Types.IntersectionContext.compilerInternalIntersectionContext(), matchExprType, this.symTable.anyType, data.env);
        if (intersectionType == this.symTable.semanticError) {
            wildCardMatchPattern.setBType(this.symTable.noType);
            return;
        }
        wildCardMatchPattern.setBType(intersectionType);
    }

    @Override
    public void visit(BLangForeach foreach, AnalyzerData data) {
        boolean onFailExists;
        SymbolEnv currentEnv = data.env;
        data.typeChecker.checkExpr(foreach.collection, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        if (Types.getImpliedType((BType)foreach.collection.getBType()).tag == 34 && !this.types.isAssignable(foreach.collection.getBType(), this.symTable.iterableType)) {
            this.dlog.error(foreach.collection.pos, DiagnosticErrorCode.INVALID_ITERABLE_OBJECT_TYPE, foreach.collection.getBType(), this.symTable.iterableType);
            foreach.resultType = this.symTable.semanticError;
            return;
        }
        this.types.setForeachTypedBindingPatternType(foreach);
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(foreach.body, currentEnv);
        this.handleForeachDefinitionVariables(foreach.variableDefinitionNode, foreach.varType, foreach.isDeclaredWithVar, false, blockEnv);
        boolean prevBreakFound = data.breakFound;
        boolean bl = onFailExists = foreach.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        data.env = blockEnv;
        this.analyzeStmt(foreach.body, data);
        this.analyzeOnFailClause(onFailExists, foreach.body, foreach.onFailClause, data);
        data.notCompletedNormally = false;
        data.breakFound = prevBreakFound;
    }

    @Override
    public void visit(BLangOnFailClause onFailClause, AnalyzerData data) {
        SymbolEnv onFailEnv = SymbolEnv.createBlockEnv(onFailClause.body, data.env);
        VariableDefinitionNode onFailVarDefNode = onFailClause.variableDefinitionNode;
        Deque<LinkedHashSet<BType>> onFailErrTypes = data.commonAnalyzerData.errorTypes;
        if (onFailVarDefNode != null) {
            LinkedHashSet<BType> currentOnFailErrTypes;
            BLangVariable variableNode = (BLangVariable)onFailVarDefNode.getVariable();
            NodeKind kind = variableNode.getKind();
            if (kind != NodeKind.VARIABLE && kind != NodeKind.ERROR_VARIABLE) {
                this.dlog.error(variableNode.pos, DiagnosticErrorCode.INVALID_BINDING_PATTERN_IN_ON_FAIL, new Object[0]);
            }
            BType failErrorType = (currentOnFailErrTypes = onFailErrTypes.peek()).size() == 1 ? (BType)currentOnFailErrTypes.iterator().next() : (currentOnFailErrTypes.size() > 1 ? BUnionType.create(this.typeEnv, null, currentOnFailErrTypes) : this.symTable.neverType);
            this.handleForeachDefinitionVariables(onFailVarDefNode, failErrorType, onFailClause.isDeclaredWithVar, true, onFailEnv);
            BLangVariable onFailVarNode = (BLangVariable)onFailVarDefNode.getVariable();
            BType onFailVarNodeBType = onFailVarNode.getBType();
            if (onFailVarNodeBType != null && onFailVarNodeBType != this.symTable.semanticError && !this.types.isAssignable(onFailVarNodeBType, this.symTable.errorType)) {
                this.dlog.error(onFailVarNode.pos, DiagnosticErrorCode.INVALID_TYPE_DEFINITION_FOR_ERROR_VAR, onFailVarNodeBType);
            }
            if (kind == NodeKind.ERROR_VARIABLE) {
                BLangErrorVariable errorVar = (BLangErrorVariable)variableNode;
                errorVar.symbol = this.symbolEnter.defineVarSymbol(errorVar.pos, errorVar.flagSet, errorVar.getBType(), Names.fromString(this.anonModelHelper.getNextErrorVarKey(onFailEnv.enclPkg.packageID)), onFailEnv, true);
            }
        }
        onFailErrTypes.pop();
        data.env = onFailEnv;
        this.analyzeStmt(onFailClause.body, data);
    }

    private void analyzeOnFailClause(boolean onFailExists, BLangBlockStmt blockStmt, BLangOnFailClause onFailClause, AnalyzerData data) {
        if (!onFailExists) {
            return;
        }
        blockStmt.failureBreakMode = this.getPossibleBreakMode(!data.commonAnalyzerData.errorTypes.peek().isEmpty());
        this.analyzeNode((BLangNode)onFailClause, data);
    }

    private BLangBlockStmt.FailureBreakMode getPossibleBreakMode(boolean possibleFailurePresent) {
        return possibleFailurePresent ? BLangBlockStmt.FailureBreakMode.BREAK_TO_OUTER_BLOCK : BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
    }

    @Override
    public void visit(BLangCollectClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangGroupByClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangGroupingKey node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangWhile whileNode, AnalyzerData data) {
        SymbolEnv whileEnv;
        boolean onFailExists;
        SymbolEnv currentEnv = data.env;
        data.typeChecker.checkExpr(whileNode.expr, currentEnv, this.symTable.booleanType, data.prevEnvs, data.commonAnalyzerData);
        boolean bl = onFailExists = whileNode.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        BType actualType = whileNode.expr.getBType();
        if (31 == Types.getImpliedType((BType)actualType).tag) {
            this.dlog.error(whileNode.expr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        boolean prevBreakFound = data.breakFound;
        data.env = whileEnv = this.typeNarrower.evaluateTruth(whileNode.expr, whileNode.body, currentEnv);
        this.analyzeStmt(whileNode.body, data);
        data.notCompletedNormally = ConditionResolver.checkConstCondition(this.types, this.symTable, whileNode.expr) == this.symTable.trueType && !data.breakFound;
        data.breakFound = prevBreakFound;
        this.analyzeOnFailClause(onFailExists, whileNode.body, whileNode.onFailClause, data);
    }

    @Override
    public void visit(BLangDo doNode, AnalyzerData data) {
        boolean onFailExists;
        data.env = SymbolEnv.createTypeNarrowedEnv(doNode, data.env);
        boolean bl = onFailExists = doNode.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        this.analyzeStmt(doNode.body, data);
        this.analyzeOnFailClause(onFailExists, doNode.body, doNode.onFailClause, data);
    }

    @Override
    public void visit(BLangFail failNode, AnalyzerData data) {
        BType errorTypes;
        BType failExprType;
        BLangExpression errorExpression = failNode.expr;
        BType errorExpressionType = this.typeChecker.checkExpr(errorExpression, data.env, data.prevEnvs, data.commonAnalyzerData);
        if (!data.commonAnalyzerData.errorTypes.isEmpty() && (failExprType = failNode.expr.getBType()) != this.symTable.semanticError && (errorTypes = this.types.getErrorTypes(failExprType)) != this.symTable.semanticError) {
            data.commonAnalyzerData.errorTypes.peek().add(errorTypes);
        }
        if (errorExpressionType != this.symTable.semanticError && !this.types.isSubTypeOfBaseType(errorExpressionType, PredefinedType.ERROR)) {
            this.dlog.error(errorExpression.pos, DiagnosticErrorCode.ERROR_TYPE_EXPECTED, errorExpressionType);
        }
        data.notCompletedNormally = true;
    }

    @Override
    public void visit(BLangLock lockNode, AnalyzerData data) {
        boolean onFailExists;
        data.env = SymbolEnv.createLockEnv(lockNode, data.env);
        boolean bl = onFailExists = lockNode.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        this.analyzeStmt(lockNode.body, data);
        this.analyzeOnFailClause(onFailExists, lockNode.body, lockNode.onFailClause, data);
    }

    @Override
    public void visit(BLangService serviceNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        this.inferServiceTypeFromListeners(serviceNode, data);
        this.addCheckExprToServiceVariable(serviceNode);
        this.analyzeNode((BLangNode)serviceNode.serviceVariable, data);
        if (serviceNode.serviceNameLiteral != null) {
            this.typeChecker.checkExpr((BLangExpression)serviceNode.serviceNameLiteral, currentEnv, this.symTable.stringType, data.prevEnvs, data.commonAnalyzerData);
        }
        serviceNode.setBType(serviceNode.serviceClass.getBType());
        BType serviceType = serviceNode.serviceClass.getBType();
        BServiceSymbol serviceSymbol = (BServiceSymbol)serviceNode.symbol;
        this.validateServiceTypeImplementation(serviceNode.pos, serviceType, serviceNode.inferredServiceType);
        for (BLangExpression attachExpr : serviceNode.attachedExprs) {
            BType exprType = this.typeChecker.checkExpr(attachExpr, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
            if (exprType != this.symTable.semanticError && !this.types.checkListenerCompatibilityAtServiceDecl(exprType)) {
                this.dlog.error(attachExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, LISTENER_NAME, exprType);
            } else if (exprType != this.symTable.semanticError && serviceNode.listenerType == null) {
                serviceNode.listenerType = exprType;
            }
            if (attachExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef attachVarRef = (BLangSimpleVarRef)attachExpr;
                if (attachVarRef.symbol != null && attachVarRef.symbol != this.symTable.notFoundSymbol && !Symbols.isFlagOn(attachVarRef.symbol.flags, 524288L)) {
                    this.dlog.error(attachVarRef.pos, DiagnosticErrorCode.INVALID_LISTENER_ATTACHMENT, new Object[0]);
                }
            } else if (attachExpr.getKind() != NodeKind.TYPE_INIT_EXPR) {
                this.dlog.error(attachExpr.pos, DiagnosticErrorCode.INVALID_LISTENER_ATTACHMENT, new Object[0]);
            }
            if (exprType.getKind() == TypeKind.OBJECT) {
                BObjectType listenerType = (BObjectType)exprType;
                this.validateServiceAttachmentOnListener(serviceNode, attachExpr, listenerType, serviceType);
            } else if (exprType.getKind() == TypeKind.UNION) {
                for (BType memberType : ((BUnionType)exprType).getMemberTypes()) {
                    if (Types.getImpliedType((BType)memberType).tag == 29) continue;
                    BType refType = Types.getImpliedType(memberType);
                    if (refType.tag != 34) continue;
                    this.validateServiceAttachmentOnListener(serviceNode, attachExpr, (BObjectType)refType, serviceType);
                }
            }
            serviceSymbol.addListenerType(exprType);
        }
    }

    private void validateServiceTypeImplementation(Location pos, BType implementedType, BType inferredServiceType) {
        if (!this.types.isAssignableIgnoreObjectTypeIds(implementedType, inferredServiceType)) {
            BType referredInferredServiceType = Types.getImpliedType(inferredServiceType);
            if (referredInferredServiceType.tag == 21 && ((HashSet)((BUnionType)referredInferredServiceType).getMemberTypes()).isEmpty()) {
                return;
            }
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_DOES_NOT_IMPLEMENT_REQUIRED_CONSTRUCTS, inferredServiceType);
        }
    }

    private void inferServiceTypeFromListeners(BLangService serviceNode, AnalyzerData data) {
        BType inferred;
        List<BLangType> typeRefs = serviceNode.serviceClass.typeRefs;
        if (!typeRefs.isEmpty()) {
            serviceNode.inferredServiceType = typeRefs.get(0).getBType();
            return;
        }
        LinkedHashSet<BType> listenerTypes = new LinkedHashSet<BType>();
        for (BLangExpression attachExpr : serviceNode.attachedExprs) {
            BType type = this.typeChecker.checkExpr(attachExpr, data.env, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
            this.flatMapAndGetObjectTypes(listenerTypes, type);
        }
        BTypeIdSet typeIdSet = BTypeIdSet.emptySet();
        if (listenerTypes.size() == 1) {
            inferred = (BType)listenerTypes.iterator().next();
            typeIdSet.add(this.getTypeIds(inferred));
        } else {
            for (BType attachType : listenerTypes) {
                typeIdSet.add(this.getTypeIds(attachType));
            }
            inferred = BUnionType.create(this.typeEnv, null, listenerTypes);
        }
        serviceNode.inferredServiceType = inferred;
        BType tServiceClass = serviceNode.serviceClass.getBType();
        this.getTypeIds(tServiceClass).add(typeIdSet);
    }

    private BTypeIdSet getTypeIds(BType type) {
        type = Types.getImpliedType(type);
        int tag = type.tag;
        if (tag == 34) {
            return ((BObjectType)type).typeIdSet;
        }
        return BTypeIdSet.emptySet();
    }

    private void flatMapAndGetObjectTypes(Set<BType> result, BType type) {
        block4: {
            block3: {
                if (!this.types.checkListenerCompatibilityAtServiceDecl(type = Types.getImpliedType(type))) {
                    return;
                }
                if (type.tag != 34) break block3;
                BObjectType objectType = (BObjectType)type;
                BObjectTypeSymbol tsymbol = (BObjectTypeSymbol)objectType.tsymbol;
                for (BAttachedFunction func : tsymbol.attachedFuncs) {
                    if (!func.funcName.value.equals("attach")) continue;
                    BType firstParam = func.type.paramTypes.get(0);
                    result.add(firstParam);
                    return;
                }
                break block4;
            }
            if (type.tag != 21) break block4;
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                this.flatMapAndGetObjectTypes(result, memberType);
            }
        }
    }

    private void addCheckExprToServiceVariable(BLangService serviceNode) {
        BLangFunction initFunction = serviceNode.serviceClass.initFunction;
        if (initFunction != null && initFunction.returnTypeNode != null && this.types.containsErrorType(initFunction.returnTypeNode.getBType())) {
            BLangCheckedExpr checkedExpr = (BLangCheckedExpr)TreeBuilder.createCheckExpressionNode();
            checkedExpr.expr = serviceNode.serviceVariable.expr;
            checkedExpr.setBType(serviceNode.serviceClass.getBType());
            serviceNode.serviceVariable.expr = checkedExpr;
        }
    }

    private void validateServiceAttachmentOnListener(BLangService serviceNode, BLangExpression attachExpr, BObjectType listenerType, BType serviceType) {
        for (BAttachedFunction func : ((BObjectTypeSymbol)listenerType.tsymbol).attachedFuncs) {
            if (!func.funcName.value.equals("attach")) continue;
            List<BType> paramTypes = func.type.paramTypes;
            if (serviceType != null && serviceType != this.symTable.noType) {
                this.validateServiceTypeAgainstAttachMethod(serviceNode.inferredServiceType, paramTypes.get(0), attachExpr.pos);
            }
            this.validateServiceAttachpointAgainstAttachMethod(serviceNode, attachExpr, paramTypes.get(1));
        }
    }

    private void validateServiceTypeAgainstAttachMethod(BType serviceType, BType targetType, Location pos) {
        if (!this.types.isAssignable(serviceType, targetType)) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_TYPE_IS_NOT_SUPPORTED_BY_LISTENER, new Object[0]);
        }
    }

    private void validateServiceAttachpointAgainstAttachMethod(BLangService serviceNode, BLangExpression listenerExpr, BType attachPointParam) {
        boolean isStringComponentAvailable = this.types.isAssignable(this.symTable.stringType, attachPointParam);
        boolean isNullable = attachPointParam.isNullable();
        boolean isArrayComponentAvailable = this.types.isAssignable(this.symTable.arrayStringType, attachPointParam);
        boolean pathLiteral = serviceNode.serviceNameLiteral != null;
        boolean absolutePath = !serviceNode.absoluteResourcePath.isEmpty();
        Location pos = listenerExpr.getPosition();
        if (!pathLiteral && isStringComponentAvailable && !isArrayComponentAvailable && !isNullable) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_LITERAL_REQUIRED_BY_LISTENER, new Object[0]);
        } else if (!absolutePath && isArrayComponentAvailable && !isStringComponentAvailable && !isNullable) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_ABSOLUTE_PATH_REQUIRED_BY_LISTENER, new Object[0]);
        } else if (!(pathLiteral || absolutePath || isNullable)) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_ABSOLUTE_PATH_OR_LITERAL_IS_REQUIRED_BY_LISTENER, new Object[0]);
        }
        if (pathLiteral && !isStringComponentAvailable) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_PATH_LITERAL_IS_NOT_SUPPORTED_BY_LISTENER, new Object[0]);
        }
        if (absolutePath && !isArrayComponentAvailable) {
            this.dlog.error(pos, DiagnosticErrorCode.SERVICE_ABSOLUTE_PATH_IS_NOT_SUPPORTED_BY_LISTENER, new Object[0]);
        }
    }

    private void validateDefaultable(BLangRecordTypeNode recordTypeNode) {
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            if (!field.flagSet.contains((Object)Flag.OPTIONAL) || field.expr == null) continue;
            this.dlog.error(field.pos, DiagnosticErrorCode.DEFAULT_VALUES_NOT_ALLOWED_FOR_OPTIONAL_FIELDS, field.name.value);
        }
    }

    @Override
    public void visit(BLangTransaction transactionNode, AnalyzerData data) {
        boolean onFailExists;
        data.env = SymbolEnv.createTransactionEnv(transactionNode, data.env);
        boolean bl = onFailExists = transactionNode.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        this.analyzeStmt(transactionNode.transactionBody, data);
        this.analyzeOnFailClause(onFailExists, transactionNode.transactionBody, transactionNode.onFailClause, data);
    }

    @Override
    public void visit(BLangRollback rollbackNode, AnalyzerData data) {
        if (rollbackNode.expr != null) {
            BUnionType expectedType = BUnionType.create(this.typeEnv, null, this.symTable.errorType, this.symTable.nilType);
            this.typeChecker.checkExpr(rollbackNode.expr, data.env, (BType)expectedType, data.prevEnvs, data.commonAnalyzerData);
        }
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction, AnalyzerData data) {
        if (retryTransaction.retrySpec != null) {
            retryTransaction.retrySpec.accept(this, data);
        }
        retryTransaction.transaction.accept(this, data);
    }

    @Override
    public void visit(BLangRetry retryNode, AnalyzerData data) {
        boolean onFailExists;
        if (retryNode.retrySpec != null) {
            retryNode.retrySpec.accept(this, data);
        }
        data.env = SymbolEnv.createRetryEnv(retryNode, data.env);
        boolean bl = onFailExists = retryNode.onFailClause != null;
        if (onFailExists) {
            data.commonAnalyzerData.errorTypes.push(new LinkedHashSet());
        }
        this.analyzeStmt(retryNode.retryBody, data);
        this.analyzeOnFailClause(onFailExists, retryNode.retryBody, retryNode.onFailClause, data);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        if (retrySpec.retryManagerType != null) {
            retrySpec.setBType(this.symResolver.resolveTypeNode(retrySpec.retryManagerType, currentEnv));
        }
        if (retrySpec.argExprs != null) {
            retrySpec.argExprs.forEach(arg -> this.typeChecker.checkExpr((BLangExpression)arg, currentEnv, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData));
        }
    }

    @Override
    public void visit(BLangForkJoin forkJoin, AnalyzerData data) {
        for (BLangSimpleVariableDef worker : forkJoin.workers) {
            BLangFunction function = ((BLangLambdaFunction)worker.var.expr).function;
            function.symbol.enclForkName = function.anonForkName;
            ((BInvokableSymbol)worker.var.symbol).enclForkName = function.anonForkName;
        }
    }

    @Override
    public void visit(BLangReturn returnNode, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        data.typeChecker.checkExpr(returnNode.expr, currentEnv, currentEnv.enclInvokable.returnTypeNode.getBType(), data.prevEnvs, data.commonAnalyzerData);
        this.validateWorkerAnnAttachments(returnNode.expr, data);
        data.notCompletedNormally = true;
    }

    void analyzeStmt(BLangStatement stmtNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)stmtNode, data);
    }

    @Override
    public void analyzeNode(BLangNode node, SymbolEnv env) {
        AnalyzerData data = new AnalyzerData(env);
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, QueryTypeChecker queryTypeChecker, SymbolEnv env) {
        AnalyzerData data = new AnalyzerData(env);
        data.typeChecker = queryTypeChecker;
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, SymbolEnv env, Types.CommonAnalyzerData commonAnalyzerData) {
        AnalyzerData data = new AnalyzerData(env);
        data.commonAnalyzerData = commonAnalyzerData;
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, SymbolEnv env, QueryTypeChecker queryTypeChecker, Types.CommonAnalyzerData commonAnalyzerData) {
        AnalyzerData data = new AnalyzerData(env);
        data.commonAnalyzerData = commonAnalyzerData;
        data.typeChecker = queryTypeChecker;
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, SymbolEnv env, Deque<SymbolEnv> prevEnvs) {
        AnalyzerData data = new AnalyzerData(env);
        data.prevEnvs = prevEnvs;
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, SymbolEnv env, Deque<SymbolEnv> prevEnvs, Types.CommonAnalyzerData commonAnalyzerData) {
        AnalyzerData data = new AnalyzerData(env);
        data.prevEnvs = prevEnvs;
        data.commonAnalyzerData = commonAnalyzerData;
        this.analyzeNode(node, data);
    }

    public void analyzeNode(BLangNode node, SymbolEnv env, Deque<SymbolEnv> prevEnvs, QueryTypeChecker queryTypeChecker, Types.CommonAnalyzerData commonAnalyzerData) {
        AnalyzerData data = new AnalyzerData(env);
        data.prevEnvs = prevEnvs;
        data.commonAnalyzerData = commonAnalyzerData;
        data.typeChecker = queryTypeChecker;
        this.analyzeNode(node, data);
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
        this.analyzeNode(node, this.symTable.noType, data);
    }

    @Override
    public void visit(BLangContinue continueNode, AnalyzerData data) {
        data.notCompletedNormally = true;
    }

    @Override
    public void visit(BLangBreak breakNode, AnalyzerData data) {
        data.notCompletedNormally = true;
        data.breakFound = true;
    }

    @Override
    public void visit(BLangPanic panicNode, AnalyzerData data) {
        this.typeChecker.checkExpr(panicNode.expr, data.env, (BType)this.symTable.errorType, data.prevEnvs, data.commonAnalyzerData);
        data.notCompletedNormally = true;
    }

    void analyzeNode(BLangNode node, BType expType, AnalyzerData data) {
        if (node != null) {
            data.prevEnvs.push(data.env);
            BType preExpType = data.expType;
            data.expType = expType;
            node.accept(this, data);
            data.env = data.prevEnvs.pop();
            data.expType = preExpType;
        }
    }

    @Override
    public void visit(BLangConstant constant, AnalyzerData data) {
        if (constant.typeNode != null && !this.types.isAllowedConstantType(constant.typeNode.getBType())) {
            if (this.types.isAssignable(constant.typeNode.getBType(), this.symTable.anydataType) && !this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(constant.typeNode.getBType())) {
                this.dlog.error(constant.typeNode.pos, DiagnosticErrorCode.CONSTANT_DECLARATION_NOT_YET_SUPPORTED, constant.typeNode);
            } else {
                this.dlog.error(constant.typeNode.pos, DiagnosticErrorCode.INVALID_CONST_DECLARATION, constant.typeNode);
            }
        }
        this.anonTypeNameSuffixes.push(constant.name.value);
        constant.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.CONST);
            this.anonTypeNameSuffixes.push(annotationAttachment.annotationName.value);
            annotationAttachment.accept(this, data);
            this.anonTypeNameSuffixes.pop();
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annotationAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol != null) {
                constant.symbol.addAnnotation(annotationAttachmentSymbol);
            }
        });
        this.anonTypeNameSuffixes.pop();
        this.constantAnalyzer.visit(constant);
    }

    private boolean isLiteralInUnaryFromConstantNotAllowed(BLangUnaryExpr unaryExpr) {
        return unaryExpr.expr.getKind() != NodeKind.NUMERIC_LITERAL && !this.types.isOperatorKindInUnaryValid(unaryExpr.operator);
    }

    private boolean isNodeKindAllowedForConstants(BLangExpression expression, BLangConstant constant) {
        NodeKind exprNodeKind = expression.getKind();
        if (exprNodeKind == NodeKind.UNARY_EXPR && this.isLiteralInUnaryFromConstantNotAllowed((BLangUnaryExpr)expression)) {
            return constant.typeNode == null;
        }
        if (exprNodeKind != NodeKind.LITERAL && exprNodeKind != NodeKind.NUMERIC_LITERAL && exprNodeKind != NodeKind.UNARY_EXPR) {
            return constant.typeNode == null;
        }
        return false;
    }

    private void checkAnnotConstantExpression(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                break;
            }
            case UNARY_EXPR: {
                this.checkAnnotConstantExpression(((BLangUnaryExpr)expression).expr);
                break;
            }
            case SIMPLE_VARIABLE_REF: {
                BSymbol symbol = ((BLangSimpleVarRef)expression).symbol;
                if (symbol == null || (symbol.tag & 0x100001CL) == 0x100001CL) break;
                this.dlog.error(expression.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
                break;
            }
            case RECORD_LITERAL_EXPR: {
                ((BLangRecordLiteral)expression).fields.forEach(field -> {
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField pair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        this.checkAnnotConstantExpression(pair.key.expr);
                        this.checkAnnotConstantExpression(pair.valueExpr);
                    } else {
                        this.checkAnnotConstantExpression((BLangRecordLiteral.BLangRecordVarNameField)field);
                    }
                });
                break;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                ((BLangListConstructorExpr)expression).exprs.forEach(this::checkAnnotConstantExpression);
                break;
            }
            case STRING_TEMPLATE_LITERAL: {
                ((BLangStringTemplateLiteral)expression).exprs.forEach(this::checkAnnotConstantExpression);
                break;
            }
            default: {
                this.dlog.error(expression.pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
            }
        }
    }

    private void handleForeachDefinitionVariables(VariableDefinitionNode variableDefinitionNode, BType varType, boolean isDeclaredWithVar, boolean onFail, SymbolEnv blockEnv) {
        BLangVariable variableNode = (BLangVariable)variableDefinitionNode.getVariable();
        if (isDeclaredWithVar) {
            if (onFail && varType == this.symTable.neverType) {
                varType = this.symTable.errorType;
            }
            this.handleDeclaredVarInForeach(variableNode, varType, blockEnv);
            return;
        }
        BType typeNodeType = this.symResolver.resolveTypeNode(variableNode.typeNode, blockEnv);
        if (this.types.isAssignable(varType, typeNodeType)) {
            if (onFail && varType == this.symTable.neverType) {
                varType = typeNodeType;
            }
            this.handleDeclaredVarInForeach(variableNode, varType, blockEnv);
            return;
        }
        if (variableNode.typeNode != null && variableNode.typeNode.pos != null) {
            this.dlog.error(variableNode.typeNode.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, varType, typeNodeType);
        }
        this.handleDeclaredVarInForeach(variableNode, typeNodeType, blockEnv);
    }

    private BLangExpression getBinaryExpr(BLangExpression lExpr, BLangExpression rExpr, OperatorKind opKind, BSymbol opSymbol) {
        BLangBinaryExpr binaryExpressionNode = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpressionNode.lhsExpr = lExpr;
        binaryExpressionNode.rhsExpr = rExpr;
        binaryExpressionNode.pos = rExpr.pos;
        binaryExpressionNode.opKind = opKind;
        if (opSymbol != this.symTable.notFoundSymbol) {
            binaryExpressionNode.setBType(opSymbol.type.getReturnType());
            binaryExpressionNode.opSymbol = (BOperatorSymbol)opSymbol;
        } else {
            binaryExpressionNode.setBType(this.symTable.semanticError);
        }
        return binaryExpressionNode;
    }

    private boolean validateObjectTypeInitInvocation(BLangExpression expr) {
        if (expr != null && expr.getKind() == NodeKind.TYPE_INIT_EXPR && ((BLangTypeInit)expr).userDefinedType == null) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_ANY_VAR_DEF, new Object[0]);
            return false;
        }
        return true;
    }

    private void setTypeOfVarRefInErrorBindingAssignment(BLangExpression expr, AnalyzerData data) {
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF && expr.getKind() != NodeKind.RECORD_VARIABLE_REF && expr.getKind() != NodeKind.ERROR_VARIABLE_REF && expr.getKind() != NodeKind.TUPLE_VARIABLE_REF) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, expr);
            expr.setBType(this.symTable.semanticError);
        }
        this.setTypeOfVarRef(expr, data);
    }

    private void setTypeOfVarRefInAssignment(BLangExpression expr, AnalyzerData data) {
        if (!(expr instanceof BLangValueExpression)) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_VARIABLE_ASSIGNMENT, expr);
            expr.setBType(this.symTable.semanticError);
        }
        this.setTypeOfVarRef(expr, data);
    }

    private void setTypeOfVarRef(BLangExpression expr, AnalyzerData data) {
        BVarSymbol originSymbol;
        BLangValueExpression varRefExpr = (BLangValueExpression)expr;
        varRefExpr.isLValue = true;
        this.typeChecker.checkExpr((BLangExpression)varRefExpr, data.env, this.symTable.noType, data.prevEnvs, data.commonAnalyzerData);
        this.checkConstantAssignment(varRefExpr, data);
        if (this.isSimpleVarRef(expr) && (originSymbol = ((BVarSymbol)((BLangSimpleVarRef)expr).symbol).originalSymbol) != null) {
            varRefExpr.setBType(originSymbol.type);
        }
    }

    private void setTypeOfVarRefForBindingPattern(BLangExpression expr, AnalyzerData data) {
        BLangVariableReference varRefExpr = (BLangVariableReference)expr;
        varRefExpr.isLValue = true;
        this.typeChecker.checkExpr((BLangExpression)varRefExpr, data.env, data.prevEnvs, data.commonAnalyzerData);
        switch (expr.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                this.setTypeOfVarRef(expr, data);
                this.validateFunctionVarRef(expr, data);
                break;
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expr;
                for (BLangExpression expression : tupleVarRef.expressions) {
                    this.setTypeOfVarRefForBindingPattern(expression, data);
                }
                if (tupleVarRef.restParam != null) {
                    this.setTypeOfVarRefForBindingPattern(tupleVarRef.restParam, data);
                }
                return;
            }
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expr;
                recordVarRef.recordRefFields.forEach(refKeyValue -> this.setTypeOfVarRefForBindingPattern(refKeyValue.variableReference, data));
                if (recordVarRef.restParam != null) {
                    this.setTypeOfVarRefForBindingPattern(recordVarRef.restParam, data);
                }
                return;
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expr;
                if (errorVarRef.message != null) {
                    this.setTypeOfVarRefForBindingPattern(errorVarRef.message, data);
                }
                if (errorVarRef.cause != null) {
                    this.setTypeOfVarRefForBindingPattern(errorVarRef.cause, data);
                    if (!this.types.isAssignable(this.symTable.errorOrNilType, errorVarRef.cause.getBType())) {
                        this.dlog.error(errorVarRef.cause.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.errorOrNilType, errorVarRef.cause.getBType());
                    }
                }
                errorVarRef.detail.forEach(namedArgExpr -> this.setTypeOfVarRefForBindingPattern(namedArgExpr.expr, data));
                if (errorVarRef.restVar == null) break;
                this.setTypeOfVarRefForBindingPattern(errorVarRef.restVar, data);
            }
        }
    }

    private void checkInvalidTypeDef(BLangExpression expr) {
        switch (expr.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                BLangSimpleVarRef variableRef = (BLangSimpleVarRef)expr;
                if (variableRef.isLValue && variableRef.symbol != null && (variableRef.symbol.tag & 0x801CL) == 32796L) {
                    this.dlog.error(expr.pos, DiagnosticErrorCode.CANNOT_ASSIGN_VALUE_TO_TYPE_DEF, new Object[0]);
                }
                return;
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expr;
                for (BLangExpression tupleExpr : tupleVarRef.expressions) {
                    this.checkInvalidTypeDef(tupleExpr);
                }
                if (tupleVarRef.restParam != null) {
                    this.checkInvalidTypeDef(tupleVarRef.restParam);
                }
                return;
            }
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expr;
                for (BLangRecordVarRef.BLangRecordVarRefKeyValue refKeyValue : recordVarRef.recordRefFields) {
                    this.checkInvalidTypeDef(refKeyValue.variableReference);
                }
                if (recordVarRef.restParam != null) {
                    this.checkInvalidTypeDef(recordVarRef.restParam);
                }
                return;
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expr;
                if (errorVarRef.message != null) {
                    this.checkInvalidTypeDef(errorVarRef.message);
                }
                if (errorVarRef.cause != null) {
                    this.checkInvalidTypeDef(errorVarRef.cause);
                }
                for (BLangNamedArgsExpression namedArgExpr : errorVarRef.detail) {
                    this.checkInvalidTypeDef(namedArgExpr.expr);
                }
                if (errorVarRef.restVar == null) break;
                this.checkInvalidTypeDef(errorVarRef.restVar);
            }
        }
    }

    private void validateAnnotationAttachmentExpr(BLangAnnotationAttachment annAttachmentNode, BAnnotationSymbol annotationSymbol, AnalyzerData data) {
        if (annotationSymbol.attachedType == null || this.types.isAssignable(annotationSymbol.attachedType, this.symTable.trueType)) {
            BLangExpression expr = annAttachmentNode.expr;
            if (expr != null) {
                this.typeChecker.checkExpr(expr, data.env, this.symTable.semanticError, data.prevEnvs, data.commonAnalyzerData);
                this.dlog.error(expr.pos, DiagnosticErrorCode.ANNOTATION_ATTACHMENT_CANNOT_HAVE_A_VALUE, annotationSymbol);
            }
            return;
        }
        BType annotType = annotationSymbol.attachedType;
        BType referredAnnotType = Types.getImpliedType(annotType);
        if (annAttachmentNode.expr == null) {
            BRecordType recordType;
            BRecordType bRecordType = referredAnnotType.tag == 12 ? (BRecordType)referredAnnotType : (recordType = referredAnnotType.tag == 20 && Types.getImpliedType((BType)((BArrayType)referredAnnotType).eType).tag == 12 ? (BRecordType)Types.getImpliedType(((BArrayType)referredAnnotType).eType) : null);
            if (recordType != null && this.hasRequiredFields(recordType)) {
                this.dlog.error(annAttachmentNode.pos, DiagnosticErrorCode.ANNOTATION_ATTACHMENT_REQUIRES_A_VALUE, recordType);
                return;
            }
        }
        if (annAttachmentNode.expr != null) {
            this.typeChecker.checkExpr(annAttachmentNode.expr, data.env, referredAnnotType.tag == 20 ? ((BArrayType)referredAnnotType).eType : annotType, data.prevEnvs, data.commonAnalyzerData);
            if (Symbols.isFlagOn(annotationSymbol.flags, 16384L)) {
                this.checkAnnotConstantExpression(annAttachmentNode.expr);
            }
        }
    }

    public boolean hasRequiredFields(BRecordType recordType) {
        for (BField field : recordType.fields.values()) {
            if (!Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
            return true;
        }
        return false;
    }

    private void validateAnnotationAttachmentCount(List<BLangAnnotationAttachment> attachments) {
        HashMap<BAnnotationSymbol, Integer> attachmentCounts = new HashMap<BAnnotationSymbol, Integer>();
        for (BLangAnnotationAttachment attachment : attachments) {
            if (attachment.annotationSymbol == null) continue;
            attachmentCounts.merge(attachment.annotationSymbol, 1, Integer::sum);
        }
        attachmentCounts.forEach((symbol, count) -> {
            if ((symbol.attachedType == null || Types.getImpliedType((BType)symbol.attachedType).tag != 20) && count > 1) {
                Optional<Object> found = Optional.empty();
                for (BLangAnnotationAttachment attachment : attachments) {
                    if (!attachment.annotationSymbol.equals(symbol)) continue;
                    found = Optional.of(attachment);
                    break;
                }
                this.dlog.error(((BLangAnnotationAttachment)found.get()).pos, DiagnosticErrorCode.ANNOTATION_ATTACHMENT_CANNOT_SPECIFY_MULTIPLE_VALUES, symbol);
            }
        });
    }

    private void validateBuiltinTypeAnnotationAttachment(List<BLangAnnotationAttachment> attachments, AnalyzerData data) {
        if (PackageID.isLangLibPackageID(data.env.enclPkg.packageID)) {
            return;
        }
        for (BLangAnnotationAttachment attachment : attachments) {
            if (attachment.annotationSymbol == null || !attachment.annotationSymbol.pkgID.equals(PackageID.ANNOTATIONS)) continue;
            String annotationName = attachment.annotationName.value;
            if (annotationName.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
                this.dlog.error(attachment.pos, DiagnosticErrorCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
                continue;
            }
            if (!annotationName.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) continue;
            this.dlog.error(attachment.pos, DiagnosticErrorCode.BUILTIN_SUBTYPE_OUTSIDE_LANG_MODULE, new Object[0]);
        }
    }

    private void validateObjectAttachedFunction(BLangFunction funcNode, AnalyzerData data) {
        if (!funcNode.attachedFunction) {
            return;
        }
        if (!Symbols.isFlagOn(funcNode.receiver.getBType().tsymbol.flags, 0x10000000L)) {
            if (funcNode.body != null) {
                this.dlog.error(funcNode.pos, DiagnosticErrorCode.ABSTRACT_OBJECT_FUNCTION_CANNOT_HAVE_BODY, funcNode.name, funcNode.receiver.getBType());
            }
            return;
        }
        if (funcNode.interfaceFunction && !data.env.enclPkg.objAttachedFunctions.contains(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.INVALID_INTERFACE_ON_NON_ABSTRACT_OBJECT, funcNode.name, funcNode.receiver.getBType());
        }
    }

    private void validateInclusions(Set<Flag> referencingTypeFlags, List<BLangType> typeRefs, boolean objectTypeDesc, boolean objectConstructorExpr) {
        boolean nonIsolated = !referencingTypeFlags.contains((Object)Flag.ISOLATED);
        boolean nonService = !referencingTypeFlags.contains((Object)Flag.SERVICE);
        boolean nonClient = !referencingTypeFlags.contains((Object)Flag.CLIENT);
        boolean nonReadOnly = !referencingTypeFlags.contains((Object)Flag.READONLY);
        for (BLangType typeRef : typeRefs) {
            BTypeSymbol tsymbol;
            BType type = typeRef.getBType();
            long flags = type.getFlags();
            ArrayList<Flag> mismatchedFlags = new ArrayList<Flag>();
            if (nonIsolated && Symbols.isFlagOn(flags, 0x20000000L)) {
                mismatchedFlags.add(Flag.ISOLATED);
            }
            if (nonService && Symbols.isFlagOn(flags, 262144L)) {
                mismatchedFlags.add(Flag.SERVICE);
            }
            if (nonClient && Symbols.isFlagOn(flags, 65536L)) {
                mismatchedFlags.add(Flag.CLIENT);
            }
            if (!mismatchedFlags.isEmpty()) {
                StringBuilder qualifierString = new StringBuilder(((Flag)((Object)mismatchedFlags.get(0))).toString().toLowerCase());
                for (int i = 1; i < mismatchedFlags.size(); ++i) {
                    qualifierString.append(" ").append(((Flag)((Object)mismatchedFlags.get(i))).toString().toLowerCase());
                }
                this.dlog.error(typeRef.pos, objectConstructorExpr ? DiagnosticErrorCode.INVALID_REFERENCE_WITH_MISMATCHED_QUALIFIERS : DiagnosticErrorCode.INVALID_INCLUSION_WITH_MISMATCHED_QUALIFIERS, qualifierString.toString());
            }
            if ((tsymbol = type.tsymbol) == null || !Symbols.isFlagOn(tsymbol.flags, 0x10000000L) && Types.getReferredType((BType)type).tag != 22 || !Symbols.isFlagOn(flags, 32L)) continue;
            if (objectTypeDesc) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.INVALID_READ_ONLY_CLASS_INCLUSION_IN_OBJECT_TYPE_DESCRIPTOR, new Object[0]);
                continue;
            }
            if (!nonReadOnly || objectConstructorExpr) continue;
            if (Types.getReferredType((BType)type).tag == 22) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.INVALID_READ_ONLY_TYPEDESC_INCLUSION_IN_NON_READ_ONLY_CLASS, new Object[0]);
                continue;
            }
            this.dlog.error(typeRef.pos, DiagnosticErrorCode.INVALID_READ_ONLY_CLASS_INCLUSION_IN_NON_READ_ONLY_CLASS, new Object[0]);
        }
    }

    private void validateReferencedFunction(Location pos, BAttachedFunction func, SymbolEnv env, DiagnosticErrorCode code) {
        BInvokableSymbol invokableSymbol = func.symbol;
        BType receiverType = invokableSymbol.receiverSymbol.type;
        if (!Symbols.isFlagOn(receiverType.tsymbol.flags, 0x10000000L)) {
            return;
        }
        if (!Symbols.isFunctionDeclaration(invokableSymbol)) {
            return;
        }
        if (!env.enclPkg.objAttachedFunctions.contains(invokableSymbol)) {
            if (Symbols.isResource(invokableSymbol)) {
                this.dlog.error(pos, code, func, receiverType);
            } else {
                this.dlog.error(pos, code, func.funcName, receiverType);
            }
        }
    }

    private boolean isSimpleVarRef(BLangExpression expr) {
        if (expr.getBType().tag == 28 || expr.getBType().tag == 24 || expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        if (((BLangSimpleVarRef)expr).symbol == null) {
            return false;
        }
        return (((BLangSimpleVarRef)expr).symbol.tag & 0x34L) == 52L;
    }

    private void resetTypeNarrowing(BLangExpression lhsExpr, AnalyzerData data) {
        if (!this.isSimpleVarRef(lhsExpr)) {
            return;
        }
        BVarSymbol varSymbol = (BVarSymbol)((BLangSimpleVarRef)lhsExpr).symbol;
        if (Symbols.isFlagOn(varSymbol.flags, 4L)) {
            return;
        }
        if (varSymbol.originalSymbol == null) {
            return;
        }
        if (data.narrowedTypeInfo != null) {
            BType currentType = ((BLangSimpleVarRef)lhsExpr).symbol.type;
            data.narrowedTypeInfo.put(this.typeNarrower.getOriginalVarSymbol(varSymbol), new BType.NarrowedTypes(currentType, currentType));
        }
        this.defineOriginalSymbol(lhsExpr, this.typeNarrower.getOriginalVarSymbol(varSymbol), data.env, data);
        data.env = data.prevEnvs.pop();
    }

    private void defineOriginalSymbol(BLangExpression lhsExpr, BVarSymbol varSymbol, SymbolEnv env, AnalyzerData data) {
        BSymbol foundSym = this.symResolver.lookupSymbolInMainSpace(env, varSymbol.name);
        if (foundSym == varSymbol) {
            data.prevEnvs.push(env);
            return;
        }
        env = SymbolEnv.createTypeNarrowedEnv(lhsExpr, env);
        this.symbolEnter.defineTypeNarrowedSymbol(lhsExpr.pos, env, varSymbol, varSymbol.type, varSymbol.origin == SymbolOrigin.VIRTUAL);
        SymbolEnv prevEnv = data.prevEnvs.pop();
        this.defineOriginalSymbol(lhsExpr, varSymbol, prevEnv, data);
        data.prevEnvs.push(env);
    }

    private void validateIsolatedParamUsage(boolean inIsolatedFunction, BLangSimpleVariable variable, boolean isRestParam, AnalyzerData data) {
        BType type;
        if (!this.hasAnnotation(variable.annAttachments, Names.ANNOTATION_ISOLATED_PARAM.value)) {
            return;
        }
        variable.symbol.flags |= 0x40000000L;
        if (!PackageID.isLangLibPackageID(data.env.enclPkg.packageID)) {
            this.dlog.error(variable.pos, DiagnosticErrorCode.ISOLATED_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
        }
        BType bType = type = isRestParam ? ((BArrayType)variable.getBType()).eType : variable.getBType();
        if (!this.types.isSubTypeOfBaseType(type, PredefinedType.FUNCTION)) {
            this.dlog.error(variable.pos, DiagnosticErrorCode.ISOLATED_PARAM_USED_WITH_INVALID_TYPE, new Object[0]);
        }
        if (!inIsolatedFunction) {
            this.dlog.error(variable.pos, DiagnosticErrorCode.ISOLATED_PARAM_USED_IN_A_NON_ISOLATED_FUNCTION, new Object[0]);
        }
    }

    private boolean hasAnnotation(List<BLangAnnotationAttachment> attachments, String name) {
        for (BLangAnnotationAttachment attachment : attachments) {
            if (!attachment.annotationName.value.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isConfigurable(BLangVariable varNode) {
        return varNode.flagSet.contains((Object)Flag.CONFIGURABLE);
    }

    private boolean isIsolated(BLangVariable varNode) {
        return varNode.flagSet.contains((Object)Flag.ISOLATED);
    }

    private void handleReadOnlyField(boolean isRecordType, LinkedHashMap<String, BField> fields, BLangSimpleVariable field, AnalyzerData data) {
        BType fieldType = field.getBType();
        if (fieldType == this.symTable.semanticError) {
            return;
        }
        BType readOnlyFieldType = this.getReadOnlyFieldType(field.pos, fieldType, data);
        if (readOnlyFieldType == this.symTable.semanticError) {
            this.dlog.error(field.pos, DiagnosticErrorCode.INVALID_READONLY_FIELD_TYPE, fieldType);
            return;
        }
        if (isRecordType) {
            fields.get((Object)field.name.value).type = readOnlyFieldType;
        }
        field.symbol.type = readOnlyFieldType;
        field.setBType(field.symbol.type);
    }

    private BType getReadOnlyFieldType(Location pos, BType fieldType, AnalyzerData data) {
        if (this.types.isInherentlyImmutableType(fieldType) || Symbols.isFlagOn(fieldType.getFlags(), 32L)) {
            return fieldType;
        }
        if (!this.types.isSelectivelyImmutableType(fieldType, data.env.enclPkg.packageID)) {
            return this.symTable.semanticError;
        }
        return ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, fieldType, data.env, this.symTable, this.anonModelHelper, this.names, new HashSet<Flag>());
    }

    private void setRestMatchPatternConstraintType(final BRecordType recordType, List<String> boundedFieldNames, BRecordType restPatternRecordType, BRecordType restVarSymbolRecordType, AnalyzerData data) {
        BType restConstraintType = this.symbolEnter.getRestMatchPatternConstraintType(recordType, new HashMap<String, BField>(), restVarSymbolRecordType.restFieldType);
        LinkedHashMap<String, BField> unMappedFields = new LinkedHashMap<String, BField>(){
            {
                this.putAll(recordType.fields);
            }
        };
        this.symbolEnter.setRestRecordFields(recordType.tsymbol.pos, data.env, unMappedFields, boundedFieldNames, restConstraintType, restVarSymbolRecordType);
        restPatternRecordType.restFieldType = restVarSymbolRecordType.restFieldType;
    }

    private List<BAnnotationAttachmentSymbol> getAnnotationAttachmentSymbols(List<BLangAnnotationAttachment> annAttachments) {
        ArrayList<BAnnotationAttachmentSymbol> annotationAttachmentSymbols = new ArrayList<BAnnotationAttachmentSymbol>();
        for (BLangAnnotationAttachment annAttachment : annAttachments) {
            BAnnotationAttachmentSymbol annotationAttachmentSymbol = annAttachment.annotationAttachmentSymbol;
            if (annotationAttachmentSymbol == null) continue;
            annotationAttachmentSymbols.add(annotationAttachmentSymbol);
        }
        return annotationAttachmentSymbols;
    }

    private void validateTypesOfOverriddenFields(BLangStructureTypeNode structureTypeNode) {
        this.validateTypesOfOverriddenFields(structureTypeNode.getBType(), structureTypeNode.fields, structureTypeNode.typeRefs);
    }

    private void validateTypesOfOverriddenFields(BType type, List<BLangSimpleVariable> fields, List<BLangType> includedTypeNodes) {
        if (type == this.symTable.semanticError) {
            return;
        }
        LinkedHashMap<String, BField> fieldsOfIncludingType = ((BStructureType)type).fields;
        Map<String, Location> explicitlySpecifiedFieldLocations = this.getFieldLocations(fields);
        for (BLangType includedTypeNode : includedTypeNodes) {
            BType includedType = Types.getImpliedType(includedTypeNode.getBType());
            int includedTypeTag = includedType.tag;
            if (includedTypeTag != 12 && includedTypeTag != 34) continue;
            BStructureType includedStructureType = (BStructureType)includedType;
            for (Map.Entry<String, BField> includedFieldEntry : includedStructureType.fields.entrySet()) {
                BType fieldTypeInIncludedType;
                BType fieldTypeInIncludingType;
                String fieldName = includedFieldEntry.getKey();
                if (!explicitlySpecifiedFieldLocations.containsKey(fieldName) || !fieldsOfIncludingType.containsKey(fieldName) || (fieldTypeInIncludingType = fieldsOfIncludingType.get((Object)fieldName).type) == this.symTable.semanticError || (fieldTypeInIncludedType = includedFieldEntry.getValue().type) == this.symTable.semanticError || this.types.isAssignable(fieldTypeInIncludingType, fieldTypeInIncludedType)) continue;
                this.dlog.error(explicitlySpecifiedFieldLocations.get(fieldName), DiagnosticErrorCode.INCOMPATIBLE_SUB_TYPE_FIELD, fieldName, fieldTypeInIncludedType, fieldTypeInIncludingType);
            }
        }
    }

    private Map<String, Location> getFieldLocations(List<BLangSimpleVariable> fields) {
        HashMap<String, Location> locations = new HashMap<String, Location>(fields.size());
        for (BLangSimpleVariable field : fields) {
            locations.put(field.name.value, field.pos);
        }
        return locations;
    }

    public class AnalyzerData {
        SymbolEnv env;
        BType expType;
        Map<BVarSymbol, BType.NarrowedTypes> narrowedTypeInfo;
        boolean notCompletedNormally;
        boolean breakFound;
        Types.CommonAnalyzerData commonAnalyzerData = new Types.CommonAnalyzerData();
        Deque<SymbolEnv> prevEnvs = new ArrayDeque<SymbolEnv>();
        TypeChecker typeChecker;

        public AnalyzerData(SymbolEnv env) {
            this.typeChecker = TypeChecker.getInstance(SemanticAnalyzer.this.compilerContext);
            this.env = env;
        }
    }
}

