/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import org.ballerinalang.model.Name;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BAnyType
extends BType
implements SelectivelyImmutableReferenceType {
    private boolean nullable = true;

    public BAnyType() {
        this((SemType)PredefinedType.ANY);
    }

    public BAnyType(Name name, long flag) {
        this(name, flag, (SemType)(Symbols.isFlagOn(flag, 32L) ? Core.intersect((SemType)PredefinedType.ANY, (SemType)PredefinedType.VAL_READONLY) : PredefinedType.ANY));
    }

    private BAnyType(Name name, long flags, SemType semType) {
        super(18, null, semType);
        this.name = name;
        this.setFlags(flags);
    }

    private BAnyType(SemType semType) {
        super(18, null, semType);
    }

    public static BAnyType newNilLiftedBAnyType() {
        BAnyType result = new BAnyType(Core.diff((SemType)PredefinedType.ANY, (SemType)PredefinedType.NIL));
        result.nullable = false;
        return result;
    }

    public static BAnyType newImmutableBAnyType() {
        return new BAnyType(Types.getImmutableTypeName(TypeKind.ANY.typeName()), 32L);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ANY;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? this.getKind().typeName() : this.getKind().typeName().concat(" & readonly");
    }
}

