/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import org.ballerinalang.model.types.ConstrainedType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BFutureType
extends BType
implements ConstrainedType {
    public BType constraint;
    public boolean workerDerivative;
    private final Env env;

    public BFutureType(Env env, BType constraint, BTypeSymbol tsymbol) {
        super(32, tsymbol);
        this.constraint = constraint;
        this.env = env;
    }

    public BFutureType(Env env, BType constraint, BTypeSymbol tsymbol, boolean workerDerivative) {
        this(env, constraint, tsymbol);
        this.workerDerivative = workerDerivative;
    }

    public BFutureType(Env env, BType constraint, BTypeSymbol tsymbol, SemType semType) {
        this(env, constraint, tsymbol);
        this.semType = semType;
    }

    @Override
    public BType getConstraint() {
        return this.constraint;
    }

    public void setConstraint(BType constraint) {
        this.constraint = constraint;
        this.semType = null;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.FUTURE;
    }

    @Override
    public String toString() {
        if (this.constraint.tag == 24 || this.constraint.tag == 28 || this.constraint.tag == 10) {
            return super.toString();
        }
        return super.toString() + "<" + String.valueOf(this.constraint) + ">";
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SemType semType() {
        if (this.semType != null) {
            return this.semType;
        }
        this.semType = this.constraint == null || this.constraint instanceof BNoType ? PredefinedType.FUTURE : SemTypes.futureContaining((Env)this.env, (SemType)this.constraint.semType());
        return this.semType;
    }
}

