/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.types.IntersectionType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Name;

public class BIntersectionType
extends BType
implements IntersectionType {
    public BType effectiveType;
    private LinkedHashSet<BType> constituentTypes;

    public BIntersectionType(BTypeSymbol tsymbol, LinkedHashSet<BType> types, BType effectiveType) {
        super(22, tsymbol);
        this.constituentTypes = BIntersectionType.toFlatTypeSet(types);
        for (BType constituentType : this.constituentTypes) {
            if (constituentType.tag != 38) continue;
            this.addFlags(32L);
            break;
        }
        this.effectiveType = effectiveType;
    }

    public BIntersectionType(BTypeSymbol tsymbol) {
        super(22, tsymbol);
    }

    public BIntersectionType(BTypeSymbol tsymbol, LinkedHashSet<BType> types, BType effectiveType, long flags) {
        super(22, tsymbol, flags);
        this.constituentTypes = BIntersectionType.toFlatTypeSet(types);
        this.effectiveType = effectiveType;
    }

    public Set<BType> getConstituentTypes() {
        return Collections.unmodifiableSet(this.constituentTypes);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.INTERSECTION;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    public void setConstituentTypes(LinkedHashSet<BType> constituentTypes) {
        this.constituentTypes = BIntersectionType.toFlatTypeSet(constituentTypes);
    }

    @Override
    public String toString() {
        Name name = this.tsymbol.name;
        if (!Symbols.isFlagOn(this.tsymbol.flags, 2048L) && !name.value.isEmpty()) {
            return name.value;
        }
        StringJoiner joiner = new StringJoiner(" & ", "(", ")");
        for (BType constituentType : this.constituentTypes) {
            if (constituentType.tag == 10) {
                joiner.add("()");
                continue;
            }
            joiner.add(constituentType.toString());
        }
        return joiner.toString();
    }

    private static LinkedHashSet<BType> toFlatTypeSet(LinkedHashSet<BType> types) {
        LinkedHashSet<BType> flatSet = new LinkedHashSet<BType>();
        for (BType type : types) {
            if (type.tag != 22) {
                flatSet.add(type);
                continue;
            }
            flatSet.addAll(((BIntersectionType)type).constituentTypes);
        }
        return flatSet;
    }

    public BType getEffectiveType() {
        return this.effectiveType;
    }

    @Override
    public void resetSemType() {
        this.semType = null;
    }

    @Override
    public SemType semType() {
        return this.computeResultantIntersection();
    }

    private SemType computeResultantIntersection() {
        BasicTypeBitSet t = PredefinedType.VAL;
        for (BType constituentType : this.getConstituentTypes()) {
            t = SemTypes.intersect((SemType)t, (SemType)constituentType.semType());
        }
        BType referredType = Types.getReferredType(this.effectiveType);
        if (referredType instanceof BErrorType) {
            BErrorType effErr = (BErrorType)referredType;
            t = effErr.distinctIdWrapper((SemType)t);
        } else if (referredType instanceof BObjectType) {
            BObjectType effObj = (BObjectType)referredType;
            t = effObj.distinctIdWrapper((SemType)t);
        }
        return t;
    }
}

