/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.Member;
import io.ballerina.types.definition.ObjectDefinition;
import io.ballerina.types.definition.ObjectQualifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.ballerinalang.model.types.ObjectType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;

public class BObjectType
extends BStructureType
implements ObjectType {
    private static final String OBJECT = "object";
    private static final String SPACE = " ";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String LEFT_CURL = "{";
    private static final String RIGHT_CURL = "}";
    private static final String SEMI_COLON = ";";
    private static final String READONLY = "readonly";
    private final Env env;
    public boolean markedIsolatedness;
    public BObjectType mutableType = null;
    public BLangClassDefinition classDef = null;
    public BTypeIdSet typeIdSet = new BTypeIdSet();
    private ObjectDefinition od = null;
    private final DistinctIdSupplier distinctIdSupplier;

    public BObjectType(Env env, BTypeSymbol tSymbol) {
        super(34, tSymbol);
        assert (env != null);
        this.env = env;
        this.distinctIdSupplier = new DistinctIdSupplier(env);
    }

    public BObjectType(Env env, BTypeSymbol tSymbol, long flags) {
        super(34, tSymbol, flags);
        assert (env != null);
        this.env = env;
        this.distinctIdSupplier = new DistinctIdSupplier(env);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OBJECT;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    private boolean hasTypeHoles() {
        return this.fields.values().stream().anyMatch(field -> field.type instanceof BNoType);
    }

    @Override
    public void resetSemType() {
        this.od = null;
    }

    @Override
    public SemType semType() {
        return this.distinctIdWrapper(this.semTypeInner());
    }

    SemType distinctIdWrapper(SemType semTypeInner) {
        return this.distinctIdSupplier.get().stream().map(SemTypes::objectDistinct).reduce(semTypeInner, Core::intersect);
    }

    private SemType semTypeInner() {
        if (this.od != null) {
            return this.od.getSemType(this.env);
        }
        this.od = new ObjectDefinition();
        assert (!this.hasTypeHoles()) : "unimplemented";
        ArrayList members = new ArrayList(this.fields.size());
        ObjectQualifiers qualifiers = this.getObjectQualifiers();
        HashSet<String> memberNames = new HashSet<String>();
        for (BField field : this.fields.values()) {
            Optional<Member> member = BObjectType.createMember(field, qualifiers.readonly(), memberNames);
            member.ifPresent(members::add);
        }
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)this.tsymbol;
        for (BAttachedFunction fun : objectSymbol.attachedFuncs) {
            Optional<Member> member = BObjectType.createMember(fun, memberNames);
            member.ifPresent(members::add);
        }
        return this.od.define(this.env, qualifiers, members);
    }

    private static Optional<Member> createMember(BAttachedFunction func, Set<String> visitedFields) {
        Object name = func.funcName.value;
        if (Symbols.isFlagOn(func.symbol.flags, 32768L)) {
            name = "$remote$" + (String)name;
        }
        if (visitedFields.contains(name)) {
            return Optional.empty();
        }
        visitedFields.add((String)name);
        Member.Visibility visibility = Symbols.isFlagOn(func.symbol.flags, 1L) ? Member.Visibility.Public : Member.Visibility.Private;
        SemType type = func.semType();
        assert (type != null) : "function type is fully implemented";
        assert (!Core.isNever((SemType)type)) : "method can't be never";
        return Optional.of(new Member((String)name, type, Member.Kind.Method, visibility, true));
    }

    private static Optional<Member> createMember(BField field, boolean readonlyObject, Set<String> visitedFields) {
        boolean immutableField;
        String name = field.name.value;
        if (visitedFields.contains(name)) {
            return Optional.empty();
        }
        visitedFields.add(name);
        Member.Visibility visibility = Symbols.isFlagOn(field.symbol.flags, 1L) ? Member.Visibility.Public : Member.Visibility.Private;
        SemType type = field.type.semType();
        if (type == null) {
            type = PredefinedType.NEVER;
        }
        if (readonlyObject || Symbols.isFlagOn(field.symbol.flags, 32L)) {
            type = Core.intersect((SemType)type, (SemType)PredefinedType.VAL_READONLY);
            immutableField = true;
        } else {
            immutableField = false;
        }
        return Optional.of(new Member(name, type, Member.Kind.Field, visibility, immutableField));
    }

    private ObjectQualifiers getObjectQualifiers() {
        long flags = this.tsymbol.flags;
        boolean isolated = Symbols.isFlagOn(this.tsymbol.flags, 0x20000000L);
        ObjectQualifiers.NetworkQualifier networkQualifier = Symbols.isFlagOn(flags, 262144L) ? ObjectQualifiers.NetworkQualifier.Service : (Symbols.isFlagOn(flags, 65536L) ? ObjectQualifiers.NetworkQualifier.Client : ObjectQualifiers.NetworkQualifier.None);
        boolean readonly = Symbols.isFlagOn(this.tsymbol.flags, 32L);
        return new ObjectQualifiers(isolated, readonly, networkQualifier);
    }

    @Override
    public String toString() {
        if (this.shouldPrintShape()) {
            StringBuilder sb = new StringBuilder();
            long symbolFlags = this.tsymbol.flags;
            if (Symbols.isFlagOn(symbolFlags, 0x20000000L)) {
                sb.append("isolated ");
            }
            sb.append(OBJECT).append(SPACE).append(LEFT_CURL);
            for (BField field : this.fields.values()) {
                long flags = field.symbol.flags;
                if (Symbols.isFlagOn(flags, 1L)) {
                    sb.append(SPACE).append(PUBLIC);
                } else if (Symbols.isFlagOn(flags, 1024L)) {
                    sb.append(SPACE).append(PRIVATE);
                }
                if (Symbols.isFlagOn(flags, 4L)) {
                    sb.append(SPACE).append("final");
                }
                sb.append(SPACE).append(field.type).append(SPACE).append(field.name).append(SEMI_COLON);
            }
            BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)this.tsymbol;
            for (BAttachedFunction fun : objectSymbol.attachedFuncs) {
                if (!Symbols.isResource(fun.symbol)) {
                    if (Symbols.isFlagOn(fun.symbol.flags, 1L)) {
                        sb.append(SPACE).append(PUBLIC);
                    } else if (Symbols.isFlagOn(fun.symbol.flags, 1024L)) {
                        sb.append(SPACE).append(PRIVATE);
                    }
                }
                sb.append(SPACE).append(fun).append(SEMI_COLON);
            }
            sb.append(SPACE).append(RIGHT_CURL);
            if (Symbols.isFlagOn(symbolFlags, 32L)) {
                sb.append(" & readonly");
            }
            return sb.toString();
        }
        return this.tsymbol.toString();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    private final class DistinctIdSupplier
    implements Supplier<List<Integer>> {
        private List<Integer> ids = null;
        private static final Map<Env, Map<BTypeIdSet.BTypeId, Integer>> allocatedIds = Collections.synchronizedMap(new WeakHashMap());
        private final Env env;

        private DistinctIdSupplier(Env env) {
            this.env = env;
            allocatedIds.putIfAbsent(env, new ConcurrentHashMap());
        }

        @Override
        public synchronized List<Integer> get() {
            if (this.ids != null) {
                return this.ids;
            }
            Map<BTypeIdSet.BTypeId, Integer> envAllocatedIds = allocatedIds.get(this.env);
            this.ids = BObjectType.this.typeIdSet.getAll().stream().map(each -> envAllocatedIds.computeIfAbsent((BTypeIdSet.BTypeId)each, key -> this.env.distinctAtomCountGetAndIncrement())).toList();
            return this.ids;
        }
    }
}

