/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

public abstract class BStructureType
extends BType {
    private static final String DOLLAR = "$";
    public LinkedHashMap<String, BField> fields = new LinkedHashMap();
    public List<BType> typeInclusions = new ArrayList<BType>();

    public BStructureType(int tag, BTypeSymbol tSymbol) {
        super(tag, tSymbol);
    }

    public BStructureType(int tag, BTypeSymbol tSymbol, long flags) {
        super(tag, tSymbol, flags);
    }

    public LinkedHashMap<String, BField> getFields() {
        return this.fields;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean shouldPrintShape() {
        Name name = this.tsymbol.name;
        if (name == null) {
            return false;
        }
        String value = name.value;
        if (value.isEmpty() || value.startsWith(DOLLAR)) {
            return true;
        }
        if (!Symbols.isFlagOn(this.tsymbol.flags, 32L)) {
            return false;
        }
        return value.startsWith("($");
    }
}

