/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.ListDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ballerinalang.model.types.TupleType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BTupleType
extends BType
implements TupleType {
    private List<BTupleMember> members;
    private List<BType> memberTypes;
    public BType restType;
    public boolean resolvingToString = false;
    public boolean isCyclic = false;
    public BTupleType mutableType;
    private final Env env;
    private ListDefinition ld = null;

    public BTupleType(Env env, List<BTupleMember> members) {
        super(31, null);
        this.members = members;
        this.env = env;
    }

    public BTupleType(Env env, BTypeSymbol tsymbol, List<BTupleMember> members) {
        super(31, tsymbol);
        this.members = members;
        this.env = env;
    }

    public BTupleType(Env env, BTypeSymbol tsymbol, List<BTupleMember> members, boolean isCyclic) {
        super(31, tsymbol);
        this.members = members;
        this.isCyclic = isCyclic;
        this.env = env;
    }

    public BTupleType(Env env, BTypeSymbol tsymbol, List<BTupleMember> members, BType restType, long flags) {
        super(31, tsymbol, flags);
        this.members = members;
        this.restType = restType;
        this.env = env;
    }

    public BTupleType(Env env, BTypeSymbol tsymbol, List<BTupleMember> members, BType restType, long flags, boolean isCyclic) {
        super(31, tsymbol, flags);
        this.members = members;
        this.restType = restType;
        this.isCyclic = isCyclic;
        this.env = env;
    }

    public BTupleType(Env env, BTypeSymbol tsymbol) {
        this(env, tsymbol, true);
    }

    private BTupleType(Env env, BTypeSymbol tsymbol, boolean readonly) {
        super(31, tsymbol);
        if (readonly) {
            this.addFlags(32L);
            if (tsymbol != null) {
                this.tsymbol.flags |= 0x20L;
            }
        }
        this.env = env;
    }

    protected void restLd() {
        this.ld = null;
    }

    public List<BType> getTupleTypes() {
        if (this.memberTypes == null) {
            this.memberTypes = new ArrayList<BType>(this.members.size());
            this.members.forEach(member -> this.memberTypes.add(member.type));
        }
        return this.memberTypes;
    }

    public List<BTupleMember> getMembers() {
        return this.members;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TUPLE;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.resolvingToString) {
            if (this.tsymbol != null && !this.tsymbol.getName().getValue().isEmpty()) {
                return this.tsymbol.toString();
            }
            return "...";
        }
        this.resolvingToString = true;
        String stringRep = "[" + this.members.stream().map(BTupleMember::toString).collect(Collectors.joining(",")) + (String)(this.restType != null ? (!this.members.isEmpty() ? "," : "") + this.restType.toString() + "...]" : "]");
        this.resolvingToString = false;
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? stringRep : stringRep.concat(" & readonly");
    }

    public boolean addMembers(BTupleMember member) {
        this.ld = null;
        if (member.type instanceof BTupleType && ((BTupleType)member.type).isCyclic && member.type.getQualifiedTypeName().equals(this.getQualifiedTypeName())) {
            return false;
        }
        this.members.add(member);
        if (this.memberTypes != null) {
            this.memberTypes.add(member.type);
        }
        if (Symbols.isFlagOn(this.getFlags(), 32L) && !Symbols.isFlagOn(member.type.getFlags(), 32L)) {
            this.setFlags(this.getFlags() ^ 0x20L);
        }
        this.setCyclicFlag(member.type);
        return true;
    }

    public boolean addRestType(BType restType) {
        this.ld = null;
        if (restType != null && restType instanceof BTupleType && ((BTupleType)restType).isCyclic && restType.getQualifiedTypeName().equals(this.getQualifiedTypeName()) && this.members.isEmpty()) {
            return false;
        }
        this.restType = restType;
        if (Symbols.isFlagOn(this.getFlags(), 32L) && !Symbols.isFlagOn(restType.getFlags(), 32L)) {
            this.setFlags(this.getFlags() ^ 0x20L);
        }
        this.setCyclicFlag(restType);
        return true;
    }

    public void setMembers(List<BTupleMember> members) {
        assert (members.isEmpty());
        this.memberTypes = null;
        this.members = members;
        this.ld = null;
    }

    private void setCyclicFlag(BType type) {
        if (this.isCyclic) {
            return;
        }
        if (type instanceof BArrayType) {
            BArrayType arrayType = (BArrayType)type;
            if (arrayType.eType == this) {
                this.isCyclic = true;
            }
        }
        if (type instanceof BMapType) {
            BMapType mapType = (BMapType)type;
            if (mapType.constraint == this) {
                this.isCyclic = true;
            }
        }
        if (type instanceof BTableType) {
            BType bType;
            BTableType tableType = (BTableType)type;
            if (tableType.constraint == this) {
                this.isCyclic = true;
            }
            if ((bType = tableType.constraint) instanceof BMapType) {
                BMapType mapType = (BMapType)bType;
                if (mapType.constraint == this) {
                    this.isCyclic = true;
                }
            }
        }
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    private boolean hasTypeHoles() {
        if (this.members != null) {
            for (BTupleMember member : this.members) {
                if (!(member.type instanceof BNoType)) continue;
                return true;
            }
        }
        if (this.restType != null) {
            return this.restType instanceof BNoType;
        }
        return false;
    }

    @Override
    public void resetSemType() {
        this.ld = null;
    }

    @Override
    public SemType semType() {
        BasicTypeBitSet restSemType;
        CellAtomicType.CellMutability mut;
        if (this.ld != null) {
            return this.ld.getSemType(this.env);
        }
        this.ld = new ListDefinition();
        if (this.hasTypeHoles()) {
            return this.ld.defineListTypeWrapped(this.env, (SemType)PredefinedType.VAL);
        }
        boolean isReadonly = Symbols.isFlagOn(this.getFlags(), 32L);
        CellAtomicType.CellMutability cellMutability = mut = isReadonly ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        if (this.members == null) {
            if (this.restType == null) {
                throw new IllegalStateException("Both members and rest type can't be null");
            }
            SemType restSemType2 = this.restType.semType();
            return this.ld.defineListTypeWrapped(this.env, List.of(), 0, (SemType)Objects.requireNonNullElse(restSemType2, PredefinedType.NEVER), mut);
        }
        ArrayList<SemType> memberSemTypes = new ArrayList<SemType>(this.members.size());
        for (BTupleMember member : this.members) {
            BType memberType = member.type;
            SemType semType = memberType.semType();
            if (semType == null) {
                semType = PredefinedType.NEVER;
            }
            memberSemTypes.add(semType);
        }
        Object object = restSemType = this.restType != null ? this.restType.semType() : PredefinedType.NEVER;
        if (restSemType == null) {
            restSemType = PredefinedType.NEVER;
        }
        return this.ld.defineListTypeWrapped(this.env, memberSemTypes, memberSemTypes.size(), (SemType)restSemType, mut);
    }

    @Override
    public void setFlags(long flags) {
        super.setFlags(flags);
        this.restLd();
    }

    @Override
    public void addFlags(long flags) {
        super.addFlags(flags);
        this.restLd();
    }
}

