/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.HashSet;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Names;

public class BXMLType
extends BType
implements SelectivelyImmutableReferenceType {
    public BType constraint;
    public BXMLType mutableType;

    public BXMLType(BType constraint, BTypeSymbol tsymbol) {
        super(8, tsymbol);
        this.constraint = constraint;
    }

    public BXMLType(BType constraint, BTypeSymbol tsymbol, long flags) {
        super(8, tsymbol, flags);
        this.constraint = constraint;
    }

    @Override
    public String toString() {
        Object stringRep = this.constraint != null && (this.constraint.tag != 21 || !(this.constraint instanceof BUnionType) || ((HashSet)((BUnionType)this.constraint).getMemberTypes()).size() != 4) ? Names.XML.value + "<" + String.valueOf(this.constraint) + ">" : Names.XML.value;
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? stringRep : ((String)stringRep).concat(" & readonly");
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.XML;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SemType semType() {
        BasicTypeBitSet s;
        if (this.semType != null) {
            return this.semType;
        }
        if (this.constraint == null) {
            s = PredefinedType.XML;
        } else {
            SemType contraintSemtype;
            BType bType = this.constraint;
            if (bType instanceof BParameterizedType) {
                BParameterizedType parameterizedType = (BParameterizedType)bType;
                contraintSemtype = parameterizedType.paramValueType.semType();
            } else {
                contraintSemtype = this.constraint.semType();
            }
            if (contraintSemtype == null || !Core.isSubtypeSimple((SemType)contraintSemtype, (BasicTypeBitSet)PredefinedType.XML)) {
                contraintSemtype = PredefinedType.NEVER;
            }
            s = SemTypes.xmlSequence((SemType)contraintSemtype);
        }
        boolean readonly = Symbols.isFlagOn(this.getFlags(), 32L);
        this.semType = readonly ? SemTypes.intersect((SemType)PredefinedType.VAL_READONLY, (SemType)s) : s;
        return this.semType;
    }
}

