/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.clauses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.clauses.GroupByClauseNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;

public class BLangGroupByClause
extends BLangNode
implements GroupByClauseNode {
    public List<BLangGroupingKey> groupingKeyList = new ArrayList<BLangGroupingKey>();
    public SymbolEnv env;
    public Set<String> nonGroupingKeys = new HashSet<String>();

    @Override
    public void addGroupingKey(BLangGroupingKey groupingKey) {
        this.groupingKeyList.add(groupingKey);
    }

    @Override
    public List<BLangGroupingKey> getGroupingKeyList() {
        return this.groupingKeyList;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.GROUP_BY;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    public String toString() {
        StringJoiner declarations = new StringJoiner(", ");
        for (BLangGroupingKey groupingKey : this.groupingKeyList) {
            declarations.add(groupingKey.toString());
        }
        return "group by " + String.valueOf(declarations);
    }
}

