/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.FieldBasedAccessNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.FieldKind;

public class BLangFieldBasedAccess
extends BLangAccessExpression
implements FieldBasedAccessNode {
    public BLangIdentifier field;
    public FieldKind fieldKind;
    public BVarSymbol varSymbol;
    public boolean isStoreOnCreation = false;

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public BLangIdentifier getFieldName() {
        return this.field;
    }

    @Override
    public boolean isOptionalFieldAccess() {
        return this.optionalFieldAccess;
    }

    public String toString() {
        return String.valueOf(this.expr) + (this.optionalFieldAccess ? "?." : ".") + String.valueOf(this.field);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.FIELD_BASED_ACCESS_EXPR;
    }

    public static class BLangPrefixedFieldBasedAccess
    extends BLangFieldBasedAccess {
        public BLangIdentifier prefix;
        public BSymbol symbol;

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return String.valueOf(this.expr) + "." + String.valueOf(this.prefix) + ":" + String.valueOf(this.field);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }

    public static class BLangStructFunctionVarRef
    extends BLangFieldBasedAccess {
        public BLangStructFunctionVarRef(BLangExpression varRef, BVarSymbol varSymbol) {
            this.expr = varRef;
            this.symbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }
}

