/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.ActionNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.InvocationNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;

public class BLangInvocation
extends BLangExpression
implements InvocationNode {
    public BLangIdentifier pkgAlias;
    public BLangIdentifier name;
    public BLangExpression expr;
    public List<BLangExpression> argExprs = new ArrayList<BLangExpression>();
    public List<BLangAnnotationAttachment> annAttachments = new ArrayList<BLangAnnotationAttachment>();
    public List<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
    public List<BLangExpression> restArgs = new ArrayList<BLangExpression>();
    public boolean objectInitMethod;
    public Set<Flag> flagSet;
    public boolean async;
    public BSymbol exprSymbol;
    public boolean functionPointerInvocation;
    public boolean langLibInvocation;
    public BSymbol symbol;

    @Override
    public IdentifierNode getPackageAlias() {
        return this.pkgAlias;
    }

    @Override
    public IdentifierNode getName() {
        return this.name;
    }

    @Override
    public List<? extends ExpressionNode> getArgumentExpressions() {
        return this.argExprs;
    }

    @Override
    public List<? extends ExpressionNode> getRequiredArgs() {
        return this.requiredArgs;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.INVOCATION;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        if (this.expr != null) {
            br.append(this.expr).append(".");
        } else if (this.pkgAlias != null && !this.pkgAlias.getValue().isEmpty()) {
            br.append(this.pkgAlias).append(":");
        }
        br.append(this.name == null ? String.valueOf(this.symbol.name) : String.valueOf(this.name));
        br.append("(");
        if (!this.argExprs.isEmpty()) {
            String s = Arrays.toString(this.argExprs.toArray());
            br.append(s, 1, s.length() - 1);
        }
        br.append(")");
        return br.toString();
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public boolean isIterableOperation() {
        return false;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public Set<Flag> getFlags() {
        return this.flagSet;
    }

    @Override
    public void addFlag(Flag flag) {
        this.getFlags().add(flag);
    }

    public List<BLangAnnotationAttachment> getAnnotationAttachments() {
        return this.annAttachments;
    }

    @Override
    public void addAnnotationAttachment(AnnotationAttachmentNode annAttachment) {
        this.getAnnotationAttachments().add((BLangAnnotationAttachment)annAttachment);
    }

    public static class BLangResourceAccessInvocation
    extends BLangInvocation
    implements ActionNode {
        public boolean invokedInsideTransaction = false;
        public BLangListConstructorExpr resourceAccessPathSegments;
        public BResourceFunction targetResourceFunc;

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }

        @Override
        public String toString() {
            StringBuilder br = new StringBuilder();
            br.append(this.expr).append("->/");
            StringJoiner joiner = new StringJoiner("/");
            this.resourceAccessPathSegments.exprs.forEach(item -> joiner.add(item.toString()));
            br.append(joiner.toString());
            br.append(".");
            br.append(this.name == null ? String.valueOf(this.symbol.name) : String.valueOf(this.name));
            br.append("(");
            StringJoiner joiner1 = new StringJoiner(",");
            this.argExprs.forEach(item -> joiner1.add(item.toString()));
            br.append(joiner1.toString());
            br.append(")");
            return br.toString();
        }
    }

    public static class BLangActionInvocation
    extends BLangInvocation
    implements ActionNode {
        public boolean remoteMethodCall = false;
        public boolean invokedInsideTransaction = false;

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }

    public static class BLangAttachedFunctionInvocation
    extends BLangInvocation {
        public BLangExpression expr;

        public BLangAttachedFunctionInvocation(Location pos, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BSymbol symbol, BType type, BLangExpression expr, boolean async) {
            this.pos = pos;
            this.requiredArgs = requiredArgs;
            this.restArgs = restArgs;
            this.symbol = symbol;
            this.setBType(type);
            this.expr = expr;
            this.async = async;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }

    public static class BFunctionPointerInvocation
    extends BLangInvocation {
        public BFunctionPointerInvocation(Location location, BLangExpression varRef, BSymbol bSymbol, BType retType) {
            this.pos = location;
            this.expr = varRef;
            this.symbol = bSymbol;
            this.setBType(retType);
        }

        public BFunctionPointerInvocation(BLangInvocation parent, BLangExpression varRef) {
            this.pkgAlias = parent.pkgAlias;
            this.pos = parent.pos;
            this.name = parent.name;
            this.requiredArgs = parent.requiredArgs;
            this.restArgs = parent.restArgs;
            this.symbol = parent.symbol;
            this.async = parent.async;
            this.expr = varRef;
            this.annAttachments = parent.annAttachments;
            this.setBType(parent.getBType());
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }
}

