/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.ListConstructorExprNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BLangListConstructorExpr
extends BLangExpression
implements ListConstructorExprNode {
    public List<BLangExpression> exprs;
    public boolean isTypedescExpr = false;
    public BType typedescType = null;

    @Override
    public NodeKind getKind() {
        return NodeKind.LIST_CONSTRUCTOR_EXPR;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    public List<BLangExpression> getExpressions() {
        return this.exprs;
    }

    public String toString() {
        return Arrays.toString(this.exprs.toArray());
    }

    public static class BLangListConstructorSpreadOpExpr
    extends BLangExpression {
        public BLangExpression expr;

        public BLangExpression getExpression() {
            return this.expr;
        }

        public void setExpression(ExpressionNode expr) {
            this.expr = (BLangExpression)expr;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.LIST_CONSTRUCTOR_SPREAD_OP;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }

    public static class BLangJSONArrayLiteral
    extends BLangArrayLiteral {
        public BLangJSONArrayLiteral(List<BLangExpression> exprs, BType jsonType) {
            this.exprs = exprs;
            this.setBType(jsonType);
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangTupleLiteral
    extends BLangListConstructorExpr {
        public BLangTupleLiteral() {
            this.exprs = new ArrayList();
        }

        public BLangTupleLiteral(Location pos, List<BLangExpression> exprs, BType tupleType) {
            this.pos = pos;
            this.exprs = exprs;
            this.setBType(tupleType);
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.TUPLE_LITERAL_EXPR;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangArrayLiteral
    extends BLangListConstructorExpr {
        public BLangArrayLiteral() {
            this.exprs = new ArrayList();
        }

        public BLangArrayLiteral(Location pos, List<BLangExpression> exprs, BType tupleType) {
            this.pos = pos;
            this.exprs = exprs;
            this.setBType(tupleType);
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.ARRAY_LITERAL_EXPR;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

