/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.MarkdownDocumentationParameterAttributeNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BLangMarkdownParameterDocumentation
extends BLangExpression
implements MarkdownDocumentationParameterAttributeNode {
    public BLangIdentifier parameterName;
    public List<String> parameterDocumentationLines = new LinkedList<String>();
    public BVarSymbol symbol;

    @Override
    public IdentifierNode getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(IdentifierNode parameterName) {
        this.parameterName = (BLangIdentifier)parameterName;
    }

    @Override
    public List<String> getParameterDocumentationLines() {
        return this.parameterDocumentationLines;
    }

    @Override
    public void addParameterDocumentationLine(String text) {
        this.parameterDocumentationLines.add(text);
    }

    @Override
    public String getParameterDocumentation() {
        return this.parameterDocumentationLines.stream().collect(Collectors.joining("\n")).replace("\r", "");
    }

    @Override
    public BVarSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(BVarSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.DOCUMENTATION_PARAMETER;
    }

    public String toString() {
        return "BLangMarkdownParameterDocumentation: " + String.valueOf(this.parameterName) + " : " + String.valueOf(this.parameterDocumentationLines);
    }
}

