/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import io.ballerina.tools.diagnostics.Location;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.VariableReferenceNode;
import org.ballerinalang.model.tree.statements.AssignmentNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangAssignment
extends BLangStatement
implements AssignmentNode {
    public BLangExpression varRef;
    public BLangExpression expr;

    public BLangAssignment() {
    }

    public BLangAssignment(Location pos, BLangExpression varRef, BLangExpression expr) {
        this.pos = pos;
        this.varRef = varRef;
        this.expr = expr;
    }

    @Override
    public ExpressionNode getVariable() {
        return this.varRef;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    @Deprecated
    public boolean isDeclaredWithVar() {
        return false;
    }

    @Override
    public void setExpression(ExpressionNode expression) {
        this.expr = (BLangExpression)expression;
    }

    @Override
    @Deprecated
    public void setDeclaredWithVar(boolean isDeclaredWithVar) {
    }

    @Override
    public void setVariable(VariableReferenceNode variableReferenceNode) {
        this.varRef = (BLangExpression)((Object)variableReferenceNode);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ASSIGNMENT;
    }

    public String toString() {
        return String.valueOf(this.varRef != null ? this.varRef : "") + (String)(this.expr != null ? " = " + String.valueOf(this.expr) : ";");
    }
}

