/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.statements.BlockStatementNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangBlockStmt
extends BLangStatement
implements BlockStatementNode {
    public List<BLangStatement> stmts;
    public BVarSymbol mapSymbol;
    public FailureBreakMode failureBreakMode = FailureBreakMode.NOT_BREAKABLE;
    public boolean isLetExpr = false;
    public Scope scope;

    public BLangBlockStmt() {
        this.stmts = new ArrayList<BLangStatement>();
    }

    public List<BLangStatement> getStatements() {
        return this.stmts;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public void addStatement(StatementNode statement) {
        this.stmts.add((BLangStatement)statement);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.BLOCK;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("; ");
        this.stmts.forEach(stmt -> sj.add(stmt.toString()));
        return sj.toString();
    }

    public static enum FailureBreakMode {
        NOT_BREAKABLE,
        BREAK_WITHIN_BLOCK,
        BREAK_TO_OUTER_BLOCK;

    }
}

