/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import io.ballerina.tools.diagnostics.Location;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.clauses.OnFailClauseNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.statements.BlockStatementNode;
import org.ballerinalang.model.tree.statements.LockNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangLock
extends BLangStatement
implements LockNode {
    public BLangBlockStmt body;
    public BLangOnFailClause onFailClause;

    @Override
    public BLangBlockStmt getBody() {
        return this.body;
    }

    @Override
    public void setBody(BlockStatementNode body) {
        this.body = (BLangBlockStmt)body;
    }

    @Override
    public OnFailClauseNode getOnFailClause() {
        return this.onFailClause;
    }

    @Override
    public void setOnFailClause(OnFailClauseNode onFailClause) {
        this.onFailClause = (BLangOnFailClause)onFailClause;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.LOCK;
    }

    public String toString() {
        return "lock {" + (this.body != null ? String.valueOf(this.body) : "") + "}";
    }

    public static class BLangUnLockStmt
    extends BLangStatement {
        public BLangLockStmt relatedLock;

        public BLangUnLockStmt(Location pos) {
            this.pos = pos;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }

        public String toString() {
            return "unlock []";
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.LOCK;
        }
    }

    public static class BLangLockStmt
    extends BLangStatement {
        public Set<BVarSymbol> lockVariables = new HashSet<BVarSymbol>();

        public BLangLockStmt(Location pos) {
            this.pos = pos;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }

        public String toString() {
            return "lock [" + this.lockVariables.stream().map(s -> s.name.value).collect(Collectors.joining(", "));
        }

        public boolean addLockVariable(BVarSymbol variable) {
            return this.lockVariables.add(variable);
        }

        public boolean addLockVariable(Set<BVarSymbol> variables) {
            return this.lockVariables.addAll(variables);
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.LOCK;
        }
    }
}

