/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.FunctionTypeNode;
import org.ballerinalang.model.tree.types.UserDefinedTypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangFunctionTypeNode
extends BLangType
implements FunctionTypeNode {
    public List<BLangSimpleVariable> params = new ArrayList<BLangSimpleVariable>();
    public BLangVariable restParam;
    public BLangType returnTypeNode;
    public Set<Flag> flagSet = new HashSet<Flag>();
    public boolean inTypeDefinitionContext;
    public boolean analyzed;
    public boolean returnsKeywordExists = false;

    @Override
    public BLangVariable getRestParam() {
        return this.restParam;
    }

    public List<BLangSimpleVariable> getParams() {
        return this.params;
    }

    @Override
    public BLangType getReturnTypeNode() {
        return this.returnTypeNode;
    }

    @Override
    public boolean isReturnKeywordExists() {
        return this.returnsKeywordExists;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.FUNCTION_TYPE;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        if (this.flagSet.contains((Object)Flag.ANY_FUNCTION)) {
            return "function";
        }
        br.append("function(");
        if (!this.params.isEmpty()) {
            br.append(this.getParamNames(this.params));
        }
        if (this.returnTypeNode != null) {
            br.append(this.returnsKeywordExists ? ")returns(" : ")(");
            br.append(this.returnTypeNode);
        }
        br.append(")");
        return br.toString();
    }

    private String getParamNames(List<BLangSimpleVariable> paramTypes) {
        return paramTypes.stream().map(paramType -> {
            if (paramType.getKind() == NodeKind.USER_DEFINED_TYPE) {
                return ((UserDefinedTypeNode)((Object)paramType)).getTypeName().getValue();
            }
            return paramType.toString();
        }).collect(Collectors.joining(", "));
    }
}

