/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import java.util.function.Consumer;

public final class LambdaExceptionUtils {
    private LambdaExceptionUtils() {
    }

    public static <T, E extends Exception> Consumer<T> rethrow(ConsumerWithExceptions<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwAsUnchecked(exception);
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface ConsumerWithExceptions<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

