/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import io.ballerina.projects.Settings;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.SettingsBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.util.RepoUtils;

public final class TomlParserUtils {
    private TomlParserUtils() {
    }

    public static Settings readSettings() {
        Path settingsFilePath = RepoUtils.createAndGetHomeReposPath().resolve("Settings.toml");
        try {
            TomlDocument settingsTomlDocument = TomlDocument.from(String.valueOf(settingsFilePath.getFileName()), Files.readString(settingsFilePath));
            SettingsBuilder settingsBuilder = SettingsBuilder.from(settingsTomlDocument);
            return settingsBuilder.settings();
        }
        catch (IOException e) {
            return Settings.from();
        }
    }

    public static Manifest getManifest(Path projectDirPath) {
        Path manifestFilePath = projectDirPath.resolve("Ballerina.toml");
        try {
            return ManifestProcessor.parseTomlContentFromFile(manifestFilePath);
        }
        catch (IOException | TomlException e) {
            return new Manifest();
        }
    }
}

