/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class HttpCompilerPluginUtil {
    private HttpCompilerPluginUtil() {
    }

    public static void updateDiagnostic(SyntaxNodeAnalysisContext ctx, Location location, HttpDiagnostic httpDiagnosticCodes) {
        DiagnosticInfo diagnosticInfo = HttpCompilerPluginUtil.getDiagnosticInfo(httpDiagnosticCodes, new Object[0]);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    public static void updateDiagnostic(SyntaxNodeAnalysisContext ctx, Location location, HttpDiagnostic httpDiagnosticCodes, Object ... argName) {
        DiagnosticInfo diagnosticInfo = HttpCompilerPluginUtil.getDiagnosticInfo(httpDiagnosticCodes, argName);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    public static void updateDiagnostic(SyntaxNodeAnalysisContext ctx, Location location, HttpDiagnostic httpDiagnosticCodes, List<DiagnosticProperty<?>> diagnosticProperties, String argName) {
        DiagnosticInfo diagnosticInfo = HttpCompilerPluginUtil.getDiagnosticInfo(httpDiagnosticCodes, argName);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, diagnosticProperties, (Object[])new Object[0]));
    }

    public static DiagnosticInfo getDiagnosticInfo(HttpDiagnostic diagnostic, Object ... args) {
        return new DiagnosticInfo(diagnostic.getCode(), String.format(diagnostic.getMessage(), args), diagnostic.getSeverity());
    }

    public static String getReturnTypeDescription(ReturnTypeDescriptorNode returnTypeDescriptorNode) {
        return returnTypeDescriptorNode.type().toString().trim();
    }

    public static void extractInterceptorReturnTypeAndValidate(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols, FunctionDefinitionNode member, HttpDiagnostic httpDiagnosticCode) {
        Optional returnTypeDescriptorNode = member.functionSignature().returnTypeDesc();
        if (returnTypeDescriptorNode.isEmpty()) {
            return;
        }
        Node returnTypeNode = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).type();
        String returnType = HttpCompilerPluginUtil.getReturnTypeDescription((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get());
        Optional functionSymbol = ctx.semanticModel().symbol((Node)member);
        if (functionSymbol.isEmpty()) {
            return;
        }
        FunctionTypeSymbol functionTypeSymbol = ((FunctionSymbol)functionSymbol.get()).typeDescriptor();
        Optional returnTypeSymbol = functionTypeSymbol.returnTypeDescriptor();
        if (returnTypeSymbol.isEmpty()) {
            return;
        }
        HttpCompilerPluginUtil.validateResourceReturnType(ctx, returnTypeNode, typeSymbols, returnType, (TypeSymbol)returnTypeSymbol.get(), httpDiagnosticCode, true);
        NodeList annotations = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).annotations();
        if (!annotations.isEmpty()) {
            HttpCompilerPluginUtil.reportReturnTypeAnnotationsAreNotAllowed(ctx, (Node)returnTypeDescriptorNode.get());
        }
    }

    public static void validateResourceReturnType(SyntaxNodeAnalysisContext ctx, Node node, Map<String, TypeSymbol> typeSymbols, String returnTypeStringValue, TypeSymbol returnTypeSymbol, HttpDiagnostic diagnosticCode, boolean isInterceptorType) {
        if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, returnTypeSymbol, isInterceptorType ? "InterceptorResourceReturnType" : "ResourceReturnType")) {
            return;
        }
        HttpCompilerPluginUtil.reportInvalidReturnType(ctx, node, returnTypeStringValue, diagnosticCode);
    }

    public static boolean subtypeOf(Map<String, TypeSymbol> typeSymbols, TypeSymbol typeSymbol, String targetTypeName) {
        TypeSymbol targetTypeSymbol = typeSymbols.get(targetTypeName);
        if (targetTypeSymbol != null) {
            return typeSymbol.subtypeOf(targetTypeSymbol);
        }
        return false;
    }

    public static boolean isHttpModuleType(String expectedType, TypeSymbol typeDescriptor) {
        Optional module = typeDescriptor.getModule();
        if (module.isEmpty()) {
            return false;
        }
        if (!"ballerina".equals(((ModuleSymbol)module.get()).id().orgName()) || !"http".equals(((ModuleSymbol)module.get()).getName().get())) {
            return false;
        }
        Optional typeName = typeDescriptor.getName();
        if (typeName.isEmpty()) {
            return false;
        }
        return expectedType.equals(typeName.get());
    }

    public static boolean isHttpModule(ModuleSymbol moduleSymbol) {
        return "http".equals(moduleSymbol.getName().get()) && "ballerina".equals(moduleSymbol.id().orgName());
    }

    public static TypeDescKind retrieveEffectiveTypeDesc(TypeSymbol descriptor) {
        TypeDescKind typeDescKind = descriptor.typeKind();
        if (typeDescKind == TypeDescKind.INTERSECTION) {
            return ((IntersectionTypeSymbol)descriptor).effectiveTypeDescriptor().typeKind();
        }
        return typeDescKind;
    }

    private static void reportInvalidReturnType(SyntaxNodeAnalysisContext ctx, Node node, String returnType, HttpDiagnostic diagnosticCode) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), diagnosticCode, returnType);
    }

    private static void reportReturnTypeAnnotationsAreNotAllowed(SyntaxNodeAnalysisContext ctx, Node node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_142);
    }

    public static void reportMissingParameterError(SyntaxNodeAnalysisContext ctx, Location location, String method) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_143, method);
    }

    public static String getNodeString(Node node, boolean isCaseSensitive) {
        String nodeString = node.toString().replaceAll("^'|\"|\\n", "").trim();
        return isCaseSensitive ? nodeString : nodeString.toLowerCase(Locale.getDefault());
    }

    public static Map<String, TypeSymbol> getCtxTypes(SyntaxNodeAnalysisContext ctx) {
        HashMap<String, TypeSymbol> typeSymbols = new HashMap<String, TypeSymbol>();
        HttpCompilerPluginUtil.populateRequiredLangTypes(ctx, typeSymbols);
        HttpCompilerPluginUtil.populateHttpModuleTypes(ctx, typeSymbols);
        return typeSymbols;
    }

    private static void populateHttpModuleTypes(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols) {
        String[] requiredTypeNames = new String[]{"ResourceReturnType", "InterceptorResourceReturnType", "Caller", "Request", "RequestContext", "Headers", "Response"};
        Optional optionalMap = ctx.semanticModel().types().typesInModule("ballerina", "http", "");
        if (optionalMap.isPresent()) {
            Map symbolMap = (Map)optionalMap.get();
            for (String typeName : requiredTypeNames) {
                Symbol symbol = (Symbol)symbolMap.get(typeName);
                if (symbol instanceof TypeSymbol) {
                    typeSymbols.put(typeName, (TypeSymbol)symbol);
                    continue;
                }
                if (!(symbol instanceof TypeDefinitionSymbol)) continue;
                typeSymbols.put(typeName, ((TypeDefinitionSymbol)symbol).typeDescriptor());
            }
        }
    }

    private static void populateRequiredLangTypes(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols) {
        Types types = ctx.semanticModel().types();
        HttpCompilerPluginUtil.populateBasicTypes(typeSymbols, types);
        HttpCompilerPluginUtil.populateNilableBasicTypes(typeSymbols, types);
        HttpCompilerPluginUtil.populateBasicArrayTypes(typeSymbols, types);
        HttpCompilerPluginUtil.populateNilableBasicArrayTypes(typeSymbols, types);
    }

    private static void populateBasicArrayTypes(Map<String, TypeSymbol> typeSymbols, Types types) {
        typeSymbols.put("string[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.STRING).build());
        typeSymbols.put("boolean[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.BOOLEAN).build());
        typeSymbols.put("int[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.INT).build());
        typeSymbols.put("float[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.FLOAT).build());
        typeSymbols.put("decimal[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.DECIMAL).build());
        typeSymbols.put("map<anydata>[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType((TypeSymbol)types.builder().MAP_TYPE.withTypeParam(types.ANYDATA).build()).build());
        typeSymbols.put("(map<anydata>|table<map<anydata>>|[anydata...])[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType((TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("map<anydata>"), typeSymbols.get("table<anydata>"), typeSymbols.get("[anydata...]")}).build()).build());
        typeSymbols.put("byte[]", (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.BYTE).build());
    }

    private static void populateBasicTypes(Map<String, TypeSymbol> typeSymbols, Types types) {
        typeSymbols.put("anydata", types.ANYDATA);
        typeSymbols.put("json", types.JSON);
        typeSymbols.put("error", types.ERROR);
        typeSymbols.put("string", types.STRING);
        typeSymbols.put("boolean", types.BOOLEAN);
        typeSymbols.put("int", types.INT);
        typeSymbols.put("float", types.FLOAT);
        typeSymbols.put("decimal", types.DECIMAL);
        typeSymbols.put("xml", types.XML);
        typeSymbols.put("nil", types.NIL);
        typeSymbols.put("object", (TypeSymbol)types.builder().OBJECT_TYPE.build());
        typeSymbols.put("map<anydata>", (TypeSymbol)types.builder().MAP_TYPE.withTypeParam(types.ANYDATA).build());
        typeSymbols.put("table<anydata>", (TypeSymbol)types.builder().TABLE_TYPE.withRowType(typeSymbols.get("map<anydata>")).build());
        typeSymbols.put("[anydata...]", (TypeSymbol)types.builder().TUPLE_TYPE.withRestType(types.ANYDATA).build());
    }

    private static void populateNilableBasicTypes(Map<String, TypeSymbol> typeSymbols, Types types) {
        typeSymbols.put("string?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.STRING, types.NIL}).build());
        typeSymbols.put("boolean?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.BOOLEAN, types.NIL}).build());
        typeSymbols.put("int?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.INT, types.NIL}).build());
        typeSymbols.put("float?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.FLOAT, types.NIL}).build());
        typeSymbols.put("decimal?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.DECIMAL, types.NIL}).build());
        typeSymbols.put("map<anydata>?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("map<anydata>"), types.NIL}).build());
    }

    private static void populateNilableBasicArrayTypes(Map<String, TypeSymbol> typeSymbols, Types types) {
        typeSymbols.put("string[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("string[]"), types.NIL}).build());
        typeSymbols.put("boolean[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("boolean[]"), types.NIL}).build());
        typeSymbols.put("int[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("int[]"), types.NIL}).build());
        typeSymbols.put("float[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("float[]"), types.NIL}).build());
        typeSymbols.put("decimal[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("decimal[]"), types.NIL}).build());
        typeSymbols.put("map<anydata>[]?", (TypeSymbol)types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbols.get("map<anydata>[]"), types.NIL}).build());
    }

    public static boolean diagnosticContainsErrors(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        return diagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
    }

    public static ServiceDeclarationNode getServiceDeclarationNode(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        if (!(node instanceof ServiceDeclarationNode)) {
            return null;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
        return HttpCompilerPluginUtil.getServiceDeclarationNode((Node)serviceDeclarationNode, context.semanticModel());
    }

    public static ServiceDeclarationNode getServiceDeclarationNode(Node node, SemanticModel semanticModel) {
        List listenerTypes;
        if (!(node instanceof ServiceDeclarationNode)) {
            return null;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
        Optional serviceSymOptional = semanticModel.symbol(node);
        if (serviceSymOptional.isPresent() && (listenerTypes = ((ServiceDeclarationSymbol)serviceSymOptional.get()).listenerTypes()).stream().noneMatch(HttpCompilerPluginUtil::isListenerBelongsToHttpModule)) {
            return null;
        }
        return serviceDeclarationNode;
    }

    public static ClassDefinitionNode getServiceClassDefinitionNode(SyntaxNodeAnalysisContext ctx) {
        TypeSymbol serviceTypeSymbol;
        if (ctx.node().kind() != SyntaxKind.CLASS_DEFINITION) {
            return null;
        }
        ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)ctx.node();
        Optional serviceType = ctx.semanticModel().types().getTypeByName("ballerina", "http", "", "Service");
        if (!HttpCompilerPluginUtil.hasServiceKeyWord(classDefinitionNode) || serviceType.isEmpty()) {
            return null;
        }
        Optional symbol = ctx.semanticModel().symbol((Node)classDefinitionNode);
        if (symbol.isEmpty() || ((Symbol)serviceType.get()).kind() != SymbolKind.TYPE_DEFINITION) {
            return null;
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol.get();
        return classSymbol.subtypeOf(serviceTypeSymbol = ((TypeDefinitionSymbol)serviceType.get()).typeDescriptor()) ? classDefinitionNode : null;
    }

    public static AnnotationNode getAnnotationNode(SyntaxNodeAnalysisContext context) {
        if (context.node().kind() != SyntaxKind.ANNOTATION) {
            return null;
        }
        Optional symbol = context.semanticModel().symbol(context.node());
        if (symbol.isPresent()) {
            Optional module = ((Symbol)symbol.get()).getModule();
            if (module.isEmpty() || !HttpCompilerPluginUtil.isHttpModule((ModuleSymbol)module.get())) {
                return null;
            }
            return (AnnotationNode)context.node();
        }
        return context.node().toSourceCode().trim().startsWith(SyntaxKind.AT_TOKEN.stringValue() + "http:") ? (AnnotationNode)context.node() : null;
    }

    private static boolean hasServiceKeyWord(ClassDefinitionNode classDefinitionNode) {
        return classDefinitionNode.classTypeQualifiers().stream().anyMatch(token -> "service".equals(token.text().trim()));
    }

    private static boolean isListenerBelongsToHttpModule(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> HttpCompilerPluginUtil.isHttpModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpCompilerPluginUtil.isHttpModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    public static boolean isServiceObjectType(ObjectTypeDescriptorNode typeNode) {
        return typeNode.objectTypeQualifiers().stream().anyMatch(qualifier -> qualifier.kind().equals((Object)SyntaxKind.SERVICE_KEYWORD));
    }

    public static boolean isHttpServiceType(SemanticModel semanticModel, Node typeNode) {
        Object t;
        Object t2;
        ObjectTypeDescriptorNode serviceObjType;
        if (!(typeNode instanceof ObjectTypeDescriptorNode) || !HttpCompilerPluginUtil.isServiceObjectType(serviceObjType = (ObjectTypeDescriptorNode)typeNode)) {
            return false;
        }
        Optional serviceObjSymbol = semanticModel.symbol((Node)serviceObjType.parent());
        if (serviceObjSymbol.isEmpty() || !((t2 = serviceObjSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceObjTypeDef = (TypeDefinitionSymbol)t2;
        Optional serviceType = semanticModel.types().getTypeByName("ballerina", "http", "", "Service");
        if (serviceType.isEmpty() || !((t = serviceType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceTypeDef = (TypeDefinitionSymbol)t;
        return serviceObjTypeDef.typeDescriptor().subtypeOf(serviceTypeDef.typeDescriptor());
    }

    public static Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }
}

