/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.HttpResourceValidator;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDefinition;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;
import java.util.Optional;

public final class HttpInterceptorResourceValidator {
    private HttpInterceptorResourceValidator() {
    }

    public static void validateResource(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, String type, Map<String, TypeSymbol> typeSymbols) {
        HttpInterceptorResourceValidator.checkResourceAnnotation(ctx, member);
        if (HttpInterceptorResourceValidator.isRequestErrorInterceptor(type)) {
            HttpInterceptorResourceValidator.extractAndValidateMethodAndPath(ctx, member);
        }
        ResourceFunctionDefinition functionNode = new ResourceFunctionDefinition(member);
        HttpResourceValidator.extractInputParamTypeAndValidate(ctx, functionNode, HttpInterceptorResourceValidator.isRequestErrorInterceptor(type), typeSymbols);
        HttpCompilerPluginUtil.extractInterceptorReturnTypeAndValidate(ctx, typeSymbols, member, HttpDiagnostic.HTTP_126);
    }

    private static boolean isRequestErrorInterceptor(String type) {
        return type.equals("RequestErrorInterceptor");
    }

    private static void extractAndValidateMethodAndPath(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member) {
        String method;
        NodeList path = member.relativeResourcePath();
        String resourcePath = path.get(0).toString().strip();
        if (!resourcePath.matches("\\[\\s*(string)\\s*(\\.{3})\\s*\\w+\\s*\\]")) {
            HttpInterceptorResourceValidator.reportInvalidResourcePath(ctx, path.get(0));
        }
        if (!(method = member.functionName().toString().strip()).contains("default")) {
            HttpInterceptorResourceValidator.reportInvalidResourceMethod(ctx, member.functionName());
        }
    }

    private static void checkResourceAnnotation(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member) {
        NodeList annotations;
        Optional metadataNodeOptional = member.metadata();
        if (metadataNodeOptional.isPresent() && !(annotations = ((MetadataNode)metadataNodeOptional.get()).annotations()).isEmpty()) {
            HttpInterceptorResourceValidator.reportResourceAnnotationNotAllowed(ctx, (AnnotationNode)annotations.get(0));
        }
    }

    private static void reportResourceAnnotationNotAllowed(SyntaxNodeAnalysisContext ctx, AnnotationNode node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_125, node.annotReference().toString());
    }

    private static void reportInvalidResourcePath(SyntaxNodeAnalysisContext ctx, Node node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_127, node.toString());
    }

    private static void reportInvalidResourceMethod(SyntaxNodeAnalysisContext ctx, IdentifierToken identifierToken) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)identifierToken.location(), HttpDiagnostic.HTTP_128, identifierToken.toString().strip());
    }
}

