/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeAnalysisContext;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.stdlib.http.compiler.HttpInterceptorServiceValidator;
import io.ballerina.stdlib.http.compiler.HttpServiceObjTypeAnalyzer;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import io.ballerina.stdlib.http.compiler.oas.ServiceContractOasGenerator;
import io.ballerina.stdlib.http.compiler.oas.ServiceOasGenerator;
import java.util.Map;

public class HttpServiceAnalyzer
extends CodeAnalyzer {
    private final Map<String, Object> ctxData;

    public HttpServiceAnalyzer(Map<String, Object> ctxData) {
        this.ctxData = ctxData;
    }

    public void init(CodeAnalysisContext codeAnalysisContext) {
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new HttpServiceObjTypeAnalyzer(), SyntaxKind.OBJECT_TYPE_DESC);
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new HttpServiceValidator(), SyntaxKind.SERVICE_DECLARATION);
        boolean httpCodeModifierExecuted = (Boolean)this.ctxData.getOrDefault("HTTP_CODE_MODIFIER_EXECUTED", false);
        if (httpCodeModifierExecuted) {
            codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ServiceContractOasGenerator(), SyntaxKind.OBJECT_TYPE_DESC);
            codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ServiceOasGenerator(), SyntaxKind.SERVICE_DECLARATION);
        }
        codeAnalysisContext.addSyntaxNodeAnalysisTask((AnalysisTask)new HttpInterceptorServiceValidator(), SyntaxKind.CLASS_DEFINITION);
    }
}

