/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.HttpResourceValidator;
import io.ballerina.stdlib.http.compiler.HttpServiceContractResourceValidator;
import io.ballerina.stdlib.http.compiler.LinkedResource;
import io.ballerina.stdlib.http.compiler.LinkedToResource;
import io.ballerina.stdlib.http.compiler.LinksMetaData;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;

public class HttpServiceValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        HttpServiceValidator.checkForServiceImplementationErrors(syntaxNodeAnalysisContext);
        if (HttpCompilerPluginUtil.diagnosticContainsErrors(syntaxNodeAnalysisContext)) {
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(syntaxNodeAnalysisContext);
        if (serviceDeclarationNode == null) {
            return;
        }
        Optional<TypeDescriptorNode> serviceTypeDesc = HttpServiceValidator.getServiceContractTypeDesc(syntaxNodeAnalysisContext.semanticModel(), serviceDeclarationNode);
        serviceTypeDesc.ifPresent(typeDescriptorNode -> HttpServiceValidator.checkBasePathExistence(syntaxNodeAnalysisContext, serviceDeclarationNode));
        Optional metadataNodeOptional = serviceDeclarationNode.metadata();
        metadataNodeOptional.ifPresent(metadataNode -> HttpServiceValidator.validateServiceAnnotation(syntaxNodeAnalysisContext, metadataNode, serviceTypeDesc.orElse(null), false));
        NodeList members = serviceDeclarationNode.members();
        if (serviceTypeDesc.isPresent()) {
            Set<String> resourcesFromServiceType = HttpServiceValidator.extractMethodsFromServiceType(serviceTypeDesc.get(), syntaxNodeAnalysisContext.semanticModel());
            HttpServiceValidator.validateServiceContractResources(syntaxNodeAnalysisContext, resourcesFromServiceType, (NodeList<Node>)members, serviceTypeDesc.get().toString().trim());
        } else {
            HttpServiceValidator.validateResources(syntaxNodeAnalysisContext, (NodeList<Node>)members);
        }
    }

    public static boolean isServiceContractImplementation(SemanticModel semanticModel, ServiceDeclarationNode node) {
        ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode((Node)node, semanticModel);
        if (serviceDeclarationNode == null) {
            return false;
        }
        return HttpServiceValidator.getServiceContractTypeDesc(semanticModel, serviceDeclarationNode).isPresent();
    }

    private static Optional<TypeDescriptorNode> getServiceContractTypeDesc(SemanticModel semanticModel, Node node) {
        ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(node, semanticModel);
        if (serviceDeclarationNode == null) {
            return Optional.empty();
        }
        return HttpServiceValidator.getServiceContractTypeDesc(semanticModel, serviceDeclarationNode);
    }

    public static Optional<TypeDescriptorNode> getServiceContractTypeDesc(SemanticModel semanticModel, ServiceDeclarationNode serviceDeclaration) {
        Object t;
        Object t2;
        Optional serviceTypeDesc = serviceDeclaration.typeDescriptor();
        if (serviceTypeDesc.isEmpty()) {
            return Optional.empty();
        }
        Optional serviceTypeSymbol = semanticModel.symbol((Node)serviceTypeDesc.get());
        if (serviceTypeSymbol.isEmpty() || !((t2 = serviceTypeSymbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return Optional.empty();
        }
        TypeReferenceTypeSymbol serviceTypeRef = (TypeReferenceTypeSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        if (serviceTypeRef.subtypeOf(serviceContractTypeDef.typeDescriptor())) {
            return serviceTypeDesc;
        }
        return Optional.empty();
    }

    private static Set<String> extractMethodsFromServiceType(TypeDescriptorNode serviceTypeDesc, SemanticModel semanticModel) {
        Object t;
        Optional serviceTypeSymbol = semanticModel.symbol((Node)serviceTypeDesc);
        if (serviceTypeSymbol.isEmpty() || !((t = serviceTypeSymbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return Collections.emptySet();
        }
        TypeReferenceTypeSymbol serviceTypeRef = (TypeReferenceTypeSymbol)t;
        TypeSymbol serviceTypeRefSymbol = serviceTypeRef.typeDescriptor();
        if (!(serviceTypeRefSymbol instanceof ObjectTypeSymbol)) {
            return Collections.emptySet();
        }
        ObjectTypeSymbol serviceObjTypeSymbol = (ObjectTypeSymbol)serviceTypeRefSymbol;
        return serviceObjTypeSymbol.methods().keySet();
    }

    private static void checkBasePathExistence(SyntaxNodeAnalysisContext ctx, ServiceDeclarationNode serviceDeclarationNode) {
        NodeList nodes = serviceDeclarationNode.absoluteResourcePath();
        if (!nodes.isEmpty()) {
            HttpServiceValidator.reportBasePathNotAllowed(ctx, (NodeList<Node>)nodes);
        }
    }

    protected static void validateResources(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, NodeList<Node> members) {
        LinksMetaData linksMetaData = new LinksMetaData();
        for (Node member : members) {
            if (member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                FunctionDefinitionNode node = (FunctionDefinitionNode)member;
                NodeList tokens = node.qualifierList();
                if (tokens.isEmpty() || !tokens.stream().anyMatch(token -> token.text().equals("remote"))) continue;
                HttpServiceValidator.reportInvalidFunctionType(syntaxNodeAnalysisContext, node);
                continue;
            }
            if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                HttpResourceValidator.validateResource(syntaxNodeAnalysisContext, (FunctionDefinitionNode)member, linksMetaData, HttpCompilerPluginUtil.getCtxTypes(syntaxNodeAnalysisContext));
                continue;
            }
            if (member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) continue;
            HttpResourceValidator.validateResource(syntaxNodeAnalysisContext, (MethodDeclarationNode)member, linksMetaData, HttpCompilerPluginUtil.getCtxTypes(syntaxNodeAnalysisContext));
        }
        HttpServiceValidator.validateResourceLinks(syntaxNodeAnalysisContext, linksMetaData);
    }

    private static void validateServiceContractResources(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, Set<String> resourcesFromServiceType, NodeList<Node> members, String serviceTypeName) {
        for (Node member : members) {
            if (member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                FunctionDefinitionNode node = (FunctionDefinitionNode)member;
                NodeList tokens = node.qualifierList();
                if (tokens.isEmpty() || !tokens.stream().anyMatch(token -> token.text().equals("remote"))) continue;
                HttpServiceValidator.reportInvalidFunctionType(syntaxNodeAnalysisContext, node);
                continue;
            }
            if (member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) continue;
            HttpServiceContractResourceValidator.validateResource(syntaxNodeAnalysisContext, (FunctionDefinitionNode)member, resourcesFromServiceType, serviceTypeName);
        }
    }

    private static void checkForServiceImplementationErrors(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        Optional<TypeDescriptorNode> serviceContractTypeDesc = HttpServiceValidator.getServiceContractTypeDesc(context.semanticModel(), node);
        if (serviceContractTypeDesc.isEmpty()) {
            return;
        }
        String serviceType = serviceContractTypeDesc.get().toString().trim();
        NodeLocation location = node.location();
        for (Diagnostic diagnostic : context.semanticModel().diagnostics()) {
            Location diagnosticLocation = diagnostic.location();
            if (!diagnostic.message().contains("no implementation found for the method 'resource function") || !HttpServiceValidator.intersects((Location)location, diagnosticLocation)) continue;
            HttpServiceValidator.enableImplementServiceContractCodeAction(context, serviceType, location);
            return;
        }
    }

    private static boolean intersects(Location targetLocation, Location diagnosticLocation) {
        return targetLocation.lineRange().startLine().line() <= diagnosticLocation.lineRange().startLine().line() && targetLocation.lineRange().endLine().line() >= diagnosticLocation.lineRange().endLine().line() && targetLocation.textRange().intersectionExists(diagnosticLocation.textRange());
    }

    private static void validateResourceLinks(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, LinksMetaData linksMetaData) {
        if (!linksMetaData.hasNameReferenceObjects()) {
            for (Map<String, LinkedToResource> linkedToResourceMap : linksMetaData.getLinkedToResourceMaps()) {
                for (LinkedToResource linkedToResource : linkedToResourceMap.values()) {
                    if (linkedToResource.hasNameRefMethodAvailable()) continue;
                    HttpServiceValidator.checkLinkedResourceExistence(syntaxNodeAnalysisContext, linksMetaData, linkedToResource);
                }
            }
        }
    }

    private static void checkLinkedResourceExistence(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, LinksMetaData linksMetaData, LinkedToResource linkedToResource) {
        if (linksMetaData.getLinkedResourcesMap().containsKey(linkedToResource.getName())) {
            List<LinkedResource> linkedResources = linksMetaData.getLinkedResourcesMap().get(linkedToResource.getName());
            if (linkedResources.size() == 1) {
                if (Objects.isNull(linkedToResource.getMethod())) {
                    return;
                }
                if (linkedResources.get(0).getMethod().equalsIgnoreCase("default") || linkedResources.get(0).getMethod().equals(linkedToResource.getMethod())) {
                    return;
                }
                HttpServiceValidator.reportUnresolvedLinkedResourceWithMethod(syntaxNodeAnalysisContext, linkedToResource);
                return;
            }
            if (Objects.isNull(linkedToResource.getMethod())) {
                HttpServiceValidator.reportUnresolvedLinkedResource(syntaxNodeAnalysisContext, linkedToResource);
                return;
            }
            boolean found = false;
            for (LinkedResource linkedResource : linkedResources) {
                if (!linkedResource.getMethod().equalsIgnoreCase("default") && !linkedResource.getMethod().equals(linkedToResource.getMethod())) continue;
                found = true;
                break;
            }
            if (!found) {
                HttpServiceValidator.reportUnresolvedLinkedResourceWithMethod(syntaxNodeAnalysisContext, linkedToResource);
            }
        } else {
            HttpServiceValidator.reportResourceNameDoesNotExist(syntaxNodeAnalysisContext, linkedToResource);
        }
    }

    protected static void validateServiceAnnotation(SyntaxNodeAnalysisContext ctx, MetadataNode metadataNode, TypeDescriptorNode serviceTypeDesc, boolean isServiceContractType) {
        NodeList annotations = metadataNode.annotations();
        for (AnnotationNode annotation : annotations) {
            String[] annotStrings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            Optional annotValue = annotation.annotValue();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !"ServiceConfig".equals((annotStrings = annotName.split(":"))[annotStrings.length - 1].trim()) || !"http".equals(annotStrings[0].trim())) continue;
            if (Objects.nonNull(serviceTypeDesc)) {
                HttpServiceValidator.validateAnnotationUsageForServiceContractType(ctx, annotation, annotValue.orElse(null), serviceTypeDesc);
                return;
            }
            annotValue.ifPresent(mappingConstructorExpressionNode -> HttpServiceValidator.validateServiceConfigAnnotation(ctx, mappingConstructorExpressionNode, isServiceContractType));
        }
    }

    private static void validateAnnotationUsageForServiceContractType(SyntaxNodeAnalysisContext ctx, AnnotationNode annotation, MappingConstructorExpressionNode annotValue, TypeDescriptorNode typeDescriptorNode) {
        if (Objects.isNull(annotValue) || annotValue.fields().isEmpty() || annotValue.fields().size() > 2) {
            HttpServiceValidator.reportInvalidServiceConfigAnnotationUsage(ctx, (Location)annotation.location());
            return;
        }
        for (MappingFieldNode field : annotValue.fields()) {
            String fieldString = field.toString();
            fieldString = fieldString.trim().replaceAll("^'|\"|\\n", "");
            if (!field.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD)) continue;
            String[] strings = fieldString.split(":", 2);
            if ("serviceType".equals(strings[0].trim())) {
                String expectedServiceType = typeDescriptorNode.toString().trim();
                String actualServiceType = strings[1].trim();
                if (actualServiceType.equals(expectedServiceType)) continue;
                HttpServiceValidator.reportInvalidServiceContractType(ctx, expectedServiceType, actualServiceType, (Location)field.location());
                return;
            }
            if ("openApiDefinition".equals(strings[0].trim())) continue;
            HttpServiceValidator.reportInvalidServiceConfigAnnotationUsage(ctx, (Location)annotation.location());
            return;
        }
    }

    protected static void validateServiceConfigAnnotation(SyntaxNodeAnalysisContext ctx, MappingConstructorExpressionNode mapping, boolean isServiceContractType) {
        for (MappingFieldNode field : mapping.fields()) {
            String fieldName = field.toString();
            fieldName = fieldName.trim().replaceAll("^'|\"|\\n", "");
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
            String[] strings = fieldName.split(":", 2);
            if ("mediaTypeSubtypePrefix".equals(strings[0].trim())) {
                if (!strings[1].trim().matches("^(\\w)+(\\s*\\.\\s*(\\w)+)*(\\s*\\+\\s*(\\w)+)*")) {
                    HttpServiceValidator.reportInvalidMediaTypeSubtype(ctx, strings[1].trim(), field);
                    continue;
                }
                if (!strings[1].trim().contains("+")) continue;
                String suffix = strings[1].trim().split("\\+", 2)[1];
                HttpServiceValidator.reportErrorMediaTypeSuffix(ctx, suffix.trim(), field);
                continue;
            }
            if ("serviceType".equals(strings[0].trim())) {
                HttpServiceValidator.reportServiceTypeNotAllowedFound(ctx, field.location());
                continue;
            }
            if (!"basePath".equals(strings[0].trim()) || isServiceContractType) continue;
            HttpServiceValidator.reportBasePathFieldNotAllowed(ctx, (Location)field.location());
        }
    }

    private static void reportInvalidFunctionType(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode node) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(HttpDiagnostic.HTTP_101.getCode(), HttpDiagnostic.HTTP_101.getMessage(), HttpDiagnostic.HTTP_101.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)node.location(), (Object[])new Object[0]));
    }

    private static void reportInvalidMediaTypeSubtype(SyntaxNodeAnalysisContext ctx, String arg, MappingFieldNode node) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(HttpDiagnostic.HTTP_120.getCode(), String.format(HttpDiagnostic.HTTP_120.getMessage(), arg), HttpDiagnostic.HTTP_120.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)node.location(), (Object[])new Object[0]));
    }

    private static void reportErrorMediaTypeSuffix(SyntaxNodeAnalysisContext ctx, String suffix, MappingFieldNode node) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(HttpDiagnostic.HTTP_119.getCode(), String.format(HttpDiagnostic.HTTP_119.getMessage(), suffix), HttpDiagnostic.HTTP_119.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)node.location(), (Object[])new Object[0]));
    }

    private static void reportResourceNameDoesNotExist(SyntaxNodeAnalysisContext ctx, LinkedToResource resource) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)resource.getNode().location(), HttpDiagnostic.HTTP_148, resource.getName());
    }

    private static void reportUnresolvedLinkedResource(SyntaxNodeAnalysisContext ctx, LinkedToResource resource) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)resource.getNode().location(), HttpDiagnostic.HTTP_149);
    }

    private static void reportUnresolvedLinkedResourceWithMethod(SyntaxNodeAnalysisContext ctx, LinkedToResource resource) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)resource.getNode().location(), HttpDiagnostic.HTTP_150, resource.getMethod(), resource.getName());
    }

    private static void reportInvalidServiceConfigAnnotationUsage(SyntaxNodeAnalysisContext ctx, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_153);
    }

    private static void reportInvalidServiceContractType(SyntaxNodeAnalysisContext ctx, String expectedServiceType, String actualServiceType, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_156, expectedServiceType, actualServiceType);
    }

    private static void reportBasePathNotAllowed(SyntaxNodeAnalysisContext ctx, NodeList<Node> nodes) {
        NodeLocation startLocation = nodes.get(0).location();
        NodeLocation endLocation = nodes.get(nodes.size() - 1).location();
        BLangDiagnosticLocation location = new BLangDiagnosticLocation(startLocation.lineRange().fileName(), startLocation.lineRange().startLine().line(), startLocation.lineRange().endLine().line(), startLocation.lineRange().startLine().offset(), endLocation.lineRange().endLine().offset(), 0, 0);
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)location, HttpDiagnostic.HTTP_154);
    }

    private static void reportBasePathFieldNotAllowed(SyntaxNodeAnalysisContext ctx, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_155);
    }

    private static void reportServiceTypeNotAllowedFound(SyntaxNodeAnalysisContext ctx, NodeLocation location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)location, HttpDiagnostic.HTTP_157);
    }

    private static void enableImplementServiceContractCodeAction(SyntaxNodeAnalysisContext ctx, String serviceType, NodeLocation location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)location, HttpDiagnostic.HTTP_HINT_105, serviceType);
    }
}

