/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.codeaction.CodeActionUtil;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ChangeReturnTypeWithCallerCodeAction
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(HttpDiagnostic.HTTP_118.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        NonTerminalNode node = CodeActionUtil.findNode(context.currentDocument().syntaxTree(), context.diagnostic().location().lineRange());
        if (node == null || node.parent().kind() != SyntaxKind.RETURN_TYPE_DESCRIPTOR) {
            return Optional.empty();
        }
        return CodeActionUtil.getCodeActionInfoWithLocation(node, "Change return type to 'error?'");
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        Optional<LineRange> lineRange = CodeActionUtil.getLineRangeFromLocationKey(context);
        if (lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.get().startLine());
        int end = textDocument.textPositionFrom(lineRange.get().endLine());
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)TextRange.from((int)start, (int)(end - start)), (String)"error?"));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return "CHANGE_RETURN_TYPE_WITH_CALLER";
    }
}

