/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.completion;

import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.completion.CompletionContext;
import io.ballerina.projects.plugins.completion.CompletionException;
import io.ballerina.projects.plugins.completion.CompletionItem;
import io.ballerina.projects.plugins.completion.CompletionProvider;
import io.ballerina.projects.plugins.completion.CompletionUtil;
import io.ballerina.stdlib.http.compiler.completion.Constants;
import java.util.List;
import java.util.stream.Collectors;

public class HttpServiceBodyContextProvider
implements CompletionProvider<ServiceDeclarationNode> {
    private static final String NAME = "HttpServiceBodyProvider";

    public String name() {
        return NAME;
    }

    public List<CompletionItem> getCompletions(CompletionContext completionContext, ServiceDeclarationNode serviceDeclarationNode) throws CompletionException {
        return Constants.METHODS.stream().map(method -> {
            String insertText = String.format("resource function %s %s(%s) %s{%s}", method, CompletionUtil.getPlaceHolderText((int)1, (String)"path"), CompletionUtil.getPlaceHolderText((int)2), CompletionUtil.getPlaceHolderText((int)3), CompletionUtil.LINE_BREAK + "\t" + CompletionUtil.getPlaceHolderText((int)4) + CompletionUtil.LINE_BREAK);
            String label = "resource function " + method + " path()";
            return new CompletionItem(label, insertText, CompletionItem.Priority.HIGH);
        }).collect(Collectors.toList());
    }

    public List<Class<ServiceDeclarationNode>> getSupportedNodes() {
        return List.of(ServiceDeclarationNode.class);
    }
}

