/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpRule;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;
import java.util.regex.Pattern;

class HttpAnnotationStaticAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private static final String CORS_FIELD_NAME = "cors";
    private static final String ALLOW_ORIGINS_FIELD_NAME = "allowOrigins";
    public static final Pattern WILDCARD_ORIGIN = Pattern.compile("\"( *)\\*( *)\"");

    public HttpAnnotationStaticAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        AnnotationNode annotationNode = HttpCompilerPluginUtil.getAnnotationNode(context);
        if (annotationNode == null) {
            return;
        }
        Optional annotationValue = annotationNode.annotValue();
        if (annotationValue.isEmpty()) {
            return;
        }
        Document document = HttpCompilerPluginUtil.getDocument(context);
        this.validateAnnotationValue((MappingConstructorExpressionNode)annotationValue.get(), document);
    }

    private void validateAnnotationValue(MappingConstructorExpressionNode annotationValueMap, Document document) {
        Optional<SpecificFieldNode> corsField = this.findSpecificField(annotationValueMap, CORS_FIELD_NAME);
        if (corsField.isEmpty() || corsField.get().valueExpr().isEmpty()) {
            return;
        }
        ExpressionNode corsVal = (ExpressionNode)corsField.get().valueExpr().get();
        if (corsVal.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
            return;
        }
        MappingConstructorExpressionNode corsMap = (MappingConstructorExpressionNode)corsVal;
        Optional<SpecificFieldNode> allowOrigins = this.findSpecificField(corsMap, ALLOW_ORIGINS_FIELD_NAME);
        if (allowOrigins.isEmpty() || allowOrigins.get().valueExpr().isEmpty()) {
            return;
        }
        ExpressionNode allowOriginsValue = (ExpressionNode)allowOrigins.get().valueExpr().get();
        if (allowOriginsValue.kind() != SyntaxKind.LIST_CONSTRUCTOR) {
            return;
        }
        this.checkForPermissiveCors((ListConstructorExpressionNode)allowOriginsValue, document);
    }

    private Optional<SpecificFieldNode> findSpecificField(MappingConstructorExpressionNode mapNode, String fieldName) {
        return mapNode.fields().stream().filter(field -> field.kind() == SyntaxKind.SPECIFIC_FIELD).map(field -> (SpecificFieldNode)field).filter(field -> fieldName.equals(field.fieldName().toSourceCode().trim())).findFirst();
    }

    private void checkForPermissiveCors(ListConstructorExpressionNode allowedOrigins, Document document) {
        for (Node exp : allowedOrigins.expressions()) {
            if (!WILDCARD_ORIGIN.matcher(exp.toSourceCode().trim()).find()) continue;
            this.reporter.reportIssue(document, (Location)exp.location(), HttpRule.AVOID_PERMISSIVE_CORS.getId());
        }
    }
}

