/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRuleContext;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.AvoidDefaultResourceAccessorRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.AvoidTraversingAttacksRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.AvoidUnsecureRedirectionsRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.HttpResourceRule;
import java.util.ArrayList;
import java.util.List;

public class HttpResourceRulesEngine {
    private final List<HttpResourceRule> rules = new ArrayList<HttpResourceRule>();

    public HttpResourceRulesEngine() {
        this.initializeDefaultRules();
    }

    public void executeRules(HttpResourceRuleContext context) {
        for (HttpResourceRule rule : this.rules) {
            if (!rule.isApplicable(context)) continue;
            rule.analyze(context);
        }
    }

    public void addRule(HttpResourceRule rule) {
        if (rule != null && !this.rules.contains(rule)) {
            this.rules.add(rule);
        }
    }

    private void initializeDefaultRules() {
        this.addRule(new AvoidDefaultResourceAccessorRule());
        this.addRule(new AvoidTraversingAttacksRule());
        this.addRule(new AvoidUnsecureRedirectionsRule());
    }
}

