/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDeclaration;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDefinition;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRuleContext;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRulesEngine;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpStaticAnalysisUtils;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.models.HttpService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class HttpServiceStaticAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private final HttpResourceRulesEngine rulesEngine;

    public HttpServiceStaticAnalyzer(Reporter reporter) {
        this.reporter = reporter;
        this.rulesEngine = new HttpResourceRulesEngine();
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        HttpService service = HttpStaticAnalysisUtils.getHttpService(context);
        if (service == null) {
            return;
        }
        Document document = HttpCompilerPluginUtil.getDocument(context);
        SemanticModel semanticModel = context.semanticModel();
        this.analyzeServiceMembers(service.members(), document, semanticModel);
    }

    private void analyzeServiceMembers(NodeList<Node> members, Document document, SemanticModel semanticModel) {
        for (Node member : members) {
            if (member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION && member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) continue;
            ResourceFunction resourceFunction = member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION ? new ResourceFunctionDefinition((FunctionDefinitionNode)member) : new ResourceFunctionDeclaration((MethodDeclarationNode)member);
            this.analyzeResource(resourceFunction, document, semanticModel);
        }
    }

    private void analyzeResource(ResourceFunction resourceFunction, Document document, SemanticModel semanticModel) {
        Symbol symbol;
        Optional<Symbol> functionSymbol = resourceFunction.getSymbol(semanticModel);
        if (functionSymbol.isEmpty() || !((symbol = functionSymbol.get()) instanceof ResourceMethodSymbol)) {
            return;
        }
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
        HttpResourceRuleContext context = this.createRuleContext(resourceFunction, resourceMethodSymbol, document, semanticModel);
        this.rulesEngine.executeRules(context);
    }

    private HttpResourceRuleContext createRuleContext(ResourceFunction resourceFunction, ResourceMethodSymbol resourceMethodSymbol, Document document, SemanticModel semanticModel) {
        Optional paramName;
        List<PathParameterSymbol> pathParameterSymbols = this.extractPathParameters(resourceMethodSymbol);
        Optional parametersOptional = resourceMethodSymbol.typeDescriptor().params();
        Optional<FunctionBodyNode> functionBody = resourceFunction.getFunctionBody();
        Optional functionReturnType = resourceMethodSymbol.typeDescriptor().returnTypeDescriptor();
        ArrayList<String> resourceParamNames = new ArrayList<String>();
        for (PathParameterSymbol pathParam : pathParameterSymbols) {
            TypeSymbol pathParamType = pathParam.typeDescriptor();
            paramName = pathParam.getName();
            if (!pathParamType.subtypeOf(semanticModel.types().ANYDATA) || !paramName.isPresent()) continue;
            resourceParamNames.add(HttpStaticAnalysisUtils.unescapeIdentifier((String)paramName.get()));
        }
        if (parametersOptional.isPresent()) {
            for (ParameterSymbol parameterSymbol : (List)parametersOptional.get()) {
                TypeSymbol paramType = parameterSymbol.typeDescriptor();
                paramName = parameterSymbol.getName();
                if (!paramType.subtypeOf(semanticModel.types().ANYDATA) || !paramName.isPresent()) continue;
                resourceParamNames.add(HttpStaticAnalysisUtils.unescapeIdentifier((String)paramName.get()));
            }
        }
        return new HttpResourceRuleContext(this.reporter, document, semanticModel, resourceFunction, resourceMethodSymbol, resourceParamNames, functionReturnType, functionBody.map(HttpStaticAnalysisUtils::extractExpressions).orElseGet(List::of));
    }

    private List<PathParameterSymbol> extractPathParameters(ResourceMethodSymbol resourceMethodSymbol) {
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        if (resourcePath instanceof PathSegmentList) {
            PathSegmentList resourcePathList = (PathSegmentList)resourcePath;
            return resourcePathList.pathParameters();
        }
        return List.of();
    }
}

