/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.ExpressionNodeInfo;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.models.HttpService;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.models.HttpServiceClass;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.models.HttpServiceDeclaration;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.models.HttpServiceObjectType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class HttpStaticAnalysisUtils {
    private HttpStaticAnalysisUtils() {
    }

    public static HttpService getHttpService(SyntaxNodeAnalysisContext context) {
        return switch (context.node().kind()) {
            case SyntaxKind.SERVICE_DECLARATION -> {
                ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(context);
                if (serviceDeclarationNode == null) {
                    yield null;
                }
                yield new HttpServiceDeclaration(serviceDeclarationNode);
            }
            case SyntaxKind.OBJECT_TYPE_DESC -> {
                if (HttpCompilerPluginUtil.isHttpServiceType(context.semanticModel(), context.node())) {
                    yield new HttpServiceObjectType((ObjectTypeDescriptorNode)context.node());
                }
                yield null;
            }
            case SyntaxKind.CLASS_DEFINITION -> {
                ClassDefinitionNode serviceClassDefinitionNode = HttpCompilerPluginUtil.getServiceClassDefinitionNode(context);
                if (serviceClassDefinitionNode == null) {
                    yield null;
                }
                yield new HttpServiceClass(serviceClassDefinitionNode);
            }
            default -> {
                String errorMessage = String.format("Unexpected node kind: %s. Expected SERVICE_DECLARATION, OBJECT_TYPE_DESC or CLASS_DEFINITION.", context.node().kind());
                throw new IllegalStateException(errorMessage);
            }
        };
    }

    public static List<ExpressionNodeInfo> extractExpressions(FunctionBodyNode functionBody) {
        FunctionBodyNode functionBodyNode = functionBody;
        Objects.requireNonNull(functionBodyNode);
        FunctionBodyNode functionBodyNode2 = functionBodyNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExpressionFunctionBodyNode.class, FunctionBodyBlockNode.class}, (Object)functionBodyNode2, n)) {
            case 0: {
                ExpressionFunctionBodyNode expressionFunctionBodyNode = (ExpressionFunctionBodyNode)functionBodyNode2;
                ExpressionNode expressionNode = expressionFunctionBodyNode.expression();
                return List.of(new ExpressionNodeInfo(expressionNode, true));
            }
            case 1: {
                FunctionBodyBlockNode functionBodyBlockNode = (FunctionBodyBlockNode)functionBodyNode2;
                ArrayList<ExpressionNodeInfo> expressions = new ArrayList<ExpressionNodeInfo>();
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)functionBodyBlockNode.statements(), expressions);
                return expressions;
            }
        }
        return List.of();
    }

    private static void addExpressions(NodeList<StatementNode> statements, List<ExpressionNodeInfo> expressions) {
        for (StatementNode statement : statements) {
            HttpStaticAnalysisUtils.addExpression(expressions, (Node)statement);
        }
    }

    private static void addExpression(List<ExpressionNodeInfo> expressions, Node statement) {
        Node node = statement;
        Objects.requireNonNull(node);
        Node node2 = node;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockStatementNode.class, ReturnStatementNode.class, AssignmentStatementNode.class, VariableDeclarationNode.class, MatchStatementNode.class, DoStatementNode.class, OnFailClauseNode.class, LockStatementNode.class, IfElseStatementNode.class, ElseBlockNode.class, ForEachStatementNode.class, WhileStatementNode.class}, (Object)node2, n)) {
            case 0: {
                BlockStatementNode blockStatementNode = (BlockStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)blockStatementNode.statements(), expressions);
                break;
            }
            case 1: {
                ReturnStatementNode returnStatementNode = (ReturnStatementNode)node2;
                returnStatementNode.expression().ifPresent(expr -> expressions.add(new ExpressionNodeInfo((ExpressionNode)expr, true)));
                break;
            }
            case 2: {
                AssignmentStatementNode assignmentNode = (AssignmentStatementNode)node2;
                expressions.add(new ExpressionNodeInfo(assignmentNode.expression()));
                break;
            }
            case 3: {
                VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)node2;
                variableDeclarationNode.initializer().ifPresent(expr -> expressions.add(new ExpressionNodeInfo((ExpressionNode)expr)));
                break;
            }
            case 4: {
                MatchStatementNode matchStatementNode = (MatchStatementNode)node2;
                matchStatementNode.matchClauses().forEach(matchClause -> HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)matchClause.blockStatement().statements(), expressions));
                break;
            }
            case 5: {
                DoStatementNode doStatementNode = (DoStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)doStatementNode.blockStatement().statements(), expressions);
                doStatementNode.onFailClause().ifPresent(value -> HttpStaticAnalysisUtils.addExpression(expressions, (Node)value));
                break;
            }
            case 6: {
                OnFailClauseNode onFailClauseNode = (OnFailClauseNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)onFailClauseNode.blockStatement().statements(), expressions);
                break;
            }
            case 7: {
                LockStatementNode lockStatementNode = (LockStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)lockStatementNode.blockStatement().statements(), expressions);
                break;
            }
            case 8: {
                IfElseStatementNode ifElseStatementNode = (IfElseStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)ifElseStatementNode.ifBody().statements(), expressions);
                ifElseStatementNode.elseBody().ifPresent(value -> HttpStaticAnalysisUtils.addExpression(expressions, value));
                break;
            }
            case 9: {
                ElseBlockNode elseBlockNode = (ElseBlockNode)node2;
                HttpStaticAnalysisUtils.addExpression(expressions, (Node)elseBlockNode.elseBody());
                break;
            }
            case 10: {
                ForEachStatementNode forEachStatementNode = (ForEachStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)forEachStatementNode.blockStatement().statements(), expressions);
                break;
            }
            case 11: {
                WhileStatementNode whileStatementNode = (WhileStatementNode)node2;
                HttpStaticAnalysisUtils.addExpressions((NodeList<StatementNode>)whileStatementNode.whileBody().statements(), expressions);
                break;
            }
        }
    }

    public static ExpressionNode getEffectiveExpression(ExpressionNode expressionNode) {
        ExpressionNode expressionNode2 = expressionNode;
        Objects.requireNonNull(expressionNode2);
        ExpressionNode expressionNode3 = expressionNode2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CheckExpressionNode.class, TypeCastExpressionNode.class}, (Object)expressionNode3, n)) {
            case 0 -> {
                CheckExpressionNode checkExpressionNode = (CheckExpressionNode)expressionNode3;
                yield checkExpressionNode.expression();
            }
            case 1 -> {
                TypeCastExpressionNode castExpressionNode = (TypeCastExpressionNode)expressionNode3;
                yield castExpressionNode.expression();
            }
            default -> expressionNode;
        };
    }

    public static Optional<Node> getCastingType(ExpressionNode expressionNode) {
        if (expressionNode instanceof TypeCastExpressionNode) {
            TypeCastExpressionNode typeCastExpressionNode = (TypeCastExpressionNode)expressionNode;
            TypeCastParamNode typeCastParamNode = typeCastExpressionNode.typeCastParam();
            return typeCastParamNode.type();
        }
        return Optional.empty();
    }

    public static String unescapeIdentifier(String identifierName) {
        String result = identifierName;
        if (result.startsWith("'")) {
            result = result.substring(1);
        }
        return result.replace("\\\\", "");
    }

    public static Optional<String> getUsedParamName(ExpressionNode expressionNode) {
        ExpressionNode expressionNode2 = expressionNode;
        Objects.requireNonNull(expressionNode2);
        ExpressionNode expressionNode3 = expressionNode2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleNameReferenceNode.class, FieldAccessExpressionNode.class, IndexedExpressionNode.class}, (Object)expressionNode3, n)) {
            case 0 -> {
                SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)expressionNode3;
                yield Optional.of(HttpStaticAnalysisUtils.unescapeIdentifier(simpleNameRef.name().text()));
            }
            case 1 -> {
                FieldAccessExpressionNode fieldAccessExpr = (FieldAccessExpressionNode)expressionNode3;
                yield HttpStaticAnalysisUtils.getUsedParamName(fieldAccessExpr.expression());
            }
            case 2 -> {
                IndexedExpressionNode indexedExpr = (IndexedExpressionNode)expressionNode3;
                yield HttpStaticAnalysisUtils.getUsedParamName(indexedExpr.containerExpression());
            }
            default -> Optional.empty();
        };
    }
}

