/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.ExpressionNodeInfo;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRuleContext;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpStaticAnalysisUtils;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.HttpResourceRule;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;
import java.util.Optional;

public class AvoidUnsecureRedirectionsRule
implements HttpResourceRule {
    public static final String REDIRECT_STATUS_CODE_RESPONSE_TYPE = "RedirectStatusCodeResponses";
    public static final String HEADERS = "headers";
    public static final String LOCATION = "location";
    private TypeSymbol redirectResponseType = null;

    @Override
    public void analyze(HttpResourceRuleContext context) {
        context.functionBodyExpressions().stream().filter(expressionNodeInfo -> expressionNodeInfo.returnExpr() && this.isRedirectResponseValue(context.semanticModel(), (ExpressionNodeInfo)expressionNodeInfo)).forEach(exprNodeInfo -> {
            ExpressionNode patt0$temp = exprNodeInfo.expression();
            if (!(patt0$temp instanceof MappingConstructorExpressionNode)) {
                return;
            }
            MappingConstructorExpressionNode mappingExpression = (MappingConstructorExpressionNode)patt0$temp;
            this.analyzeRedirectResponse(mappingExpression, context);
        });
    }

    @Override
    public int getRuleId() {
        return HttpRule.AVOID_UNSECURE_REDIRECTIONS.getId();
    }

    @Override
    public boolean isApplicable(HttpResourceRuleContext context) {
        if (this.redirectResponseType == null) {
            this.initializeRedirectResponseType(context.semanticModel());
        }
        return !context.resourceParamNames().isEmpty() && context.functionReturnType().isPresent() && !context.functionBodyExpressions().isEmpty() && this.redirectResponseType != null && this.hasRedirectResponseType(context.functionReturnType().get(), this.redirectResponseType);
    }

    private void initializeRedirectResponseType(SemanticModel semanticModel) {
        Optional httpTypes = semanticModel.types().typesInModule("ballerina", "http", "");
        if (httpTypes.isEmpty() || !((Map)httpTypes.get()).containsKey(REDIRECT_STATUS_CODE_RESPONSE_TYPE)) {
            return;
        }
        Symbol symbol = (Symbol)((Map)httpTypes.get()).get(REDIRECT_STATUS_CODE_RESPONSE_TYPE);
        if (symbol instanceof TypeDefinitionSymbol) {
            TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol;
            this.redirectResponseType = typeDefinitionSymbol.typeDescriptor();
        }
    }

    private boolean matchesFieldName(Node fieldNameNode, String expectedFieldName, boolean ignoreCase) {
        if (fieldNameNode instanceof IdentifierToken) {
            IdentifierToken identifierToken = (IdentifierToken)fieldNameNode;
            String fieldName = HttpStaticAnalysisUtils.unescapeIdentifier(identifierToken.text());
            return ignoreCase ? fieldName.equalsIgnoreCase(expectedFieldName) : fieldName.equals(expectedFieldName);
        }
        if (fieldNameNode instanceof BasicLiteralNode) {
            BasicLiteralNode basicLiteralNode = (BasicLiteralNode)fieldNameNode;
            String fieldName = basicLiteralNode.literalToken().text();
            fieldName = fieldName.substring(1, fieldName.length() - 1);
            return ignoreCase ? fieldName.equalsIgnoreCase(expectedFieldName) : fieldName.equals(expectedFieldName);
        }
        return false;
    }

    private boolean isRedirectResponseValue(SemanticModel semanticModel, ExpressionNodeInfo expressionNodeInfo) {
        Object t;
        if (expressionNodeInfo.castingType().isEmpty()) {
            return true;
        }
        Node node = expressionNodeInfo.castingType().get();
        Optional symbol = semanticModel.symbol(node);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof TypeSymbol)) {
            return false;
        }
        TypeSymbol returnTypeSymbol = (TypeSymbol)t;
        return returnTypeSymbol.subtypeOf(this.redirectResponseType);
    }

    private boolean hasRedirectResponseType(TypeSymbol returnTypeSymbol, TypeSymbol redirectResponseType) {
        if (redirectResponseType == null) {
            return false;
        }
        if (returnTypeSymbol.subtypeOf(redirectResponseType)) {
            return true;
        }
        if (returnTypeSymbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol referenceTypeSymbol = (TypeReferenceTypeSymbol)returnTypeSymbol;
            return this.hasRedirectResponseType(referenceTypeSymbol.typeDescriptor(), redirectResponseType);
        }
        if (returnTypeSymbol instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)returnTypeSymbol;
            return unionTypeSymbol.memberTypeDescriptors().stream().anyMatch(memberType -> this.hasRedirectResponseType((TypeSymbol)memberType, this.redirectResponseType));
        }
        return false;
    }

    private void analyzeRedirectResponse(MappingConstructorExpressionNode mappingExpression, HttpResourceRuleContext context) {
        for (MappingFieldNode field : mappingExpression.fields()) {
            Object t;
            Node fieldNameNode;
            if (!field.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD) || !this.matchesFieldName(fieldNameNode = ((SpecificFieldNode)field).fieldName(), HEADERS, false)) continue;
            Optional valueExpr = ((SpecificFieldNode)field).valueExpr();
            if (valueExpr.isEmpty() || !((t = valueExpr.get()) instanceof MappingConstructorExpressionNode)) {
                return;
            }
            MappingConstructorExpressionNode headersMap = (MappingConstructorExpressionNode)t;
            this.analyzeLocationHeaders(headersMap, context);
        }
    }

    private void analyzeLocationHeaders(MappingConstructorExpressionNode headersMap, HttpResourceRuleContext context) {
        SeparatedNodeList headers = headersMap.fields();
        for (MappingFieldNode header : headers) {
            Node headerFieldNameNode;
            if (!header.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD) || !this.matchesFieldName(headerFieldNameNode = ((SpecificFieldNode)header).fieldName(), LOCATION, true)) continue;
            this.analyzeLocationHeaderValue(header, context);
        }
    }

    private void analyzeLocationHeaderValue(MappingFieldNode header, HttpResourceRuleContext context) {
        ExpressionNode expression;
        Optional<String> usedParamName;
        Optional locationValue = ((SpecificFieldNode)header).valueExpr();
        if (locationValue.isPresent() && (usedParamName = HttpStaticAnalysisUtils.getUsedParamName(expression = (ExpressionNode)locationValue.get())).isPresent() && context.resourceParamNames().contains(usedParamName.get())) {
            context.reporter().reportIssue(context.document(), (Location)header.location(), this.getRuleId());
        }
    }
}

