/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.persist.BalException;
import io.ballerina.persist.cmd.Utils;
import io.ballerina.persist.nodegenerator.syntax.utils.TomlSyntaxUtils;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Initialize the persistence layer in the Ballerina project."})
public class Add
implements BLauncherCmd {
    private static final PrintStream errStream = System.err;
    private static final String COMMAND_IDENTIFIER = "persist-add";
    private final String sourcePath;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--datastore"})
    private String datastore;
    @CommandLine.Option(names={"--module"})
    private String module;
    @CommandLine.Option(names={"--id"}, description={"ID for the generated Ballerina client"})
    private String id;
    @CommandLine.Option(names={"--test-datastore"}, description={"Test data store for the generated Ballerina client"})
    private String testDatastore;

    public Add() {
        this("");
    }

    public Add(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)COMMAND_IDENTIFIER);
            errStream.println(commandUsageInfo);
            return;
        }
        try {
            String packageName;
            if (Objects.isNull(this.datastore)) {
                this.datastore = "inmemory";
            } else {
                BalProjectUtils.validateDatastore(this.datastore);
            }
            BalProjectUtils.validateTestDatastore(this.datastore, this.testDatastore);
            try {
                packageName = TomlSyntaxUtils.readPackageName(this.sourcePath);
            }
            catch (BalException e) {
                errStream.println(e.getMessage());
                return;
            }
            String moduleNameWithPackage = this.validateAndProcessModule(packageName, this.module);
            this.createDefaultClientId();
            String syntaxTree = this.updateBallerinaToml(Paths.get(this.sourcePath, "Ballerina.toml"), moduleNameWithPackage, this.datastore, this.testDatastore, this.id);
            Utils.writeOutputString(syntaxTree, Paths.get(this.sourcePath, "Ballerina.toml").toAbsolutePath().toString());
            this.createPersistDirectoryIfNotExists();
            this.createDefaultSchemaBalFile();
            errStream.printf("Integrated the generation of persist client and entity types into the package build process." + System.lineSeparator(), new Object[0]);
            errStream.println(System.lineSeparator() + "Next steps:");
            errStream.println("1. Define your data model in \"persist/model.bal\".");
            errStream.println("2. Execute `bal build` to generate the persist client during package build.");
            if (Objects.nonNull(this.testDatastore)) {
                errStream.printf(System.lineSeparator() + "The test client for the %s datastore will be generated in the %s module.%n", this.testDatastore, this.module);
                BalProjectUtils.printTestClientUsageSteps(this.testDatastore, packageName, this.module);
            }
        }
        catch (BalException | IOException e) {
            errStream.printf("ERROR: %s%n", e.getMessage());
        }
    }

    private String updateBallerinaToml(Path tomlPath, String module, String datastore, String testDatastore, String id) throws BalException, IOException {
        TomlSyntaxUtils.NativeDependency dependency = TomlSyntaxUtils.getDependencyConfig(datastore, testDatastore);
        TomlSyntaxUtils.ConfigDeclaration declaration = TomlSyntaxUtils.getConfigDeclaration(tomlPath, dependency);
        if (declaration.persistConfigExists()) {
            throw new BalException("persist configuration already exists in the Ballerina.toml. remove the existing configuration and try again.");
        }
        NodeList<DocumentMemberDeclarationNode> moduleMembers = declaration.moduleMembers();
        if (!moduleMembers.isEmpty()) {
            moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTableArray((String)"tool.persist", null));
            moduleMembers = Add.populateBallerinaNodeList(moduleMembers, module, datastore, testDatastore, id);
            moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = NodeFactory.createDocumentNode(moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
        return SyntaxTree.from((TextDocument)textDocument).toSourceCode();
    }

    private static NodeList<DocumentMemberDeclarationNode> populateBallerinaNodeList(NodeList<DocumentMemberDeclarationNode> moduleMembers, String module, String dataStore, String testDatastore, String id) {
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"id", (String)id, null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"targetModule", (String)module, null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"options.datastore", (String)dataStore, null));
        if (testDatastore != null) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"options.testDatastore", (String)testDatastore, null));
        }
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"filePath", (String)"persist/model.bal", null));
        return moduleMembers;
    }

    public String getName() {
        return "add";
    }

    public void printLongDesc(StringBuilder stringBuilder) {
    }

    public void printUsage(StringBuilder stringBuilder) {
    }

    public void setParentCmdParser(CommandLine commandLine) {
    }

    private String validateAndProcessModule(String packageName, String module) throws BalException {
        if (Objects.nonNull(module)) {
            if (!ProjectUtils.validateModuleName((String)module)) {
                throw new BalException(String.format("invalid module name : '%s' :" + System.lineSeparator() + "module name can only contain alphanumerics, underscores and periods", module));
            }
            if (!ProjectUtils.validateNameLength((String)module)) {
                throw new BalException(String.format("invalid module name : '%s' :" + System.lineSeparator() + "maximum length of module name is 256 characters", module));
            }
        }
        return Objects.isNull(module) ? packageName : String.format("%s.%s", packageName.replaceAll("\"", ""), module.replaceAll("\"", ""));
    }

    private void createPersistDirectoryIfNotExists() throws IOException {
        Path persistDirPath = Paths.get(this.sourcePath, "persist");
        if (!Files.exists(persistDirPath, new LinkOption[0])) {
            Files.createDirectory(persistDirPath.toAbsolutePath(), new FileAttribute[0]);
        }
    }

    private void createDefaultSchemaBalFile() throws IOException, BalException {
        List schemaFiles;
        try (Stream<Path> stream = Files.list(Paths.get(this.sourcePath, "persist"));){
            schemaFiles = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).filter(file -> file.toString().toLowerCase(Locale.ENGLISH).endsWith(".bal")).map(file -> file.toString().replace(".bal", "")).collect(Collectors.toList());
        }
        if (schemaFiles.size() > 1) {
            throw new BalException("the persist directory allows only one model definition file, but contains many files.");
        }
        if (schemaFiles.isEmpty()) {
            Utils.generateSchemaBalFile(Paths.get(this.sourcePath, "persist"));
        }
    }

    private void createDefaultClientId() {
        if (this.id == null || this.id.isBlank()) {
            this.id = "generate-db-client";
        }
    }
}

