/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.persist.BalException;
import io.ballerina.persist.cmd.Utils;
import io.ballerina.persist.utils.BalProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Initialize the persistence layer in the Ballerina project."})
public class Init
implements BLauncherCmd {
    private final PrintStream errStream = System.err;
    private static final String COMMAND_IDENTIFIER = "persist-init";
    private final String sourcePath;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--datastore"})
    private String datastore;
    @CommandLine.Option(names={"--module"})
    private String module;

    public Init() {
        this("");
    }

    public Init(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void execute() {
        List schemaFiles;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)COMMAND_IDENTIFIER);
            this.errStream.println(commandUsageInfo);
            return;
        }
        Path projectPath = Paths.get(this.sourcePath, new String[0]);
        try {
            BalProjectUtils.validateBallerinaProject(projectPath);
        }
        catch (BalException e) {
            this.errStream.println(e.getMessage());
            return;
        }
        Path persistDirPath = Paths.get(this.sourcePath, "persist");
        if (!Files.exists(persistDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(persistDirPath.toAbsolutePath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.errStream.println("ERROR: failed to create the persist directory. " + e.getMessage());
                return;
            }
        }
        try (Stream<Path> stream = Files.list(persistDirPath);){
            schemaFiles = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).filter(file -> file.toString().toLowerCase(Locale.ENGLISH).endsWith(".bal")).map(file -> file.toString().replace(".bal", "")).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.errStream.println("ERROR: failed to list model definition files in the persist directory. " + e.getMessage());
            return;
        }
        if (schemaFiles.size() > 1) {
            this.errStream.println("ERROR: the persist directory allows only one model definition file, but contains many files.");
            return;
        }
        if (schemaFiles.size() == 0) {
            try {
                Utils.generateSchemaBalFile(persistDirPath);
            }
            catch (BalException e) {
                this.errStream.println("ERROR: failed to create the model definition file in persist directory. " + e.getMessage());
                return;
            }
        }
        if (this.datastore != null || this.module != null) {
            this.errStream.println("The behavior of the `bal persist init` command has been updated starting from Ballerina update 09.");
            this.errStream.println("Now, you no longer need to provide any parameters. The command will exclusively create the `persist` directory in the project's root directory. This directory contains the data model definition file (`model.bal`) for the project." + System.lineSeparator());
            this.errStream.println("If you have any questions or need further assistance, refer to the updated documentation.");
        } else {
            this.errStream.println("Initialized the package for persistence.");
            this.errStream.println(System.lineSeparator() + "Next steps:");
            this.errStream.println("1. Define your data model in \"persist/model.bal\".");
            this.errStream.println("2. Execute `bal persist add --datastore <datastore> --module <module>` to add an entry to \"Ballerina.toml\" for integrating code generation with the package build process.");
            this.errStream.println("OR");
            this.errStream.println("Execute `bal persist generate --datastore <datastore> --module <module>` for a one-time generation of the client.");
        }
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public String getName() {
        return "persist";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generate database configurations file inside the Ballerina project").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina persist init").append(System.lineSeparator());
    }
}

