/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import java.util.ArrayList;
import java.util.List;

public class Function {
    private final SyntaxKind kind;
    private NodeList<Token> qualifierList;
    private final Token finalKeyWord = AbstractNodeFactory.createIdentifierToken((String)"function ");
    private final IdentifierToken functionName;
    private NodeList<Node> relativeResourcePath;
    private final List<Node> parameters;
    private ReturnTypeDescriptorNode returnTypeDescriptorNode;
    private NodeList<StatementNode> statements;

    public Function(String name, SyntaxKind kind) {
        this.qualifierList = AbstractNodeFactory.createEmptyNodeList();
        this.functionName = AbstractNodeFactory.createIdentifierToken((String)(name + " "));
        this.relativeResourcePath = AbstractNodeFactory.createEmptyNodeList();
        this.parameters = new ArrayList<Node>();
        this.statements = NodeFactory.createEmptyNodeList();
        this.kind = kind;
    }

    public FunctionDefinitionNode getFunctionDefinitionNode() {
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)this.kind, null, this.qualifierList, (Token)this.finalKeyWord, (IdentifierToken)this.functionName, this.relativeResourcePath, (FunctionSignatureNode)this.getFunctionSignature(), (FunctionBodyNode)this.getFunctionBody());
    }

    public void addRelativeResourcePaths(NodeList<Node> paths) {
        this.relativeResourcePath = paths;
    }

    public void addQualifiers(String[] qualifiers) {
        for (String qualifier : qualifiers) {
            this.qualifierList = this.qualifierList.add((Node)AbstractNodeFactory.createIdentifierToken((String)(qualifier + " ")));
        }
    }

    private FunctionSignatureNode getFunctionSignature() {
        return NodeFactory.createFunctionSignatureNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_PAREN, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(this.parameters), (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_PAREN, (ReturnTypeDescriptorNode)this.returnTypeDescriptorNode);
    }

    public void addRequiredParameter(Node typeName, String name) {
        if (this.parameters.size() > 0) {
            this.parameters.add((Node)SyntaxTokenConstants.SYNTAX_TREE_COMMA);
        }
        NodeList annotations = NodeFactory.createEmptyNodeList();
        this.parameters.add((Node)NodeFactory.createRequiredParameterNode((NodeList)annotations, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)name)));
    }

    public void addDefaultableParameter(Node typeName, String name, Node defaultValue) {
        if (this.parameters.size() > 0) {
            this.parameters.add((Node)SyntaxTokenConstants.SYNTAX_TREE_COMMA);
        }
        NodeList annotations = NodeFactory.createEmptyNodeList();
        this.parameters.add((Node)NodeFactory.createDefaultableParameterNode((NodeList)annotations, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)name), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)defaultValue));
    }

    public void addReturns(TypeDescriptorNode node) {
        this.returnTypeDescriptorNode = TypeDescriptor.getReturnTypeDescriptorNode((Node)node);
    }

    private FunctionBodyNode getFunctionBody() {
        return NodeFactory.createFunctionBodyBlockNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_BRACE, null, this.statements, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_BRACE, null);
    }

    public void addStatement(StatementNode node) {
        this.statements = this.statements.add((Node)node);
    }

    public void addIfElseStatement(IfElseStatementNode node) {
        this.statements = this.statements.add((Node)node);
    }
}

