/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.inflector;

import io.ballerina.persist.inflector.Rules;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pluralizer {
    private Pluralizer() {
    }

    public static String pluralize(String word) {
        for (String rule : Rules.UNCOUNTABLE_RULES) {
            if (!Pattern.matches(rule, word)) continue;
            return word;
        }
        for (String[] irregularRule : Rules.IRREGULAR_RULES) {
            if (irregularRule[1].equals(word)) {
                return word;
            }
            if (!irregularRule[0].equals(word)) continue;
            return irregularRule[1];
        }
        for (String[] pluralizationRule : Rules.PLURALIZATION_RULES) {
            Matcher matcher = Pattern.compile(pluralizationRule[0]).matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(pluralizationRule[1]);
        }
        return word;
    }
}

