/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspectiondto;

public class SqlColumn {
    private final String columnName;
    private final String tableName;
    private final String dataType;
    private final String fullDataType;
    private final String characterMaximumLength;
    private final String numericPrecision;
    private final String numericScale;
    private final String columnDefault;
    private final String isNullable;
    private final boolean isPrimaryKey;
    private final boolean isDbGenerated;
    private final String checkConstraint;

    private SqlColumn(String columnName, String tableName, String dataType, String fullDataType, String characterMaximumLength, String numericPrecision, String numericScale, String columnDefault, String isNullable, Boolean isPrimaryKey, Boolean isDbGenerated, String checkConstraint) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.dataType = dataType;
        this.fullDataType = fullDataType;
        this.characterMaximumLength = characterMaximumLength;
        this.numericPrecision = numericPrecision;
        this.numericScale = numericScale;
        this.columnDefault = columnDefault;
        this.isNullable = isNullable;
        this.isPrimaryKey = isPrimaryKey;
        this.isDbGenerated = isDbGenerated;
        this.checkConstraint = checkConstraint;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getFullDataType() {
        return this.fullDataType;
    }

    public String getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public String getNumericPrecision() {
        return this.numericPrecision;
    }

    public String getNumericScale() {
        return this.numericScale;
    }

    public String getColumnDefault() {
        return this.columnDefault;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public Boolean isDbGenerated() {
        return this.isDbGenerated;
    }

    public Boolean getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public static Builder newBuilder(String columnName) {
        return new Builder(columnName);
    }

    public static class Builder {
        private String columnName;
        private String dataType;
        private String fullDataType;
        private String characterMaximumLength;
        private String numericPrecision;
        private String numericScale;
        private String columnDefault;
        private String isNullable;
        private String tableName;
        private Boolean isPrimaryKey;
        private Boolean isDbGenerated;
        private String checkConstraint;

        private Builder(String columnName) {
            this.columnName = columnName;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setIsDbGenerated(Boolean isDbGenerated) {
            this.isDbGenerated = isDbGenerated;
            return this;
        }

        public Builder setFullDataType(String fullDataType) {
            this.fullDataType = fullDataType;
            return this;
        }

        public Builder setCharacterMaximumLength(String characterMaximumLength) {
            this.characterMaximumLength = characterMaximumLength;
            return this;
        }

        public Builder setNumericPrecision(String numericPrecision) {
            this.numericPrecision = numericPrecision;
            return this;
        }

        public Builder setNumericScale(String numericScale) {
            this.numericScale = numericScale;
            return this;
        }

        public Builder setColumnDefault(String columnDefault) {
            this.columnDefault = columnDefault;
            return this;
        }

        public Builder setIsNullable(String isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public Builder setCheckConstraint(String checkConstraint) {
            this.checkConstraint = checkConstraint;
            return this;
        }

        public SqlColumn build() {
            return new SqlColumn(this.columnName, this.tableName, this.dataType, this.fullDataType, this.characterMaximumLength, this.numericPrecision, this.numericScale, this.columnDefault, this.isNullable, this.isPrimaryKey, this.isDbGenerated, this.checkConstraint);
        }
    }
}

