/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspectiondto;

import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.introspectiondto.SqlForeignKey;
import io.ballerina.persist.introspectiondto.SqlIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlTable {
    private final String tableName;
    private final List<SqlColumn> columns;
    private final List<SqlForeignKey> sqlForeignKeys;
    private final List<SqlIndex> indexes;

    public SqlTable(String tableName) {
        this.tableName = tableName;
        this.columns = new ArrayList<SqlColumn>();
        this.sqlForeignKeys = new ArrayList<SqlForeignKey>();
        this.indexes = new ArrayList<SqlIndex>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<SqlColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<SqlForeignKey> getSqlForeignKeys() {
        return Collections.unmodifiableList(this.sqlForeignKeys);
    }

    public List<SqlIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void addColumn(SqlColumn column) {
        this.columns.add(column);
    }

    public void addForeignKey(SqlForeignKey foreignKey) {
        this.sqlForeignKeys.add(foreignKey);
    }

    public void addIndex(SqlIndex index) {
        this.indexes.add(index);
    }

    public static Builder newBuilder(String tableName) {
        return new Builder(tableName);
    }

    public static class Builder {
        private final String tableName;

        private Builder(String tableName) {
            this.tableName = tableName;
        }

        public SqlTable build() {
            return new SqlTable(this.tableName);
        }
    }
}

