/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.persist.BalException;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.syntax.sources.DbModelGenSyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.sources.DbSyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.sources.GSheetSyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.sources.InMemorySyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.sources.RedisSyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.utils.AppScriptUtils;
import io.ballerina.persist.nodegenerator.syntax.utils.SqlScriptUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class SourceGenerator {
    private static final String persistTypesBal = "persist_types.bal";
    private static final String persistClientBal = "persist_client.bal";
    private static final String persistModelBal = "model.bal";
    private static final String NEW_LINE = System.lineSeparator();
    private final String sourcePath;
    private final String moduleNameWithPackageName;
    private final Path generatedSourceDirPath;
    private final Module entityModule;

    public SourceGenerator(String sourcePath, Path generatedSourceDirPath, String moduleNameWithPackageName, Module entityModule) {
        this.sourcePath = sourcePath;
        this.moduleNameWithPackageName = moduleNameWithPackageName;
        this.entityModule = entityModule;
        this.generatedSourceDirPath = generatedSourceDirPath;
    }

    public void createDbModel() throws BalException {
        DbModelGenSyntaxTree dbModelGenSyntaxTree = new DbModelGenSyntaxTree();
        this.addModelFile(dbModelGenSyntaxTree.getDataModels(this.entityModule), this.generatedSourceDirPath.resolve(persistModelBal).toAbsolutePath(), this.moduleNameWithPackageName);
    }

    private void addModelFile(SyntaxTree syntaxTree, Path path, String moduleName) throws BalException {
        try {
            this.writeOutputFile(Formatter.format((String)syntaxTree.toSourceCode()), path);
        }
        catch (IOException | FormatterException e) {
            throw new BalException(String.format("could not write the records for the `%s` data model to the model.bal file.", moduleName) + e.getMessage());
        }
    }

    public void createDbSources(String datasource) throws BalException {
        DbSyntaxTree dbSyntaxTree = new DbSyntaxTree();
        try {
            this.addDataSourceConfigBalFile(this.generatedSourceDirPath, "persist_db_config.bal", dbSyntaxTree.getDataStoreConfigSyntax(datasource));
            this.addConfigTomlFile(this.sourcePath, dbSyntaxTree.getConfigTomlSyntax(this.moduleNameWithPackageName, datasource), this.moduleNameWithPackageName);
            this.addDataTypesBalFile(dbSyntaxTree.getDataTypesSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistTypesBal).toAbsolutePath(), this.moduleNameWithPackageName);
            this.addClientFile(dbSyntaxTree.getClientSyntax(this.entityModule, datasource), this.generatedSourceDirPath.resolve(persistClientBal).toAbsolutePath(), this.moduleNameWithPackageName);
            SourceGenerator.addSqlScriptFile(this.entityModule.getModuleName(), SqlScriptUtils.generateSqlScript(this.entityModule.getEntityMap().values(), datasource), this.generatedSourceDirPath);
        }
        catch (BalException e) {
            throw new BalException(e.getMessage());
        }
    }

    public void createTestDataSources(String testDatastore) throws BalException {
        if (testDatastore.equals("h2")) {
            DbSyntaxTree dbSyntaxTree = new DbSyntaxTree();
            this.addClientFile(dbSyntaxTree.getTestClientSyntax(this.entityModule), this.generatedSourceDirPath.resolve("persist_test_client.bal").toAbsolutePath(), this.moduleNameWithPackageName);
            this.addTestInitFile(dbSyntaxTree.getTestInitSyntax(SqlScriptUtils.generateSqlScript(this.entityModule.getEntityMap().values(), testDatastore)), this.generatedSourceDirPath.resolve("persist_test_init.bal").toAbsolutePath());
        } else {
            InMemorySyntaxTree inMemorySyntaxTree = new InMemorySyntaxTree();
            this.addClientFile(inMemorySyntaxTree.getTestClientSyntax(this.entityModule), this.generatedSourceDirPath.resolve("persist_test_client.bal").toAbsolutePath(), this.moduleNameWithPackageName);
        }
    }

    public void createRedisSources() throws BalException {
        RedisSyntaxTree redisSyntaxTree = new RedisSyntaxTree();
        try {
            this.addDataSourceConfigBalFile(this.generatedSourceDirPath, "persist_db_config.bal", redisSyntaxTree.getDataStoreConfigSyntax());
            this.addConfigTomlFile(this.sourcePath, redisSyntaxTree.getConfigTomlSyntax(this.moduleNameWithPackageName), this.moduleNameWithPackageName);
            this.addDataTypesBalFile(redisSyntaxTree.getDataTypesSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistTypesBal).toAbsolutePath(), this.moduleNameWithPackageName);
            this.addClientFile(redisSyntaxTree.getClientSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistClientBal).toAbsolutePath(), this.moduleNameWithPackageName);
        }
        catch (BalException e) {
            throw new BalException(e.getMessage());
        }
    }

    public void createInMemorySources() throws BalException {
        InMemorySyntaxTree inMemorySyntaxTree = new InMemorySyntaxTree();
        try {
            this.createGeneratedDirectory(this.generatedSourceDirPath);
            this.addDataTypesBalFile(inMemorySyntaxTree.getDataTypesSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistTypesBal).toAbsolutePath(), this.moduleNameWithPackageName);
            this.addClientFile(inMemorySyntaxTree.getClientSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistClientBal).toAbsolutePath(), this.moduleNameWithPackageName);
        }
        catch (BalException e) {
            throw new BalException(e.getMessage());
        }
    }

    public void createGSheetSources() throws BalException {
        GSheetSyntaxTree gSheetSyntaxTree = new GSheetSyntaxTree();
        try {
            this.addDataSourceConfigBalFile(this.generatedSourceDirPath, "persist_sheet_config.bal", gSheetSyntaxTree.getDataStoreConfigSyntax());
            this.addConfigTomlFile(this.sourcePath, gSheetSyntaxTree.getConfigTomlSyntax(this.moduleNameWithPackageName), this.moduleNameWithPackageName);
            this.addDataTypesBalFile(gSheetSyntaxTree.getDataTypesSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistTypesBal).toAbsolutePath(), this.moduleNameWithPackageName);
            this.addClientFile(gSheetSyntaxTree.getClientSyntax(this.entityModule), this.generatedSourceDirPath.resolve(persistClientBal).toAbsolutePath(), this.moduleNameWithPackageName);
            SourceGenerator.addGoogleScriptFile(this.entityModule.getModuleName(), AppScriptUtils.generateJavaScriptFile(this.entityModule.getEntityMap().values()), this.generatedSourceDirPath);
        }
        catch (BalException e) {
            throw new BalException(e.getMessage());
        }
    }

    private void addDataSourceConfigBalFile(Path generatedSourceDirPath, String fileName, SyntaxTree syntaxTree) throws BalException {
        Path configFilePath = generatedSourceDirPath.resolve(fileName);
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            try {
                this.writeOutputFile(Formatter.format((String)syntaxTree.toSourceCode()), configFilePath.toAbsolutePath());
            }
            catch (Exception e) {
                throw new BalException("failed to generate the persist_db_config.bal file. " + e.getMessage());
            }
        }
    }

    private void addConfigTomlFile(String sourcePath, SyntaxTree syntaxTree, String moduleName) throws BalException {
        Path configPath = Paths.get(sourcePath, "Config.toml").toAbsolutePath();
        try {
            if (!Files.exists(configPath.toAbsolutePath(), new LinkOption[0])) {
                this.writeOutputFile(syntaxTree.toSourceCode(), configPath);
            } else {
                this.writeOutputFile(this.getUpdateConfigTomlSyntax(configPath, moduleName, syntaxTree).toSourceCode(), configPath);
            }
        }
        catch (IOException e) {
            throw new BalException("could not update Config.toml file inside the Ballerina project. " + e.getMessage());
        }
    }

    private void addDataTypesBalFile(SyntaxTree syntaxTree, Path path, String moduleName) throws BalException {
        try {
            this.writeOutputFile(Formatter.format((String)syntaxTree.toSourceCode()), path);
        }
        catch (IOException | FormatterException e) {
            throw new BalException(String.format("could not write the type code for the `%s` data model to the persist_types.bal file.", moduleName) + e.getMessage());
        }
    }

    private void addClientFile(SyntaxTree syntaxTree, Path path, String moduleName) throws BalException {
        try {
            this.writeOutputFile(Formatter.format((String)syntaxTree.toSourceCode()), path);
        }
        catch (IOException | FormatterException e) {
            throw new BalException(String.format("could not write the client code for the `%s` data model to the persist_client.bal file.", moduleName) + e.getMessage());
        }
    }

    private void addTestInitFile(SyntaxTree syntaxTree, Path path) throws BalException {
        try {
            this.writeOutputFile(Formatter.format((String)syntaxTree.toSourceCode()), path);
        }
        catch (IOException | FormatterException e) {
            throw new BalException(String.format("could not write the db initialization scripts to the `%s` file. %s", path.getFileName(), e.getMessage()));
        }
    }

    private void createGeneratedDirectory(Path path) throws BalException {
        if (Objects.nonNull(path)) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BalException(String.format("could not create the parent directories of output path %s. %s", path, e.getMessage()));
            }
        }
    }

    private void writeOutputFile(String syntaxTree, Path outPath) throws IOException {
        try (PrintWriter writer = new PrintWriter(outPath.toString(), StandardCharsets.UTF_8);){
            writer.println(syntaxTree);
        }
    }

    public static void addSqlScriptFile(String moduleName, String[] sqlScripts, Path filePath) throws BalException {
        Path path = Paths.get(String.valueOf(filePath), "script.sql");
        StringBuilder sqlScript = new StringBuilder();
        sqlScript.append("-- AUTO-GENERATED FILE.").append(NEW_LINE).append(NEW_LINE);
        sqlScript.append(String.format("-- This file is an auto-generated file by Ballerina persistence layer for %s.", moduleName)).append(NEW_LINE);
        sqlScript.append("-- Please verify the generated scripts and execute them against the target DB server.").append(NEW_LINE).append(NEW_LINE);
        for (String script : sqlScripts) {
            sqlScript.append(script).append(NEW_LINE);
        }
        try {
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)sqlScript, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BalException(String.format("could not write the SQL script to the %s file. %s", "script.sql", e.getMessage()));
        }
    }

    private static void addGoogleScriptFile(String moduleName, String gsScripts, Path filePath) throws BalException {
        Path path = Paths.get(String.valueOf(filePath), "script.gs");
        StringBuilder gsScript = new StringBuilder();
        gsScript.append("// AUTO-GENERATED FILE.").append(NEW_LINE).append(NEW_LINE);
        gsScript.append(String.format("// This file is an auto-generated file by Ballerina persistence layer for %s.", moduleName)).append(NEW_LINE);
        gsScript.append("// Please verify the generated scripts and execute them against the target DB server.").append(NEW_LINE).append(NEW_LINE);
        gsScript.append(gsScripts);
        try {
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)gsScript, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BalException(String.format("could not write the google AppScript code to the %s file. %s", "script.gs", e.getMessage()));
        }
    }

    private SyntaxTree getUpdateConfigTomlSyntax(Path configPath, String moduleName, SyntaxTree newConfigSyntaxTree) throws IOException {
        boolean configExists = false;
        NodeList moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        Path fileNamePath = configPath.getFileName();
        TextDocument configDocument = TextDocuments.from((String)Files.readString(configPath));
        if (Objects.nonNull(fileNamePath)) {
            io.ballerina.toml.syntax.tree.SyntaxTree syntaxTree = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)configDocument, (String)fileNamePath.toString());
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            for (DocumentMemberDeclarationNode member : nodeList) {
                if (member instanceof KeyValueNode) {
                    moduleMembers = moduleMembers.add((Node)member);
                    continue;
                }
                if (member instanceof TableNode) {
                    TableNode node = (TableNode)member;
                    moduleMembers = moduleMembers.add((Node)member);
                    if (!node.identifier().toSourceCode().trim().equals(moduleName)) continue;
                    configExists = true;
                    continue;
                }
                if (!(member instanceof TableArrayNode)) continue;
                moduleMembers = moduleMembers.add((Node)member);
            }
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = NodeFactory.createDocumentNode((NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = !configExists ? TextDocuments.from((String)(documentNode.toSourceCode() + NEW_LINE + newConfigSyntaxTree.toSourceCode())) : TextDocuments.from((String)documentNode.toSourceCode());
        return SyntaxTree.from((TextDocument)textDocument);
    }
}

