/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.clients;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.IfElse;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GSheetClientSyntax
implements ClientSyntax {
    private final Map<String, String> queryMethodStatement = new HashMap<String, String>();
    private final Module entityModule;

    public GSheetClientSyntax(Module entityModule) {
        this.entityModule = entityModule;
    }

    @Override
    public NodeList<ImportDeclarationNode> getImports() {
        NodeList imports = BalSyntaxUtils.generateImportGSheets(this.entityModule);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", "googleapis.sheets", null));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", "persist.googlesheets", null));
        return imports;
    }

    @Override
    public NodeList<ModuleMemberDeclarationNode> getConstantVariables() {
        return BalSyntaxUtils.generateConstantVariables(this.entityModule);
    }

    @Override
    public Client getClientObject(Module entityModule, String clientName) {
        Client clientObject = BalSyntaxUtils.generateClientSignature(clientName, true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final sheets:Client googleSheetClient;"), true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final http:Client httpClient;"), true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final map<googlesheets:GoogleSheetsClient> persistClients;"), true);
        return clientObject;
    }

    @Override
    public FunctionDefinitionNode getInitFunction(Module entityModule) {
        String httpClient = "httpClient";
        String sheetClient = "googleSheetClient";
        Function init = new Function("init", SyntaxKind.OBJECT_METHOD_DEFINITION);
        init.addQualifiers(new String[]{"public", "isolated"});
        init.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        init.addStatement(NodeParser.parseStatement((String)this.generateMetadataRecord(entityModule)));
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.SHEET_CLIENT_CONFIG_TEMPLATE));
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.HTTP_CLIENT_CONFIG_TEMPLATE));
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.HTTP_CLIENT_INIT_TEMPLATE));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", httpClient)));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", httpClient)));
        init.addIfElseStatement(errorCheck.getIfElseStatementNode());
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.SHEET_CLIENT_INIT_TEMPLATE));
        IfElse isCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", sheetClient)));
        isCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", sheetClient)));
        init.addIfElseStatement(isCheck.getIfElseStatementNode());
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.SELF_HTTP_CLIENT_INIT_TEMPLATE));
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.SELF_SHEET_CLIENT_INIT_TEMPLATE));
        init.addStatement(NodeParser.parseStatement((String)BalSyntaxConstants.SHEET_IDS_TEMPLATE));
        StringBuilder persistClientMap = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (persistClientMap.length() != 0) {
                persistClientMap.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            String nameWithUnderScore = BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName());
            persistClientMap.append(String.format("[%s]: check new (self.googleSheetClient, self.httpClient, metadata.get(%s).cloneReadOnly(), spreadsheetId.cloneReadOnly(), sheetIds.get(%s).cloneReadOnly())", nameWithUnderScore, nameWithUnderScore, nameWithUnderScore));
        }
        init.addStatement(NodeParser.parseStatement((String)String.format("self.persistClients = {%s};", persistClientMap)));
        return init.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getGetFunction(Entity entity) {
        return BalSyntaxUtils.generateGetFunction(entity, "GoogleSheetsProcessor", "googlesheets");
    }

    @Override
    public FunctionDefinitionNode getGetByKeyFunction(Entity entity) {
        return BalSyntaxUtils.generateGetByKeyFunction(entity, "GoogleSheetsProcessor", "googlesheets");
    }

    @Override
    public FunctionDefinitionNode getCloseFunction() {
        Function close = BalSyntaxUtils.generateCloseFunction();
        close.addStatement(NodeParser.parseStatement((String)"return ();"));
        return close.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPostFunction(Entity entity) {
        String parameterType = String.format("%sInsert", entity.getEntityName());
        List<EntityField> primaryKeys = entity.getKeys();
        Function create = BalSyntaxUtils.generatePostFunction(entity, primaryKeys, parameterType);
        GSheetClientSyntax.addFunctionBodyToPostResource(create, primaryKeys, BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), parameterType);
        return create.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPutFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function update = BalSyntaxUtils.generatePutFunction(entity, filterKeys, path);
        if (entity.getKeys().size() > 1) {
            update.addStatement(NodeParser.parseStatement((String)"googlesheets:GoogleSheetsClient googleSheetsClient;"));
            String getPersistClientStatement = String.format("googleSheetsClient = self.persistClients.get(%s);", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            update.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
            update.addStatement(NodeParser.parseStatement((String)String.format("_ = check googleSheetsClient.runUpdateQuery(%s, value);", filterKeys.substring(0, filterKeys.length() - 2).concat("}"))));
        } else {
            update.addStatement(NodeParser.parseStatement((String)"googlesheets:GoogleSheetsClient googleSheetsClient;"));
            String getPersistClientStatement = String.format("googleSheetsClient = self.persistClients.get(%s);", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            update.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
            update.addStatement(NodeParser.parseStatement((String)String.format("_ = check googleSheetsClient.runUpdateQuery(%s, value);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName())));
        }
        update.addStatement(NodeParser.parseStatement((String)String.format("return self->%s.get();", path)));
        return update.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getDeleteFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function delete = BalSyntaxUtils.generateDeleteFunction(entity, filterKeys, path);
        delete.addStatement(NodeParser.parseStatement((String)String.format("%s result = check self->%s.get();", entity.getEntityName(), path)));
        if (entity.getKeys().size() > 1) {
            delete.addStatement(NodeParser.parseStatement((String)"googlesheets:GoogleSheetsClient googleSheetsClient;"));
            String getPersistClientStatement = String.format("googleSheetsClient = self.persistClients.get(%s);", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            delete.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
            delete.addStatement(NodeParser.parseStatement((String)String.format("_ = check googleSheetsClient.runDeleteQuery(%s);", filterKeys.substring(0, filterKeys.length() - 2).concat("}"))));
        } else {
            delete.addStatement(NodeParser.parseStatement((String)"googlesheets:GoogleSheetsClient googleSheetsClient;"));
            String getPersistClientStatement = String.format("googleSheetsClient = self.persistClients.get(%s);", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            delete.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
            delete.addStatement(NodeParser.parseStatement((String)String.format("_ = check googleSheetsClient.runDeleteQuery(%s);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName())));
        }
        delete.addStatement(NodeParser.parseStatement((String)"return result;"));
        return delete.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getQueryNativeSQLFunction() {
        throw new UnsupportedOperationException("Query native SQL function is not supported for Google Sheets");
    }

    @Override
    public FunctionDefinitionNode getExecuteNativeSQLFunction() {
        throw new UnsupportedOperationException("Execute native SQL function is not supported for Google Sheets");
    }

    private String generateMetadataRecord(Module entityModule) {
        StringBuilder mapBuilder = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            int index = 0;
            String endRange = "A";
            boolean hasAssociationMethod = false;
            String entityName = entity.getEntityName();
            String entityResourceName = entity.getClientResourceName();
            StringBuilder fieldMetaData = new StringBuilder();
            StringBuilder associationsMethods = new StringBuilder();
            StringBuilder fieldType = new StringBuilder();
            Object resourceName = BalSyntaxUtils.stripEscapeCharacter(entityResourceName);
            resourceName = ((String)resourceName).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)resourceName).substring(1).toLowerCase(Locale.ENGLISH);
            if (mapBuilder.length() != 0) {
                mapBuilder.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            StringBuilder entityMetaData = new StringBuilder();
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_RECORD_ENTITY_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entityName)));
            entityMetaData.append(String.format(BalSyntaxConstants.TABLE_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entityName)));
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_KEY_FIELDS_TEMPLATE, BalSyntaxUtils.getPrimaryKeys(entity, true)));
            block1: for (EntityField field : entity.getFields()) {
                if (field.getRelation() == null) {
                    if (fieldMetaData.length() != 0) {
                        fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                        fieldType.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                    }
                    endRange = this.getEndRange(++index);
                    fieldMetaData.append(String.format("%s: {columnName: \"%s\", columnId: \"%s\"}", field.getFieldName(), BalSyntaxUtils.stripEscapeCharacter(field.getFieldName()), endRange));
                    if (field.getEnum() == null) {
                        fieldType.append(String.format("%s: \"%s\"", field.getFieldName(), field.getFieldType()));
                        continue;
                    }
                    fieldType.append(String.format("%s: \"%s\"", field.getFieldName(), "ENUM"));
                    continue;
                }
                Relation relation = field.getRelation();
                if (relation.isOwner()) {
                    if (fieldMetaData.length() != 0) {
                        fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                        fieldType.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                    }
                    for (Relation.Key reference : relation.getKeyColumns()) {
                        String fieldName = reference.getField();
                        endRange = this.getEndRange(++index);
                        fieldMetaData.append(String.format("%s: {columnName: \"%s\", columnId: \"%s\"}", fieldName, BalSyntaxUtils.stripEscapeCharacter(fieldName), endRange));
                        fieldType.append(String.format("%s: \"%s\"", fieldName, reference.getType()));
                    }
                    continue;
                }
                if (!relation.getRelationType().equals((Object)Relation.RelationType.MANY)) continue;
                Entity assEntity = relation.getAssocEntity();
                for (EntityField entityField : assEntity.getFields()) {
                    if (entityField.getRelation() == null || !entityField.getFieldType().equals(entityName) || !entityField.getRelation().getRelationType().equals((Object)Relation.RelationType.ONE)) continue;
                    hasAssociationMethod = true;
                    if (associationsMethods.length() != 0) {
                        associationsMethods.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                    }
                    String associateEntityName = BalSyntaxUtils.stripEscapeCharacter(relation.getAssocEntity().getClientResourceName());
                    String associateEntityNameCamelCase = associateEntityName.substring(0, 1).toUpperCase(Locale.ENGLISH) + associateEntityName.substring(1).toLowerCase(Locale.ENGLISH);
                    String associateFieldName = BalSyntaxUtils.stripEscapeCharacter(field.getFieldName());
                    String associateFieldNameCamelCase = associateFieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + associateFieldName.substring(1).toLowerCase(Locale.ENGLISH);
                    associationsMethods.append(String.format("%s: self.query%s", "\"" + associateFieldName + "\"", entity.getEntityName().concat(associateFieldNameCamelCase)));
                    int referenceIndex = 0;
                    StringBuilder conditionStatement = new StringBuilder();
                    for (String reference : relation.getReferences()) {
                        if (conditionStatement.length() > 1) {
                            conditionStatement.append(" && ");
                        }
                        conditionStatement.append(String.format("'object.%s == value[\"%s\"] ", reference, entity.getKeys().get(referenceIndex).getFieldName()));
                        ++referenceIndex;
                    }
                    this.queryMethodStatement.put("query" + entity.getEntityName().concat(associateFieldNameCamelCase), String.format("stream<%s, persist:Error?> %sStream = self.query%sStream();", assEntity.getEntityName(), associateEntityName, associateEntityNameCamelCase) + String.format(BalSyntaxConstants.G_SHEET_RETURN_STATEMENT_FOR_RELATIONAL_ENTITY, "", associateEntityName + "Stream", conditionStatement));
                    continue block1;
                }
            }
            entityMetaData.append(String.format(BalSyntaxConstants.RANGE_TEMPLATE, endRange));
            entityMetaData.append(String.format(BalSyntaxConstants.G_SHEET_METADATA_QUERY_TEMPLATE, resourceName));
            entityMetaData.append(String.format("queryOne: self.queryOne%s,", resourceName));
            entityMetaData.append(String.format("dataTypes: {%s},", fieldType));
            entityMetaData.append(String.format("fieldMetadata: {%s}", fieldMetaData));
            if (hasAssociationMethod) {
                entityMetaData.append(", ");
                entityMetaData.append(String.format("associationsMethods: {%s}", associationsMethods));
            } else {
                entityMetaData.append(", ");
                entityMetaData.append(String.format("associationsMethods: {%s}", ""));
            }
            mapBuilder.append(String.format("[%s]: {%s}", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), entityMetaData));
        }
        return String.format("final record {|googlesheets:SheetMetadata...;|} & readonly metadata = {%s};", mapBuilder);
    }

    private static void addFunctionBodyToPostResource(Function create, List<EntityField> primaryKeys, String tableName, String parameterType) {
        create.addStatement(NodeParser.parseStatement((String)"googlesheets:GoogleSheetsClient googleSheetsClient;"));
        String getPersistClientStatement = String.format("googleSheetsClient = self.persistClients.get(%s);", tableName);
        create.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        create.addStatement(NodeParser.parseStatement((String)"_ = check googleSheetsClient.runBatchInsertQuery(data);"));
        create.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.RETURN_CREATED_KEY, parameterType)));
        StringBuilder filterKeys = new StringBuilder();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            filterKeys.append("inserted.").append(primaryKeys.get(i).getFieldName());
            if (i >= primaryKeys.size() - 1) continue;
            filterKeys.append(",");
        }
        filterKeys = primaryKeys.size() == 1 ? new StringBuilder("\t\t\tselect " + String.valueOf(filterKeys) + ";") : new StringBuilder("\t\t\tselect [" + String.valueOf(filterKeys) + "];");
        create.addStatement(NodeParser.parseStatement((String)filterKeys.toString()));
    }

    private String getEndRange(int index) {
        switch (index) {
            case 1: {
                return "A";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "D";
            }
            case 5: {
                return "E";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "H";
            }
            case 9: {
                return "I";
            }
            case 10: {
                return "J";
            }
            case 11: {
                return "K";
            }
            case 12: {
                return "L";
            }
            case 13: {
                return "M";
            }
            case 14: {
                return "N";
            }
            case 15: {
                return "O";
            }
            case 16: {
                return "P";
            }
            case 17: {
                return "Q";
            }
            case 18: {
                return "R";
            }
            case 19: {
                return "S";
            }
            case 20: {
                return "T";
            }
            case 21: {
                return "U";
            }
            case 22: {
                return "V";
            }
            case 23: {
                return "W";
            }
            case 24: {
                return "X";
            }
            case 25: {
                return "Y";
            }
            case 26: {
                return "Z";
            }
        }
        throw new IllegalStateException("Unexpected value: " + index);
    }

    public Iterable<Map.Entry<String, String>> getQueryMethodStatementEntries() {
        return this.queryMethodStatement.entrySet();
    }
}

