/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.sources;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.ClientResource;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.QueryMethod;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.InMemoryClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.sources.SyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class InMemorySyntaxTree
implements SyntaxTree {
    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getClientSyntax(Module entityModule) throws BalException {
        InMemoryClientSyntax dbClientSyntax = new InMemoryClientSyntax(entityModule);
        Client clientObject = dbClientSyntax.getClientObject(entityModule, "Client");
        return InMemorySyntaxTree.getSyntaxTree(entityModule, dbClientSyntax, clientObject);
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getTestClientSyntax(Module entityModule) throws BalException {
        InMemoryClientSyntax dbClientSyntax = new InMemoryClientSyntax(entityModule);
        Client clientObject = dbClientSyntax.getClientObject(entityModule, "InMemoryClient");
        return InMemorySyntaxTree.getSyntaxTree(entityModule, dbClientSyntax, clientObject);
    }

    private static io.ballerina.compiler.syntax.tree.SyntaxTree getSyntaxTree(Module entityModule, InMemoryClientSyntax dbClientSyntax, Client clientObject) throws BalException {
        NodeList<ImportDeclarationNode> imports = dbClientSyntax.getImports();
        NodeList moduleMembers = dbClientSyntax.getConstantVariables();
        for (Entity entity : entityModule.getEntityMap().values()) {
            moduleMembers = moduleMembers.add((Node)NodeParser.parseModuleMemberDeclaration((String)String.format("final isolated table<%s> key(%s) %sTable = table[];", entity.getEntityName(), InMemorySyntaxTree.getPrimaryKeys(entity, false), entity.getClientResourceName())));
        }
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.isEmpty()) {
            throw new BalException("data definition file() does not contain any entities.");
        }
        clientObject.addMember((Node)dbClientSyntax.getInitFunction(entityModule), true);
        ArrayList<ClientResource> resourceList = new ArrayList<ClientResource>();
        for (Entity entity : entityArray) {
            ClientResource resource2 = new ClientResource();
            resource2.addFunction((Node)dbClientSyntax.getGetFunction(entity), true);
            resource2.addFunction((Node)dbClientSyntax.getGetByKeyFunction(entity), true);
            resource2.addFunction((Node)dbClientSyntax.getPostFunction(entity), true);
            resource2.addFunction((Node)dbClientSyntax.getPutFunction(entity), true);
            resource2.addFunction((Node)dbClientSyntax.getDeleteFunction(entity), true);
            resourceList.add(resource2);
        }
        resourceList.forEach(resource -> resource.getFunctions().forEach(function -> clientObject.addMember((Node)function, false)));
        clientObject.addMember((Node)dbClientSyntax.getCloseFunction(), true);
        moduleMembers = moduleMembers.add((Node)clientObject.getClassDefinitionNode());
        ArrayList<FunctionDefinitionNode> functionsList = new ArrayList<FunctionDefinitionNode>();
        for (Entity entity : entityArray) {
            functionsList.addAll(List.of(InMemorySyntaxTree.createQueryFunctions(entity)));
        }
        for (QueryMethod queryMethod : dbClientSyntax.queryMethodList) {
            String entityName = queryMethod.getAssociatedEntityName();
            Function query = new Function(queryMethod.getMethodName(), SyntaxKind.OBJECT_METHOD_DEFINITION);
            query.addStatement(NodeParser.parseStatement((String)InMemorySyntaxTree.getClonedTable(entityModule.getEntityMap().get(entityName))));
            query.addQualifiers(new String[]{"isolated"});
            query.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("record{}[]"));
            query.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode("record{}"), "value");
            query.addRequiredParameter((Node)TypeDescriptor.getArrayTypeDescriptorNode("string"), "fields");
            query.addStatement(NodeParser.parseStatement((String)queryMethod.getMethodBody()));
            functionsList.add(query.getFunctionDefinitionNode());
        }
        moduleMembers = moduleMembers.addAll(functionsList);
        return BalSyntaxUtils.generateSyntaxTree(imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataTypesSyntax(Module entityModule) throws BalException {
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (!entityArray.isEmpty()) {
            return BalSyntaxUtils.generateTypeSyntaxTree(entityModule, "inmemory");
        }
        return null;
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataStoreConfigSyntax() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getConfigTomlSyntax(String moduleName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static FunctionDefinitionNode[] createQueryFunctions(Entity entity) {
        String resourceName = entity.getClientResourceName();
        String nameInCamelCase = resourceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + resourceName.substring(1);
        String clonedTables = InMemorySyntaxTree.getQueryClonedTables(entity);
        StringBuilder queryBuilder = new StringBuilder(String.format(BalSyntaxConstants.QUERY_STATEMENT, resourceName));
        Function query = new Function(String.format("query%s", nameInCamelCase), SyntaxKind.OBJECT_METHOD_DEFINITION);
        query.addQualifiers(new String[]{"isolated"});
        query.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("stream<record{}, persist:Error?>"));
        query.addRequiredParameter((Node)TypeDescriptor.getArrayTypeDescriptorNode("string"), "fields");
        query.addStatement(NodeParser.parseStatement((String)clonedTables));
        StringBuilder queryOneBuilder = new StringBuilder(String.format("from record{} 'object in %sClonedTable", resourceName));
        queryOneBuilder.append(String.format(BalSyntaxConstants.QUERY_ONE_WHERE_CLAUSE, InMemorySyntaxTree.getPrimaryKeys(entity, true)));
        Function queryOne = new Function(String.format("queryOne%s", nameInCamelCase), SyntaxKind.OBJECT_METHOD_DEFINITION);
        queryOne.addQualifiers(new String[]{"isolated"});
        queryOne.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("record {}|persist:NotFoundError"));
        queryOne.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode("anydata"), "key");
        queryOne.addStatement(NodeParser.parseStatement((String)clonedTables));
        InMemorySyntaxTree.createQuery(entity, queryBuilder, queryOneBuilder);
        query.addStatement(NodeParser.parseStatement((String)queryBuilder.toString()));
        queryOne.addStatement(NodeParser.parseStatement((String)queryOneBuilder.toString()));
        queryOne.addStatement(NodeParser.parseStatement((String)String.format("return persist:getNotFoundError(\"%s\", key);", entity.getEntityName())));
        return new FunctionDefinitionNode[]{query.getFunctionDefinitionNode(), queryOne.getFunctionDefinitionNode()};
    }

    private static void createQuery(Entity entity, StringBuilder queryBuilder, StringBuilder queryOneBuilder) {
        StringBuilder relationalRecordFields = new StringBuilder();
        for (EntityField field : entity.getFields()) {
            Relation relation;
            if (field.getRelation() == null || !(relation = field.getRelation()).isOwner()) continue;
            Entity assocEntity = relation.getAssocEntity();
            String fieldName = field.getFieldName();
            queryBuilder.append(String.format("    outer join var %s in %sClonedTable", fieldName.toLowerCase(Locale.ENGLISH), assocEntity.getClientResourceName()));
            queryBuilder.append(" on ");
            queryOneBuilder.append(String.format("    outer join var %s in %sClonedTable", fieldName.toLowerCase(Locale.ENGLISH), assocEntity.getClientResourceName()));
            queryOneBuilder.append(" on ");
            relationalRecordFields.append(String.format("\"%s\": %s,", fieldName, fieldName.toLowerCase(Locale.ENGLISH)));
            int i = 0;
            StringBuilder arrayFields = new StringBuilder();
            StringBuilder arrayValues = new StringBuilder();
            arrayFields.append("[");
            arrayValues.append("[");
            for (String references : relation.getReferences()) {
                if (i > 0) {
                    arrayFields.append(",");
                    arrayValues.append(",");
                }
                arrayFields.append(String.format("'object.%s", relation.getKeyColumns().get(i).getField()));
                arrayValues.append(String.format("%s?.%s", field.getFieldName().toLowerCase(Locale.ENGLISH), references));
                ++i;
            }
            queryBuilder.append((CharSequence)arrayFields.append("]"));
            queryBuilder.append(" equals ");
            queryBuilder.append((CharSequence)arrayValues.append("]"));
            queryOneBuilder.append((CharSequence)arrayFields);
            queryOneBuilder.append(" equals ");
            queryOneBuilder.append((CharSequence)arrayValues);
        }
        if (!relationalRecordFields.isEmpty()) {
            queryBuilder.append(String.format(BalSyntaxConstants.SELECT_QUERY, "," + System.lineSeparator() + relationalRecordFields.substring(0, relationalRecordFields.length() - 1)));
            queryOneBuilder.append(String.format(BalSyntaxConstants.DO_QUERY, "," + System.lineSeparator() + relationalRecordFields.substring(0, relationalRecordFields.length() - 1)));
        } else {
            queryBuilder.append(String.format(BalSyntaxConstants.SELECT_QUERY, ""));
            queryOneBuilder.append(String.format(BalSyntaxConstants.DO_QUERY, ""));
        }
    }

    private static String getPrimaryKeys(Entity entity, boolean addDoubleQuotes) {
        StringBuilder keyFields = new StringBuilder();
        for (EntityField key : entity.getKeys()) {
            if (!keyFields.isEmpty()) {
                keyFields.append(", ");
            }
            if (addDoubleQuotes) {
                keyFields.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName())).append("\"");
                continue;
            }
            keyFields.append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName()));
        }
        return keyFields.toString();
    }

    private static String getQueryClonedTables(Entity entity) {
        StringBuilder clonedTables = new StringBuilder();
        ArrayList<Entity> clonedTablesList = new ArrayList<Entity>();
        clonedTables.append(InMemorySyntaxTree.getClonedTable(entity));
        clonedTablesList.add(entity);
        for (EntityField field : entity.getFields()) {
            Entity assocEntity;
            Relation relation = field.getRelation();
            if (relation == null || !relation.isOwner() || clonedTablesList.contains(assocEntity = relation.getAssocEntity())) continue;
            clonedTables.append(InMemorySyntaxTree.getClonedTable(assocEntity));
            clonedTablesList.add(assocEntity);
        }
        return clonedTables.toString();
    }

    private static String getClonedTable(Entity entity) {
        StringBuilder clonedTable = new StringBuilder();
        clonedTable.append(String.format("table<%s> key(%s) %sClonedTable;", entity.getEntityName(), InMemorySyntaxTree.getPrimaryKeys(entity, false), entity.getClientResourceName()));
        String clonedTableDeclaration = String.format("%sClonedTable = %sTable.clone();", entity.getClientResourceName(), entity.getClientResourceName());
        clonedTable.append(String.format("lock {%s}", clonedTableDeclaration));
        return clonedTable.toString();
    }
}

