/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.utils;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.PersistToolsConstants;
import io.ballerina.persist.cmd.Utils;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Enum;
import io.ballerina.persist.models.EnumMember;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class BalProjectUtils {
    private static final PrintStream errStream = System.err;

    private BalProjectUtils() {
    }

    public static Module getEntities(Path schemaFile) throws BalException {
        Path schemaFilename = schemaFile.getFileName();
        if (schemaFilename == null) {
            throw new BalException("the model definition file name is invalid.");
        }
        String moduleName = schemaFilename.toString().substring(0, schemaFilename.toString().lastIndexOf(46));
        Module.Builder moduleBuilder = Module.newBuilder(moduleName);
        try {
            SyntaxTree balSyntaxTree = SyntaxTree.from((TextDocument)TextDocuments.from((String)Files.readString(schemaFile)));
            BalProjectUtils.populateEnums(moduleBuilder, balSyntaxTree);
            BalProjectUtils.populateEntities(moduleBuilder, balSyntaxTree);
            Module entityModule = moduleBuilder.build();
            if (entityModule.getEntityMap().values().stream().allMatch(Entity::containsUnsupportedTypes)) {
                throw new BalException("all entities contain at least one unsupported data type.");
            }
            BalProjectUtils.inferEnumDetails(entityModule);
            BalProjectUtils.inferRelationDetails(entityModule);
            return entityModule;
        }
        catch (BalException | IOException | RuntimeException e) {
            throw new BalException(e.getMessage());
        }
    }

    public static void updateToml(String sourcePath, String datastore, String module) throws BalException, IOException {
        String sourceContent = "[[tool.persist]]" + System.lineSeparator() + "options.datastore = \"" + datastore + "\"" + System.lineSeparator() + "module = \"" + module + "\"";
        Path generatedCmdOutPath = Paths.get(sourcePath, "target", "Persist.toml");
        Utils.writeToTargetFile(sourceContent, generatedCmdOutPath.toAbsolutePath().toString());
    }

    public static void validateSchemaFile(Path schemaPath) throws BalException {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setOffline(Boolean.valueOf(true));
        SingleFileProject buildProject = SingleFileProject.load((Path)schemaPath.toAbsolutePath(), (BuildOptions)buildOptionsBuilder.build());
        Package currentPackage = buildProject.currentPackage();
        PackageCompilation compilation = currentPackage.getCompilation();
        DiagnosticResult diagnosticResult = compilation.diagnosticResult();
        if (diagnosticResult.hasErrors()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(String.format("the model definition file(%s) has errors.", schemaPath.getFileName()));
            int validErrors = 0;
            for (Diagnostic diagnostic : diagnosticResult.errors()) {
                errorMessage.append(System.lineSeparator());
                errorMessage.append(diagnostic);
                ++validErrors;
            }
            if (validErrors > 0) {
                throw new BalException(errorMessage.toString());
            }
        }
    }

    public static Project buildDriverFile(Path driverPath) throws BalException {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setOffline(Boolean.valueOf(true));
        SingleFileProject buildProject = SingleFileProject.load((Path)driverPath.toAbsolutePath(), (BuildOptions)buildOptionsBuilder.build());
        Package currentPackage = buildProject.currentPackage();
        PackageCompilation compilation = currentPackage.getCompilation();
        DiagnosticResult diagnosticResult = compilation.diagnosticResult();
        if (diagnosticResult.hasErrors()) {
            throw new BalException("failed to build the driver file.");
        }
        return buildProject;
    }

    public static void validateBallerinaProject(Path projectPath) throws BalException {
        Optional<Path> ballerinaToml;
        try (Stream<Path> stream = Files.list(projectPath);){
            ballerinaToml = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).filter(file -> "Ballerina.toml".equals(file.toString())).findFirst();
        }
        catch (IOException e) {
            throw new BalException(String.format("ERROR: invalid Ballerina package directory: %s, %s.%n", projectPath.toAbsolutePath(), e.getMessage()));
        }
        if (ballerinaToml.isEmpty()) {
            throw new BalException(String.format("ERROR: invalid Ballerina package directory: %s, cannot find 'Ballerina.toml' file.%n", projectPath.toAbsolutePath()));
        }
    }

    public static io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> addNewLine(io.ballerina.toml.syntax.tree.NodeList moduleMembers, int n) {
        for (int i = 0; i < n; ++i) {
            moduleMembers = moduleMembers.add((Node)AbstractNodeFactory.createIdentifierToken((String)System.lineSeparator()));
        }
        return moduleMembers;
    }

    public static void populateEntities(Module.Builder moduleBuilder, SyntaxTree balSyntaxTree) throws IOException, BalException {
        ModulePartNode rootNote = (ModulePartNode)balSyntaxTree.rootNode();
        NodeList nodeList = rootNote.members();
        rootNote.imports().stream().filter(importNode -> importNode.orgName().isPresent() && ((ImportOrgNameNode)importNode.orgName().get()).orgName().text().equals("ballerina") && importNode.moduleName().stream().anyMatch(node -> node.text().equals("persist"))).findFirst().orElseThrow(() -> new BalException("no `import ballerina/persist as _;` statement found.."));
        for (ImportDeclarationNode importDeclarationNode : rootNote.imports()) {
            if (!((IdentifierToken)importDeclarationNode.moduleName().get(0)).text().equals("constraint") || !importDeclarationNode.orgName().isPresent() || !((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text().equals("ballerina")) continue;
            moduleBuilder.addImportModulePrefix("constraint");
        }
        for (ModuleMemberDeclarationNode moduleNode : nodeList) {
            if (moduleNode.kind() != SyntaxKind.TYPE_DEFINITION) continue;
            TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)moduleNode;
            Entity.Builder entityBuilder = Entity.newBuilder(typeDefinitionNode.typeName().text().trim());
            ArrayList<EntityField> keyArray = new ArrayList<EntityField>();
            RecordTypeDescriptorNode recordDesc = (RecordTypeDescriptorNode)((TypeDefinitionNode)moduleNode).typeDescriptor();
            Optional entityMetadataNode = typeDefinitionNode.metadata();
            entityBuilder.setTableName(typeDefinitionNode.typeName().text().trim());
            String annotatedTableName = entityMetadataNode.map(metaData -> BalSyntaxUtils.readStringValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(metaData.annotations().stream().toList(), "sql:Name", "value"))).orElse("");
            if (!annotatedTableName.isEmpty()) {
                entityBuilder.setTableName(annotatedTableName);
            }
            entityMetadataNode.map(metaData -> BalSyntaxUtils.readStringValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(metaData.annotations().stream().toList(), "sql:Schema", "value"))).ifPresent(entityBuilder::setSchemaName);
            if (recordDesc.toSourceCode().contains("//Unsupported[")) {
                errStream.println("WARNING the entity '" + entityBuilder.getEntityName() + "' contains unsupported data types. client api for this entity will not be generated.");
                entityBuilder.setContainsUnsupportedTypes(true);
            }
            for (io.ballerina.compiler.syntax.tree.Node node : recordDesc.fields()) {
                TypeDescriptorNode type;
                RecordFieldNode fieldNode = (RecordFieldNode)node;
                EntityField.Builder fieldBuilder = EntityField.newBuilder(fieldNode.fieldName().text().trim());
                io.ballerina.compiler.syntax.tree.Node fieldType = fieldNode.typeName();
                if (fieldType instanceof OptionalTypeDescriptorNode) {
                    fieldBuilder.setOptionalType(true);
                    fieldType = ((OptionalTypeDescriptorNode)fieldType).typeDescriptor();
                }
                if (fieldType instanceof ArrayTypeDescriptorNode) {
                    type = ((ArrayTypeDescriptorNode)fieldType).memberTypeDesc();
                    fieldBuilder.setArrayType(true);
                } else {
                    type = (TypeDescriptorNode)fieldType;
                }
                String fType = BalProjectUtils.getType(type, fieldNode.fieldName().text().trim());
                String qualifiedNamePrefix = BalProjectUtils.getQualifiedModulePrefix(type);
                fieldBuilder.setType(fType);
                fieldBuilder.setOptionalType(fieldNode.typeName().kind().equals((Object)SyntaxKind.OPTIONAL_TYPE_DESC));
                fieldBuilder.setFieldColumnName(fieldNode.fieldName().text().trim());
                fieldBuilder.setOptionalField(fieldNode.questionMarkToken().isPresent());
                Optional metadataNode = fieldNode.metadata();
                metadataNode.ifPresent(value -> {
                    List<String> decimal;
                    String charLength;
                    String varcharLength;
                    List<String> relationRefs;
                    boolean isIndexPresent;
                    boolean isUniqueIndexPresent;
                    List<AnnotationNode> annotations = value.annotations().stream().toList();
                    boolean dbGenerated = BalSyntaxUtils.isAnnotationPresent(annotations, "sql:Generated");
                    fieldBuilder.setIsDbGenerated(dbGenerated);
                    String fieldColumnName = BalSyntaxUtils.readStringValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Name", "value"));
                    if (!fieldColumnName.isEmpty()) {
                        fieldBuilder.setFieldColumnName(fieldColumnName);
                    }
                    if (isUniqueIndexPresent = BalSyntaxUtils.isAnnotationPresent(annotations, "sql:UniqueIndex")) {
                        BalSyntaxUtils.AnnotationUtilRecord uniqueIndexAnnot = new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:UniqueIndex", "name");
                        if (BalSyntaxUtils.isAnnotationFieldArrayType(uniqueIndexAnnot)) {
                            List<String> uniqueIndexNames = BalSyntaxUtils.readStringArrayValueFromAnnotation(uniqueIndexAnnot);
                            uniqueIndexNames.forEach(uniqueIndexName -> entityBuilder.upsertUniqueIndex((String)uniqueIndexName, fieldBuilder.build()));
                        } else if (BalSyntaxUtils.isAnnotationFieldStringType(uniqueIndexAnnot)) {
                            entityBuilder.upsertUniqueIndex(BalSyntaxUtils.readStringValueFromAnnotation(uniqueIndexAnnot), fieldBuilder.build());
                        } else {
                            entityBuilder.upsertUniqueIndex("unique_idx_" + fieldBuilder.getFieldName().toLowerCase(Locale.ENGLISH), fieldBuilder.build());
                        }
                    }
                    if (isIndexPresent = BalSyntaxUtils.isAnnotationPresent(annotations, "sql:Index")) {
                        BalSyntaxUtils.AnnotationUtilRecord indexAnnot = new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Index", "name");
                        if (BalSyntaxUtils.isAnnotationFieldArrayType(indexAnnot)) {
                            List<String> indexNames = BalSyntaxUtils.readStringArrayValueFromAnnotation(indexAnnot);
                            indexNames.forEach(indexName -> entityBuilder.upsertIndex((String)indexName, fieldBuilder.build()));
                        } else if (BalSyntaxUtils.isAnnotationFieldStringType(indexAnnot)) {
                            entityBuilder.upsertIndex(BalSyntaxUtils.readStringValueFromAnnotation(indexAnnot), fieldBuilder.build());
                        } else {
                            entityBuilder.upsertIndex("idx_" + fieldBuilder.getFieldName().toLowerCase(Locale.ENGLISH), fieldBuilder.build());
                        }
                    }
                    if ((relationRefs = BalSyntaxUtils.readStringArrayValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Relation", "keys"))) != null) {
                        fieldBuilder.setRelationRefs(relationRefs);
                    }
                    if (!(varcharLength = BalSyntaxUtils.readStringValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Varchar", "length"))).isEmpty()) {
                        fieldBuilder.setSqlType(new SqlType("VARCHAR", null, null, 0, 0, Integer.parseInt(varcharLength)));
                    }
                    if (!(charLength = BalSyntaxUtils.readStringValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Char", "length"))).isEmpty()) {
                        fieldBuilder.setSqlType(new SqlType("CHAR", null, null, 0, 0, Integer.parseInt(charLength)));
                    }
                    if ((decimal = BalSyntaxUtils.readStringArrayValueFromAnnotation(new BalSyntaxUtils.AnnotationUtilRecord(annotations, "sql:Decimal", "precision"))) != null && decimal.size() == 2) {
                        fieldBuilder.setSqlType(new SqlType("DECIMAL", null, null, Integer.parseInt(decimal.get(0).trim()), Integer.parseInt(decimal.get(1).trim()), 0));
                    }
                    fieldBuilder.setAnnotations(annotations);
                });
                EntityField entityField = fieldBuilder.build();
                entityBuilder.addField(entityField);
                if (fieldNode.readonlyKeyword().isPresent()) {
                    keyArray.add(entityField);
                }
                if (qualifiedNamePrefix == null) continue;
                moduleBuilder.addImportModulePrefix(qualifiedNamePrefix);
            }
            entityBuilder.setKeys(keyArray);
            Entity entity = entityBuilder.build();
            moduleBuilder.addEntity(entity.getEntityName(), entity);
        }
    }

    public static void populateEnums(Module.Builder moduleBuilder, SyntaxTree balSyntaxTree) throws IOException, BalException {
        ModulePartNode rootNote = (ModulePartNode)balSyntaxTree.rootNode();
        NodeList nodeList = rootNote.members();
        rootNote.imports().stream().filter(importNode -> importNode.orgName().isPresent() && ((ImportOrgNameNode)importNode.orgName().get()).orgName().text().equals("ballerina") && importNode.moduleName().stream().anyMatch(node -> node.text().equals("persist"))).findFirst().orElseThrow(() -> new BalException("no `import ballerina/persist as _;` statement found."));
        for (ModuleMemberDeclarationNode moduleNode : nodeList) {
            if (moduleNode.kind() != SyntaxKind.ENUM_DECLARATION) continue;
            EnumDeclarationNode enumDeclarationNode = (EnumDeclarationNode)moduleNode;
            Enum.Builder enumBuilder = Enum.newBuilder(enumDeclarationNode.identifier().text().trim());
            for (io.ballerina.compiler.syntax.tree.Node node : enumDeclarationNode.enumMemberList()) {
                EnumMember enumMember;
                if (!(node instanceof EnumMemberNode)) continue;
                EnumMemberNode enumMemberNode = (EnumMemberNode)node;
                if (enumMemberNode.constExprNode().isPresent()) {
                    String value = ((ExpressionNode)enumMemberNode.constExprNode().get()).toSourceCode().trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    enumMember = new EnumMember(enumMemberNode.identifier().text().trim(), value);
                } else {
                    enumMember = new EnumMember(enumMemberNode.identifier().text().trim(), null);
                }
                enumBuilder.addMember(enumMember);
            }
            Enum enumValue = enumBuilder.build();
            moduleBuilder.addEnum(enumValue.getEnumName(), enumValue);
        }
    }

    private static String getType(TypeDescriptorNode typeDesc, String fieldName) throws BalException {
        switch (typeDesc.kind()) {
            case INT_TYPE_DESC: 
            case BOOLEAN_TYPE_DESC: 
            case DECIMAL_TYPE_DESC: 
            case FLOAT_TYPE_DESC: 
            case STRING_TYPE_DESC: 
            case BYTE_TYPE_DESC: {
                return ((BuiltinSimpleNameReferenceNode)typeDesc).name().text();
            }
            case QUALIFIED_NAME_REFERENCE: {
                QualifiedNameReferenceNode qualifiedName = (QualifiedNameReferenceNode)typeDesc;
                String modulePrefix = qualifiedName.modulePrefix().text();
                String identifier = qualifiedName.identifier().text();
                return modulePrefix + ":" + identifier;
            }
            case SIMPLE_NAME_REFERENCE: {
                return ((SimpleNameReferenceNode)typeDesc).name().text();
            }
            case OPTIONAL_TYPE_DESC: {
                return BalProjectUtils.getType((TypeDescriptorNode)((OptionalTypeDescriptorNode)typeDesc).typeDescriptor(), fieldName);
            }
        }
        throw new BalException(String.format("unsupported data type found for the field `%s`", fieldName));
    }

    private static String getQualifiedModulePrefix(TypeDescriptorNode typeDesc) {
        if (typeDesc.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qualifiedName = (QualifiedNameReferenceNode)typeDesc;
            return qualifiedName.modulePrefix().text();
        }
        return null;
    }

    public static void inferRelationDetails(Module entityModule) {
        Map<String, Entity> entityMap = entityModule.getEntityMap();
        for (Entity entity : entityMap.values()) {
            List<EntityField> fields = entity.getFields();
            HashMap relationFields = new HashMap();
            fields.stream().filter(field -> entityMap.get(field.getFieldType()) != null && field.getRelation() == null).forEach(field -> {
                if (relationFields.containsKey(field.getFieldType())) {
                    ((List)relationFields.get(field.getFieldType())).add(field);
                } else {
                    ArrayList<EntityField> fieldList = new ArrayList<EntityField>();
                    fieldList.add((EntityField)field);
                    relationFields.put(field.getFieldType(), fieldList);
                }
            });
            for (List fieldList : relationFields.values()) {
                Entity assocEntity = entityMap.get(((EntityField)fieldList.get(0)).getFieldType());
                List<EntityField> assocFields = assocEntity.getFields().stream().filter(assocField -> assocField.getFieldType().equals(entity.getEntityName()) && assocField.getRelation() == null).toList();
                for (int i = 0; i < fieldList.size(); ++i) {
                    EntityField field2 = (EntityField)fieldList.get(i);
                    EntityField assocField2 = assocFields.get(i);
                    if (field2.isArrayType() && assocField2.isArrayType()) {
                        throw new RuntimeException("unsupported many to many relation between " + entity.getEntityName() + " and " + assocEntity.getEntityName());
                    }
                    if (field2.isArrayType() || assocField2.isArrayType()) {
                        if (field2.isArrayType()) {
                            field2.setRelation(BalProjectUtils.computeRelation(assocField2.getFieldName(), entity, assocEntity, false, Relation.RelationType.MANY, assocField2.getRelationRefs()));
                            assocField2.setRelation(BalProjectUtils.computeRelation(assocField2.getFieldName(), assocEntity, entity, true, Relation.RelationType.ONE, assocField2.getRelationRefs()));
                        } else {
                            field2.setRelation(BalProjectUtils.computeRelation(field2.getFieldName(), entity, assocEntity, true, Relation.RelationType.ONE, field2.getRelationRefs()));
                            assocField2.setRelation(BalProjectUtils.computeRelation(field2.getFieldName(), assocEntity, entity, false, Relation.RelationType.MANY, field2.getRelationRefs()));
                        }
                    } else if (field2.isOptionalType()) {
                        field2.setRelation(BalProjectUtils.computeRelation(assocField2.getFieldName(), entity, assocEntity, false, Relation.RelationType.ONE, assocField2.getRelationRefs()));
                        assocField2.setRelation(BalProjectUtils.computeRelation(assocField2.getFieldName(), assocEntity, entity, true, Relation.RelationType.ONE, assocField2.getRelationRefs()));
                    } else {
                        field2.setRelation(BalProjectUtils.computeRelation(field2.getFieldName(), entity, assocEntity, true, Relation.RelationType.ONE, field2.getRelationRefs()));
                        assocField2.setRelation(BalProjectUtils.computeRelation(field2.getFieldName(), assocEntity, entity, false, Relation.RelationType.ONE, field2.getRelationRefs()));
                    }
                    if (field2.getRelationRefs() != null) {
                        field2.getRelationRefs().forEach(entity::removeField);
                    }
                    if (assocField2.getRelationRefs() == null) continue;
                    assocField2.getRelationRefs().forEach(assocEntity::removeField);
                }
            }
        }
    }

    public static void inferEnumDetails(Module entityModule) {
        Map<String, Enum> enumMap = entityModule.getEnumMap();
        for (Entity entity : entityModule.getEntityMap().values()) {
            for (EntityField field : entity.getFields()) {
                if (!enumMap.containsKey(field.getFieldType())) continue;
                field.setEnum(enumMap.get(field.getFieldType()));
            }
        }
    }

    private static Relation computeRelation(String fieldName, Entity entity, Entity assocEntity, boolean isOwner, Relation.RelationType relationType, List<String> relationRefs) {
        Relation.Builder relBuilder = new Relation.Builder();
        relBuilder.setAssocEntity(assocEntity);
        if (isOwner) {
            List<Relation.Key> keyColumns = IntStream.range(0, assocEntity.getKeys().size()).mapToObj(i -> {
                EntityField key = assocEntity.getKeys().get(i);
                if (!relationRefs.isEmpty()) {
                    String fkField = (String)relationRefs.get(i);
                    EntityField fkEntityField = entity.getFieldByName(fkField);
                    return new Relation.Key(fkField, fkEntityField.getFieldColumnName(), key.getFieldName(), key.getFieldColumnName(), key.getFieldType());
                }
                String fkField = BalProjectUtils.stripEscapeCharacter(fieldName.toLowerCase(Locale.ENGLISH)) + BalProjectUtils.stripEscapeCharacter(key.getFieldName()).substring(0, 1).toUpperCase(Locale.ENGLISH) + BalProjectUtils.stripEscapeCharacter(key.getFieldName()).substring(1);
                return new Relation.Key(fkField, fkField, key.getFieldName(), key.getFieldColumnName(), key.getFieldType());
            }).collect(Collectors.toList());
            relBuilder.setOwner(true);
            relBuilder.setRelationType(relationType);
            relBuilder.setKeys(keyColumns);
            relBuilder.setReferences(assocEntity.getKeys().stream().map(EntityField::getFieldName).collect(Collectors.toList()));
        } else {
            List<Relation.Key> keyColumns = IntStream.range(0, entity.getKeys().size()).mapToObj(i -> {
                EntityField key = entity.getKeys().get(i);
                Object fkField = BalProjectUtils.stripEscapeCharacter(fieldName.toLowerCase(Locale.ENGLISH)) + BalProjectUtils.stripEscapeCharacter(key.getFieldName()).substring(0, 1).toUpperCase(Locale.ENGLISH) + BalProjectUtils.stripEscapeCharacter(key.getFieldName()).substring(1);
                if (!relationRefs.isEmpty()) {
                    fkField = (String)relationRefs.get(i);
                    EntityField assocField = assocEntity.getFieldByName((String)fkField);
                    return new Relation.Key(key.getFieldName(), key.getFieldColumnName(), (String)fkField, assocField.getFieldColumnName(), key.getFieldType());
                }
                return new Relation.Key(key.getFieldName(), key.getFieldColumnName(), (String)fkField, (String)fkField, key.getFieldType());
            }).collect(Collectors.toList());
            relBuilder.setOwner(false);
            relBuilder.setRelationType(relationType);
            relBuilder.setKeys(keyColumns);
            relBuilder.setReferences(keyColumns.stream().map(Relation.Key::getReference).collect(Collectors.toList()));
        }
        return relBuilder.build();
    }

    private static String stripEscapeCharacter(String fieldName) {
        return fieldName.startsWith("'") ? fieldName.substring(1) : fieldName;
    }

    public static Path getSchemaFilePath(String sourcePath) throws BalException {
        List schemaFilePaths;
        Path persistDir = Paths.get(sourcePath, "persist");
        if (!Files.isDirectory(persistDir, LinkOption.NOFOLLOW_LINKS)) {
            throw new BalException("ERROR: the persist directory inside the Ballerina project does not exist. run `bal persist init` to initiate the project before generation");
        }
        try (Stream<Path> stream = Files.list(persistDir);){
            schemaFilePaths = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).filter(file -> file.toString().toLowerCase(Locale.ENGLISH).endsWith(".bal")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new BalException("ERROR: failed to list the model definition files in the persist directory. " + e.getMessage());
        }
        if (schemaFilePaths.isEmpty()) {
            throw new BalException("ERROR: the persist directory does not contain any model definition file. run `bal persist init` to initiate the project before generation.");
        }
        if (schemaFilePaths.size() > 1) {
            throw new BalException("ERROR: the persist directory allows only one model definition file, but contains many files.");
        }
        return (Path)schemaFilePaths.get(0);
    }

    public static void validatePullCommandOptions(String datastore, String host, String port, String user, String database) throws BalException {
        String nameRegex = "[A-Za-z]\\w*";
        ArrayList<Object> errors = new ArrayList<Object>();
        if (datastore == null) {
            errors.add("The datastore type is not provided.");
        } else if (datastore.isEmpty()) {
            errors.add("The datastore type cannot be empty.");
        } else if (!(datastore.equals("mysql") || datastore.equals("postgresql") || datastore.equals("mssql"))) {
            errors.add("Unsupported data store: '" + datastore + "'");
        }
        if (host == null) {
            errors.add("The host is not provided.");
        } else if (host.isEmpty()) {
            errors.add("The host cannot be empty.");
        }
        if (port == null) {
            errors.add("The port is not provided.");
        } else if (port.isEmpty()) {
            errors.add("The port cannot be empty.");
        } else if (!Pattern.matches("\\d+", port)) {
            errors.add("The port is invalid. The port should be a number.");
        } else if (Integer.parseInt(port) < 0 || Integer.parseInt(port) > 65535) {
            errors.add("The port is invalid. The port should be in the range of 0 to 65535.");
        }
        if (user == null) {
            errors.add("The user is not provided.");
        } else if (user.isEmpty()) {
            errors.add("The user cannot be empty.");
        }
        if (database == null) {
            errors.add("The database is not provided.");
        } else if (database.isEmpty()) {
            errors.add("The database cannot be empty.");
        } else if (!Pattern.matches(nameRegex, database)) {
            errors.add("The database name is invalid. The database name should start with a letter or underscore (_) and must contain only alphanumeric characters.");
        }
        if (!errors.isEmpty()) {
            throw new BalException(String.join((CharSequence)System.lineSeparator(), errors));
        }
    }

    public static void validateDatastore(String datastore) throws BalException {
        if (!PersistToolsConstants.SUPPORTED_DB_PROVIDERS.contains(datastore)) {
            throw new BalException(String.format("the persist layer supports one of data stores: %s. but found '%s' datasource.", Arrays.toString(PersistToolsConstants.SUPPORTED_DB_PROVIDERS.toArray()), datastore));
        }
    }

    public static void validateTestDatastore(String datastore, String testDatastore) throws BalException {
        if (testDatastore == null) {
            return;
        }
        if (!PersistToolsConstants.SUPPORTED_TEST_DB_PROVIDERS.contains(testDatastore)) {
            throw new BalException(String.format("the persist layer supports one of test data stores: %s. but found '%s' datastore.", Arrays.toString(PersistToolsConstants.SUPPORTED_TEST_DB_PROVIDERS.toArray()), testDatastore));
        }
        if (testDatastore.equals("inmemory") && !PersistToolsConstants.SUPPORTED_NOSQL_DB_PROVIDERS.contains(datastore)) {
            throw new BalException(String.format("the in-memory datastore is supported as the test data store for data stores: %s. but found '%s' datasource.", Arrays.toString(PersistToolsConstants.SUPPORTED_NOSQL_DB_PROVIDERS.toArray()), datastore));
        }
        if (testDatastore.equals("h2") && !PersistToolsConstants.SUPPORTED_SQL_DB_PROVIDERS.contains(datastore)) {
            throw new BalException(String.format("the H2 datastore is supported as the test data store for data stores: %s. but found '%s' datastore.", Arrays.toString(PersistToolsConstants.SUPPORTED_SQL_DB_PROVIDERS.toArray()), datastore));
        }
    }

    public static void printTestClientUsageSteps(String testDatastore, String packageName, String module) {
        String yellowColor = "\u001b[33m";
        String resetColor = "\u001b[0m";
        errStream.println(System.lineSeparator() + "To use the generated test client in your tests, please follow the steps below");
        errStream.println(System.lineSeparator() + "1. Initialize the persist client in a function.");
        Object modulePrefix = packageName.equals(module) ? "" : module + ":";
        errStream.println(MessageFormat.format("{0}final {2}Client dbClient = check initializeClient();\n\nfunction initializeClient() returns {2}Client|error '{'\n    return new ();\n'}'{1}", yellowColor, resetColor, modulePrefix));
        errStream.println(System.lineSeparator() + "2. Mock the client instance with the test client instance using Ballerina function mocking");
        if ("inmemory".equals(testDatastore)) {
            errStream.println(MessageFormat.format("{0}@test:Mock '{'functionName: \"initializeClient\"'}'\nisolated function getMockClient() returns {2}Client|error '{'\n    return test:mock({2}Client, check new {2}InMemoryClient());\n'}'{1}", yellowColor, resetColor, modulePrefix));
        } else {
            errStream.println(MessageFormat.format("{0}@test:Mock '{'functionName: \"initializeClient\"'}'\nisolated function getMockClient() returns {2}Client|error '{'\n    return test:mock({2}Client, check new {2}H2Client(\"jdbc:h2:./test\", \"sa\", \"\"));\n'}'{1}", yellowColor, resetColor, modulePrefix));
            errStream.println(System.lineSeparator() + "3. Call the setup and cleanup DB scripts in tests before and after suites");
            errStream.println(MessageFormat.format("{0}@test:BeforeSuite\nisolated function beforeSuite() returns error? '{'\n    check {2}setupTestDB();\n'}'\n\n@test:AfterSuite\nfunction afterSuite() returns error? '{'\n    check {2}cleanupTestDB();\n'}'{1}", yellowColor, resetColor, modulePrefix));
        }
    }
}

